
##########  source("Bispec.R")
ifftshift<-function(x)
  {
    ##  x must be a 2D matrix
    a = dim(x)
    numDims = length(a)

    
        m1 = a[1]
        p = floor(m1/2)
        v1 = c(seq(from=p+1, to=m1), seq(from=1, to=p))

        m2 = a[2]
        p = floor(m2/2)
        v2 = c(seq(from=p+1, to=m2), seq(from=1, to=p))



    
        M=x[v1,v2]
   
    return(M)
  }
fftshift<-function(x)
  {
    ##  x must be a 2D matrix
    a = dim(x)
    numDims = length(a)

    
        m1 = a[1]
        p = ceiling(m1/2)
        v1 = c(seq(from=p+1, to=m1), seq(from=1, to=p))

        m2 = a[2]
        p = ceiling(m2/2)
        v2 = c(seq(from=p+1, to=m2), seq(from=1, to=p))



    
        M=x[v1,v2]
   
    return(M)
  }

####################################################################
#example of 2D amplitude spectrum

# sample image:
#####w<-5 #width of central square
#####xn<- 128; yn<- 128
#####im<- matrix(0,nrow=yn,ncol=xn)
#####xc<-floor(xn/2)+1; yc<- floor(yn/2)+1 # centers of the image
#####im[(-m:m)+xc,(-m:m)+yc]<- 1
#####fftim<-fft(im)

#####im2<- matrix(0,nrow=yn,ncol=xn)
#centres spectrum: Gonzalez & Wintz (1977) Digital Image Processing p.53
#####im2<-im * (-1)^(row(im) + col(im))
#####fftim2<-fft(im2)

#####par(mfrow=c(2,2),pty='s')
#####image(im); title('im=Original image')
#####image(Mod(fftim)); title('Mod(fft(im))')
#####image(Mod(fftim2)) ; title('Centred Mod(fft(im))') 

##########  BB = bisp3cum(signal=champ, samprate=125, maxlag=256, window='parzen' , scale='b', COL=rainbow(100) )

###################################################################
##########  source("Bispec.R")

bisp3cum<-function(signal=1:10,samprate=1,maxlag=0,window='n',scale='b', COL=rainbow(100) )
  {

    ### return( [bisp,freq,cum,lag])

###	BISP3CUM Auto bispectrum/3rd order cumulant
###
###	[bisp,freq,cum,lag]=bisp3cum(signal,samprate,maxlag,window,scale)
###
###	The maxlag*2+1 x maxlag*2+1 element auto bispectrum and 3rd order cumulant matrices
###	and maxlag*2+1 element frequency and lag vectors are computed from the signal
###	matrix containing samples in rows and records in columns, signal sample rate and
###	maximum lag scalars, and lag window function and scale strings.
###
###	If unspecified, the signal matrix is entered after the prompt from the keyboard,
###	and the default assignments samprate=1 and maxlag=0 are used.  The window and scale
###	strings specify lag window and scale matrix computation, according to:
###
###	window = 'none', 'n', or unspecified does not compute a window
###	       = 'uniform' or 'u' computes the uniform hexagonal window
###	       = 'sasaki' or 's' computes the sasaki window
###	       = 'priestley' or 'p' computes the priestley window
###	       = 'parzen' or 'pa' computes the parzen window
###	       = 'hamming' or 'h' computes the hamming window
###	       = 'gaussian' or 'g' computes the gaussian distribution window
###	       = 'daniell' or 'd' computes the daniell window
###
###	scale  = 'biased', 'b', or unspecified computes the biased estimate
###	       = 'unbiased' or 'u' computes the unbiased estimate

###	Implemented using MATLAB 5.3.1 and additional functions:
###
###	mat=toep(column,row)
###	wind=lagwind(lag,window)
###
###	Implementation:
###
###	cum(k,l) = sum_{n=0}^{N-1} conj(signal(n))*signal(n+k)*signal(n+l)/N
###
###	k,l = {-maxlag,...,-1,0,1,...,maxlag}, n = {0,1,...,N-1}
###
###	bisp=fftshift(fft2(ifftshift(cum.*wind)))
###
###	Example:
###   bisp3cum(c(complex(real=1, imaginary=-1), complex(real=-1, imaginary=1)),1,1)

###	 [b,f,c,l]=bisp3cum([1-i -1+i],1,1)
### 
###	b =
###
###	  -5.1962 - 5.1962i        0            -0.0000 - 0.0000i
###	        0                  0                  0          
###	  -0.0000 - 0.0000i   0.0000 + 0.0000i   5.1962 + 5.1962i
###
###	f =
###
###	   -0.5000         0    0.5000
###
###	c =
###
###	  -1.0000 + 1.0000i   1.0000 - 1.0000i        0          
###	   1.0000 - 1.0000i        0            -1.0000 + 1.0000i
###	        0            -1.0000 + 1.0000i   1.0000 - 1.0000i
###
###	l =
###
###	    -1     0     1
###
###	References:
###
###	C. L. Nikias, A. P. Petropulu, Higher-Order Spectra Analysis:  A Nonlinear Signal
###	Processing Framework, PTR Prentice Hall, Englewood Cliffs, NJ, 1993.
###
###	T. S. Rao, M. M. Gabr, An Introduction to Bispectral Analysis and Bilinear Time
###	Series Models, Lecture Notes in Statistics, Volume 24, D. Brillinger, S. Fienberg,
###	J. Gani, J. Hartigan, K. Krickeberg, Editors, Springer-Verlag, New York, NY, 1984.
###
###	Copyright (c) 2000
###	Tom McMurray
###	mcmurray@teamcmi.com

###	assign default input parameters



   if(missing(samprate)) { samprate=1; }

    if(missing(maxlag)) {  maxlag=256 }

    if(missing( window)) {   window='n';}

    if(missing(scale )) {  scale='b';}
    if(missing(COL )) {   COL=rainbow(100) }


## %	while signal is unsupported, enter supported signal or return for 0 outputs


## K=dim(signal);
## Ksig=dimsix(signal);

   ##  if signal is a matrix treat this differently
   nsamp = length(signal)
   nrec = 1
   

##%	while samprate is unsupported, enter supported samprate or return for samprate=1




## %	compute lag vector

lagindex=seq(from=-maxlag, to=maxlag);

lag=lagindex/samprate;

##%	if maxlag, compute freq vector


   freq=lagindex/maxlag/2*samprate;
   

##   freq=0;
##   window='n';
##   scale='b';

##clear lagindex

##%	resolve window


windowchoices = c('none', 'uniform', 'sasaki', 'priestley', 'parzen', 'hamming' ,'gaussian',
      'daniell');
   
windI = which(!is.na(match(windowchoices, window)))

   window='priestley';
  window='parzen';


scalechoices=c('biased', 'unbiased');
   
scaleind=windI = which(!is.na(match(scalechoices, scale)))

##  scale=scalechoices{scaleind};
   
scale=substr(scale, 1, 1);

##  %	generate constants

maxlag1=maxlag+1;
maxlag2=maxlag*2;
maxlag21=maxlag2+1;
   
samp1ind=seq(from=nsamp, by=-1, to=1);
samlsamind=seq(from=nsamp-maxlag, to=nsamp);
   
ml1samind=seq(from=maxlag1, to=nsamp);
ml211ind=seq(from=maxlag21, by=-1, to=1);
zeros1maxlag=rep(0,length=maxlag);
zerosmaxlag1=zeros1maxlag;
onesmaxlag211=rep(1, length=maxlag21);
strmaxlag21=paste(sep='', maxlag21);

## %	subtract mean from signal

##meansig=mean(signal);
##signal=signal-meansig(ones(nsamp,1),:);

## signal=   sweep(signal, 2, mean)
   meansig=mean(signal);
   signal = signal - meansig
   

## %	initialize cumulant matrix

##cum=zeros(maxlag21);

cum=matrix(0, ncol=maxlag21, nrow=maxlag21)
   

##%	signal record cumulant computation loop

##% tic   ## stopwatch timer 
for( k in 1:nrec)
  {
  ##   time=cputime;
  ##   sig=signal[,k];
  ##     
   sig=signal 

   trflsig=  t(sig[samp1ind]);

   toepsig=toep(c(sig[samlsamind], zerosmaxlag1),c(Conj(trflsig[ml1samind]), zeros1maxlag));
   
##%	compute cumulant
   
   cum=cum+ (toepsig *trflsig[onesmaxlag211,]) %*% t(toepsig);
  ##   print disp(['record ' num2str(k) ':  time = ' num2str(cputime-time) ' seconds'])
 }
   cum=cum/nrec;
   ## clear samp1ind samlsamind ml1samind zerosmaxlag1 sig trflsig toepsig

   ## %	if scale=='b', compute biased cumulant

if(scale=='b')
{
   cum=cum/nsamp;
 }
## %	else, compute unbiased cumulant
else
  {

   ##  maxlag1=257; nsamp = 3001
  ##   nsamp = 7;  maxlag1=5
    
   scalmat=matrix(0, ncol=maxlag1, nrow=maxlag1);
   for(k in 1:maxlag1)
     {
      maxlag1k=maxlag1-k;
      scalmat[k,k:maxlag1]=matrix(nsamp-maxlag1k,ncol=1,nrow=maxlag1k+1);
    }
   ##  triu is the upper tirangular part of a matrix


   zz = t(scalmat)
   diag(zz) = 0
   scalmat=scalmat+zz

   nsampmaxlag1=nsamp-maxlag1;
   
   maxlag1ind=seq(from=maxlag, by=-1, to=1)

   tp = toep(seq(from=nsampmaxlag1, to=nsamp-2),  seq(from=nsampmaxlag1, by=-1, to=nsamp-maxlag2))
   

   scalmat=cbind(scalmat,   rbind(tp, scalmat[maxlag1,maxlag1ind] ) );


   scalmat=rbind(scalmat, scalmat[maxlag1ind,ml211ind]);

     
   scalmat[scalmat<1]=1;
     
   cum=cum/scalmat;

     
  ## clear scalmat maxlag1ind
}
##   time=num2str(toc);
##  disp(' ')
##  disp([strmaxlag21 ' x ' strmaxlag21 ' element cumulant computed in ' time ' seconds'])

##   %	  generate lag window function

##  if window(1)=='n'
##     wind=1;
##  else
   wind=lagwind(maxlag1,window);
   
##  %	generate 2d even window function
   
   windeven=c(wind[seq(from=maxlag1, by=-1, to=2)],  wind);

   windeven=matrix( rep(windeven, times=length(onesmaxlag211)), ncol= length(onesmaxlag211), byrow=TRUE );

   
## %	0 pad window function
   
   wind=c(wind, zeros1maxlag);

## %	generate 2d window function
   
   wind=toep(wind, c(wind[1],  rep(0, length=maxlag2)) );
    zz = t(wind)
   diag(zz) = 0
   wind=wind+zz

  ##   wind=wind+tril[wind,-1).';

   wind=wind[ml211ind,]*windeven*windeven;

##   clear windeven


## clear ml211ind zeros1maxlag onesmaxlag211

## %	compute bispectrum

## tic
QUM = cum*wind

##   bisp=fftshift(fft2(ifftshift(QUM)));



##   im2=QUM * (-1)^(row(QUM) + col(QUM))
 im2= ifftshift(QUM)

bisp=fft(im2) 


bisp=fftshift(bisp)


plot.bisp(signal,samprate,lag,cum, freq,  bisp,  COL)

invisible( list(bisp=bisp,freq=freq,cum=cum,lag=lag,COL=COL ))


}

###########################################
##########  source("Bispec.R")

plot.bisp<-function(signal, samprate, lag, cum, freq,  bisp , COL)
{

  par(mfrow=c(2,2))

  plot(ts(signal, deltat=1/samprate) , ylab="Amplitude", type='l', main="Input Time Series")

 ##  image(lag,lag,cum, col=COL, xlab="", ylab="" )

  PLOT.image(lag,lag,cum, COL=COL, xlab="", ylab="" )
  title( main="3rd Order Cumulant V^3", xlab="Lag Tau0, s", ylab="Lag Tau1, s" ) 

 ##   image(freq,freq,abs(bisp), col=COL,xlab="", ylab="" )
   PLOT.image(freq,freq,abs(bisp), COL=COL,xlab="", ylab="" )
  title( main="Bispectrum Amplitude", xlab="Frequency F0, Hz", ylab="Frequency F1, Hz" ) 


   p = atan2(Im(bisp), Re(bisp))
  
   PLOT.image(freq,freq,p*180/pi, COL=COL, xlab="", ylab="")
  title(main='Bispectrum Phase Deg', xlab="Frequency F0, Hz", ylab="Frequency F1, Hz")


}
###########################################
##########  source("Bispec.R")
