cat("sourcing /home/lees/Progs/R_stuff/DUMPSEIS.R\n")

###
###
### source("/home/lees/Progs/R_stuff/DUMPSEIS.R")

dump.get<-function(infofile, datfile, DIR=".", kname=1, kcomp=2)
  {
     ### S1 = dump.get("SEIS_INFO_0000.dat","SEIS_DATA_0000.dat", DIR="/home/beer/lees/DUMP")
     ###  S2 = dump.get( "139_17_seisinfo","139_17_seia.dat", "/home/beer/lees/April/APRILDAT.1")



    if(missing(DIR))
      {
        DIR="."
      }
        
    ifile = infofile
        
    dfile =  datfile

    info = scan(file=paste(sep="/",DIR,ifile) , list(name="", yr=0, mo=0, dom=0,
                      hr=0, mn=0, sec=0, msec=0, dt=0, t1=0,
                      t2=0, off=0, n1=0, n2=0, n3=0, n=0))
        nn = length(info$name)
        ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)

        
        dat = matrix(scan(file=paste(sep="/",DIR,dfile)), ncol=nn,  byrow=TRUE)
        p = dim(dat)
        ex = seq(0,p[1]-1)*info$dt[1]
        par(mfrow=c(nn,1))
        par(mai=c(0.1, .7, 0.1, 0.5) )

    nam =  info$name
    stnams = as.list(1:length(nam))

    for( i in 1:length(nam))
      {
        NM = unlist(strsplit(nam[i], "\\."))
        
        
        stnams[[i]] = list(name=NM[kname], comp=NM[kcomp])
      }
    ST = unlist(stnams)
    STN = ST[names(unlist(stnams))=="name"]
    comp  = ST[names(unlist(stnams))=="comp"]
    
        for(i in 1:nn)
          {
            if(i==nn) {  par(mai=c(0.2, .7, 0.1, 0.5) ) }
            plot(ex, dat[,i], type='l', axes=FALSE, xlab='', ylab='')
            box()
            axis(1, tck=0.03,lab=FALSE)
            axis(2)

          }
        axis(1)
        u = par("usr")
        text(u[1], u[3]+(u[4]-u[3])*.05, labels=paste(sep = " ", ftime[1]) , pos=4)
        return(list(infofile=ifile, info=info, dfil=datfile, dat=dat, stn=STN, comp=comp, dir=DIR))
  }
##########################################
##########################################
### source("/home/lees/Progs/R_stuff/stromb.R")
###
### source("/home/lees/Progs/R_stuff/DUMPSEIS.R")

dump.plot<-function(S1)
  {
 ### dump.plot(S1)
    
    dat = S1$dat
    info = S1$info
    nn = length(info$name)
    ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)

        p = dim(dat)
        ex = seq(0,p[1]-1)*info$dt[1]
        par(mfrow=c(nn,1))
        par(mai=c(0.1, .7, 0.1, 0.5) )



        for(i in 1:nn)
          {
            if(i==nn) {  par(mai=c(0.2, .7, 0.1, 0.5) ) }
            plot(ex, dat[,i], type='l', axes=FALSE, xlab='', ylab='')
            box()
            axis(1, tck=0.03,lab=FALSE)
            axis(2)

          }
        axis(1)
        u = par("usr")
         text(u[1], u[3]+(u[4]-u[3])*.05, labels=paste(sep = " ", ftime) , pos=4)
    

  }
##########################################
### source("/home/lees/Progs/R_stuff/DUMPSEIS.R")

##########
dump.Aplot<-function(S1, COMP=c(1:4), WIN=c(0,1), RMINST=FALSE, INTEG=FALSE, FILT=f, rot=FALSE, CINTEG=c(FALSE), LABS=LABS, sfact=1)
  {
 ### dump.plot(S1)
##########   plot a dump file retrieved earlier and do some optional processing

  if(missing(COMP)){COMP = seq(from=1, to=length(info$name))}
  if(missing(sfact)) { sfact=1}
  if(missing(rot)){ rot = FALSE }
  if(missing(LABS)){  LABS = seq(from=1, to=length(info$name)) }
  if(missing(FILT)) { FILT = list(ON=FALSE, fl=0.5, fh=1.0, type="LP", proto="BU", vec=c(FALSE)) }
  if(missing(INTEG)){ INTEG = FALSE }
  if(missing(RMINST))  {   RMINST = FALSE }
  if(missing(CINTEG))  { CINTEG = rep(TRUE, length(COMP)) }
  
    
  dat = S1$dat
  info = S1$info
  nn = length(info$name)
  dt = info$dt[1]
  ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)
  
  p = dim(dat)
  ex = seq(0,p[1]-1)*dt
  
  FR = matrix(nrow=p[1], ncol=nn)
  # Notes = as.vector(1:(nn))
  Notes = paste(sep = ' ', S1$stn, S1$comp)
  
  for(i in 1:nn)
    {
      amp = dat[,i]
      if(INTEG==TRUE)
        {
          amp=trapz(amp, dt)
        }
      FR[,i] = amp
    }
  if(nn==1)
    {
      plot(ex, amp, type='l')
    }
  else
    {
      PLOT.MATN( FR, tim=ex, dt=dt, sfact=sfact, notes=Notes)
    }
  
}

###
### source("/home/lees/Progs/R_stuff/DUMPSEIS.R")
#########################################
get.dump.sta<-function(SIN, stpos, comppos, STA=stastromb)
{

  if(missing(STA)) { STA=stastromb }

  
  nam = ename(SIN$info$name)
  
  NM = strsplit(nam, "\\.")
  stnams = as.list(seq(1, length(NM)))
  
  for( i in 1:length(nam))
    {
      NM = unlist(strsplit(nam[i], "\\."))
      stnams[[i]] = list(name=NM[stpos], comp=NM[comppos])
    }


  
  ST = unlist(stnams)
  
  SIN$STN = ST[names(unlist(stnams))=="name"]
  
  SIN$comp= ST[names(unlist(stnams))=="comp"]
  
  SIN$chans = rep("", length(SIN$comp))
  
  SIN$sense = rep(1, length(SIN$comp))
  SIN$units = rep("", length(SIN$comp))
  SIN$chaname = rep("", length(SIN$comp))
  
  for(i in 1:length(SIN$STN))
    {
      st = SIN$STN[i]
      #  cp = as.integer(SIN$comp[i])
      cp = SIN$comp[i]
      NAM = STA$name==st
      nc = unlist(STA$das[NAM])==cp

      A = unlist(STA$chans[NAM])
      
      
      SIN$chans[i] = A[nc]
      
      A = unlist(STA$sense[NAM])
      SIN$sense[i] = A[nc]

      A = unlist(STA$units[NAM])
      SIN$units[i] = A[nc]

      A = unlist(STA$chaname[NAM])
      SIN$chaname[i] = A[nc]


      
    }
  
  return(SIN)
  
}

### source("/home/lees/Progs/R_stuff/DUMPSEIS.R")
#########################################
