k =seq(from=0, to=63, by=1)

N = 64
M = 5
T = N/M
A = 10


xk = A * sin(2*pi*k/T)

plot(k, xk, type='l')


Xm = fft(xk)


Im(Xm)


Pm = sqrt(Re(Xm * Conj(Xm)))
Pm = Mod(Xm)



or

Pm = (Mod(Xm)^2)/N

plot(Pm, type='p')

plot(Pm, type='s')

plot(Pm[0:32], type='s' )
points(Pm[0:32] )

##  Theoretical Peak for
##  this DFT (from notes in handout)

TheorPm = A*A*N/4

##  compare with:
  

max(Pm[0:32])

f = seq(from=0, to=N/2, by=1)

plot(f, Pm[1:33], ylab="Power Density", xlab="frequency Hz-s")
plot(f, Pm[1:33], type='h', ylab="Power Density", xlab="frequency number")


OR

f = seq(from=0, to=0.5, length=33)


plot(f, Pm[1:33], type='h', ylab="Power Density", xlab="frequency Hz-s")

##  add in rectangle showing the power spectrum bar
## the width is 1/N, the units are Hz-s (unitless or units of nyquist)

rect(f[6]-(1/N), 0, f[6]+(1/N),  Pm[6], col=2)

###########################################
###########################################
###########################################
####  another example:

##  create a vector of 6 amplitudes and 6 frequencies



amps = c(2,5,6,4,9, 12)
fs = c(10, 32, 21, 45, 23, 12)

##  create a time vector with dt=0.004  (4 milliseconds)

t = seq(from=0, to=5, by=0.004)

## start with a y of all zeroes

y = rep(0, length(t))

## for each frequency add in a sinusoid 
for(i in 1:length(amps))
  {
    y1 = amps[i]*sin(2*pi*fs[i]*t)
    y = y+y1
  }

###  look at the amplitude spectrum
naive(y, 0.004)
