
####  cluster analysis in R


###   igneous data
ig = scan(file="IGNEOUS.TXT", skip=1, list(Rock.name='',   Index=0,   SiO2=0,   Al2O3=0,   Fe2O3=0,   FeO=0,   MgO=0,   CaO=0,   Na2O=0,   K2O=0))

K = cbind(ig$SiO2,   ig$Al2O3,   ig$Fe2O3,   ig$FeO,   ig$MgO,   ig$CaO,   ig$Na2O,   ig$K2O)
nams = paste( ig$Index, ig$Rock.name)
rownames(K) =  nams


ka1 = scale(K)

k1 = dist(ka1, diag=TRUE, upper=TRUE)

khc = hclust(k1, method="single")
plot(khc, main="IGNEOUS.TXT")

khc = hclust(k1, method="average")
plot(khc, main="IGNEOUS.TXT")

khc = hclust(k1, method="centroid")
plot(khc, main="IGNEOUS.TXT")

comp.tree(k1, meth=c("single","average","median","centroid"))

comp.tree<-function(dx, meth=c("single","average","median","centroid")   )
  {
    ##  compare cluster analysis using different clustering methods
    
    N = length(meth)
    M1 = floor(N/2)
    M2 = ceiling(N/M1)
    
    
    op <- par(no.readonly = TRUE)
    par(mfrow= c(M2, M1), mar = c(3,3,1,1))
    
    for(i in 1:N)
      {
        hc = hclust(dx , method = meth[i])
        dend1 <- as.dendrogram(hc)
        plot(dend1, nodePar=list(pch = 2:1,cex=.4*2:1, col = 2:3), horiz = TRUE)
        title(main=meth[i])
      }
    par(op)
  }





###   carbonate  data

CARB.head = scan(file="D:/LEES/CLASSES/Data_Analysis/dos_files/CARBONAT.TXT",n=6, what='')

CARB = scan(file="D:/LEES/CLASSES/Data_Analysis/dos_files/CARBONAT.TXT", skip=1, list(name='',   sg=0,   sRI=0,   lRI=0,   bi=0,   hard=0))



CARB.head = scan(file="CARBONAT.TXT",n=6, what='')

CARB = scan(file="CARBONAT.TXT", skip=1, list(name='',   sg=0,   sRI=0,   lRI=0,   bi=0,   hard=0))



CA = cbind(CARB$sg,CARB$sRI,CARB$lRI,CARB$bi,CARB$hard) 

nam =  substr(CARB$name, 1,2)

colnames(CA)  = CARB.head[2:6]
rownames(CA) =  nam


ca1 = scale(CA)

d1 = dist(ca1, diag=TRUE, upper=TRUE)

c1  = cor(t(ca1))

### cor(t(CA))



########################
hc = hclust(d1, method="single")
plot(hc, main="Figure Davis 6-8 b")

### title("Figure Davis 6-8 b")


  hc = hclust(d1 , method = "single")
        dend1 <- as.dendrogram(hc)
        plot(dend1, nodePar=list(pch = 2:1,cex=.4*2:1, col = 2:3), horiz = TRUE)
        title(main="Figure Davis 6-8 b")

########################  other methods of cluster analysis

hc = hclust(d1, method="average")
plot(hc, main="Average")



hc = hclust(d1, method="centroid")
plot(hc, main="Centroid")


#####################  table 6-8 in Davis page 491
A = matrix(c(0.24, 1.78, 0.69, 3.32,
  0.48, 2.07, 2.41, 4.78,
  0.76, 4.05, 1.2, 3.21,
  0.23, 2.98, 0.85, 2.06,
  0.04, 3.33, 3.39, 2.63,
  1.98, 0.98, 2.01, 2.02), ncol=4, byrow=TRUE)


###  correlations:

### as per p. 489 in Davis,
####   transpose the matrix and find the correlation matrix
cA = cor(t(A))

dA = dist(scale(A), diag=TRUE, upper=TRUE)

plot(hclust(dA, method="single"))


plot(hclust(as.dist(1-cA), method="single"))


###  arithmetically combine the values at each stage

###  AB are clustered and CD are clustered but not E or F

cA2 = diag(rep(1,4))

cA2[1,2] = 
