t = seq(from=0, by=1/99, to=1);
y  = sin(2*pi*15*t) + sin(2*pi*40*t);

naive(y,1/99)

hanning.window
########    w(i) = 0.5 - 0.5*cos(2*pi*i/(n-1))
library(e1071)
########
########   convolution theorm and filtering
########
## create a hanning shaped filter int he time domain
h = hanning.window(10);
## convolve this with the input signal y

hx = convolve(y, h, type="filter");

##  plot y
plot(t,y, type='l')

##  plot the filter h
plot(t[1:length(h)],h, type='l')

##  plot the convolved sequence
plot(t[1:length(hx)],hx, type='l')


par(mfrow=c(3,1))
##  plot the the Amp Spectrum of the original series
naive(y, 1/99)
##  plot the the Amp Spectrum of the hanning filter
naive(h,1/99)

##  plot the the Amp Spectrum of  convolved sequence
naive(hx,1/99)
########

###  details

dt = 1/100

t = seq(from=0, by=dt, length=200);
y  = sin(2*pi*15*t) + sin(2*pi*40*t);

plot(t,y, type='l')


fty = fft(y)

m = Mod(fty)

phi = Arg(fty)


plot(m, type='l')

plot(phi, type='l')


f = (0:(length(y)-1))*100/length(y)

plot(f, m,  type='l')

plot(f, phi,  type='l')

mf = rep(0, length(m))

mf[f>30&f<80] = 1;
mp = mf * m;


plot(f, mp,  type='l')
A = m;
A[f>30&f<70] = 0;


plot(f, A,  type='l')

par(mfrow=c(2,1))
plot(f, m,  type='l')
plot(f, A,  type='l')

par(mfrow=c(1,1))

i = as.complex(0,1)

fo = A / (cos(phi)-i*sin(phi));

####  show original spectrum and filtered spectrum
par(mfrow=c(2,1))
plot(f, m,  type='l', main="Original Amplitude Spectrum")
plot(f, Mod(fo) ,  type='l', main="Filtered Amplitude Spectrum" )


ay = fft(fo, inverse = TRUE) / length(y)
#####  show original data and filtered data

plot(t,y,  type='l', main="Original Data")
plot(t, Re(ay) ,  type='l', main="Filtered Data" )

################################


## read in Co2 data
##  co2=scan(file="http://www.unc.edu/~leesj/CLASS/Data_Analysis/Data_Files/co2.dat")

data(co2)

###  co2 data is sampled once per month.  
##   Unit of time is one year.
##   so deltat = 1/12

dt = 1/12
t = seq(0, by=dt, length=length(co2))

co2=co2-mean(co2)

par(mfrow=c(1,1))
plot(t, co2, type='l')

##  find linear model and remove the trend
r1 = lm(co2 ~ t)

plot(t, r1$residuals, type='l')

rs = r1$residuals
naive(rs, dt)
###  note periodogram goes out to nyquist frequency
###  Nf  =  6  = 1/2deltat


## use filtering to remove the long period signal

fty = fft(rs)
m = Mod(fty)

phi = Arg(fty)

f = (0:(length(rs)-1))*12/length(rs)
par(mfrow=c(2,1))

plot(f, m,  type='l')
plot(f, phi,  type='l')



par(mfrow=c(1,1))

plot(f,  m,  type='l')
abline(v=f[length(f)/2], lty=2)

##  determine on plot where the cut-off points are for the filter

L = locator(1)
x1 = L$x[1]
x2 = (f[length(f)])-x1

abline(v=c(x1,x2), lty=1, col=2)

###########################################################
mf = rep(0, length(m))
###  high-pass filter (notice the logical and=&)
mf[ f>x1 & f<x2 ] = 1


###########################################################
mf = rep(0, length(m))
###  low-pass filter  (notice the logical or=|)
mf[ f<x1 | f>x2 ] = 1


###########################################################
###########################################################
###  once filter is determined, apply and plot results
mp = mf * m;
plot(f, mp,  type='l')

fo = mp / (cos(phi)-i*sin(phi));

##  inverse fourie transform the resulting filtered spectrum
ay = fft(fo, inverse = TRUE) / length(y)

plot(t, Re(ay), type='l')


###  band pass filter
plot(f,  m,  type='l')
abline(v=f[1+length(f)/2], lty=2)

L = locator(2)
x1 = L$x[1]
x2 = L$x[2]
x3 = (f[length(f)])-x1
x4 = (f[length(f)])-x2
abline(v=c(x1,x2, x3, x4), lty=1, col=2)
mtext(c("x1", "x2", "x3", "x4"), side=3, at=c(x1,x2, x3, x4))


###  for band pass:
mf = rep(0, length(m))
mf[ (f>x1 & f<x2) |  (f>x4 & f<x3 ) ] = 1

###  for band reject (notch):
mf = rep(1, length(m))
mf[ (f>x1 & f<x2) |  (f>x4 & f<x3 ) ] = 0


mp = mf * m;
plot(f, mp,  type='l')
###  re-introduce the phase into the amplitude
fo = mp / (cos(phi)-i*sin(phi));

##  inverse fourie transform the resulting filtered spectrum
ay = fft(fo, inverse = TRUE) / length(y)

plot(t, Re(ay), type='l')


###  for band reject (notch):
mf = rep(1, length(m))
mf[ (f>x1 & f<x2) |  (f>x4 & f<x3 ) ] = 0
mf = 1-mf


#########################
##  another way:
FIL = as.complex(mf, 0)

G = fty*FIL

plot(f, Mod(G), type='l')

ag = fft(G, inverse = TRUE) / length(y)

plot(t, Re(ag), type='l')

#####################################

###  instead of hitting it with a rectangle 
##   lets use a better window

plot(f, mf,  type='l')
###  create a cosine taper
z = rep(1, length=25)
zt = j.taper(z, 0.20)

k = length(zt)

c1=findInterval( ((x1+x2)/2), f)
c2=findInterval( ((x3+x4)/2), f)

zf = mf
zl = floor(k/2)
zf[ (c1-zl):(c1+zl) ] = zt
zf[ (c2-zl):(c2+zl) ] = zt

plot(zf)




w = mf[mf==1]




