data(lynx)
postscript(file ="Lynx.ps" , horizontal=TRUE, onefile=F,print.it=F)

plot(lynx, ylab = expression("Number Lynx Trappings"),las = 1)

title("Annual numbers of lynx trappings for 1821-1934 in Canada")
dev.off()

data(co2)

postscript(file ="CO2.ps" ,  horizontal=TRUE, onefile=F,print.it=F)


plot(co2, ylab = expression("Atmospheric concentration of CO"[2]),
          las = 1)

dev.off()

Oinfo = scan(file="/home/lees/DAT/O18.dat", n=6)


O18 = scan(file="/home/lees/DAT/O18.dat", skip=1)
o18 = scan(file="http://www.unc.edu/~leesj/CLASS/Data_Analysis/Data_Files/O18_GRIP.dat", list(y=0, o=0, b=0))

o18 = scan(file="H:/public_html/CLASS/Data_Analysis/Data_Files/O18_GRIP.dat", list(y=0, o=0, b=0))

x = seq(from=o18$y[1], to=o18$y[length(o18$y)], by=20)

NY = aspline(o18$y, y=o18$o , x,  ties = mean, method="original", degree=3)



postscript(file ="DO18.ps" , horizontal=TRUE, onefile=F,print.it=F)

plot(seq(from=0, by=3, length=length(O18)), O18, type='l', xlab=expression("Time, years 10^6"), ylab="Delta O18")
dev.off()

postscript(file ="SUNSPOTS.ps" , horizontal=TRUE, onefile=F,print.it=F)

plot(sunspots)
dev.off()

data(sunspots)
plot(sunspots)
acf(sunspots, lag.max=200)

data(nhtemp)
plot(nhtemp)

data(faithful)
plot(faithful)

data(airquality)
plot(airquality)

data(airmiles)
plot(airmiles)
##############################################

tseis = scan(file="D:/LEES/CLASSES/Data_Analysis/Data_Files/tseis.dat", skip=1)
tseis = scan(file="/home/lees/DAT/tseis", skip=1)

postscript(file ="Seismic.ps" , horizontal=TRUE, onefile=F,print.it=F)
plot(seq(0, by=0.004, length=length(tseis)) , tseis, type='l', xlab="Time, s", ylab="Amplitude" )
title("Seismic signal, DT=250 samp/s")
dev.off()



y = c ( 1.35,  1.00, -1.96, -2.17, -1.78, -4.21,
         -3.30, -1.43, -1.35, -0.34, -1.38,  0.30,
         -0.10, -4.13, -5.12, -2.13, -1.17, -1.24,
         -0.18,  0.29,  0.23,  0.00,  0.06,  0.17,
          0.98,  0.17,  1.59,  2.62,  1.96,  4.28,
          0.26, -1.66, -3.03, -1.80,  1.04,  3.06,
         -0.05,  1.68,  1.70, -0.73,  2.59,  6.77,
         -0.98, -1.71, -2.53, -0.61,  3.14,  2.96,
          1.01, -3.69,  0.45,  3.89,  1.38,  1.57,
         -0.08,  1.30,  0.62, -0.87, -2.11,  2.48,
         -4.73, -2.70, -2.45, -4.17, -5.76, -5.09,
         -2.92, -0.22,  1.42,  3.26,  0.05, -0.95,
         -2.14, -2.19, -1.96,  2.18, -2.97, -1.89,
          0.12, -0.76, -0.94, -3.90, -0.86, -2.88,
         -2.58, -2.78,  3.30,  2.06, -1.54, -1.30,
         -1.78, -0.13, -0.20, -1.35, -2.82, -1.97,
          2.25,  1.17, -2.29, -2.49, -0.87, -4.15, -0.53 )




y  = ts ( y, start=1975, frequency=12 )

par(mfrow=c(1,1))

fit.low = lowess ( time(y), y )

lines ( fit.low )

plot.ts( y, type="l", pch="*", main="Estimated level of exchange rate" )

for ( d in 1:4) {
  lines ( time(y),
          conj.update.dlm(y,delta=.6+.1*d,m.0=0,C.0=1,n.0=1,S.0=.01)$m,
          lty=d )
}
legend ( 1981, 6, legend=paste(delta=.6+.1*(1:4)), lty=1:4, bty="n" )
text ( 1981, 6.5, "Discount factor", adj=0 )

conj.update.dlm<-function ( Y, W=NA, delta, m.0, C.0, n.0, S.0 ) 
{
  N = length(y)
  m = rep( NA, length=N )
  n = rep( NA, length=N )
  C = rep( NA, length=N )
  R = rep( NA, length=N )
  Q = rep( NA, length=N )
  S = rep( NA, length=N )
  f = rep( NA, length=N )
  A = rep( NA, length=N )
  e = rep( NA, length=N )

  Y = c(NA,Y)
  
  C[1] = C.0
  m[1] = m.0
  S[1] = S.0
  n[1] = n.0

  for ( t in 2:N ) {
    n[t] = n[t-1] + 1
       ### to specify the model via a discount factor instead of W
       ### we use the following line
    if ( missing(W) & !missing(delta) ) W[t] = C[t-1] * (1-delta) / delta
    R[t] = C[t-1] + W[t]
    f[t] = m[t-1]
    Q[t] = R[t] + S[t-1]
    A[t] = R[t] / Q[t]
    e[t] = Y[t] - f[t]
    S[t] = S[t-1] + ( S[t-1]/n[t] ) * ( e[t]^2/Q[t] - 1 )
    m[t] = m[t-1] + A[t]*e[t]
    C[t] = A[t]*S[t]
  }

  return ( list ( m=m, C=C, R=R, f=f, Q=Q, n=n, S=S ) )
}
###########################################################
###########################################################
###########################################################


ss = scan(file="d:/LEES/CLASSES/Data_Analysis/dos_files/SONIC.TXT", skip=1, list(d=0, v=0, a=0))

plot(ss$v, ss$d, pch=ss$a, type='p')
