###
###
## source("/home/lees/Progs/R_stuff/KAM.R") 

#######################################################
readkammap<-function()
  {
    
    VMAP = scan(file="/home/lees/Bware/Van/Srfplt/map.to.plot", list(y=0, x=0, pen=0) )
    mind = seq(1,length(VMAP$y))
    
    begs = mind[VMAP$pen==3]
    vends = begs-1
    vends = c(vends[2:length(vends)], length(VMAP$pen))
    VMAP$begs = begs
    VMAP$vends = vends
    return(VMAP)
    ##  VMAP = readkammap()
  }

#######################################################
readkamSKS<-function()
  {
    ###  set up the sks splitting data from Valerie Peyton paper
    SKSDAT <<-  scan(file="/home/lees/Site/SEKS/SKS_PAP/SKS_DATA.txt", 
      list(sta=' ',baz=0,fast=0,del=0,azerr=0,delerr=0,xcor=0,snr1=0,snr2=0,	over=0,	event=' '))
    
    SKSEVS <<- scan(file="/home/lees/Site/SEKS/SKS_PAP/Peyton_events", skip=1,
      list(lat=0, lon=0, id=' '))
    
    STA <<- scan(file="/home/lees/Site/SEKS/stations.SEKS",	list(sta=' ',lat=0, lon=0, z=0))


    msta = match(SKSDAT$sta, STA$sta)
    
    SKSDAT$lat  <<-  STA$lat[msta]
    SKSDAT$lon  <<-  STA$lon[msta]
    

   
    ##  readkamSKS()
  }



#######################################################
## source("/home/lees/Progs/R_stuff/KAM.R") 

pkammap<-function(VMAP)
  {
    ## pkammap(VMAP)


    if(exists("MAPLIM")==TRUE)
      {
        plot(range(MAPLIM$x), range(MAPLIM$y), asp=1.8, type='n', xlab = "", ylab = "")
      }
    else
      {
        
        plot(range(VMAP$x), range(VMAP$y), asp=1.8, type='n', xlab = "", ylab = "")
      }
    
    for(i in 1:length(VMAP$begs))
      {
        lines(VMAP$x[VMAP$begs[i]:VMAP$vends[i]],VMAP$y[VMAP$begs[i]:VMAP$vends[i]], col='DodgerBlue' )
      }

    points(STA$lon, STA$lat, pch=6)
  }
                  
#######################################################
#######################################################
## source("/home/lees/Progs/R_stuff/KAM.R") 

plotSKS<-function()
  {
   ## pkammap(VMAP); plotSKS()
    
    u = par('usr')
    d1 = 0.1*(u[2]-u[1])
    if(exists("PBAR1")==FALSE)
      {
        PBAR1<<-locator(1)
      }

    a1 = PBAR1$x[1]
    b1 = PBAR1$y[1]
    
    segments(a1,b1,a1+d1,b1)

    angle = SKSDAT$fast
    x1 = SKSDAT$lon+  d1*0.5* SKSDAT$del* cos( pi*(angle-180)/180)
    y1 = SKSDAT$lat+  d1*0.5* SKSDAT$del* sin( pi*(angle-180)/180)

    x2 = SKSDAT$lon+  d1*0.5* SKSDAT$del* cos( pi*(angle)/180)
    y2 = SKSDAT$lat+  d1*0.5* SKSDAT$del* sin( pi*(angle)/180)

    ## segments(x1,y1,x2,y2)
    arrows(x1,y1,x2,y2, length = 0.05, code=3)
    

  }
#######################################################
## source("/home/lees/Progs/R_stuff/KAM.R") 


plotSKSproj<-function( dfac=0.1)
  {
   ##
###  PROJmap(KamMAP,LAT=min(MAPLIM$y), LON=min(MAPLIM$x), pts=STA, WIN=MAPLIM , ADD=FALSE, ASP=TRUE)
###   plotSKSproj(OLAT=min(MAPLIM$y), OLON=min(MAPLIM$x))
###

    if(missing(dfac)) { dfac = 0.1 }
    
    u = par('usr')

    
    d1 = dfac*(u[2]-u[1])

    
    if(exists("PBAR1")==FALSE)
      {
        PBAR1<<-locator(1)
      }

    a1 = PBAR1$x[1]
    b1 = PBAR1$y[1]
    
    arrows(a1,b1,a1+d1,b1, length = 0.05, code=3, lwd=1)

    angle = 90-SKSDAT$fast

    PKM = GLOB.XY( SKSDAT$lat , SKSDAT$lon )
    
    x1 = PKM$x+  d1*0.5* SKSDAT$del* sin( pi*(angle-180)/180)
    y1 = PKM$y+  d1*0.5* SKSDAT$del* cos( pi*(angle-180)/180)

    x2 = PKM$x+  d1*0.5* SKSDAT$del* sin( pi*(angle)/180)
    y2 = PKM$y+  d1*0.5* SKSDAT$del* cos( pi*(angle)/180)

    ## segments(x1,y1,x2,y2)
    arrows(x1,y1,x2,y2, length = 0.05, code=3, lwd=2)
    

  }

