########### read in a leesmap file
###   source("LEESMAP.R"); save.image()

#################################################################
###  need a program to read in a leesmap and create a list in R
#################################################################


zebra<-function(x,y,Dx, dx, dy, lab="", PMAT=NULL)
{
###  draw a zebra bar km scale on a map
###  x, y = location of left point 
###   DX  =length km
###    dx  = alternating distance
###   dy = thickness of zebra


  if(missing(PMAT)) { PMAT=NULL  }
  if(missing(lab)) { lab=NULL  }
   
  for(i in 1:(Dx/dx))
    {
      px1 = x+(i-1)*dx
      py1 = y
      px2 = x+(i)*dx
      py2 = y+dy

      if(!is.null(PMAT))
        {
          tem1 = trans3d(px1, py1, rep(0, length(py1)) , PMAT)
          tem2 = trans3d(px2, py2, rep(0, length(py2)) , PMAT)
          rect(tem1$x[1], tem1$y[1], tem2$x[1], tem2$y[1], col=i%%2)

        }
      else
        {
          rect(px1, py1, px2, py2, col=i%%2)
        }
      
    }


  if(!is.null(PMAT))
    {
      tem1 = trans3d(x, y, rep(0, length(y)) , PMAT)
      text(tem1$x[1], tem1$y[1], labels="0", pos=1)
      
      tem1 = trans3d(px2, y, rep(0, length(y)) , PMAT)
      text(tem1$x[1], tem1$y[1], labels=Dx, pos=1 )
      
      tem1 = trans3d((x+px2)/2, y, rep(0, length(y)) , PMAT)
      text(tem1$x[1], tem1$y[1], labels=lab, pos=3 )
    }
  else
    {
      text(x,y, labels="0", pos=1)
      text(px2, y, labels=Dx, pos=1 )
      text((x+px2)/2, y, labels=lab, pos=3)
    }

}


#################################################################
#################################################################
gleesmap<-function(fn)
{
###   get a leesmap from an ascii file.
  ###  the ascii file is gernated from a leesmap using  driveleesmap input.leesmap
  
  fstks = paste(sep='', fn, ".strks")
  fpnts = paste(sep='', fn, ".pnts")

  stks =  scan(file=fstks, list(nam='', num=0, index=0, col=0, style=0))
  pnts=scan(file=fpnts, list(lat=0, lon=0))

  return(list(STROKES=stks, POINTS=pnts))

}
#################################################################
###   source("LEESMAP.R"); save.image()

#################################################################
boundleesmap<-function(MAP)
{
  ## the the bounds of strokes in a leesmap
  
 Kstroke = length(MAP$STROKES$num)

 LAT1 = rep(NA, length=Kstroke)
 LAT2 = rep(NA, length=Kstroke)
 LON1 = rep(NA, length=Kstroke)
 LON2 = rep(NA, length=Kstroke)
 
  for(i in 1:Kstroke)
    {
      j1 = MAP$STROKES$index[i]+1
      j2 = j1+MAP$STROKES$num[i]-1

      blon  = range(MAP$POINTS$lon[j1:j2])
      blat  = range(MAP$POINTS$lat[j1:j2])
      LAT1[i] = blat[1]
      LAT2[i] = blat[2]
      LON1[i] = blon[1]
      LON2[i] = blon[2]
      
    }

 MAP$STROKES$LAT1=LAT1
 MAP$STROKES$LAT2=LAT2
 MAP$STROKES$LON1=LON1
 MAP$STROKES$LON2=LON2

 return(MAP)
}





#################################################################
###   source("LEESMAP.R"); save.image()
####  worldmap = gleesmap("/home/lees/Site/World/world.leesmap")
####  worldmap = boundleesmap(worldmap)
#################################################################
#################################################################
plotleesmap<-function(MAP, LIM=c(-180, -90, 180, 90) , add=TRUE, ...)
{
  if(missing(add)) { add=FALSE }
  if(missing(LIM))
    {
      lon = fmod(MAP$POINTS$lon, 360)
      LIM=c( min(lon), min(MAP$POINTS$lat), max(lon), max(MAP$POINTS$lat))
    }
  

###  determine stroke inclusion

###  (x2>=x3)&&(x4>=x1)&& (y2>=y3)&&(y4>=y1)

  y1 = MAP$STROKES$LAT1
  y2 = MAP$STROKES$LAT2
  x1 = fmod(MAP$STROKES$LON1, 360)
  x2 = fmod(MAP$STROKES$LON2, 360)

  y3 = LIM[2]
  y4 = LIM[4]
  x3 = fmod(LIM[1], 360)
  x4 = fmod(LIM[3], 360)
  

  
  OUT = y1>=y4 | x1>=x4 | y2 <= y3 | x2 <= x3

  IN = which(!OUT)
  
 ###   MAP$STROKES$LAT1>=LIM[1] 
print(IN)
  
  Kstroke = length(MAP$STROKES$num)
  ####   for(i in 1:Kstroke)


    if(add==FALSE)
    {
      ##  plot(MAP$POINTS$lon, MAP$POINTS$lat, type='n')
      ##  xlab="Lon", ylab="Lat",
      ## if(is.null(xlab)) { xlab="Lon" }
      plot(fmod(MAP$POINTS$lon, 360), MAP$POINTS$lat, xlim=fmod(c(LIM[1], LIM[3]), 360)  , ylim=c(LIM[2], LIM[4]), type='n',  ...)
    }



     for(i in IN)
    {

      
      j1 = MAP$STROKES$index[i]+1
      j2 = j1+MAP$STROKES$num[i]-1

      if(MAP$STROKES$style[i]==1)
        {
          points(fmod(MAP$POINTS$lon[j1:j2], 360), MAP$POINTS$lat[j1:j2], col=MAP$STROKES$col[i])
        }

      
      if(MAP$STROKES$style[i]==2)
        {
          lines(fmod(MAP$POINTS$lon[j1:j2], 360), MAP$POINTS$lat[j1:j2], col=MAP$STROKES$col[i])
        }

      if(MAP$STROKES$style[i]==3)
        {
          polygon(fmod(MAP$POINTS$lon[j1:j2], 360), MAP$POINTS$lat[j1:j2], border=FALSE, col=MAP$STROKES$col[i])
        }



      
      ##  locator()

    }

}

##################################
#################################################################
#################################################################
###   source("LEESMAP.R"); save.image()
#################################################################
#################################################################
Aplotleesmap<-function(MAP, LIM=c(-180, -90, 180, 90) , add=TRUE, ...)
{
  if(missing(add)) { add=FALSE }
  if(missing(LIM))
    {
      lon =MAP$POINTS$lon
      LIM=c( min(lon), min(MAP$POINTS$lat), max(lon), max(MAP$POINTS$lat))
    }
  

###  determine stroke inclusion

###  (x2>=x3)&&(x4>=x1)&& (y2>=y3)&&(y4>=y1)

  y1 = MAP$STROKES$LAT1
  y2 = MAP$STROKES$LAT2
  x1 = MAP$STROKES$LON1
  x2 = MAP$STROKES$LON2

  y3 = LIM[2]
  y4 = LIM[4]
  x3 = LIM[1]
  x4 = LIM[3]
  

  
  OUT = y1>=y4 | x1>=x4 | y2 <= y3 | x2 <= x3

  IN = which(!OUT)
  
 ###   MAP$STROKES$LAT1>=LIM[1] 
print(IN)
  
  Kstroke = length(MAP$STROKES$num)
  ####   for(i in 1:Kstroke)


    if(add==FALSE)
    {
      ##  plot(MAP$POINTS$lon, MAP$POINTS$lat, type='n')
      ##  xlab="Lon", ylab="Lat",
      ## if(is.null(xlab)) { xlab="Lon" }
      plot(MAP$POINTS$lon, MAP$POINTS$lat, xlim=c(LIM[1], LIM[3])  , ylim=c(LIM[2], LIM[4]), type='n',  ...)
    }



     for(i in IN)
    {

      
      j1 = MAP$STROKES$index[i]+1
      j2 = j1+MAP$STROKES$num[i]-1

      if(MAP$STROKES$style[i]==1)
        {
          points(MAP$POINTS$lon[j1:j2], MAP$POINTS$lat[j1:j2], col=MAP$STROKES$col[i])
        }

      
      if(MAP$STROKES$style[i]==2)
        {
          lines(MAP$POINTS$lon[j1:j2], MAP$POINTS$lat[j1:j2], col=MAP$STROKES$col[i])
        }

      if(MAP$STROKES$style[i]==3)
        {
          polygon(MAP$POINTS$lon[j1:j2], MAP$POINTS$lat[j1:j2], border=FALSE, col=MAP$STROKES$col[i])
        }



      
      ##  locator()

    }

}



##################################
#################################################################
Wplotleesmap<-function(MAP, LIM=c(-180, -90, 180, 90) , add=TRUE)
{
  if(missing(add)) { add=FALSE }
   if(missing(LIM)) { LIM=c(min(MAP$POINTS$lon), min(MAP$POINTS$lat), max(MAP$POINTS$lon), max(MAP$POINTS$lat))  }
 
  if(add==FALSE)
    {
      ##  plot(MAP$POINTS$lon, MAP$POINTS$lat, type='n')
      plot(MAP$POINTS$lon, MAP$POINTS$lat, xlim=c(LIM[1], LIM[3]), ylim=c(LIM[2], LIM[4]), type='n')

      
    }


  ###  determine stroke inclusion

  ###  (x2>=x3)&&(x4>=x1)&& (y2>=y3)&&(y4>=y1)

y1 = MAP$STROKES$LAT1
y2 = MAP$STROKES$LAT2
x1 = MAP$STROKES$LON1
x2 = MAP$STROKES$LON2

y3 = LIM[2]
y4 = LIM[4]
x3 = LIM[1]
x4 = LIM[3]
  

  
OUT = y1>=y4 | x1>=x4 | y2 <= y3 | x2 <= x3

   IN = which(!OUT)
  
 ###   MAP$STROKES$LAT1>=LIM[1] 

  Kstroke = length(MAP$STROKES$num)
  ####   for(i in 1:Kstroke)

     for(i in IN)
    {

      
      j1 = MAP$STROKES$index[i]+1
      j2 = j1+MAP$STROKES$num[i]-1

      if(MAP$STROKES$style[i]==1)
        {
          points(MAP$POINTS$lon[j1:j2], MAP$POINTS$lat[j1:j2], col=MAP$STROKES$col[i])
        }

      
      if(MAP$STROKES$style[i]==2)
        {
          lines(MAP$POINTS$lon[j1:j2], MAP$POINTS$lat[j1:j2], col=MAP$STROKES$col[i])
        }

      if(MAP$STROKES$style[i]==3)
        {
          polygon(MAP$POINTS$lon[j1:j2], MAP$POINTS$lat[j1:j2], border=FALSE, col=MAP$STROKES$col[i])
        }



      
      ##  locator()

    }

}

#################################################################
###   source("LEESMAP.R"); save.image()


xseclines<-function(lat1, lon1, lat2, lon2, labs=null, PMAT=NULL, ... )
  {
    if(missing(PMAT)) { PMAT=NULL  }
    if(missing(labs)) { labs=NULL }

    xsecxy1 = GLOB.XY(lat1,  lon1 )
    if(!is.null(PMAT))
      {
        tem1 = trans3d(xsecxy1$x, xsecxy1$y, rep(0, length(xsecxy1$y)) , PMAT)
        xsecxy1$x = tem1$x
         xsecxy1$y = tem1$y    
      }
    xsecxy2 = GLOB.XY(lat2,  lon2 )
    if(!is.null(PMAT))
      {
        tem2 = trans3d(xsecxy2$x, xsecxy2$y, rep(0, length(xsecxy2$y)) , PMAT)
                xsecxy2$x = tem2$x
         xsecxy2$y = tem2$y    

      }

    segments(xsectem1$x, xsectem1$y, xsectem2$x,xsectem2$y, ...)

    if(!is.null(labs))
      {

        alpha = 180*atan2(xsectem2$y-xsectem1$y, xsectem2$x-xsectem1$x)/pi
        ### xlabs =cbind( c("A", "B", "C"), c("A'", "B'", "C'"))
        for(i in 1:length(xsectem1$x))
          {
        text(xsectem1$x[i], xsectem1$y[i], labels=xlabs[i,1], pos=3, srt=alpha[i])
        
        text(xsectem2$x[i], xsectem2$y[i], labels=xlabs[i,2], pos=3, srt=alpha[i])
      }

      }


  }



addTIX<-function(lats, lons, PMAT=NULL, col=gray(0.7), TICS=c(1,1), OUTER=TRUE, sides=c(1,2,3,4) )
{
   if(missing(col)) {col=gray(0.7)}
   if(missing(TICS)) { TICS=NULL }
   if(missing(OUTER)) { OUTER=TRUE }
   if(missing(sides)) { sides=c(1,2,3,4)  }
   if(missing(PMAT)) { PMAT=NULL  }




   #####   first do longitudes along a given latitude:
   if(is.null(TICS)) { return() }

   #####

   if(any(sides==1))
     {
        i = lats[1]

   if(OUTER==TRUE)
     {
        j = lons
      }
   else
     {
       j = lons[-c(1, length(lons))]
     }
        
        xy = GLOB.XY(rep(i, length(j)), j  )
        txy = GLOB.XY(rep(i, length(j))+TICS[1], j  )
        if(!is.null(PMAT))
          {
            tem = trans3d(xy$x, xy$y, rep(0, length(xy$y)) , PMAT)
            xy$x = tem$x
            xy$y = tem$y
            tem = trans3d(txy$x, txy$y, rep(0, length(txy$y)) , PMAT)
            txy$x = tem$x
            txy$y = tem$y
          }

        segments(xy$x, xy$y, txy$x, txy$y)

      }

   if(any(sides==3))
     {
       i = lats[length(lats)]
       
       if(OUTER==TRUE)
         {
           j = lons
         }
       else
         {
           j = lons[-c(1, length(lons))]
         }
       
       xy = GLOB.XY(rep(i, length(j)), j  )
       txy = GLOB.XY(rep(i, length(j))-TICS[1], j  )
       if(!is.null(PMAT))
         {
           tem = trans3d(xy$x, xy$y, rep(0, length(xy$y)) , PMAT)
           xy$x = tem$x
           xy$y = tem$y
           tem = trans3d(txy$x, txy$y, rep(0, length(txy$y)) , PMAT)
            txy$x = tem$x
           txy$y = tem$y
         }
       
       segments(xy$x, xy$y, txy$x, txy$y)
       
     }


   ###  then do latitudes along a given longitude
   if(any(sides==2))
     {
       if(OUTER==TRUE)
         {        
           i = lats
         }
       else
         {
           i = lats[-c(1, length(lats))]
           
         }
       j = lons[1]
       
       xy = GLOB.XY(i,  rep(j, length(i)) )
       txy = GLOB.XY(i,  rep(j, length(i))+TICS[2] )
       
       if(!is.null(PMAT))
         {
           tem = trans3d(xy$x, xy$y, rep(0, length(xy$y)) , PMAT)
           xy$x = tem$x
           xy$y = tem$y
           
           tem = trans3d(txy$x, txy$y, rep(0, length(txy$y)) , PMAT)
           txy$x = tem$x
           txy$y = tem$y
           
         }
       segments(xy$x, xy$y, txy$x, txy$y)
     }
   if(any(sides==4))
     {
       if(OUTER==TRUE)
         {        
           i = lats
         }
       else
         {
           i = lats[-c(1, length(lats))]
           
         }
       j = lons[length(lons)]
       
       xy = GLOB.XY(i,  rep(j, length(i)) )
       txy = GLOB.XY(i,  rep(j, length(i))-TICS[2] )
       
       if(!is.null(PMAT))
         {
           tem = trans3d(xy$x, xy$y, rep(0, length(xy$y)) , PMAT)
           xy$x = tem$x
           xy$y = tem$y
           
           tem = trans3d(txy$x, txy$y, rep(0, length(txy$y)) , PMAT)
           txy$x = tem$x
           txy$y = tem$y
           
         }
       segments(xy$x, xy$y, txy$x, txy$y)
     }
      
}


################################################################################################
################################################################################################
GetBORDXY<-function(lats, lons, col=0)
  {
  if(missing(col)) {col=0}


  LATS = c(rep(min(lats), 12), seq(from=min(lats), to=max(lats), length=12), rep(max(lats), 12), seq(from=max(lats), to=min(lats), length=12))

  LONS = c(seq(from=min(lons), to=max(lons), length=12), rep(max(lons), 12), seq(from=max(lons), to=min(lons), length=12), rep(min(lons), 12))
  
  xy = GLOB.XY(LATS , LONS  )

  ########lines(xy$x, xy$y, col=col)
  
  return(xy)
  }
########
#######################################################################################################
#########################################################################################


addLLXY<-function(lats, lons, PMAT=NULL, col=gray(0.7), GRID=TRUE, GRIDcol=1, LABS=NULL, LABcol=1, BORDER=NULL, TICS=c(1,1))
  {

    if(missing(col)) {col=gray(0.7)}
    if(missing(GRID)) { GRID = TRUE }
    if(missing(GRIDcol)) { GRIDcol = gray(0.7) }
    if(missing(LABS)) { LABS =NULL }
    if(missing(LABcol)) { LABcol = 1 }
    
    if(missing(BORDER)) { BORDER=NULL }
    if(missing(TICS)) { TICS=NULL }

    

    
########  latitudes

    if(!is.null(GRIDcol) )
      {
        col = GRIDcol
        for(i in lons)
          {
            xy = GLOB.XY(lats ,  rep(fmod(i, 360), length(lats))  )
            if(!is.null(PMAT))
              {
                tem = trans3d(xy$x, xy$y, rep(0, length(xy$y)) , PMAT)
                xy$x = tem$x
                xy$y = tem$y
              }

            lines(xy$x, xy$y, col=GRIDcol, lty=2, lwd=.4, xpd=TRUE )

          }

########  longitudes
        for(i in lats)
          {
            xy = GLOB.XY(rep(i, length(lons)), lons  )

            if(!is.null(PMAT))
              {
                tem = trans3d(xy$x, xy$y, rep(0, length(xy$y)) , PMAT)
                xy$x = tem$x
                xy$y = tem$y
              }

            lines(xy$x, xy$y,  col=GRIDcol, lty=2, lwd=.4, xpd=TRUE )

          }
      }

    if(!is.null(TICS))
      {
        addTIX(lats, lons, PMAT=PMAT, col=GRIDcol, TICS=TICS)
        
      }
    
###  anotations
###  longitudes

    if(!is.null(LABS))
      {
        col = LABcol
        i = lats[1]
        j = lons[-1]
        
        xy = GLOB.XY(rep(i, length(j)), j  )
        
        if(!is.null(PMAT))
          {
            tem = trans3d(xy$x, xy$y, rep(0, length(xy$y)) , PMAT)
            xy$x = tem$x
            xy$y = tem$y
          }
        
###i = lats[2]
###xy2 = GLOB.XY(rep(i, length(lons)), lons  ) 
###angs = 180*atan2(xy$y-xy2$y,xy$x-xy2$x   )/pi
        
        degs = floor(j)
        mins = round(60*(j-degs))

        for(k in 1:length(j))
          {
            #print(paste(sep=' ', degs[k], mins[k]))

            
            if(mins[k]==0)
              {
                text(xy$x[k], xy$y[k], labels=bquote(.(degs[k])*degree)  , xpd=TRUE, pos=1, col=col)
                
                
              }
            else
              {
                text(xy$x[k], xy$y[k], labels=bquote(.(degs[k])*degree ~ .(mins[k])*minute)  , xpd=TRUE, pos=1, col=col)

              }
          }
        
        i = lats[-1]
        j = lons[1]
        
        xy = GLOB.XY(i,  rep(j, length(i)) )
        if(!is.null(PMAT))
          {
            tem = trans3d(xy$x, xy$y, rep(0, length(xy$y)) , PMAT)
            xy$x = tem$x
            xy$y = tem$y
          }
        
        degs = floor(i)
        mins = round(60*(i-degs))
        for(k in 1:length(i))
          {
            if(mins[k]==0)
              {
               text(xy$x[k], xy$y[k], labels=bquote(.(degs[k])*degree)  , xpd=TRUE, pos=2, col=col)
              }
            else
              {
                 text(xy$x[k], xy$y[k], labels=bquote(.(degs[k])*degree ~ .(mins[k])*minute)  , xpd=TRUE, pos=1, col=col)
                
              }
          }
        
      }
    
    
  }

#################################################################
###   source("LEESMAP.R"); save.image()

plotleesmapXY<-function(MAP, LIM=c(-180, -90, 180, 90), PMAT=NULL, add=TRUE, GRID=NULL, GRIDcol=1, cenlon=0, linelty=1, ...)
{
  if(missing(cenlon)) { cenlon=0 }
  if(missing(GRID)) { GRID=NULL }
    if(missing(GRIDcol)) { GRIDcol=1 }
  if(missing(PMAT)) { PMAT=NULL }
  if(missing(linelty)) { linelty=1 }
    
  if(missing(LIM))
    {
      
      LIM=c(min(MAP$POINTS$lon), min(MAP$POINTS$lat), max(MAP$POINTS$lon), max(MAP$POINTS$lat))

    }

  LLlim = list(lat=LIM[c(2,4)], lon=LIM[c(1,3)])
  
  if(missing(add)) { add=FALSE }


  if(exists("PROJ.DATA")==FALSE)
    {
      setPROJ(type=2, LAT0=median(MAP$POINTS$lat), LON0=median(MAP$POINTS$lon) , LATS=NULL, LONS=NULL, DLAT=NULL, DLON=NULL, FN =0)
    }

  
  if(is.null(MAP$POINTS$x))
    {
      MAPXY = GLOB.XY(MAP$POINTS$lat ,  fmod( MAP$POINTS$lon, 360)  )

      if(is.null(PMAT))
        {
          MAP$POINTS$x = MAPXY$x
          MAP$POINTS$y = MAPXY$y
        }
      else
        {
          tem = trans3d(MAPXY$x, MAPXY$y, rep(0, length(MAPXY$y)) , PMAT)
          MAP$POINTS$x = tem$x
          MAP$POINTS$y = tem$y
        }

      STRKXYLL = GLOB.XY( MAP$STROKES$LAT1,  fmod(MAP$STROKES$LON1, 360)  )
      STRKXYUR = GLOB.XY( MAP$STROKES$LAT2,  fmod(MAP$STROKES$LON2, 360)  )


      
      if(is.null(PMAT))
        {
          MAP$STROKES$x1 = STRKXYLL$x
          MAP$STROKES$y1 = STRKXYLL$y
        }
      else
        {
          tem = trans3d(STRKXYLL$x, STRKXYLL$y, rep(0, length(STRKXYLL$y)) , PMAT)

          MAP$STROKES$x1= tem$x
          MAP$STROKES$y1= tem$y
        }


      
      if(is.null(PMAT))
        {
          MAP$STROKES$x2 = STRKXYUR$x
          MAP$STROKES$y2 = STRKXYUR$y
        }
      else
        {

          tem = trans3d(STRKXYUR$x, STRKXYUR$y, rep(0, length(STRKXYUR$y)) , PMAT)

          MAP$STROKES$x2= tem$x
          MAP$STROKES$y2= tem$y
        }

    }
  
 
  xrange = diff(range(MAP$POINTS$x))
  yrange = diff(range(MAP$POINTS$y))

  Kstroke = length(MAP$STROKES$num)


  ###  if(exists("worldmap"))

  if(TRUE)
    {
      y1 = MAP$STROKES$LAT1
      y2 = MAP$STROKES$LAT2
      x1 =   fmod(MAP$STROKES$LON1, 360)
      x2 =   fmod(MAP$STROKES$LON2, 360)
      
      
      y3 = LIM[2]
      y4 = LIM[4]
      x3 =  fmod(LIM[1], 360)
      x4 =  fmod(LIM[3], 360)
      
      
      
      OUT = y1>=y4 | x1>=x4 | y2 <= y3 | x2 <= x3
      
      IN = which(!OUT)
    }
  else
    {
      IN = 1:length(MAP$STROKES$num)

    }

  

  if(add==FALSE)
    {
      plot(c(MAP$STROKES$x1[IN],MAP$STROKES$x2[IN]) , c(MAP$STROKES$y1[IN], MAP$STROKES$y2[IN]), asp=TRUE, type='n', ...)

    }
  if(!is.null(GRID))
    {
      addLLXY(GRID$lats, GRID$lons, PMAT=PMAT, GRIDcol=GRIDcol, LABS=0, BORDER=0 )
    }
  
  for(i in IN)
    {
      j1 = MAP$STROKES$index[i]+1
      j2 = j1+MAP$STROKES$num[i]-1
      ###  print(paste(sep=' ',"----------------------", i, j1,j2))
      if(MAP$STROKES$style[i]==1)
        {
          points(MAP$POINTS$x[j1:j2], MAP$POINTS$y[j1:j2], col=MAP$STROKES$col[i])
        }

      
      if(MAP$STROKES$style[i]==2)
        {
          x = MAP$POINTS$x[j1:j2]
          y = MAP$POINTS$y[j1:j2]

         
          
          xd = abs(diff(c(x, x[1])))
          ww = which(xd>0.9*xrange)
          if(!is.null(ww) & length(ww)>0 )
            {
              print(paste(sep=' ', "################", i, length(x), length(ww)))
              print(x)
              ##  print(ww)
              wdi = c(0, ww, length(x))
              
              print(wdi)
              for(j in 1:(length(wdi)-1))
                {
                  if((wdi[j+1])<(wdi[j]+1)) next
                  ind = seq(from=(wdi[j]+1), to=(wdi[j+1]), by=1)
                  lines(x[ind], y[ind], col=MAP$STROKES$col[i], lty=linelty)
                }

              
            }
          else
            {
              x[MAP$POINTS$lon[j1:j2]<LLlim$lon[1] |  MAP$POINTS$lon[j1:j2]>LLlim$lon[2] ] = NA
              y[MAP$POINTS$lat[j1:j2]<LLlim$lat[1] |  MAP$POINTS$lat[j1:j2]>LLlim$lat[2] ] = NA
              
              lines(x, y, col=MAP$STROKES$col[i], lty=linelty)
            } 
        }

      if(MAP$STROKES$style[i]==3)
        {
          polygon(MAP$POINTS$x[j1:j2], MAP$POINTS$y[j1:j2], border=FALSE, col=MAP$STROKES$col[i])
        }



      
      ##  locator()

    }

}
#################################################################
###   source("LEESMAP.R"); save.image()
