##############
############## source("/home/lees/Progs/R_stuff/MLAB.R")
###   focmec(az1, dip1, az2, dip2)


focmec<-function(az1, dip1, az2, dip2)
  {

#  %  
 DEG2RAD=0.017453293;
 
 RAD2DEG=57.295778667;

  num = 40;


#[cx,cy] = circle;
 C = circle()

#%  M F  20 35 G 222 57 U 200 55 V  42 33 P 213 11 T  76 75


#% patch(cx,cy, 3)
plot(C$x,C$y, type='l', asp=1, axes=FALSE, xlab="", ylab="")
   
F1 = fmtraj(dip1, az1, 1);
 
k = length(F1$x);

F2  = fmtraj(dip2, az2, 1);

#hold on

#% plot(fx1,fy1);
#% plot(fx1(1), fy1(1), 'ro');
#% plot(fx2(1), fy2(1), 'go');

#% plot(fx1(k), fy1(k), 'rx');
#% plot(fx2(k), fy2(k), 'gx');

alpha1 = atan2(F1$y[1], F1$x[1]);

alpha2 = atan2(F1$y[k], F1$x[k]);

beta1 = atan2(F2$y[1], F2$x[1]);

beta2 = atan2(F2$y[k], F2$x[k]);

a1 = RAD2DEG * alpha1;
a2 = RAD2DEG * alpha2;
b1 = RAD2DEG * beta1;
b2 = RAD2DEG * beta2;

#print(paste(sep=" ", a1,a2, b1, b2))


tx1= rep(0,num);
ty1  = rep(0,num);
dang = (beta1-alpha2)/num;

ang = alpha2;

for(i in 1:40)
  {
   ang = ang+dang;
   tx1[i] = cos(ang);
   ty1[i] = sin(ang);
 }
     
tx2= rep(0,num);
ty2  = rep(0,num);
dang = (alpha1-beta2)/num;

ang = beta2;
for(i in 1:40)
  {
   ang = ang+dang;
   tx2[i] = cos(ang);
   ty2[i] = sin(ang);
#% fprintf(1, '%6.2f  %6.2f\n',x,y);

 # % plot(x,y, 'r+')
 }
   
# %plot(fx2,fy2);

Px = c(F1$x, tx1, F2$x, tx2);
  Py = c(F1$y, ty1, F2$y, ty2);


#patch(Px, Py, [.85 .85 1]);

polygon(Px, Py, col=gray(0.85) )
  
lines(F1$x,F1$y, col=2);

 dip.points(az1, dip1, az2, dip2 );

 pole.points(az1, dip1, az2, dip2 );

circ.tics()
   
tit = paste(sep=" ", "F =", prang(az1), prang(dip1), " G = ",  prang(az2), prang(dip2));
title(tit)

#hold off
  }
#######################
dip.points<-function(az1, dip1, az2, dip2 )
  {
DEG2RAD =		0.017453293;
#% az1, dip1, az2, dip2
tdip = dip1;
trot =az1;

 xi = DEG2RAD * (90 - tdip);
  tq = sqrt(2) * sin(xi / 2.0);
  pltx = tq * sin(DEG2RAD * (180+trot));
  plty = tq * cos(DEG2RAD * (180+trot)); 
points( pltx, plty , col=4, pch=2)

tdip = dip2;
trot =az2;

 xi = DEG2RAD * (90 - tdip);
  tq = sqrt(2) * sin(xi / 2.0);
  pltx = tq * sin(DEG2RAD * (180+trot));
  plty = tq * cos(DEG2RAD * (180+trot)); 
points( pltx, plty , col=2, pch=2)
}
########################
pole.points<-function(az1, dip1, az2, dip2 )
  {
DEG2RAD =		0.017453293;
##% az1, dip1, az2, dip2
tdip = dip1;
trot =az1;

 xi = DEG2RAD * ( tdip);
  tq = sqrt(2) * sin(xi / 2.0);
  pltx = tq * sin(DEG2RAD * (trot));
  plty = tq * cos(DEG2RAD * (trot)); 
points( pltx, plty , col=4, pch=1)

tdip = dip2;
trot =az2;

 xi = DEG2RAD * ( tdip);
  tq = sqrt(2) * sin(xi / 2.0);
  pltx = tq * sin(DEG2RAD * (trot));
  plty = tq * cos(DEG2RAD * (trot)); 
points( pltx, plty , col=2, pch=1)
}
 ##########################
TP.2.XYZ<-function(trend, dip)
  {
###%  
   DEG2RAD = 0.017453293;
###% OLD geotouch version  t = (90 - trend) * DEG2RAD;

  t = (90 - trend) * DEG2RAD;


  p = dip * DEG2RAD;

  x1 = cos(t) * sin(p);
  x2 = sin(t) * sin(p);
  x3 = cos(p);
   return(list(x=x1, y=x2, z=x3))
 }



##########################
null.plane<-function(az1, dip1, az2, dip2)
  {
 DEG2RAD =		0.017453293;
 RAD2DEG	=	57.295778667;


a = TP.2.XYZ(az1 , dip1);

b = TP.2.XYZ(az2 , dip2 );

cee = CROSS(a,b);

trendc = 90-RAD2DEG*atan2(cee$y, cee$x);

dipc = 90-RAD2DEG*acos(cee$z);
     
C  = fmtraj(90-dipc, trendc, 1);


dip.point(trendc, 90-dipc);

lines(C$x,C$y, type='l', col=2);
 return(list(az=trendc, dip=dipc))
}
###########################
dip.point<-function(az1, dip1  )
  {
DEG2RAD =0.017453293;
tdip = dip1;
trot =az1;
 xi = DEG2RAD * ( tdip);
  tq = sqrt(2) * sin(xi / 2.0);
  pltx = tq * sin(DEG2RAD * (trot));
  plty = tq * cos(DEG2RAD * (trot)); 
points( pltx, plty , pch=23)
}


#############################
circle<- function()
  {
##%   create a circle for plotting
 DEG2RAD = 0.017453293;
k = 360 ;
cx = rep(0,k);
cy = rep(0,k);


for (i in 1:360)
  {

a = DEG2RAD*i;

cx[i] = cos(a);
cy[i] = sin(a);
}
 return(list(x=cx, y=cy))

}
#######################
circ.tics<-function()
  {
# %    plot a set of tic marks and the center of the circle
points(0,0, pch=3)

for( i in seq(0, 360, by=10))
  {
   ang = i*0.017453293;
   x = cos(ang);
   y = sin(ang);
   points(x,y, pch=3)
 }
}
   


 #######################

fmtraj<-function(dip, az, iang)
  {
 XMAP.PI = pi;
 DEG2RAD = pi/180;
 RAD2DEG=  180/pi;
 XMAP.PI.2 = pi/2 ;
 XMAP.1.PI= 1/pi ;
 XMAP.SQRT2 = sqrt(2) ;
 XMAP.SQRT1.2 = 1/sqrt(2);
 
  beta = (90+az)* DEG2RAD;
  co = cos(beta);
  si = sin(beta);
 
  lambda = XMAP.PI.2 - dip* DEG2RAD;

i = 1;

k = 180/iang ;
 
fx = rep(0,k);
fy = rep(0,k);


j = -90;

for(n in  1:k)
 {
    phi = j * DEG2RAD;
    alpha = acos(cos(phi) * cos(lambda));
    if ( dip < 0.0 ) {
        alpha = -1*alpha;
      }
    tq = XMAP.SQRT2 * sin(alpha / 2.0);
    if (sin(alpha) == 0.0) {
       sint = 1.0;
     }
    else
      {
      
	sint = sin(phi) / sin(alpha);
      }
    if (1 - sint^2 <= 0.0) {
       x = 0.0 ;}
    else {
       x = tq * sqrt(1-(sint^2));
     }
    
    y = tq * sint;             
    fx[i] = co * x + si * y;
    fy[i] = -si * x + co * y;
    i=i+1;
   j = j + iang;

  }


 return(list(x=fx, y=fy))


  }
