
#######  source("PICK.R"); save.image()


test.drive<-function(Xamp, DT)
  {

    TPALS = c("rainbow", "topo.colors", "terrain.colors", "heat.colors", "tomo.col")
    APALS = c("rainbow", "topo", "terrain", "heat", "tomo")


    
    labs = c("DONE", "Postscript", APALS )
    colabs = rep(1,length(labs))
    pchlabs = rep(4,length(labs))
 
    NSEL = 1

    X11()
###  
    plot.ts(Xamp)
    
    buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
    zloc = plocator(COL=rgb(1,0.8, 0.8), NUM=FALSE , YN=NSEL, style=1)
    
    Nclick = length(zloc$x)
    if(is.null(zloc$x)) { return(NULL) }
    K = whichbutt(zloc ,buttons)
    
    sloc = zloc
    
    while(Nclick>0)
      {
      if(K[Nclick] == 1)
        {
          break;
        }


      ####################   POSTSCRIPT  ##################
      
       if(K[Nclick]==2)
        {

          print("Start postscript plot.ts")
          plfname = local.file("test","eps")
          jdev = dev.cur()
          postscript(file=plfname, horizontal=TRUE, print.it=FALSE,  onefile=FALSE)
          plot.ts(Xamp)
           print("Done creating postscript")
          dev.off()
          dev.set(jdev)
        }


       buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
      zloc = plocator(COL=rgb(1,0.8, 0.8), NUM=FALSE , YN=length(sel), style=1)
      Nclick = length(zloc$x)
      if(is.null(zloc$x)) { return(sloc) }
      K =  whichbutt(zloc ,buttons)
      print(K)
      

      }

    print("DONE with TEST")
    
    
  }
#######  source("/home/lees/Progs/R_stuff/PICK.R")

SPECT.drive<-function(Xamp, DT=0.008, NEW=TRUE)
  {

    if(missing(DT)) { DT=1 }
    if(missing(NEW)) { NEW=TRUE }

    
    TPALS = c("rainbow", "topo.colors", "terrain.colors", "heat.colors", "tomo.col")
    APALS = c("rainbow", "topo",           "terrain",      "heat",       "tomo")
    ADDBUTS = c("RAW", "LOG", "SQRT", "Grid" )
    
    NCOL = 100
    
    labs = c("DONE", "Postscript", APALS, ADDBUTS )
    NLABS = length(labs)
    NOLAB = NLABS +1000
  ###  FUN = match.fun(TPALS[1])
     
   ###  pal = FUN(NCOL)

    pal = Gcols(plow=5, phi=0,  N=100, pal=TPALS[1])
    scale.def = 0
   
    colabs = c(rep(1,2) , rep(2, length(APALS) ), rep(4,length(ADDBUTS) ))
    pchlabs = c(rep(1,2) , rep(2, length(APALS) ), rep(4,length(ADDBUTS) ))
 
    gridon = FALSE
 
    NSEL = 1

    if(NEW==TRUE)
      {
        X11()
      }
###  
###     faha <-  wlet.do(Xamp, DT, noctave=7, zscale=  DEV = evolfft(Xamp,DT , Nfft=4096, Ns=250 , Nov=240,  fl=fl, fh=fh  )
    plotevol(DEV, log=scale.def, fl=0, fh=15, col=pal, ygrid=gridon)
   scale.def,  col=pal)
###     print("Finished calculation for  wlet.do")
###     wlet2freqs(faha$noctave, faha$nvoice, DT, flip=faha$flip, c(0.5, 1, 2,3,4,5)  , plot=TRUE)

    fl=0
    fh=0.25*(1/DT)

    ###  fh is one half the nyquist frequency
    fhshow = round(fh/2)

    
    DEV = evolfft(Xamp,DT , Nfft=4096, Ns=250 , Nov=240,  fl=fl, fh=fh  )
    plotevol(DEV, log=scale.def, fl=0, fh=15, col=pal, ygrid=gridon)
    
    buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
    zloc = plocator(COL=rgb(1,0.8, 0.8), NUM=FALSE , YN=NSEL, style=3)
    
    Nclick = length(zloc$x)
    if(is.null(zloc$x)) { return(NULL) }
    K = whichbutt(zloc ,buttons)
    
    sloc = zloc

  ####   print(paste("Button",K, Nclick,K[Nclick] ))
    while(Nclick>0)
      {
        if(K[Nclick] == match("DONE", labs, nomatch = NOLAB))
          {
            break;
          }
      
      ####################   POSTSCRIPT  ##################
        if(K[Nclick] == match("Postscript", labs, nomatch = NOLAB))
        {

          print(paste(sep=' ' ,"Starting postscript file plotevol"))
           jdev = dev.cur()
           plfname = local.file("sgram","eps")
           P = round(par('pin'))

           postscript(file=plfname , width=P[1], height=P[2], paper = "special", horizontal=FALSE, onefile=TRUE,print.it=FALSE)

          ## postscript(file=plfname, horizontal=TRUE, print.it=FALSE,  onefile=FALSE)
           plotevol(DEV, log=scale.def, fl=0, fh=fhshow, col=pal, ygrid=gridon)
           print(paste(sep=' ' ,"Done creating postscript file: ", plfname))

          dev.off()
          dev.set(jdev)
        }

       
        if( length(which(K[Nclick] == match(APALS, labs, nomatch = NOLAB)))>0 )
          {
            J = match(labs[K[Nclick]] ,  APALS   )
            
            ##FUN = match.fun(TPALS[J])
            ##  pal = FUN(NCOL)
            pal = Gcols(plow=5, phi=0,  N=100, pal=TPALS[J])
            
              plotevol(DEV, log=scale.def, fl=0, fh=15, col=pal, ygrid=gridon)
            buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
          }


###     "RAW", "LOG", "SQRT"

        if(K[Nclick]==match("RAW", labs, nomatch = NOLAB))
          {
            scale.def = 0
         
              plotevol(DEV, log=scale.def, fl=0, fh=fhshow, col=pal, ygrid=gridon)
            buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
        }
        if(K[Nclick]==match("LOG", labs, nomatch = NOLAB))
          {
            scale.def = 1
            plotevol(DEV, log=scale.def, fl=0, fh=fhshow, col=pal, ygrid=gridon)
            buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
        }
        if(K[Nclick]==match("SQRT", labs, nomatch = NOLAB))
          {
            scale.def = 2
            plotevol(DEV, log=scale.def, fl=0, fh=fhshow, col=pal, ygrid=gridon)
            buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
        }

         if(K[Nclick]==match("Grid", labs, nomatch = NOLAB))
          {
            
            gridon = !gridon
            
            
            plotevol(DEV, log=scale.def, fl=0, fh=fhshow, col=pal, ygrid=gridon)
            buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
        }
      
      
        ###  print(paste(sep=' ', "scale.def=", scale.def))

       ###   buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
      zloc = plocator(COL=rgb(1,0.8, 0.8), NUM=FALSE , YN=NSEL, style=3)
      Nclick = length(zloc$x)
      if(is.null(zloc$x)) { return(sloc) }
      K =  whichbutt(zloc ,buttons)
     #### print(paste("Button",K, Nclick))
      

      }

    print("DONE with Sgram")
    
    
  }
#######  source("PICK.R"); save.image()

#######  source("PICK.R", verbose =TRUE, echo=TRUE, local=TRUE, print.eval=TRUE ); save.image()

#######  source("PICK.R", verbose =TRUE, echo=TRUE, local=TRUE ); save.image()
#######  source("PICK.R", echo =TRUE ); save.image()


wlet.drive<-function(Xamp, DT=0.008)
  {

    if(missing(DT)) { DT=1 }
   TPALS = c("rainbow", "topo.colors", "terrain.colors", "heat.colors", "tomo.col")
    APALS = c("rainbow", "topo", "terrain", "heat", "tomo")
    ADDBUTS = c("RAW", "LOG", "SQRT" )
   NCOL = 100
    
    labs = c("DONE", "Postscript", APALS,  ADDBUTS)
  
    pfreqs = c(0.5, 1, 2,3,4,5, 10, 14)
   ###    FUN = match.fun(TPALS[1])

   ###    pal = FUN(NCOL)

    pal = Gcols(plow=5, phi=0,  N=100, pal=TPALS[1])
    
    scale.def = 3
    colabs = c(rep(1,2) , rep(2, length(APALS) ), rep(4,length(ADDBUTS) ))
    pchlabs = c(rep(1,2) , rep(2, length(APALS) ), rep(4,length(ADDBUTS) ))
 
    NSEL = 1

    X11()
###  
    faha <-  wlet.do(Xamp, DT, noctave=7, zscale=scale.def,  col=pal)
    print("Finished calculation for  wlet.do")
    pwlet2freqs(faha$noctave, faha$nvoice, DT, flip=faha$flip, pfreqs , plot=TRUE)

    
    buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
    zloc = plocator(COL=rgb(1,0.8, 0.8), NUM=FALSE , YN=NSEL, style=1)
    
    Nclick = length(zloc$x)
    if(is.null(zloc$x)) { return(NULL) }
    K = whichbutt(zloc ,buttons)
    
    sloc = zloc

 

  ####   print(paste("Button",K, Nclick,K[Nclick] ))
    while(Nclick>0)
      {


        if(K[Nclick] == match("DONE", labs, nomatch = NOLAB))
          {
            break;
          }
      
     

      ####################   POSTSCRIPT  ##################
      
        if(K[Nclick] == match("Postscript", labs, nomatch = NOLAB))
          {
            print(paste(sep=' ' ,"Start postscript file plotwlet"))
            jdev = dev.cur()
            plfname = local.file("wlet","eps")


            P = round(par('pin'))

            postscript(file=plfname , width=P[1], height=P[2], paper = "special", horizontal=FALSE, onefile=TRUE,print.it=FALSE)


            
           ##  postscript(file=plfname, horizontal=TRUE, print.it=FALSE,  onefile=FALSE)

            
            plotwlet(faha, Xamp, DT, zscale=scale.def, col=pal,  ygrid=FALSE)
            pwlet2freqs(faha$noctave, faha$nvoice, DT, flip=faha$flip, pfreqs  , plot=TRUE)
            
            print(paste(sep=' ' ,"Done creating postscript file:", plfname))

            
            dev.off()
            dev.set(jdev)
          }

        
       
        if( length(which(K[Nclick] == match(APALS, labs, nomatch = NOLAB)))>0 )
          {
            J = match(labs[K[Nclick]] ,  APALS   )
            
            ##  FUN = match.fun(TPALS[J])
             ##  pal = FUN(NCOL)
            
            pal = Gcols(plow=5, phi=0,  N=100, pal=TPALS[J])
 
            plotwlet(faha, Xamp, DT, zscale=scale.def, col=pal,  ygrid=FALSE)
            pwlet2freqs(faha$noctave, faha$nvoice, DT, flip=faha$flip, pfreqs , plot=TRUE)
            buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
            
          }

        if(K[Nclick]==match("RAW", labs, nomatch = NOLAB))
          {
            scale.def = 1
            plotwlet(faha, Xamp, DT, zscale=scale.def,  col=pal)
            pwlet2freqs(faha$noctave, faha$nvoice, DT, flip=faha$flip,  pfreqs , plot=TRUE)
            buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
          }
        if(K[Nclick]==match("LOG", labs, nomatch = NOLAB))
          {
            scale.def = 2
            plotwlet(faha, Xamp, DT, zscale=scale.def,  col=pal)
            pwlet2freqs(faha$noctave, faha$nvoice, DT, flip=faha$flip,  pfreqs , plot=TRUE)
            buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
          }
        if(K[Nclick]==match("SQRT", labs, nomatch = NOLAB))
          {
            scale.def = 3
            plotwlet(faha, Xamp, DT, zscale=scale.def,  col=pal)
            pwlet2freqs(faha$noctave, faha$nvoice, DT, flip=faha$flip,  pfreqs , plot=TRUE)
            buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
          }
        
        
        #### buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
        zloc = plocator(COL=rgb(1,0.8, 0.8), NUM=FALSE , YN=NSEL, style=1)
        Nclick = length(zloc$x)
        if(is.null(zloc$x)) { return(sloc) }
        K =  whichbutt(zloc ,buttons)
#### print(paste("Button",K, Nclick))
        
        
      }
    
    print("DONE with Wlet")
    
    
  }

#############################################################################
#############################################################################
#############################################################################
#######  source("PICK.R"); save.image()

detail.pick<-function(y, ex, dt, TIT="")
  {
    if(missing(TIT)) { TIT=NULL }
   labs = c("DONE", "PROJ", "XING", "YMIN", "YMAX", "SAVED", "NONE" )
   colabs =  rep(1,length(labs))
   pchlabs = rep(1,length(labs))
   NSEL = 1
   N = 0
   NLABS = length(labs)
   NOLAB = NLABS +1000
   KSAVE = NULL
    xsave = NULL
    ysave = NULL
    pwink = 0.01*diff(range(ex))
    pcol=rgb(1,.5, 0)
    plot(ex, y, type='n', col=1)
    abline(h=0, col=1)
    points(ex, y, col=rgb(0.75,0.75,0.8) )
    lines(ex, y, col=1)
    
    title(main=TIT)
    
   ###    title(main="click middle mouse to end session")
    buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
    ###  zloc = plocator(col=rgb(1,0, 0), NUM=TRUE , YN=NSEL, style=-1)
   zloc = locator(1, type='p', col=pcol)

   
    
    Nclick = length(zloc$x)
    if(is.null(zloc$x)) { return(NULL) }
    K = whichbutt(zloc ,buttons)
   sloc = zloc
   while(Nclick>0)
     {
        ##  abline(v=zloc$x[1], col=2)
        xsave = c(xsave, zloc$x)
        ysave = c(ysave, zloc$y)
        N = N+1
      ###  print(paste("CLICKER ", N, zloc$x, zloc$y , xsave[N], ysave[N], length(xsave)  ))
       if(K[Nclick] == match("DONE", labs, nomatch = NOLAB))
         {
           N = N-1
           xsave = xsave[1:N]
           ysave = ysave[1:N]

           break;
         }
       if(K[Nclick] == match("Postscript", labs, nomatch = NOLAB))
          {
          }


        
      if(K[Nclick] == match("XING", labs, nomatch = NOLAB))
          {
            ###  find the zero crossing

             ###print(paste("xing ", N, xsave[N], ysave[N]))
            ### print(paste("should be  ",xsave[N-1], ysave[N-1]))
             ### print(xsave)

            N = N-1
            xsave = xsave[1:N]
            ysave = ysave[1:N]

            
           LX = xsave[N]
           LY =  ysave[N]
           rim = findInterval(LX, ex)
           nflag = seq(from=(rim-5), to=rim+5, by=1)
           lex = ex[nflag]
           lwhy = y[nflag]
           sy = sign(lwhy[1])
           ww = which(sign(lwhy) !=sy) 
           
           x1 = lex[ww[1]-1]
           y1 =  lwhy[ww[1]-1]
           x2 = lex[ ww[1] ]
           y2 =  lwhy[ww[1]]

           m = (y2-y1)/(x2-x1)
           b = y2-m*x2

           xingx = -b/m
           xingy = 0
           points(c(x1,x2,xingx), c(y1, y2, xingy), col=2)

           
           xsave[N] = xingx
           ysave[N] = xingy
            text(xsave[N], ysave[N], labels= N, pos=3)
      

          }
   
      if(K[Nclick] == match("PROJ", labs, nomatch = NOLAB))
          {
            ###  find the zero crossing

             ###print(paste("xing ", N, xsave[N], ysave[N]))
            ### print(paste("should be  ",xsave[N-1], ysave[N-1]))
             ### print(xsave)

            n = length(xsave)
           ##  xsave = xsave[1:N]
            ##  ysave = ysave[1:N]

           x1 = xsave[n-1]
            
           y1 = ysave[n-1]
           x2 = xsave[n-2]
           y2 =  ysave[n-2]

           m = (y2-y1)/(x2-x1)
           b = y2-m*x2
          ###  print(paste(sep=' ',"slope and intercept", m,b))
          ###  print(paste(sep=' ', n, x1,y1, x2,y2))
           xingx = -b/m
           xingy = 0
           points(c(x1,x2,xingx), c(y1, y2, xingy), col=2)

            N = N-2
            xsave = xsave[1:N]
            ysave = ysave[1:N]
            
            xsave[N] = xingx
            ysave[N] = xingy
            text(xsave[N], ysave[N], labels= N, pos=3)
      

          }

        
      if(K[Nclick] == match("YMAX", labs, nomatch = NOLAB))
          {
            ##  find the local max


            N = N-1
            xsave = xsave[1:N]
            ysave = ysave[1:N]


            
           ### print(paste("MAX ", N, xsave[N], ysave[N]))
            LX = xsave[N]
            LY =  ysave[N]
            ax = LX
            
            flag = ex > (ax-pwink) & ex < (ax+pwink)
            w1 = which(flag)[1]-1
            
            rim = which.max(y[flag])
            abline(v=ex[w1+rim], col=4)

           
           xsave[N] = ex[w1+rim]
           ysave[N] = y[w1+rim]
             text(xsave[N], ysave[N], labels= N, pos=3)
 

            points(xsave[N],  ysave[N] , col=3, pch=7) 
        
           ###  points(xsave[N],  ysave[N] , col=3, pch=7) 
           
            
          }
       if(K[Nclick] == match("YMIN", labs, nomatch = NOLAB))
          {


             N = N-1
            xsave = xsave[1:N]
            ysave = ysave[1:N]

           ### print(paste("MIN ", N, xsave[N], ysave[N]))
            LX = xsave[N]
            LY =  ysave[N]
            ax = LX
            flag = ex > (ax-pwink) & ex < (ax+pwink)
            w1 = which(flag)[1]-1

             points( ex[flag]  ,  y[flag], col=5, pch=7) 
            rim = which.min(y[flag])

            
            abline(v=ex[w1+rim], col=4)
            
                  
            xsave[N] = ex[w1+rim]
            ysave[N] = y[w1+rim]
             text(xsave[N], ysave[N], labels= N, pos=3)
            
            points(xsave[N],  ysave[N] , col=3, pch=7) 
           
            
          }
         if(K[Nclick] == match("NONE", labs, nomatch = NOLAB))
          {
            N = 0
            KSAVE = NULL
            xsave = NULL
            ysave = NULL
            plot(ex, y, type='n', col=1)
            abline(h=0, col=1)
             points(ex, y, col=rgb(0.75,0.75,0.8) )
            lines(ex, y, col=1)
            title(main=TIT)
###    title(main="click middle mouse to end session")
            buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
          }
        if(K[Nclick] == match("POINTS", labs, nomatch = NOLAB))
          {
            if(N>1)
              {
                N = N-1
                xsave = xsave[1:N]
                ysave = ysave[1:N]
              }
            else
              {
                N = 0
                xsave = NULL
                ysave = NULL
              }
            points(ex, y, col=rgb(0.8,0.8,0.8) )
            
          }
       if(K[Nclick] == match("SAVED", labs, nomatch = NOLAB))
          {
            
            points(xsave, ysave, col=rgb(0.5,1, 0.5) )
            text(xsave, ysave, labels=1:length(xsave), pos=1)
          }
      
      
       
       #### buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
       ####  zloc = plocator(col=rgb(1,0, 0), NUM=TRUE , YN=NSEL, style=-1)
        zloc = locator(1, type='p', col=pcol)
       Nclick = length(zloc$x)
       if(is.null(zloc$x)) { return(sloc) }
       K =  whichbutt(zloc ,buttons)
      ###  print(paste("Button",K, Nclick))
     }
   
   

   KSAVE = list(x=xsave, y=ysave)
   
   return(KSAVE)
 }



#############################################################################
#############################################################################
#############################################################################

PLOT.WPX<-function(t0, STNS, COMPS, WPX, FILL=FALSE)
  {
    
    ##     WPX[[NPX]] =  list( pick=c(NH$info$yr[ipick], NH$info$jd[ipick], NH$info$hr[ipick], NH$info$mn[ipick], asec), kind="SHAPE", sta= STNS[ypick], comp=COMPS[ypick], PULS=PULS)

    ### match(JH$COMPS, "V")
    ###  match(JH$STN, "MAS")&match(JH$COMPS, "V")


    if(missing(FILL)) { FILL=FALSE }
    du = 1/length(STNS)

  #####  print(paste(sep=' ', "PLOT.WPX NPX=", length(WPX)))

    for(i in 1:length(WPX))
      {
        if( WPX[[i]]$kind== "SHAPE")  { next; }
        
        imatch = which(match(STNS, WPX[[i]]$sta)& match(COMPS,WPX[[i]]$comp))
        
     #####  print(paste(sep=' ', "PLOT.WPX", i, imatch, WPX[[i]]$sta, WPX[[i]]$comp))

              
        ypixA = (length(STNS)-imatch)*du
        ypixB =  ypixA+du
        x1 = secdif(   t0$jd, t0$hr, t0$mn, t0$sec, WPX[[i]]$pick[2],  WPX[[i]]$pick[3],  WPX[[i]]$pick[4], WPX[[i]]$pick[5])
     #####  print(paste(sep=' ', "PLOT.WPX", i, x1, ypixA, x1, ypixB))

       if(FILL==TRUE)
         {
             segments(x1, 0, x1, 1, col=grey(.8) )
         }
        segments(x1, ypixA, x1, ypixB, col=WPX[[i]]$col)
        text(x1, ypixB, labels=WPX[[i]]$kind, col=WPX[[i]]$col, pos=4)

       
        
      }
    
  }



 ##########  this is where to predict the source time given an acoustic arrival at a given station (Tungurahua)
         ############  ignore this for general case
      ##########  if(WPX[[i]]$kind=="A")
       ##########   {
       ##########     if(WPX[[i]]$sta=="MAS") { ptim = 3516/340 }
       ##########     if(WPX[[i]]$sta=="JUI") { ptim = 4168/340 }
       ##########     if(WPX[[i]]$sta=="RUN") { ptim = 5889/340 }
            
       ##########     x2 = secdif(   t0$jd, t0$hr, t0$mn, t0$sec, WPX[[i]]$pick[2],  WPX[[i]]$pick[3],  WPX[[i]]$pick[4], WPX[[i]]$pick[5]-ptim)

        ##########    segments(x2, ypixA, x2, ypixB, col=rgb(1.0, 0.8,0.8), lty=2)
            
       ##########   }


#############################################################################
#############################################################################
#############################################################################
########  source("PICK.R") ; save.image()

choosfilt<-function(thefilts=thefilts, ncol=5)
  {
    ###  choosfilt()
    
    if(missing(thefilts))
      {
        thefilts =
          list(flo=
               c(0.02, 0.02, 0.02, 0.02, 0.02,   0.02,
                 0.02, 0.02, 0.02,  0.02, 0.02,  0.02,
                 0.02,
                 1/2, 1/50,1/100, 1/100,
                 0.2, 15, 5, 2,
                 100),
               fhi=
               c(1/10, 1/6, 1/5, 1/4, 1/3, 1/2,
                 0.2,  0.5, 1.0,  2.0, 3.0,  4.0,
                 7.0,
                 8, 1/2.0,1/5.0,1/10.0,
                 7.0, 100, 100, 100,
                 100),
             type =
               c("LP","LP", "LP", "LP", "LP", "LP",
                 "LP","LP", "LP", "LP", "LP", "LP",
                 "LP",
                 "BP", "BP","BP","BP",
                 "HP", "HP","HP", "HP",
                 "None"))
      }
    
    if(missing(ncol)) {  ncol=5  }
    


if( length(thefilts$type) != length(thefilts$flo ) &   length(thefilts$type)  != length(thefilts$fhi ) )
  {
    print(paste(sep=' ',"problem with filter definition", length(thefilts$type),length(thefilts$flo ), length(thefilts$fhi )   ))

  }
    
###  print(data.frame(cbind(thefilts$flo, thefilts$fhi,   1/thefilts$flo, 1/thefilts$fhi,  thefilts$type)))
    
###    namcols = c("springgreen2",   "plum2" ,         "cyan3"  ,        "darkgoldenrod2")
###    match(namcols, colors())
   ###  print(Z)
    colpals = matrix(c(0,238,118,238,174,238,0,205,205,238,173,14)/255, nrow=3)

    colrgb = rgb(colpals[1,],colpals[2,], colpals[3,])
    
    N = length( thefilts$flo)

    utyp  = unique(thefilts$type)
    thecols = rep(colrgb[1], N)
    for(j in 1:length(utyp))
      {

        thecols[which(utyp[j]==thefilts$type) ] = colrgb[j]
      }
    
    X11()
    

    cols = topo.colors(1.5*N)
   
    nrow = round((N/ncol)+.5)
    
    dx = 1/ncol
    dy =  1/nrow
 plot(c(0,1), c(0,1), type='n', axes=FALSE, xlab='', ylab='')
    
    for(i in 1:N)
      {
        B =  itoxyz(i, ncol, nrow, 1)
        x = (B$ix-1)*dx
        y = (B$iy-1)*dy
        rect(x , y , x+dx, y+dy, lty=1, col=thecols[i] )

        if(thefilts$flo[i]<1)
          {
            lolab = paste(sep=' ', 1/thefilts$flo[i], "s")

          }
        else
          {
            lolab = paste(sep=' ', thefilts$flo[i], "Hz")
          }

        if(thefilts$fhi[i]<1)
          {
            hilab = paste(sep=' ', 1/thefilts$fhi[i], "s")

          }
        else
          {
            hilab = paste(sep=' ', thefilts$fhi[i], "Hz")
          }

        if(thefilts$type[i]=="LP")
          {
            lab = paste(sep='\n',thefilts$type[i],  hilab )
          }
        if(thefilts$type[i]=="HP")
          {
            lab = paste(sep='\n',thefilts$type[i],  lolab )
          }

          if(thefilts$type[i]=="BP")
          {
            lab = paste(sep='\n',thefilts$type[i],  lolab,  hilab )
          }
          if(thefilts$type[i]=="None")
          {
            lab = paste(sep='\n',thefilts$type[i] )
          }
       
        
        text(x+dx/2, y+dy/2, lab)
        
      }

    z = locator(type='p')
    ii = 1+floor(z$x/dx)
    jj = 1+floor(z$y/dy)
    B =  ii+(jj-1)*(ncol)

    i = B[length(B)]

    GIVE = list(type=thefilts$type[i],  fl=thefilts$flo[i],fh=thefilts$fhi[i],ON=FALSE,  proto="BU" )

    print(GIVE)

    dev.off(dev.cur())
    
    return(GIVE)

    
########## data.frame(cbind( formatC(thefilts$flo, digits =5, width=6, flag=" "),
##########     formatC(thefilts$fhi, digits =5, width=6, flag=" ") ,
##########     formatC(1/thefilts$flo, digits =5, width=6, flag=" "),
##########     formatC(1/thefilts$fhi, digits =5, width=6, flag=" ") ))


  #####   ans=readline("which filter do you want? ")

   #####  ians = match(ans, 1:length(thefilts$flo))
    
   #####  return(list(ON=FALSE, fl=thefilts$flo[ians], fh=thefilts$fhi[ians], type=thefilts$type[ians], proto="BU"))

  }

##########   choosfilt()


#############################################################################
#############################################################################
#############################################################################
########  source("PICK.R") ; save.image()

PICK.GEN<-function(GH, sel=1:length(GH$dt), ORD=NULL, WIN=NULL, APIX=NULL, STDLAB=NULL,
                   PADDLAB=NULL, SHOWONLY=FALSE, CHOP=FALSE, TIT="")
{
###  a = PICK.MARIO(GH,  sel, WIN=twin)
  
  if(missing(WIN)) { WIN = NULL }
  if(missing(sel)) { sel = 1:length(GH$dt)}
   if(missing(ORD)) { ORD = NULL } 
  if(missing(APIX)) { APIX = NULL}
  if(missing(SHOWONLY)) { SHOWONLY=FALSE}
  if(missing(CHOP)) { CHOP=TRUE }
   if(missing(STDLAB)) { STDLAB = c("DONE", "zoom out", "zoom in", "restore",  "AUTOP", "XTR", "SPEC", "SGRAM" ,"WLET", "FILT", "SCALE")}
  if(missing(PADDLAB)) { PADDLAB=c( "PPIX", "AccPIX", "XPIX", "NOPIX", "Postscript") }
  if(missing(TIT)) { TIT=NULL }

  if(CHOP==TRUE)
    {
      if(!is.null(WIN))
        {
          NH = CHOP.SEISN(GH, sel , WIN=WIN)
        }
      else
        {
          
          NH = GH
        }
      
      WIN = c(0, NH$dt*length(NH$JSTR[[1]]))
      
    }
  else{
    
    NH = GH
  }


  if(is.na(match("NOPIX",  PADDLAB))==TRUE) { PADDLAB = c(PADDLAB, "NOPIX") }

  ##  these are specialized "standard functions"
  
  ##  stdlab = c("DONE", "zoom out", "zoom in", "restore",  "AUTOP", "SIG", "SPEC", "SGRAM" ,"WLET", "FILT")

  stdlab =  STDLAB

  
  
  ##   labs = c("DONE", "zoom out", "zoom in", "restore", "PPIX", "AccPIX", "XPIX", "CPIX", "NOPIX", "AUTOP", "SIG", "SPEC", "SGRAM" ,"WLET", "FILT")
  
  labs = c(stdlab, PADDLAB)
  NLABS = length(labs)
  NOLAB = NLABS +1000
  ScaleFACT = 1
  ##  match("", labs)

  pnos = grep("PIX", labs)
  
  colabs = rep(1,length(labs))
  colabs[pnos] = seq(from=2, length=length(pnos))
  colpix = seq(from=2, length=length(pnos))
  pchlabs = rep(4,length(labs))
  pchlabs[pnos] = seq(from=15, length=length(pnos))


  
  NSEL = length(NH$dt[sel])

  if(is.null(APIX)==TRUE)
    {
      WPX = as.list(NA)
      NPX = 0
      
      
      
    }
  else
    {
      ## print("reading in pickfile")
      ##    APIX=SAVDAT[[ii]]
      WPX = APIX
      NPX = length(WPX)

      pdb = unlist(WPX)
      npdb = names(unlist(pdb))
      
      
      ##  print(paste(sep=' ', "read in pickfile",NPX))
      ## print(xpix)
    }
  

  BRUNKOUNT = 0
  BRUNINFO = as.list(NA)

  DETLKOUNT = 0
  DETLINFO = as.list(NA)

  
  STNS = NH$STNS[sel]
  COMPS = NH$COMPS[sel]

   ###   print(STNS)
  ###   print(COMPS)
 
  
  UNIsta = unique(STNS)
  
  NUNI = length( UNIsta)


  pcols = rep(rgb(0,0,0), length(NH$dt) )

  pcols[c(grep("1", COMPS), grep("I", COMPS))] = rgb(0,.4,0)
  pcols[c(grep("4", COMPS), grep("V", COMPS), grep("Z", COMPS), grep("v", COMPS), grep("z", COMPS)   )] = rgb(0.4,0,0)
  
  pcols[c(grep("J", COMPS), grep("K", COMPS))] = rgb(0,0,0.4)


  ###  print(pcols)
  
 ###   for Tung_04 use this mapping 
###   ords = match(STNS,c("MAS", "JUI" ,"RUN",   "OVT"))
###   ordc = match(COMPS, c("I", "J", "K", "V", "N",  "E"))


###   want the sorting of comps to be Vertical North East always


  oCOMPS = COMPS

  
  oCOMPS[grep("I", COMPS)] = 1
  oCOMPS[grep("A", COMPS)] = 1
  
  oCOMPS[grep("V", COMPS)] = 2
  oCOMPS[grep("Z", COMPS)] = 2
  
  oCOMPS[grep("v", COMPS)] = 2
  oCOMPS[grep("z", COMPS)] = 2

  oCOMPS[grep("N", COMPS)] = 3
  oCOMPS[grep("n", COMPS)] = 3

  oCOMPS[grep("E", COMPS)] = 4
  oCOMPS[grep("e", COMPS)] = 4

  

  ords = match(STNS, sort(UNIsta))
  ordc = match(oCOMPS, sort(unique(oCOMPS) ))

  ordsel = order( ords+ordc/10)


####  try to do some automatic ordering....this does not work in certain circumstances
  ###  need to improve this section
##  if( length(sel) == length(GH$dt) & ORD==TRUE )
##     {
##       sel = ordsel
##       STNS = STNS[sel]
##       COMPS = COMPS[sel]
##     }

    if(!is.null(ORD))
    {
      STNS = STNS[ORD]
      COMPS = COMPS[ORD]
    }

##   print("*************    check stations and comps****** ")
##  print(STNS)
##  print(COMPS)
 
  
  du = 1/NSEL

  
  isel = sel[1]
  
  T0 = list(jd=NH$info$jd[isel], hr=NH$info$hr[isel], mn=NH$info$mn[isel], sec=(NH$info$sec[isel]+NH$info$msec[isel]/1000+NH$info$t1[isel]-NH$info$off[isel]))
  
###  print(sel)
###  print(STNS)
###  print(COMPS)
###  print(NH$KNOTES[sel])
###  print(NSEL)
###  print(NH$dt[sel])
###  print(pcols[sel])
  LASTwin = WIN
  
  YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel , sfact=ScaleFACT, notes=NH$KNOTES[sel], COL=pcols, TIT=TIT)
   buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
  
  TE = !is.na(WPX[[1]])
  
       
     if(NPX>0 & TE[1])
        {
         
          PLOT.WPX(T0, STNS, COMPS, WPX)
        ##   segments(xpix, ypixA, xpix, ypixB, col=colpix)
         ##  text(xpix, ypixB, labels=cpixa, col=colpix, pos=4)
        }
      

  if(SHOWONLY==TRUE) { return(0) }

  MAINdev = dev.cur()

  ###  Get.Screens(2)
  dev.set( MAINdev)
  
###   if(NPX>0)
 ###       {

  ###        PLOT.WPX(T0, STNS, COMPS, WPX)
        ##   segments(xpix, ypixA, xpix, ypixB, col=colpix)
         ##  text(xpix, ypixB, labels=cpixa, col=colpix, pos=4)
   ###     }
      
  
  u = par("usr")
  sloc = list(x=c(u[1],u[2]))
  ppick  = NA
  spick  = NA
  xpick = NA
#### ftime = Zdate(NH$info, sel[1],0)
#### mtext( ftime, side = 3, at = 0, line=0.5, adj=0)
  
####  title("LEFT 0 Click = done; 1 Click=replot;   2 Click=zoom")
 
####  NV = LabelBAR(labs)
 ###   zloc = plocator(COL=rgb(1,0.8, 0.8))
zloc = plocator(COL=rgb(1,0.8, 0.8), NUM=FALSE , YN=NSEL, style=1)
  
  Nclick = length(zloc$x)
  if(is.null(zloc$x)) { return(NULL) }
  K = whichbutt(zloc ,buttons)
  
  sloc = zloc
  
  while(Nclick>0)
    {
      
      if(K[Nclick] == match("DONE", labs, nomatch = NOLAB))
        {
          break;
        }
      
      
      if(Nclick==1 & K[Nclick]==0)
        {
          WIN = NULL
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel, sfact=ScaleFACT , notes=NH$KNOTES[sel], COL=pcols, TIT=TIT)
          buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
          u = par("usr")
          
          sloc = list(x=c(u[1],u[2]))
          
          
        }

       ####################  START  BUTTON DEFINITIONS    ###########################

      
       ###################   RESTORE  ###########################      
      if(K[Nclick]==match("restore", labs, nomatch = NOLAB))
        {
          WIN = NULL
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel, sfact=ScaleFACT , notes=NH$KNOTES[sel], COL=pcols, TIT=TIT)
          buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
          u = par("usr")
          L = length(sloc$x)
          if(L>1)
            {
              abline(v=sloc$x[c(L-1,L)], col=gray(0.8), lty=2)
            }
          sloc = list(x=c(u[1],u[2]))
          
        }

      ################  ZOOM IN BY WINDOW CLICKING   #################
      if(Nclick>1 & K[Nclick]==0)
        {
          
          WIN  = sort(zloc$x[c( Nclick-1, Nclick)])
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel, sfact=ScaleFACT , notes=NH$KNOTES[sel], COL=pcols, TIT=TIT)
          buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
         #### ftime = Zdate(NH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)
          sloc = zloc
        }

      ###################   ZOOM  OUT  ###########################      
      if(K[Nclick]==match("zoom out", labs, nomatch = NOLAB))
        {
          u = par("usr")
          DX = (u[2]-u[1])*0.3
          zloc = list(x= c(u[1]-DX, u[2]+DX))
          WIN  = zloc$x
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel, sfact=ScaleFACT , notes=NH$KNOTES[sel], COL=pcols, TIT=TIT)
          buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
         #### ftime = Zdate(NH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)

          sloc = zloc
        }
      ###################   ZOOM IN   ###########################      
       if(K[Nclick]==match("zoom in", labs, nomatch = NOLAB))
        {
          u = par("usr")
          DX = (u[2]-u[1])*0.3
          zloc = list(x= c(u[1]+DX, u[2]-DX))
          WIN  = zloc$x
         
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel, sfact=ScaleFACT , notes=NH$KNOTES[sel], COL=pcols, TIT=TIT)
          buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
         #### ftime = Zdate(NH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)

          sloc = zloc
        }
      ###################   ZOOM IN   ###########################      
       if(K[Nclick]==match("SCALE", labs, nomatch = NOLAB))
        {

          if(ScaleFACT==1)
            {

              ScaleFACT=2
            }
          else
            {
              ScaleFACT=1

            }
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel, sfact=ScaleFACT , notes=NH$KNOTES[sel], COL=pcols, TIT=TIT)
          buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
         #### ftime = Zdate(NH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)

          
        }



      
       ###################   Postscript output   ###########################  
      if(K[Nclick] == match("Postscript", labs, nomatch = NOLAB))
        {
          print(paste(sep=' ' ,"Start postscript PLOT.SEISN"))
          jdev = dev.cur()
          plfname = local.file("pick_gen","eps")
          
          ### postscript(file=plfname, horizontal=TRUE, print.it=FALSE,  onefile=FALSE)
           P = round(par('pin'))

           postscript(file=plfname , width=P[1], height=P[2], paper = "special", horizontal=FALSE, onefile=TRUE,print.it=FALSE)

         
          print(paste(sep=' ' ,"Doing postscript", plfname))
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel, sfact=ScaleFACT , notes=NH$KNOTES[sel], COL=pcols, TIT=TIT)
          print(paste(sep=' ' ,"Done creating postscript file: ", plfname))
          dev.off()
          dev.set(jdev)
        }


      ###################   AUTO  PICKs   ###########################      
 
      if(K[Nclick]==match("AUTOP", labs, nomatch = NOLAB) & Nclick>=3)
        {
         
         ###  u = par("usr")

          
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
        
          
          ipick = sel[ypick]
          print(paste(sep=' ',ypick, NH$info$name[ ipick]))
          
         ###   amp = NH$JSTR[[j]][NH$ex>sloc$x[1]&NH$ex<sloc$x[2] ]
          
          print(paste(sep=' ',YN$DX[1], YN$DX[2], WIN[1], WIN[2]))
          famp = NH$JSTR[[ipick]]

           pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
          Xamp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]

       ###     dev.set(3)
          
       ###   plot.ts(Xamp)
        ###  locator()
        ###  dev.set(2)
          

          
         ### KPIX = autopick(Xamp, which.max(abs(Xamp)) )
         ###  ktarg = which.max(abs(Xamp))
          
         ### ktarg = floor((zloc$x[Nclick-1]-YN$DX[1])/NH$dt[ypick])
         ktarg = which.max(abs(Xamp))

          ###  print(paste(sep=' ',"DUMP",zloc$x[Nclick-1], ktarg,which.max(abs(Xamp))))

          deltat = NH$info$dt[ ipick]
        ###    KPIX = autopick(Xamp, ktarg )

          
          X11()
 
          if(COMPS[ypick] == "I")
            {
              fy = butfilt(Xamp, fl=.5, fh=20, deltat, "HP", "BU" )
             ###  RAT = ratcurve(fy, dt=deltat, fwlen =  75,  bwlen  = 125, PLOT=TRUE)
              RAT = PSTLTcurve(fy, dt=deltat, fwlen=75,  bwlen=125, perc=0.1, stretch=1000 , MED=21, PLOT=TRUE)


              
            }
          else
            {
              fy = butfilt(Xamp, fl=.2, fh=7, deltat, "HP", "BU" )
              ##     RAT = ratcurve(fy, dt=deltat, fwlen =  175,  bwlen  = 175, PLOT=TRUE)
              RAT = PSTLTcurve(fy, dt=deltat, fwlen=175,  bwlen=175, perc=0.1, stretch=1000 , MED=21, PLOT=TRUE)
              araict = GETARAIC(fy, deltat=deltat, T1=RAT$eye, Mar=8, O1=2, O2=0.2, WW=2,   PLOT=FALSE)
              print(araict)
              
            }
              ##################################################
               ########  source("PICK.R") ; save.image()

          
          dev.set( MAINdev)
          
          
          ### print(KPIX)
         ### dev.set(dev.next())
          
          ### plot.ts(Xamp)
          ### abline(v=KPIX$ind, col=2)
           ###  dev.set(dev.next())

          autpix = c(pwin[1]+RAT$ind*NH$dt[ipick], pwin[1]+RAT$eye*NH$dt[ipick], pwin[1]+RAT$mix*NH$dt[ipick], pwin[1]+araict*NH$dt[ipick])
          print(autpix*NH$dt[ipick])
          
          abline(v=autpix    , col=c(2,3,4, 4))

        #######  print(paste(sep=" ", "going to vline....", pwin[1], "ara=",araict, "ip=",ipick, NH$dt[ipick]))
          vline(pwin[1]+araict*NH$dt[ipick] ,  per =-0.2 , COL=rgb(.4, 0, 0) )
          
          
        }
      ###################   XTRACT PART of A trace   ###########################      
 
      if(K[Nclick]==match("XTR", labs, nomatch = NOLAB) & Nclick>1)
        {
         ###  u = par("usr")
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          print(paste(sep=' ',"EXTRACT", ypick, NH$info$name[ ipick]))

          famp = NH$JSTR[[ipick]]

          pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
          temp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]
          Xamp =  -1*temp
          smallex = NH$ex[ NH$ex > pwin[1] & NH$ex <pwin[2]]

          asec = NH$info$sec[ipick]+NH$info$msec[ipick]/1000+NH$info$t1[ipick]-NH$info$off[ipick]+pwin[1]

          
          TP = list(yr=NH$info$yr[ipick], jd=NH$info$jd[ipick], hr=NH$info$hr[ipick], mn=NH$info$mn[ipick], sec=asec )
          
          invisible(list(x=smallex, y=temp, deltat=NH$dt[ipick], name=NH$info$name[ipick] , Tpick=TP ))
        }
      
      
      ###################   PULSE ANALYSIS   ###########################      
  ######   print(paste(sep=' ',Nclick,  K[Nclick], match("SIG", labs)))

      
      if(K[Nclick]==match("SIG", labs, nomatch = NOLAB) & Nclick>=3)
        {
         ###  u = par("usr")
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          print(paste(sep=' ',ypick, NH$info$name[ ipick]))

          famp = NH$JSTR[[ipick]]
          ###  need to flip the accoustic trace?

          pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
          temp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]
          Xamp =  -1*temp
          smallex = NH$ex[ NH$ex > pwin[1] & NH$ex <pwin[2]]
          
          X11()
          ###  plot.ts(Xamp)

          PULS = tung.pulse( smallex , Xamp , NH$dt[ipick])
          NPX = NPX+1
               asec = NH$info$sec[ipick]+NH$info$msec[ipick]/1000+NH$info$t1[ipick]-NH$info$off[ipick]+pwin[1]
           WPX[[NPX]] =  list( pick=c(NH$info$yr[ipick], NH$info$jd[ipick], NH$info$hr[ipick], NH$info$mn[ipick], asec), kind="SHAPE", sta= STNS[ypick], comp=COMPS[ypick], PULS=PULS)

          dev.set( MAINdev)
        }
      
      ###################   FREQUENCY ANALYSIS   ###########################      
 
      if(K[Nclick]==match("SPEC", labs, nomatch = NOLAB) & Nclick>=3)
        {
         ###  u = par("usr")
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          print(paste(sep=' ',ypick, NH$info$name[ ipick]))

          famp = NH$JSTR[[ipick]]
          ###  need to flip the accoustic trace?

         pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
          
          temp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]
          
          g  =  list(y=temp-mean(temp), dt=NH$dt[ipick])
          ### g$x = NH$ex[ NH$ex > zloc$x[Nclick-2] & NH$ex <zloc$x[Nclick-1]]
  
          X11()
          f1 = 0.1
          f2 = floor(0.33*(1/NH$dt[ipick]))

          
           Spec = MTMplot(g, f1, f2, PLOT=TRUE)
          dev.set( MAINdev)
  
          ###  dev.off(dev.cur())
    ###   source("/home/lees/Progs/R_stuff/tung.R");
          ###     a = PICK.MARIO(GH,  sel, WIN=twin) 

          
        }
      
      ###################   SPECTROGRAM  ANALYSIS   ###########################      
 
      if(K[Nclick]==match("SGRAM", labs, nomatch = NOLAB) & Nclick>=1)
        {
         ###  u = par("usr")

          if(Nclick>=3)
            {
              ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
              ipick = sel[ypick]
              print(paste(sep=' ',ypick, NH$info$name[ ipick]))
              pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
            }
          if(Nclick==2)
            {
              ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
              ipick = sel[ypick]
              print(paste(sep=' ',ypick, NH$info$name[ipick]))
              pwin = WIN
            }

          if(Nclick==1)
            {
              pwin = LASTwin
            }

          LASTwin = pwin
   
          ### print(paste(sep=" ", "DOING SGRAM  Nclick, ipick, pwin", Nclick, ipick, pwin))
          
          famp = NH$JSTR[[ipick]]
         
          
          
          temp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]
          Xamp =   temp-mean(temp)
          SPECT.drive(Xamp, DT=NH$dt[ipick])

        ###  DEV = evolfft(Xamp,NH$dt[ipick] , Nfft=4096, Ns=250 , Nov=240,  fl=0, fh=15  )

        
         ###  X11()
        ###   plotevol(DEV, log=1, fl=0, fh=15, col=rainbow(50))
          
          dev.set(MAINdev)
          
        }

      ###################   wavelet  ANALYSIS   ###########################      
 
      if(K[Nclick]==match("WLET", labs, nomatch = NOLAB) & Nclick>=1)
        {
       
          if(Nclick>=3)
            {
              ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
              ipick = sel[ypick]
              print(paste(sep=' ',ypick, NH$info$name[ ipick]))
              pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
            }
          if(Nclick==2)
            {
              ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
              ipick = sel[ypick]
              print(paste(sep=' ',ypick, NH$info$name[ipick]))
              pwin = WIN
            }

          if(Nclick==1)
            {
              pwin = LASTwin
            }

          LASTwin = pwin
     
           
          famp = NH$JSTR[[ipick]]
         
          
          temp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]
          Xamp =   temp-mean(temp)
         ###  smallex = NH$ex[ NH$ex > pwin[1] & NH$ex <pwin[2]]
          
          ###X11()
          ###  plot.ts(Xamp)
          ### wlet.do(Xamp, NH$dt[ipick], noctave=7, zscale=3,  col=terrain.colors(100))
          wlet.drive(Xamp, NH$dt[ipick])

          
          dev.set( MAINdev)
 #######  source("/home/lees/Progs/R_stuff/PICK.R"); save.image()


        }
            ###################   filter stuff  ANALYSIS   ###########################      
 
      if(K[Nclick]==match("FILT", labs, nomatch = NOLAB))
        {

           Fdef = choosfilt()

           ##### if(!exists("Fdef"))
            #####  {
            #####    Fdef = choosfilt()
                
               
            #####    print(Fdef)
                

            #####  }

           if(Fdef$type=="None")
             {
               NH = OLDH
             }
           else
             {
               OLDH=NH
               KF = FILT.SEISN(NH, sel = sel, FILT=Fdef)
               NH = KF
             }


           X11()
           
           YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel , sfact=ScaleFACT, notes=NH$KNOTES[sel], COL=pcols, TIT=TIT)
           buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
           dev.set( MAINdev)
           
           
        
         }
 ###########################      
      if(K[Nclick]==match("BRUNE", labs, nomatch = NOLAB) & Nclick>=3)
        {
          
###  u = par("usr")
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
         ###  print(paste(sep=' ',"look at Brune", ypick, NH$info$name[ ipick]))
          
          famp = NH$JSTR[[ipick]]
###  need to flip the accoustic trace?
          
          pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
          temp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]
          Xamp =   temp-mean(temp)

          dev.set(MAINdev+1)
         ##  dev.set(dev.next())
          
          ##  X11()
          
          ## plot(Xamp, type='l')
          ##  title(main="click middle mouse to continue")
          ##
          ## locator()

          ###   fix the freq ranges
          f1 = 0.01
          f2 = floor(0.25*(1/NH$dt[ipick]))
          
          BF = brune.doom( Xamp, NH$dt[ipick] ,f1=f1, f2=f2 ,  PLOTB = TRUE)
          BRUNKOUNT = BRUNKOUNT+1
          BRUNINFO[[BRUNKOUNT]] = list(stn=NH$STNS[ipick], comp=NH$COMPS[ipick] ,  pwin=pwin, BF=BF)
          print(BF) 
          NH$KNOTES[ipick] = paste(sep=" ", "BR", NH$KNOTES[ipick])
          dev.set( MAINdev)
#######  source("PICK.R"); save.image()
          
        }
 ###########################      
###########################      
      if(K[Nclick]==match("DETAIL", labs, nomatch = NOLAB) & Nclick>=3)
        {
          screens(2)
          
###  u = par("usr")
          print("Going to  DETAIL")
          
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          
          
          famp = NH$JSTR[[ipick]]

          
          pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
          ex  =  NH$ex[NH$ex > pwin[1] & NH$ex <pwin[2]]
          temp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]
  
          ##  X11()
          
          dev.set(MAINdev+1)
          dsec  = NH$dt[ipick]
          fh=0.12*(1/dsec)
          fl = 0.5
          fy = butfilt(temp, fl=fl, fh=fh , dsec , "BP", "BU" )
          Xamp =   fy-mean(fy)
          
          KSAVE = detail.pick(Xamp, ex,  dsec, TIT=NH$KNOTES[ipick])

          DETLKOUNT = DETLKOUNT+1
          DETLINFO[[DETLKOUNT]] = list(stn=NH$STNS[ipick], comp=NH$COMPS[ipick] ,  pwin=pwin, points=KSAVE, filt=c(fl,fh))

          ##  dev.off()
          NH$KNOTES[ipick] = paste(sep=" ", "DT", NH$KNOTES[ipick])
          dev.set( MAINdev)
#######  source("/home/lees/Progs/R_stuff/PICK.R")
          
        }
 ###########################      





      

            ###################   time pick analysis   ###########################      
 
      if(K[Nclick]==match("Pinfo", labs, nomatch = NOLAB))
        {
          ppick = zloc$x[1:(Nclick-1)]
          dpick = c(0, diff(ppick))
           ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
              ipick = sel[ypick]
              m = match(STNS[ypick],UNIsta)
          jj = floor((zloc$y[Nclick-1])/du)
               asec = NH$info$sec[ipick]+NH$info$msec[ipick]/1000+NH$info$t1[ipick]-NH$info$off[ipick]+ppick[Nclick-1]

          print(paste(sep=" ", "PICK=", NH$info$yr[ipick], NH$info$jd[ipick], NH$info$hr[ipick], NH$info$mn[ipick], asec, "sta=", STNS[ypick], "comp=", COMPS[ypick] ))
          
          print(ppick)
          print(dpick)
            
        }

       ################### 
      if(K[Nclick]==match("YPIX", labs, nomatch = NOLAB))
        {

          zappa = match(labs[K[Nclick]], PADDLAB)
          col = colpix[which(pnos=="YPIX")]
          
          azap = PADDLAB[zappa]
          kzap = substr(azap, 1, 1)
          
          ppick = zloc$x[1:(Nclick-1)]
          
           ypick = length(sel)-floor(length(sel)*zloc$y[1:(Nclick-1)])
              ipick = sel[ypick]
         
          ####### print(ppick)
         #######  print(ypick)
         #######  print(ipick)
          ### print(paste(' ', "Nclick=", Nclick))
          #### print(STNS)
          #### print(COMPS)
 
          for(iz in 1:(Nclick-1))
            {
              
              NPX = NPX+1
              
              i1 = ipick[iz]
              i2 = ypick[iz]

              asec = NH$info$sec[i1]+NH$info$msec[i1]/1000+NH$info$t1[i1]-NH$info$off[i1]+ppick[iz]
           ####   print("############################")
           ####  print(paste(' ', "ypix diag", NPX, iz, i1, i2, STNS[i2], COMPS[i2], asec))
              
              WPX[[NPX]] = list( pick=c(NH$info$yr[i1], NH$info$jd[i1], NH$info$hr[i1], NH$info$mn[i1], asec),
                   kind=kzap, sta= STNS[i2], comp=COMPS[i2], col=colpix[zappa] )

              
              ##  print(WPX[[NPX]])
            }
          
      
          K[Nclick] = 0
        }

                #############################################################################
                    ########  source("PICK.R") ; save.image()


      ###################   generic  PICK   ###########################      

      if(K[Nclick]>0)
        {
          ###   restrict search to only labs that have PIX in them
          pnos = grep("PIX", labs)
          
          if(!is.na(match(labs[K[Nclick]], pnos)) & labs[K[Nclick]]!="YPIX" &   Nclick>1)
            {
              
              zappa = match(labs[K[Nclick]], PADDLAB)
              azap = PADDLAB[zappa]
              
              kzap = substr(azap, 1, 1)
              
              
###   print(paste(sep=" " , "WIN=",sloc$x))
              ppick = zloc$x[1:(Nclick-1)]
###        abline(v=ppick, col=4)
              
              ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
              ipick = sel[ypick]
              
              m = match(STNS[ypick],UNIsta)
###  Upix[[m]]$x  = ppick
              
###   PPIX(list(x=zloc$x[Nclick-1], y=zloc$y[Nclick-1]), YN=NSEL, col=3, lab="P")
              jj = floor((zloc$y[Nclick-1])/du)
              
              
              NPX = NPX+1
###   WPX[[NPX]] = list( yr=NH$info$yr[ipick], jd=NH$info$jd[ipick], hr=NH$info$hr[ipick], mn=NH$info$mn[ipick], sec=NH$info$sec[ipick],
##### msec=NH$info$msec[ipick], t1=NH$info$t1[ipick], off=NH$info$off[ipick], x=ppick, yA=jj*du, yB=jj*du+du, kind="X",
########  sta= STNS[ypick], comp=COMPS[ypick], col=4)
              asec = NH$info$sec[ipick]+NH$info$msec[ipick]/1000+NH$info$t1[ipick]-NH$info$off[ipick]+ppick[Nclick-1]
              WPX[[NPX]] = list( pick=c(NH$info$yr[ipick], NH$info$jd[ipick], NH$info$hr[ipick], NH$info$mn[ipick], asec), kind=kzap, sta= STNS[ypick], comp=COMPS[ypick], col=colpix[zappa] )
              
              #### print(paste(" ", azap, kzap))
            }
        }
###################   REMOVE  PICKs   ###########################      
      
      
      if(K[Nclick]==match("NOPIX", labs))
        {
          NPX = 0
          WPX = as.list(NA)
          
          
        }



      
      ####################  END BUTTON DEFINITIONS    ###########################      


            ###################   WRAP UP and PLOT AGAIN   ###########################      

      
      ###   source("/home/lees/Progs/R_stuff/tung.R");   a = PICK.MARIO(GH,  sel, WIN=twin) 

       ###  a = PICK.MARIO(GH,  sel, WIN=twin)
      ####  plot the picks

     ####   fin = ftorn[ii]
     ###    JH = Get.DumpDat( fin, "/home/beer/lees/DUMP/MARIO2", stloc=6, cmploc=7, XSTA=NULL)
      ####  a = PICK.MARIO(JH,sel=1:length(JH$dt), WIN=NULL)



      
      if(NPX>0)
        {
          
          PLOT.WPX(T0, STNS, COMPS, WPX)
          
         ##  segments(xpix, ypixA, xpix, ypixB, col=colpix)
         ##  text(xpix, ypixB, labels=cpixa, col=colpix, pos=4)
        }
      
      
       ##   buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
 
###  NV = LabelBAR(labs)
      zloc = plocator(COL=rgb(1,0.8, 0.8), NUM=FALSE , YN=length(sel), style=1)
      Nclick = length(zloc$x)
      if(is.null(zloc$x)) { invisible(list(sloc=sloc, WPX=WPX, BRUNINFO=BRUNINFO, DETLINFO=DETLINFO))  }
      K =  whichbutt(zloc ,buttons)
### K = ValBAR(NV, zloc)
###  print(paste(sep=" ", "K=",K))
      
    }

  ### PRET = list(TPIX=TPIX, xpix=xpix,ypixA=ypixA, ypixB=ypixB,cpixa= cpixa, cpixb=cpixb, cpixc=cpixc, colpix=colpix)
 ###  return(PRET)
   pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
  #### print(pwin)
  #### print(WIN)
 invisible(list(sloc=sloc, WPX=WPX, BRUNINFO=BRUNINFO, DETLINFO=DETLINFO)) 

}		
##################################################
########  source("PICK.R") ; save.image()




