cat("sourcing /home/lees/Progs/R_stuff/SUBS.R\n")

#######
###  source("/home/lees/Progs/R_stuff/SUBS.R")

liblibs<-function()
  {

    library(tcltk) 
    library(tkrplot) 
    library(pastecs)
    library(xgobi)
    library(mva)
    library(cluster)
    library(ts)
    library(spatial)
    library(splines)
    library(modreg)

     library(Rwave)
     library(MASS)

  }
#######
###  source("/home/lees/Progs/R_stuff/SUBS.R")

MakeName<-function(pref)
  {
    for(i in 1:1000)
      {
        nam <<- paste(pref,formatC(i, format="d", wid=3, flag="0"), sep=".")
        if(exists(nam)==FALSE) return(nam)
      }

  }
#######
###  source("/home/lees/Progs/R_stuff/SUBS.R")

recdate<-function(jday, hr, mi, sec)
{
#  recdate:  take a structure with time and rectify it
  secs = jday*(24*60*60)+hr*(60*60)+mi*(60)+sec;
  days = floor( secs / (24.*60.*60.));
  left =  secs - days*(24*60*60);
  hrs = floor( left / (60.*60.));
  left =  left - hrs*(60*60);
  mins = floor(left/60.0);
   sec = left - mins*60;
  list( jday=days, hour=hrs, min=mins, sec=sec)
}
##########
secdif<-function(jday, hr, mi, sec, jday2, hr2, mi2, sec2)
{
#  
  secs1 = jday*(24*60*60)+hr*(60*60)+mi*(60)+sec;
  secs2 = jday2*(24*60*60)+hr2*(60*60)+mi2*(60)+sec2;
 return(secs2-secs1)
}
##########


jday<-function(yr, mo, day)
  {
    IT = ISOdatetime(yr, mo, day, 12, 0, 0, tz = "")

    #  j = julian(IT, origin=ISOdatetime(yr-1, 12,31, 0,0,0, tz = ""))

    
    jday = floor(as.numeric(julian(IT, origin=ISOdatetime(yr[1]-1, 12,31, 0,0,0, tz = ""))  ) )
    
    return(jday)
  }
###########
fromjul<-function(jul, yy)
{
       j=jul-1721119
       yy=trunc((4*j-1)/146097)
       j=4*j-1-146097*yy
       dd=trunc(j/4)
       j=trunc((4*dd+3)/1461)
       dd=4*dd+3-1461*j
       dd=trunc((dd+4)/4)
       mm=trunc((5*dd-3)/153)
       dd=5*dd-3-153*mm
       dd=trunc((dd+5)/5)
       yy=100*yy+j


yy[mm<10]=yy[mm<10]
yy[mm>=10]=yy[mm>=10]+1;
     ##  if(mm<10)
   ## 	{	
       ##       yy=yy+0;
   ## 	}
      ##        else
   ## 	{
      ##        yy=yy+1;
   ## 	}

	flg = mm<10


	mm[flg] = mm[flg]+3;  
	mm[!flg] =  mm[!flg]-9;
     	##  if(mm<10)
	##	{
      	##    mm= mm+3;
	##	}
       	##   else
	##	{
       	##   mm=mm-9;
	##	}



return(list(mon=mm, dom=dd))	
}
 
####### source("/home/lees/Progs/R_stuff/SUBS.R")


tojul<-function(year, month, day)
{
## /*   given a year a month and day, return the julian day
##   */ 
       
       yy = year;
       mm = month;
       dd = day;
       jul = 0;


	flg = mm>2
	yy[flg] = yy[flg]
	yy[!flg] = yy[!flg]-1

	mm[flg] = mm[flg] -3
	mm[!flg] = mm[!flg] +9
	
     ##  if(mm>2)
##	{
       ##   yy = yy+0;
##	}
       ##   else
	##{
       ##   yy = yy -1;
##	}
          
      ## if(mm>2)
##	{
        ##  mm = mm -3;
##	}
        ##  else
##	{
      ##    mm = mm+9;
##	}
          
       c = trunc(yy/100);
       ya = yy-100*c;
       jul= trunc((146097*c)/4)+trunc((1461*ya)/4)+ trunc((153*mm+2)/5) +dd+1721119;

	return(jul);

}
####### source("/home/lees/Progs/R_stuff/SUBS.R")

getjul<-function(year, month, day)
{
	jstart = tojul(year, 1, 1);
   
	jul = tojul(year, month, day)-jstart+1;
   
       return(jul)

}

getmoday<-function(jul, iyear)
{
if(length(iyear)<length(jul))
{
iyear = rep(iyear, length(jul))

}
inine =   tojul(iyear,1,1);
ijul =    inine + jul - 1;
MD = fromjul( ijul, iyear);

return(list(mon=MD$mon, dom=MD$dom))

}

####### source("/home/lees/Progs/R_stuff/SUBS.R")


pdate<-function(odate, pr=FALSE)
{

  if(missing(pr)) {pr=FALSE }
  out = paste(sep=' ',paste(sep="/",odate$yr, formatC(odate$mon, format="d", width=2,flag="0"), formatC(odate$dom, format="d", width=2,flag="0")), paste(sep=":",formatC(odate$hr, format="d", width=2,flag="0"), formatC(odate$min, format="d", width=2,flag="0"), format.default(odate$sec, digits=5)))
  ##
  if(pr==TRUE) {  print(out) }
  
  return(out)
  
}
####### source("/home/lees/Progs/R_stuff/SUBS.R")
####DIR = "/home/lees/KARDAT_1999_252"
####fil1 = "SEIS_INFO_00247.dat"
####GFIL = KAR.Gdat(fil1 , DIR)
####PLOT.MATN(GFIL$JMAT, dt=GFIL$dt, notes=GFIL$KNOTES, COL=GFIL$pcol)
########################################################################
ptime<-function(GFIL, YN=1)
{
  if(missing(YN)) {  Yranges = length(GFIL$KNOTES) }
  xp = plocator(style =2, Yranges = YN)

  j = xp$n
  jd = getjul(GFIL$info$yr[j],GFIL$info$mo[j] , GFIL$info$dom[j])

  rd = recdate(jd, GFIL$info$hr[j], GFIL$info$mn[j], (xp$x+ GFIL$info$sec[j]+GFIL$info$msec[j]/1000+GFIL$info$t1[j]-GFIL$info$off[j]) )

  md = getmoday(rd$jday, GFIL$info$yr[j])

  odate = list(yr=GFIL$info$yr[j], jday=rd$jday, mon=md$mon, dom=md$dom, hr=rd$hour, min=rd$min, sec=rd$sec)
  pdate(odate)
  invisible(odate)
}
##########
####### source("/home/lees/Progs/R_stuff/SUBS.R")
########################################################################
addsec<-function(odate, sec)
{
###  add a number of seconds to an existing date structure
rd = recdate(odate$jday, odate$hr, odate$min, odate$sec+sec )

md = getmoday(rd$jday, odate$yr)


newdate = list(yr=odate$yr, jday=rd$jday, mon=md$mon, dom=md$dom, hr=rd$hour, min=rd$min, sec=rd$sec)


return(newdate)
}




####### source("/home/lees/Progs/R_stuff/SUBS.R")

plotK<-function(K)
{
     nn = length(K$info$fn)
     par(mfrow=c(nn, 1))
     plot(K$t,K$data[,1], type='l', xlab="s")
     plot(K$t,K$data[,2], type='l', xlab="s")
     plot(K$t,K$data[,3], type='l', xlab="s")
}
#######
plotK3<-function(K)
{
     nn = length(K$info$fn)
     
     plot(K$t,K$data[,1], type='l', xlab="s")
     plot(K$t,K$data[,2], type='l', xlab="s")
     plot(K$t,K$data[,3], type='l', xlab="s")
}
#######
error.bar<-function(x, y, lo, hi, pch=sym, col=clr, barw=0.1, add=FALSE, ...)
  {
    if(missing(add)) { add=FALSE; }
    if(missing(pch)) { pch=1 }
    if(missing(col)) { col=1 }
    if(missing(barw)) {  barw=0.1 }
   

    
    if(add==FALSE)
      {
    plot(x,y, xlim=range(x[!is.na(x)]), ylim=range(c(lo[!is.na(lo)], hi[!is.na(hi)])), type='n', xlab="", ylab="", ...)
  }
    fi = par("fin")
    u = par("usr")
    w = barw*((u[2]-u[1])/fi[1])
    points(x,y, pch=pch, col=col)
    segments(x,lo, x, hi, col=col)
    segments(x-w,lo,x+w, lo, col=col)
    segments(x-w,hi,x+w, hi, col=col)
  }
#######
######  source("/home/lees/Progs/R_stuff/SUBS.R")

read.DUMP<-function(infof, dataf)
{

         ascin <-scan(file=infof, list(fn="", yr=0, mon=0, dom=0, hr=0, min=0, sec=0, ms=0, dt=0, t1=0, t2=0, toff=0, begs=0, ibeg=0, iend=0, dif=0))

        nn=length(ascin$fn)


       ascd <-matrix( scan(file=dataf) ,ncol=nn,nrow=ascin$dif[1]-2,  byrow=TRUE)

      t = ascin$dt[1]*(1:(ascin$dif[1]-2))

	sta = substr(ascin$fn[1], 1, 3)
	comp = substr(ascin$fn, 5, 5)
      list(info=ascin, data=ascd, t=t, sta=sta, comp=comp)

}
######  source("/home/lees/Progs/R_stuff/SUBS.R")

####################################
hypot<-function(x1,y1,x2,y2)
{

return( sqrt( (x1-x2)^2+(y1-y2)^2) )

}
####################################
hypotL<-function(x)
{
x1 = x$x[1]
x2 = x$x[2]
y1 = x$y[1]
y2 = x$y[2]
return(hypot(x1,y1,x2,y2))
}
######  source("/home/lees/Progs/R_stuff/SUBS.R")

####################################
rotmat<-function(alph)
{

matrix(c(cos(alph), -sin(alph), sin(alph), cos(alph)), ncol=2)

}

####################################

rotseis<-function(k)
{

	for(i in 1:k)
	{
 
	ang = i*360/k
	alph = ang * pi/180

	r = rotmat(alph)

	B = A[,2:3] %*% r

	C = cbind(A[,1], B)

	plot.ts(C)
	title(ang)

	print("hit any key")
	scan("")

	}

}
####################################


rotseis2<-function(A, k)
{
	
	j = 0
	i = 0 
	amp = range(A[,2:3] )


	while(j < 3)
	{
 
	ang = i*360/k
	alph = ang * pi/180

	r = rotmat(alph)

	B = A[,2:3] %*% r

	C = cbind(A[,1], B)

	amp = range(C[,2:3] )


	plotseis3(C, amp)
	title(ang)

        print(ang)
	print("hit 1 or 2")
	j = scan("", blank.lines.skip=TRUE, what = 0, n=1)
        if(j<=1)
	{
	i = i+1
	}
	if(j==2)
	{

	i = i-1
	}


	}

}

####################################
plotseis3<-function(A, amp)
{
# par(mfrow=c(1,1))
#  scale the traces to go between 1-12
v = A[,1]
n = A[,2]
e = A[,3]

x = 1:length(v)

par(mfrow=c(3,1))
par(mai=c( 0 , 0.574, 0 , 0.294 ), omi=c(.2, .1, .1, .1) )
plot(v, type='l', axes=FALSE  )
axis(2)
 axis(1, tick=TRUE, labels=FALSE)
box()

plot(n, type='l', axes=FALSE, ylim=c(amp[1], amp[2])  )
 axis(2)

 axis(1, tick=TRUE, labels=FALSE)
box()
plot(e, type='l', axes=FALSE, ylim=c(amp[1], amp[2]) )
 axis(2)
 axis(1)
box()

}


pwd<-function()
{
system("pwd")

}

####################################
find.file <- function(str){
	n<-rep(F,nchar(str))
	 for(i in 1:nchar(str)){
	k=substring(str,i,i)
	k
	if(k == "/")n[i]<-T
	}
	a<-1:nchar(str)
	a[n]
}


######################### Organize the data into a distance matrix for R
cormat<-function(n, h)
{
   m =  matrix( rep(0, n*n) ,  nrow = n,  ncol = n)
   b = 0
   for(i in 1:(n-1)) 
     {

       a = (n-1)-i+1
       z = b+1
       b = b+a


       w = i+1
         #  print(c(i, a, w, z, b))

      m[ w:n, i] = h[z:b]
      m[ i, w:n] = h[z:b]
     }
   return(m)
}
########################################
######  source("/home/lees/Progs/R_stuff/SUBS.R")
######  source("/home/lees/Progs/R_stuff/SUBS.R")



slice<-function(x,y,r,a1, a2, col)
{
#  create the polygon pie slice and fill it
p1 = a1*pi/180
p2 = a2*pi/180

dang = seq(p1,p2,length=10)

cx  = r*cos(dang)
sx = r*sin(dang)

ix = c(x, cx, x)
iy = c(y, sx , y)


polygon(ix, iy,col=col) 
}
########################################
######  source("/home/lees/Progs/R_stuff/SUBS.R")
######  source("SUBS.R"); save.image()



######  source("/home/lees/Progs/R_stuff/SUBS.R")
antipolygon <- function(x,y,col=0)
{
  ##  use the polygon in x,y to blank out (mask) teh image on the screen
  ## useful for plotting contour plots and images
  ##  antipolygon(POL$x, POL$y, col=rgb(1,1,1) )
  ##  see contPfile  for an example of usage:
  
  u <- par("usr")
  x <- c(x,x[1],u[1],u[1],u[2],u[2],u[1])
  y <- c(y,y[1],u[3],u[4],u[4],u[3],u[3])
  polygon(x,y,border=col,col=col)
  box()
}

##############
###  draw a flow diagram (circular histogram)
#  provide a vector of values distributed evenly
#  around the circle
flower<-function(x, y, z)
{
m = max(z)
n =  length(z)
omega = 360/n
so = 90-seq(0, 360, by=omega)

for(i in 1:length(z))
{
# print(paste(sep=' ', i, so[i], so[i+1]))
slice(0, 0, z[i]/m, so[i], so[i+1], "blue") 

}

}


#######################

greatAz<-function(lat1, lon1, lat2, lon2)
{

phi1=lat1*pi/180
lam0 =  lon1*pi/180

phi =lat2*pi/180 
lam =lon2*pi/180 



  tem1 = cos(phi1)*sin(phi) - sin(phi1)*cos(phi)*cos(lam-lam0);
  tem2 = atan2(cos(phi)*sin(lam-lam0), tem1); 

	return(tem2*180/pi)


}

#######################

GCLCFR<-function(t)
{
  r<-sin(t)
  o<-(1.0 - 0.0033670033 * (r*r))
  o
}

gclc<-function(phiorg, lamorg, phi, lam)
{
 
 A<-6378206.4
 E2<-0.00676866
 E<-0.0822719
 E1<-0.993231340
 TwoE<-0.164543800
 R<-6378.2064
 DEG2RAD<- 0.017453293
 RAD2DEG<- 57.295778667
 EARTHRAD<- 6378.163
 ECCEN<- 0.0033670033
 PO180<- 0.017453293

 
  PHI0<- DEG2RAD * phiorg
  LAM0<- DEG2RAD * lamorg
 
  crlat<- atan(ECCEN * sin(2.0 * PHI0) / GCLCFR(PHI0))
  zgcl<- PHI0 - crlat
  a<- GCLCFR(zgcl)
  rho<- EARTHRAD * a
  b<- ((ECCEN * sin(2.0 * zgcl) / a))^2 + 1.0
  ca<- 2.0 * ECCEN * cos(2.0 * zgcl) * a + ((ECCEN * sin(2.0 * zgcl)))^2
  cdist<- ca / (a*a * b) + 1.0
  RHO0<- rho
  C<- crlat
  B<- cdist
  
  xlat<- DEG2RAD * phi
  ylon<- DEG2RAD * lam
  y<- (-1.0)*RHO0 * (LAM0 - ylon) * cos(xlat - C)
  x<- RHO0 * (xlat - PHI0) / B
  
list(x=x,y=y)


}
#######################
######  source("/home/lees/Progs/R_stuff/SUBS.R")

lcgc<-function(phiorg, lamorg, ex, why)
{
 
 A<-6378206.4
 E2<-0.00676866
 E<-0.0822719
 E1<-0.993231340
 TwoE<-0.164543800
 R<-6378.2064
 DEG2RAD<- 0.017453293
 RAD2DEG<- 57.295778667
 EARTHRAD<- 6378.163
 ECCEN<- 0.0033670033
 PO180<- 0.017453293

 
  PHI0<- DEG2RAD * phiorg
  LAM0<- DEG2RAD * lamorg
 
  crlat<- atan(ECCEN * sin(2.0 * PHI0) / GCLCFR(PHI0))
  zgcl<- PHI0 - crlat
  a<- GCLCFR(zgcl)
  rho<- EARTHRAD * a
  b<- ((ECCEN * sin(2.0 * zgcl) / a))^2 + 1.0
  ca<- 2.0 * ECCEN * cos(2.0 * zgcl) * a + ((ECCEN * sin(2.0 * zgcl)))^2
  cdist<- ca / (a*a * b) + 1.0
  RHO0<- rho
  C<- crlat
  B<- cdist

 xlat = (ex) * B / RHO0 + PHI0;
phi = RAD2DEG * (ex * B / RHO0 + PHI0);
lam = RAD2DEG * (LAM0 - (why*(-1)) / (RHO0 * cos(xlat - C)));
 return(list(lat=phi, lon=lam))
 
}


#######################
######  source("/home/lees/Progs/R_stuff/SUBS.R")

STA.dist<-function(  azis, zvals, asta)
{
divs = seq(0,360, by=10)
zmn = rep(0, (length(divs)-1))
zmd = rep(0, (length(divs)-1))
zlen = rep(0, (length(divs)-1))

for(i in 1:(length(divs)-1))
{
#print(paste(sep=' ', i, divs[i], divs[i+1]))
flag = azis>divs[i]&azis<divs[i+1]
zmn[i] =   mean(zvals[flag]) 
zmd[i] =   median(zvals[flag])
zlen[i] =   length(zvals[flag])

}

zmn[is.nan(zmn)] = 0.0
zmd[is.nan(zmd)] = 0.0
zmn[is.na(zmn)] = 0.0
zmd[is.na(zmd)] = 0.0


opar <- par(no.readonly = TRUE)
 par(mfrow=c(2,2))
plot(c(-1,1), c(-1, 1), type='n',  axes=FALSE ,  xlab=paste(sep=' ', 'min=', min(abs(zmn)), 'max=', max(abs(zmn))), ylab='', main=paste(sep=' ', asta, "Mean"))
flower(0, 0, abs(zmn))
# text(-1, -1, labels=(paste(sep=' ', 'min=', min(abs(zmn)), 'max=', max(abs(zmn)))   )  )

plot(c(-1,1), c(-1, 1), type='n',  axes=FALSE, xlab=paste(sep=' ', 'min=', min(abs(zmd)), 'max=', max(abs(zmd))), ylab='', main=paste(sep=' ', asta,"Median"))
flower(0, 0, abs(zmd))
# text(-1, -1, labels=(paste(sep=' ', 'min=', min(abs(zmd)), 'max=', max(abs(zmd)))))

plot(c(-1,1), c(-1, 1), type='n',  axes=FALSE, xlab=paste(sep=' ', 'min=', min(abs(zlen)), 'max=', max(abs(zlen))), ylab='', main=paste(sep=' ', asta,"Number"))
flower(0, 0, abs(zlen))
# text(-1, -1, labels=(paste(sep=' ', 'min=', min(abs(zlen)), 'max=', max(abs(zlen)))))

japmap(jmap)
par(opar)

return(list(zmn=zmn, zmd=zmd, zlen=zlen))


}
#######################
######  source("/home/lees/Progs/R_stuff/SUBS.R")

######   source("SUBS.R");save.image()

#########################################################################
#########################################################################
#########################################################################

distaz<-function( olat, olon, tlat, tlon)
{
# *   This subroutine will compute the distance, azimuth, and back
## * azimuth (in degrees), given the latitude and longitude (in degrees)
# * of an origin point and a target point.  (E+,W-; N+,S-)
  twopi = 2*pi;
  R.MAPK=6378.2064
  ERR=1;
  OK=0;
  L = list(err=0, del=0, az=0, baz=0)
  L$err = 0;

  olat[is.na(olat)] = -100
  tlat[is.na(tlat)] = -100

  olat[olat < -90. || olat > 90.] = NA
  
  tlat[tlat < -90. || tlat > 90.] = NA

  

  olon = olon%%360
  tlon = tlon%%360
  
  L$err=1;
  clat = 90. - olat;
  clon = olon;
  ####    if(clon < 0.) { clon =clon+ 360.; }
  clon = clon%%360
  clar = DEG2RAD*clat;
  clor = DEG2RAD*clon ;
  stho = sin(clar);
  ctho = cos(clar);
  ctlat = 90. - tlat;
  ctlon = tlon;
  #### if(clon < 0.) ctlon =ctlon+ 360.;
ctlon = ctlon%%360
  
  ctlar = DEG2RAD*ctlat ;
  ctlor = DEG2RAD*ctlon;
  sth = sin(ctlar);
  cth = cos(ctlar);
  dph = ctlor - clor;
  sdph = sin(dph);
  cdph = cos(dph);
  delr = acos(stho * sth * cdph + ctho * cth);
  del = RAD2DEG* delr ;

#### /* compute forward azimuth */

####	if(sth == 0.) { azr = 0.;}
####	else { azr = atan2(sdph,stho*cth/sth-ctho*cdph);}

  azr = rep(0, length(sdph))
  azr[sth!=0.0] = atan2(sdph,stho*cth/sth-ctho*cdph);
  az = RAD2DEG*azr;
  azr = azr%%360

###/* compute back azimuth */
  bazr = rep(0, length(sdph))

  
  bazr[stho!=0.0] = bazr = atan2(-sdph,sth*ctho/stho-cth*cdph);

  baz = RAD2DEG*bazr;
  bazr =bazr%%360

  
  L$del = del
  L$az =az
  L$baz = baz
  L$dist = L$del*2*pi*R.MAPK/360
  
	return(L);
}
###############
#########################################################################
#########################################################################
reg<-function(x,y)
  {
    #  standard linear regression of y on x
    #
    #  should use the program lm in R
    #  lmp2p = lm(lseis ~ linfra)
    # summary(lmp2p)
    # anova(lmp2p)
    #    abline(lmp2p)
    
    n = length(y)
    A = cbind( rep(1, n), x)

    ATA = t(A) %*% A   ;

    ATAinv  = solve(ATA)

    b = ATAinv %*% t(A) %*%  y;

    Yhat = A %*% b ;

    res = y - Yhat ;

    SSR = sum( (Yhat-mean(y))*(Yhat-mean(y)))
    SST = sum( (y-mean(y))*(y-mean(y)))
    SSE = SST- SSR
    dfR = 1;
    dfT = n - 1
    dfE = dfT - dfR


    MSSR = SSR/dfR
    MSSE = SSE/dfE


    FT = MSSR/MSSE

##  to get the quantiles of a distribution use
    #  qt(.95, 20)  ==== tinv(.95,20) in matlab

     prob = pf( FT, dfR, dfE)
    
    xm = x - mean(x)
    sigma = 1.0
    Eb1 = sigma/ sqrt(sum( xm * xm  ) )

    
    
    return(list(coefficients=b,residuals=res,  fitted.values=Yhat,
                SSR=SSR, SST=SST, SSE=SSE,
                dfR=dfR, dfT=dfT, dfE=dfE,
                MSSR=MSSR,MSSE=MSSE, FT=FT, prob=prob))
  }
###################################################
###################################################
###################################################

VarRed<-function(X,Y, SEQ=SEQ)
{

  if(missing(SEQ)) {
    SEQ = seq(from=-1,to=1, by=.1)
  }
  
  LMAX = rep(0,length(SEQ))
  
  for(i in 1:length(SEQ))
    {
      lambda = SEQ[i]
      if(lambda != 0)
        {
          W = (Y^lambda - 1)/lambda  
        }
      else
        {
          W = log(Y)
        }
      n = length(Y)
      R = lm(W ~ X)

#       R = reg(X, W)

    #   SSR = sum(R$residuals^2)
     #   SSR = sum((R$fitted.values-Y)^2)
     AR = anova(R)
      SSR = AR$"Sum Sq"[2]
      
      LJ = (lambda-1)*sum(log(Y))

      Lmax = -(0.5*n*log(SSR/n)) + LJ

      LMAX[i] = Lmax

    }


  
  plot(SEQ,LMAX)
 

  probs = c(0.001)
  LIM = max(LMAX) - 0.5*qchisq(1-probs,1)
  abline(h=LIM, col=c(3), lty=3)  
  LIM95 = max(LMAX) - 0.5*qchisq(1-0.05,1)
  RLIM = range( SEQ[LMAX>LIM95])
   abline(v=RLIM, col=c(3), lty=3)
  # probs = c(0.1,0.05,0.025,0.01,0.001)
  probs = c(0.05)
  LIM = max(LMAX) - 0.5*qchisq(1-probs,1)
  abline(h=LIM, col=c(2), lty=2)  
  LIM95 = max(LMAX) - 0.5*qchisq(1-0.05,1)
  RLIM = range( SEQ[LMAX>LIM95])
   abline(v=RLIM, col=c(2), lty=2)



  
  return(list(X=X, Y=Y, lambda=SEQ, LMAX=LMAX, MAX=SEQ[which.max(LMAX)], LIM=LIM, probs=probs, LIM95=RLIM))

}
### plot(V$lambda, V$LMAX)

###################################################
###  source("/home/lees/Progs/R_stuff/SUBS.R")

###################################################
###################################################

peaks<-function(series,span=3)
{
z <- embed(series, span)
result = max.col(z) == (1 + span %/% 2)
return(result)
}


###  source("/home/lees/Progs/R_stuff/SUBS.R")
