
####################################################
####################################################
######### 
###  source("/home/lees/Progs/R_stuff/Specfit.R")

brune.func<-function( freq,  omega0,  tstar0, fc, alpha, gamma)
{

  SMALL.NUMBER = 1e-300
  gam2 = 2.0*gamma;
   a1 = freq^(-alpha);
   a2 = (freq/fc)^(gam2);

   tstar = tstar0* a1 ;
   e2ft = exp((-pi*freq*tstar));


   tmod = (omega0*e2ft) / sqrt(1+a2 );

  ## plot(freq, tmod, type='l', log='xy')
  
   tmod[tmod<=0.0] = SMALL.NUMBER ;
  

   return(tmod);

}
  ##
  ## nbrune = brune.func(freq, omega0, tstar0 , fcorn,  alpha, gamma )
## plot(freq, nbrune, type='l', log='xy')
####################################################
######### 
###  source("/home/lees/Progs/R_stuff/Specfit.R")
brune.score<-function(f, spec, jbrune, f1, f2 )
  {
    sc = (log10(spec)-log10(jbrune))^2;
  }
####################################################
######### 
###  source("/home/lees/Progs/R_stuff/Specfit.R")
brune.search1<-function(f, sp, omega0, tstar0 , fcorn,  alpha, gamma )
  {
    ## brune.search
    ## 
    ng = 20
    ns = 10
    gamma.save = 0
    tstar.save = 0
    t1 = tstar0-0.2*abs(tstar0)
    t2 = tstar0+0.2*abs(tstar0)

    g1 = gamma-0.1*abs(gamma)
    g2 = gamma+0.5*abs(gamma)

    jbrune = brune.func(f, omega0, t1 , fcorn,  alpha, g1 )

    osc = sum((log10(sp)-log10(jbrune))^2);
    
    for(tstar in seq(from=t1, to=t2, length=ns))
        {
          for(gamma in seq(from=g1, to=g2, length=ng))
              {
               jbrune = brune.func(f, omega0, tstar , fcorn,  alpha, gamma )

                sc = sum((log10(sp)-log10(jbrune))^2);
               if(sc<osc)
                 {
                   osc = sc;
                   gamma.save = gamma
                   tstar.save = tstar

                 }
              }

        }


    print(paste(sep=' ', gamma.save, tstar.save, osc))

    
    return(list(gamma=gamma.save, tstar= tstar.save))
          
  }
brune.search<-function(infreq, inspec, f1, f2, omega0, fcorn, tstar0, gamma  )
{

  ##  print(paste(sep=' ', "Bsearch", f1, f2, omega0, fcorn, tstar0, gamma))
flim = infreq>=f1&infreq<=f2
x = infreq[flim]
y = inspec[flim]
n = length(x)
fcorn = fcorn
omega0  = omega0

dgam = c(gamma-0.1*abs(gamma),gamma+2*abs(gamma), 0) 
ngam = 20
tst1 = tstar0-0.2*abs(tstar0)
tst2 = tstar0+0.2*abs(tstar0)
nstar = 10

dstar = c(tst1, tst2,0)

  sear<-.C("CALL_DGAMMA",
    as.double(x),
    as.double(y),
    as.integer(n) ,
    as.double(fcorn),
    as.double(omega0),
    as.double(dgam), 
    as.integer(ngam),		  
    as.double(dstar), 
    as.integer(nstar)
    )
gam3 =  sear[[6]]
tstar3 =  sear[[8]]

return(list(omega0=omega0,tstar0=tstar3[3]  , fc=fcorn,  alpha=0, gamma=gam3[3]) )

}


####################################################
######### 
###  source("/home/lees/Progs/R_stuff/Specfit.R")

get.cornerA<-function( x, y)
  {
####    find best fit corner frequency omega0 and tstar for
    ##  brune model

    ##  break spectrum into two parts: first half is fit with
    ##  average value, second half with sloping line
    nf = length(x)
    scores = rep(0,nf)
    ascores = rep(0,nf)
    bscores = rep(0,nf)
    cscores = rep(0,nf)

    
    omega = rep(0,nf)
    slope = rep(0,nf)
    cept = rep(0,nf)
    temp = rep(0,nf)

    for(i in 2:(nf-1))
      {

        i1 = 1:i
        i2 = (i+1):nf
        omega[i] = mean(y[i1])
        reg = lm(y[i2] ~ x[i2])
        temp[i] = sum(y[i2])

        ascores[i] = sum((y[i1]-omega[i])^2)
        bscores[i] = sum((reg$residuals)^2  )
        cscores[i] =  sum( ((reg$coefficients[2]*x[i2]+reg$coefficients[1])-y[i2])^2)
        
        ## scores[i] = sum( (y[i1]-omega[i])^2 + (reg$residuals)^2 )
        scores[i] =ascores[i]+ bscores[i]
        
        slope[i] = reg$coefficients[2]
        cept[i] = reg$coefficients[1]
         
      }


    winner = 1+which.min(scores[2:(nf-1)])


    plot( x, y, type='l')
    abline(h = omega[winner], col=4)
    abline(c(cept[winner], slope[winner]), col=2)

    print(paste(sep=' ', winner, x[winner] , omega[winner], slope[winner], cept[winner], scores[winner]))
    
    
    return(list(winner=winner, omega=omega, slope=slope, cept=cept, scores=scores, temp=temp, ascores=ascores, bscores=bscores, cscores=cscores))

    
##     zc = get.cornerA(  log10(Spec$f[flag]) , log10(lspec[flag]))


  }
###  source("/home/lees/Progs/R_stuff/Specfit.R")
###   dyn.load("/home/lees/Progs/Rc/GetCornerFreq.so")

get.corner<-function( INfreq, INspec, dt, f1, f2, PLOT=FALSE)
  {
####  calculate the best fit Omega0, Corner freq and Tstar
    ##  for a Brune Model
    ## computations are done in the LOG-LOG domain
    ## so we fit a flat line for Omega and a linear fall off for tstar
    
    ## example: mc = get.corner(Spec$f, lspec, dt, 0.01, 15.0, PLOT=TRUE)

    
    if(missing(PLOT)) { PLOT=FALSE }
    
    n = length(INfreq);
    corn = 0
    ave = 0
    slope = 0
    interc = 0
    K = 0

    flag = INfreq>=f1 & INfreq<=f2

    freqlim  =  INfreq[flag]
    speclim  =  INspec[flag]

    Lfreqlim = log10(freqlim)
    Lspeclim  = log10(speclim)

    n = length(freqlim);
    
  barf<-.C("CALL_DCORN",
    as.double(Lfreqlim),
    as.double(Lspeclim),
    as.integer(n) ,
    as.integer(K) ,
    as.double(ave) ,
    as.double(slope) ,
    as.double(interc)
    )

    K = unlist(barf[[4]])+1
    ave=unlist(barf[[5]]);
 
    slope = unlist(barf[[6]]);
    interc  = unlist(barf[[7]]);

    

    ###  now get the corner frequency

    newx = (ave-interc)/slope

    ## fc = freqlim[K]

    fc = 10^newx
    
    PI = 3.14159265358979;
    gamma = 2.0;
   
   
    
    f = fc;

   
    
    ftem = f*(PI * log10(2.718281828));
    fa = slope*log10(fc);
    fb = 0.5*log10( 1+ (f/fc)^(2*gamma));
    tem = -(fa+fb)/ftem;
    tstar0 = tem/10.;
    omega0 = 10^ave;

     print(paste(sep=' ', "Gcorn:", ave ,omega0,  fc, slope, interc,  tstar0 ))
    if(PLOT==TRUE)
      {

        opar = par("usr")
        par(mfrow=c(2,1))
        
        plot(Lfreqlim, Lspeclim, type='l', main="Restricted Freq", xlab="Log Freq", ylab="Log Displacement")
        abline(h=ave, col=4)
        abline(interc, slope, col=2)

        plot(log10(INfreq), log10(INspec), type='l', main="Full Freq", xlab="Log Freq", ylab="Log Displacement")
        abline(h=ave, col=4)
        abline(interc, slope, col=2)

        
       invisible( par(opar))

      }
    ret = list(corn=fc,ave=ave,slope=slope,interc=interc,tstar0=tstar0,omega0=omega0 )

    return(ret)

    ## example: mc = get.corner(Spec$f, lspec, dt, 0.01, 15.0, PLOT=TRUE)


}
###  source("/home/lees/Progs/R_stuff/Specfit.R")

###   dyn.load("/home/lees/Progs/Rc/GetCornerFreq.so")


##
## get.corner(Spec$f, lspec, dt, 0.01, 10.0)


