
###  wavelet transform plotting routines

###  library(Rwave) 

##   source("/home/lees/Progs/R_stuff/WLET.R"); save.image()



###  library(Rwave) ; source("/home/lees/Progs/R_stuff/WLET.R")

wlet.do<-function(why, dt, noctave=6, nvoice=20, flip=TRUE, ploty=TRUE, zscale=1, col=terrain.colors(100))
  {
    ### usage: wlet.do(x,  delta, noctave = 4, nvoice = 20,  flip=FALSE,  col=rainbow(100))


    if(missing(col)) { col=rainbow(100) }
    if(missing(noctave)) { noctave=6 }
    if(missing(nvoice)) { nvoice=20 }
    if(missing(flip)) { flip=TRUE }
    if(missing(ploty)) { ploty=TRUE }
    if(missing(zscale)) {  zscale=1  }

   opar = par()
    ## par(mfrow=c(2,1))
    ## par(xaxs='i')

    ## plot.ts(ts(why, deltat=dt) )
    kaha= cwt(why, noctave, nvoice=nvoice, w0=5, twoD=TRUE, plot=FALSE)
 ##   kaha= cwt(why, noctave, nvoice=nvoice, w0=5, twoD=TRUE, plot=TRUE)

###  get the scale for the y-axis
    

###    ii = sort(rep(c(1:noctave), times=nvoice))
###    jj = rep(c(0:(nvoice-1)), times=noctave)
###    sa = 2^(ii+jj/nvoice)
###   take the log
###    lsa = log2(sa)

    
    if(flip==TRUE)
      {
        baha =  mirror.matrix(Mod(kaha))
        
      }
    else
      {
        baha = Mod(kaha)
       
      }

    baha = list(img=baha, noctave=noctave , nvoice=nvoice, flip=flip)
    
    ##  wlet.plot(baha, why, dt, col=col, zscale=zscale)


    plotwlet(baha, why, dt , zscale=zscale,  col=col,  ygrid=FALSE)
 
    
    invisible(baha)
    
 }
#################################################
#################################################
##   source("/home/lees/Progs/R_stuff/WLET.R"); save.image()

#################################################
#################################################

plotwlet<-function(baha, Ysig, dt , zscale=1,  col=col, ygrid=FALSE)
  {
    if(missing(zscale)) { zscale = 1 }
    
    if(missing(col)) { col=rainbow(50) }
    
     if(missing(ygrid)) { ygrid=FALSE }
    

    perc = 0.85

    
    if(baha$flip==TRUE)
      {
        
###NO: yax = rev(baha$nvoice*((1:baha$noctave)-1)/(baha$nvoice*baha$noctave))
        yax = rev(baha$nvoice*((1:baha$noctave))/(baha$nvoice*baha$noctave))
        
        
      }
    else
      {
        
        yax =baha$nvoice*((1:baha$noctave)-1)/(baha$nvoice*baha$noctave)
      }
    
    

    a = Ysig

    DSPEC = baha$img
    numfreqs = nrow(baha$img)
    y =  yax
    x = dt*(1:nrow(baha$img))
     
    yflag = rep(TRUE, length(y))

    tim = dt*seq(0, length=length(a))
   
    
  ##   image(x,why,t(DSPEC[1:(numfreqs/2),]), add=TRUE, col = col,xlab='time', ylab='freq', axes=FALSE)

   ##   image(x,why,log10(t(DSPEC[1:(numfreqs/2),])), add=TRUE, col = col,xlab='time', ylab='freq', axes=FALSE)

    IMAT =baha$img

 ##print(y)
    why   = sort( RESCALE( 1:ncol(baha$img) , 0 , perc , 1, ncol(baha$img) ))
 ##print(why)
    

    if(zscale<=1){ ImPlot = IMAT; units="Amp" } 
    if(zscale==2){ ImPlot =     log10(IMAT) ; units="Log Amp"}
    if(zscale==3){ ImPlot = sqrt(IMAT) ; units="SQRT Amp"}
    if(zscale==4){ ImPlot = 20*log10( IMAT/ max( IMAT, na.rm=TRUE) ) ; units="DB"}
       if(zscale>4){ ImPlot = IMAT; units="Amp" }  

   ##   par(mfrow=c(1,1))
    par(xaxs='i', yaxs='i')

    plot(range(tim), c(0,1), axes=FALSE, type='n', xlab='', ylab='log(scale)')
  
    image.default(x=x, y=why , z=ImPlot , add=TRUE, col = col, xlab='time', ylab='log(scale)', axes=FALSE)
    
    trace = RESCALE( a, perc , 1.0  , min(a), max(a) )

    
   lines(tim, trace)

    ##  sy = RESCALE( a, perc  , 1.0  , min(a), max(a) )
    Tdiff = max(tim)-min(tim)
    
    ##   segments(max(tim)-Tdiff*.04-DEVOL$wpars$Ns*dt, 0.76, max(tim)-Tdiff*.04, 0.76, lwd=2)
    

                                        # axis(1)
                                        #  axis(3)
    
    xtix = pretty(x, n=10)
  #   xtix = xtix[xtix>=min(x)&xtix<=max(x)]

 #    xtix = c(floor(min(x)),xtix,  floor(max(x)))
    
    axis(3,tck=.01,at=xtix,lab=FALSE)
    mtext( side=3,    at=xtix, text=xtix, line=.5)


    axis(1,tck=.01,at=xtix,lab=FALSE)
    mtext( side=1,    at=xtix, text=xtix, line=.25)

   
                                        #  title(xlab="Time, s")
    mtext(side=1, at=max(x), text="Time, s" , line=1.5, adj=1)



      

    raxspec= RESCALE(yax , 0 , perc , 0, 1 )
      
    axis(2, at=raxspec, labels=2^(1:baha$noctave))
    
   ##    axis(2, at=raxspec, labels=format.default(axspec, digits=3), pos=min(x))

    if(ygrid==TRUE)
      {
      
        ##  abline(h=raxspec)
        segments(rep(min(x), length(raxspec)), raxspec,  rep(max(x), length(raxspec)) , raxspec)

      }


  

    
    axtrace = range(a)
    raxtrace= RESCALE( axtrace, perc , 1.0 , min(a), max(a) )
    axis(4, at=raxtrace, labels=format.default(axtrace, digits=3), pos=max(tim))
    
    HOZscale( ImPlot, col, units=units, s1=0.4, s2=0.95)

    invisible(list(y=y[yflag], why=why, yBounds=c(0,perc), x=x, yat=raxspec))

  }


##############################################################
##   source("/home/lees/Progs/R_stuff/WLET.R")
##############################################################
##   source("/home/lees/Progs/R_stuff/WLET.R")
wlet.plot<-function(baha, why, dt, col=terrain.colors(100), zscale=1, plotsig=1)
  {
    
    if(missing(col)) { col=rainbow(100) }
    if(missing(zscale)) { zscale=1 }
    if(missing(plotsig)) { plotsig=1 }

    units="Raw"
    if(baha$flip==TRUE)
      {
        
        ###NO: yax = rev(baha$nvoice*((1:baha$noctave)-1)/(baha$nvoice*baha$noctave))
        yax = rev(baha$nvoice*((1:baha$noctave))/(baha$nvoice*baha$noctave))

        
      }
    else
      {
        
        yax =baha$nvoice*((1:baha$noctave)-1)/(baha$nvoice*baha$noctave)
      }


    if(zscale==2)
      {
        baha$img = log(baha$img)
           units="Log"
      }

    if(zscale==3)
      {
        baha$img = sqrt(baha$img)
           units="Sqrt"
      }

    
    image.default(x=dt*(1:nrow(baha$img))  ,z=(baha$img),  axes=FALSE , xlab = "Time", ylab = "log(scale)", col=col)
    
    axis(1);
    axis(2, at=yax,labels=2^(1:baha$noctave)) 
    
    if(!is.null(plotsig) )
      {
        why2   = RESCALE(why, 0.65 , 1.0 , min(why), max(why) )
        lines(dt*(1:nrow(baha$img)), why2, col=plotsig)
      }
    box()

   HOZscale(baha$img, col, units=units, s1=0.5, s2=0.95)

    
    invisible( list(yat=yax,labs=2^(1:baha$noctave)))
    
  }
##############################################################
##   source("/home/lees/Progs/R_stuff/WLET.R")

gab.plot<-function(baha, why, dt, col=terrain.colors(100), zscale=1, plotsig=1)
  {
    
    if(missing(col)) { col=rainbow(100) }
    if(missing(zscale)) { zscale=1 }
    if(missing(plotsig)) { plotsig=1 }
      

        
        yax =pretty(seq(from=0, by=baha$freqstep,  length=baha$nvoice))


    if(zscale==2)
      {
        baha$img = log(baha$img)
      }

    if(zscale==3)
      {
        baha$img = sqrt(baha$img)
      }

    
    image.default(x=dt*(1:nrow(baha$img))  ,z=(baha$img),  axes=FALSE , xlab = "Time", ylab = "log(scale)", col=col)
    
    axis(1);
    axis(2, at=yax,labels=yax) 
    
    if(!is.null(plotsig) )
      {
        why2   = RESCALE(why, 0.65 , 1.0 , min(why), max(why) )
        lines(dt*(1:nrow(baha$img)), why2, col=plotsig)
      }
    box()
    
   ##  invisible()
    
  }
##############################################################
##   source("/home/lees/Progs/R_stuff/WLET.R")
Mmorlet<-function(UB=-4, LB=4, N=256, plot=FALSE)
{

  ###  create a morlet function based on the matlab style routines
  if(missing(plot) ) { plot=FALSE }
  if(missing(UB) ) { UB = -4 }
  if(missing(LB) ) { LB = 4 }
  if(missing(N) ) { N = 256 }
  
###  this is the morlet function as set up by MATLAB
  out2 = seq(from=UB, to=LB, length=N)
  out1 = exp(-(out2^2)/2) * cos(5*out2)
  if(plot==TRUE)
    {
      plot(out2, out1, type='l')
    }
  invisible(list(xval=out2, morl=out1))
}


##############################################################
##############################################################
scal2freqs<- function(octs, dt, plot=FALSE)
{
  ####   make a vector of  freqencies from the scales
  if(missing(plot) ) { plot=FALSE }
  mm  = Mmorlet(-8, 8, 256)
   ##  m2 = morlet(256, 128,  256/16, w0=5)
  psi = mm$morl
  psiFT = fft(psi); 
  sp = (abs(psiFT)); 
  indmax = which.max(sp)
  vmax = sp[indmax]
  TD = max(mm$xval)-min(mm$xval);
  per = TD/(indmax-1); 
  freq = 1/per;

  if(plot==TRUE)
    {
      psiFT[sp<vmax] = 0;
      
      recfreq = fft(psiFT, inverse = TRUE);
      plot(mm$xval, mm$morl, type='l')
      
      lines(mm$xval, 0.75*max(abs(psi))*Re(recfreq)/max(abs(recfreq)), col=2)
    }

#####
  freqs = freq / (octs * dt)


   return(freqs)

}
##############################################################
##############################################################
wlet2freqs<- function(noctave, nvoice,  dt, flip=TRUE, tab.FREQ, plot=FALSE)
{
  i1 = sort(rep(c(1:noctave), times=nvoice))
  jj = rep(c(0:(nvoice-1)), times=noctave)

  sa = 2^(i1+jj/nvoice)

  efs = scal2freqs(sa, dt)

  if(flip==TRUE)
    {
      efs = rev(efs)
    }

  I1 = matrix(rep(efs, times=length(tab.FREQ)), ncol=length(tab.FREQ))
  I2 = matrix(rep(tab.FREQ, times=length(efs)), ncol=length(tab.FREQ), byrow=TRUE)

  IA = apply(abs(I1-I2), 2, which.min)


  Iat = nvoice*(log2(sa[IA])-1)/(nvoice*noctave)

  if(plot==TRUE)
    {
      abline(h=Iat, lty=2, col=rgb(0.5, 0.5, 0.5) )
      axis(side = 4, at=Iat, labels=tab.FREQ)
    }

  FOUT = Iat
  invisible(FOUT)
}

##   source("/home/lees/Progs/R_stuff/WLET.R"); save.image()

##   source("WLET.R"); save.image()


##############################################################
##############################################################
pwlet2freqs<- function(noctave, nvoice,  dt, flip=TRUE, tab.FREQ, plot=FALSE)
{
  perc = 0.85
  
  i1 = sort(rep(c(1:noctave), times=nvoice))
  jj = rep(c(0:(nvoice-1)), times=noctave)

  sa = 2^(i1+jj/nvoice)

  efs = scal2freqs(sa, dt)

  if(flip==TRUE)
    {
      efs = rev(efs)
    }

  I1 = matrix(rep(efs, times=length(tab.FREQ)), ncol=length(tab.FREQ))
  I2 = matrix(rep(tab.FREQ, times=length(efs)), ncol=length(tab.FREQ), byrow=TRUE)

  IA = apply(abs(I1-I2), 2, which.min)


  Iat = nvoice*(log2(sa[IA])-1)/(nvoice*noctave)

   why   = RESCALE(Iat , 0 , perc , 0, 1 )

  
  if(plot==TRUE)
    {
      abline(h=why, lty=2, col=rgb(0.5, 0.5, 0.5) )
      alabs = as.character(tab.FREQ)
      ###  alabs[length(alabs)] = paste(sep=" ", alabs[length(alabs)], "Hz")
      axis(side = 4, at=why, labels=alabs)
      mtext(side=4, line=1, at = why[length(why)] , text="Hz", adj=(-1))
    }

  FOUT = why
  invisible(FOUT)
}


##   source("/home/lees/Progs/R_stuff/WLET.R")


wlet2.do<-function(why, dt, zlog=FALSE, col=terrain.colors(100))
  {

    if(missing(col)) { col=terrain.colors(100)}
    if(missing(zlog)) {zlog=FALSE }

    
  ##  opar = par()
    ## par(mfrow=c(2,1))
    ## par(xaxs='i')

    ## plot.ts(ts(why, deltat=dt) )
    ##  kaha= cwt(why, 6, nvoice=20, w0=2 * pi, twoD=TRUE, plot=FALSE)
    kaha= cwt(why, 6, nvoice=20, w0=2 * pi, twoD=TRUE, plot=FALSE)
    baha =  mirror.matrix(Mod(kaha))

    if(zlog==TRUE)
      {
        baha = log(baha)
      }
    
    ## filled.contour(x=dt*(1:nrow(baha))  ,y=1:ncol(baha)   , z=(baha), xlab = "Time", ylab = "log(scale)",  main = "Wavelet Transform Modulus", col=col)


    
     image.default(x=dt*(1:nrow(baha))  ,z=(baha), axes=FALSE, xlab = "Time", ylab = "log(scale)", col=col)

    axis(1);
    axis(2, at=20*(1:6)/120,labels=2^(1:6)) 

    
   why2   = RESCALE(why, 0.65 , 1.0 , min(why), max(why) )

   lines(dt*(1:nrow(baha)), why2)
    box()
    invisible(baha)

 }
##############################################################
##   source("/home/lees/Progs/R_stuff/WLET.R")

wlet2.plot<-function(baha, why, dt, col=terrain.colors(100))
  {

    if(missing(col)) { col=rainbow(100) }
 
    image.default(x=dt*(1:nrow(baha))  ,z=(baha), xlab = "Time", ylab = "log(scale)",  main = "Wavelet Transform Modulus", col=col)

   why2   = RESCALE(why, 0.65 , 1.0 , min(why), max(why) )

   lines(dt*(1:nrow(baha)), why2)
    box()
 }


##############################################################
##   source("/home/lees/Progs/R_stuff/WLET.R")
