####  functions for reading in tomographic images
####   replacement programs for geotouch
####

####  source("/home/lees/Progs/Palette/tomo100.R")
 
####  source("/home/lees/Progs/R_stuff/XMA.R")

####  A = GXMA("/home/lees/Site/NAndes/Ecuador/hay5.RIMAGE")
#### image(A$kmx, A$kmy, t(A$z) , col=cmap, asp=1, add=FALSE)
GetOrg<-function(name)
  {
    ###  read in an origin file in the geotouch format
    ###  or the tomographic inversion style of origin
    ### name = "/home/lees/Site/BOS/INV3/fuj.org.plot"
    ### org = GetOrg(name)
    

    A = scan(file=name,nlines=1,what=0)
    B1 = scan(file=name,skip=1,nlines=1,what=0)
     B2 = scan(file=name,skip=2,nlines=1,what=0)

    ja = length(A)
    
    type = A[1]
    proj = A[2]
    nx=A[3]
    ny = A[4]
    nz= A[5]
    dx=A[6]
    if(ja>6)
      {
    dy=A[7]
  }
    else
      {
        dy=dx
      }

    jb1 = length(B1)
    if(jb1==1)
      {
        lat = B1
      }
    else
      {
        lat = B1[1]+B1[2]/60+B1[3]/3600
      }
     jb2 = length(B2)
    if(jb2==1)
      {
        lon = B2
      }
    else
      {
        lon = B2[1]+B2[2]/60+B2[3]/3600
      }
   
    return(list(type=type,proj=proj,nx=nx, ny=ny,nz=nz, dx=dx, dy=dy, lat=lat, lon=lon))  
  }
############################################################
####  source("/home/lees/Progs/R_stuff/XMA.R")
PlotOrg<-function(org, style=0)
  {
    if(missing(style)) { style=0 }
    XYLL = GLOB.XY(org$lat, org$lon)
    KX = org$dx*org$nx
    KY = org$dy*org$ny
    ##   PROJpoints(org$lat, org$lon, PCH=3, COL=2)
    UR = lcgc(org$lat, org$lon, KX, KY)
    ##   PROJpoints(UR$lat, UR$lon, PCH=3, COL=4)
    XYUR = GLOB.XY(UR$lat, UR$lon)
    if(style==0)
      {
        rect(XYLL$x, XYLL$y, XYUR$x, XYUR$y, border=3)
      }
    if(style==1)
      {
        rect(XYLL$x, XYLL$y, XYUR$x, XYUR$y, border=3)
        RX = org$dx* (1:org$nx)
        RY = org$dy* (1:org$ny)
        JX1  = lcgc(org$lat, org$lon, RX, rep(0, length(RX) ))
        JY1  = lcgc(org$lat, org$lon, rep(0, length(RY) ), RY)

        JX2  = lcgc(org$lat, org$lon, RX, rep(KY, length(RX) ))
        JY2  = lcgc(org$lat, org$lon, rep(KX, length(RY) ), RY)

        V1 = GLOB.XY(JX1$lat, JX1$lon)
        V2 = GLOB.XY(JX2$lat, JX2$lon)

        segments(V1$x, V1$y, V2$x, V2$y)
        V1 = GLOB.XY(JY1$lat, JY1$lon)
        V2 = GLOB.XY(JY2$lat, JY2$lon)

        segments(V1$x, V1$y, V2$x, V2$y)

        
      }
    
  }

############################################################
####  source("/home/lees/Progs/R_stuff/XMA.R")
####  source("XMA.R"); save.image()


GXMA<-function(name)
  {
	############  

    A = scan(file=name, nmax=1, list(x1=0, x2=0, nx=0, ny=0, skip=0, lat=0, lon=0, dx=0, dy=0))
    D = scan(file=name, skip=1)
    D[D==A$skip] = NA

    x = A$dx*seq(from=0, length=A$nx)
    y = A$dy*seq(from=0, length=A$ny)
    
    z = matrix(D, ncol=A$nx, nrow=A$ny, byrow=TRUE)

    DAPROJ = PROJ.DATA
    setPROJ(type=2, LAT0=A$lat, LON0=A$lon )



    LL = XY.GLOB( x , rep(0,length(x)) )
    lons = LL$lon
    LL = XY.GLOB( rep(0,length(y)) , y )
    lats = LL$lat

    PROJ.DATA<<-DAPROJ

    mx = GLOB.XY(A$lat, A$lon  )
    kmx = mx$x+x
    kmy = mx$y+y

    return(list(org=A, x=x, y=y, z=z, lats=lats, lons=lons, kmx=kmx, kmy=kmy) )

    
  }
##############################################################################
GXMA3D<-function(name)
  {
    ##  GXMA3D function to get a tomographic inversion result from doinv
    ##  
    A = scan(file=name, nmax=1, list(lat=0, lon=0, nx=0, ny=0, nz=0, dx=0, dy=0))
    D = scan(file=name, skip=1, n=A$nz)
    
    M = scan(file=name, skip=3)

    
    A$skip = 1000.0;
    
    M[M==A$skip] = NA

    x = A$dx*seq(from=0, length=A$nx)
    y = A$dy*seq(from=0, length=A$ny)
    


    MOD = as.list(1:A$nz)


    tot = A$nx*A$ny*A$nz
    
    toplen = A$nx*A$ny

    
    for(i in 1:A$nz)
      {
        k = (i-1)*toplen
        MOD[[i]] = t(matrix(M[(k+1):(k+toplen)], ncol=A$nx, nrow=A$ny, byrow=TRUE))

        ###  image(x,y,MOD[[i]], col=tomocolors)
        ###   locator()
        
      }


    ###  image(x,y,MOD[[3]], col=tomocolors)
    ###  image(x,y,MOD[[5]], col=tomocolors)

  ###     DAPROJ = PROJ.DATA
   ###    setPROJ(type=2, LAT0=A$lat, LON0=A$lon )

  ###     LL = XY.GLOB( x , rep(0,length(x)) )
  ###     lons = LL$lon
  ###     LL = XY.GLOB( rep(0,length(y)) , y )
  ###     lats = LL$lat

   ###    PROJ.DATA<<-DAPROJ

  ###     mx = GLOB.XY(A$lat, A$lon  )
  ###     kmx = mx$x+x
   ###    kmy = mx$y+y

    return(list(name=name, A=A, D=D, V=NULL, MOD=MOD, x=x, y=y) )

    
  }
##############################################################################
GXMA3DV<-function(name)
  {
    ##  GXMA3D function to get a tomographic inversion result from doinv
    ##  
    A = scan(file=name, nmax=1, list(lat=0, lon=0, nx=0, ny=0, nz=0, dx=0, dy=0))
    D = scan(file=name, skip=1, n=A$nz)
    V = scan(file=name, skip=2, n=A$nz)

    M = scan(file=name, skip=3)

    
    A$skip = 1000.0;
    
    M[M==A$skip] = NA

    x = A$dx*seq(from=0, length=A$nx)
    y = A$dy*seq(from=0, length=A$ny)
    


    MOD = as.list(1:A$nz)


    tot = A$nx*A$ny*A$nz
    
    toplen = A$nx*A$ny

    
    for(i in 1:A$nz)
      {
        k = (i-1)*toplen
        MOD[[i]] = t(matrix(M[(k+1):(k+toplen)], ncol=A$nx, nrow=A$ny, byrow=TRUE))

        ###  image(x,y,MOD[[i]], col=tomocolors)
        ###   locator()
        
      }


    ###  image(x,y,MOD[[3]], col=tomocolors)
    ###  image(x,y,MOD[[5]], col=tomocolors)

  ###     DAPROJ = PROJ.DATA
   ###    setPROJ(type=2, LAT0=A$lat, LON0=A$lon )

  ###     LL = XY.GLOB( x , rep(0,length(x)) )
  ###     lons = LL$lon
  ###     LL = XY.GLOB( rep(0,length(y)) , y )
  ###     lats = LL$lat

   ###    PROJ.DATA<<-DAPROJ

  ###     mx = GLOB.XY(A$lat, A$lon  )
  ###     kmx = mx$x+x
   ###    kmy = mx$y+y

    return(list(name=name, A=A, D=D, V=V, MOD=MOD, x=x, y=y) )

    
  }

####################################### 

pltomo<-function(x,y,MOD,i, colmap=tomocolors, zlim=zlim)
  {
    if(missing(colmap)) { colmap=tomocolors }

    Z = MOD[[i]]
    if(missing(zlim)) { zlim=NULL }

    if(is.null(zlim))
      {
        image(x,y,Z, asp=1, col=colmap,  xlab="km", ylab="km")
      }
    else
      {
        image(x,y,Z, asp=1, col=colmap,  xlab="km", ylab="km", zlim=zlim)
      }
  }

pMOD<-function(x,y,D, MOD, I=1, J=2, LOC=TRUE, MAP=NULL)
  {
    z = c(D, D[length(D)]+ D[length(D)])

    if(missing(I)) { I=1 }
    if(missing(J)) { J=length(MOD) }
    if(missing(LOC)) { LOC=TRUE }
    if(missing(MAP)) { MAP=NULL }
    
    for( i in I:J )
      {
        pltomo(x,y,MOD,i)
        title(paste(sep=' ', "Depth", z[i], "-", z[i+1]))
        if(!is.null(MAP) )
          {
            PROJmap(JAPmap,  ADD=TRUE, COL=TRUE)
          }
        if(LOC==TRUE) { locator() }
      }

  }
################################
CMOD<-function(KMOD,...)
  {
    pMOD(KMOD$x, KMOD$y, KMOD$D, KMOD$MOD,...)
  }






####  source("/home/lees/Progs/R_stuff/XMA.R")
####           KMOD = GXMA3D("/home/lees/Site/BOS/INV92/DINV5.mod")

####    CMOD(KMOD)

####   source("/home/lees/Progs/Palette/tomo100.R")

####   tomocolors
