######  BOSAI R Stuff
######  source("/home/lees/Progs/R_stuff/bosai.R")

###########  major modifications 2003.12.10
###########  major modifications Thu Feb 12 12:12:56 EST 2004
###########                 added in earthquake hyocenter comparison


##  sta.uw.1992.LLZ
##  sta=scan(file="/home/lees/Site/BOS/INV92/sta.uw.1992.LLZ", list(name='',lat=0, lon=0, z=0))
##       bxy = GLOB.XY(sta$lat,sta$lon)
##       sta$x =  bxy$x; sta$y = bxy$y



########################################
setJAPmap<-function()
{
JAPmap<<- setGenmap("/home/lees/Site/BOS/Rmap")
GENmap(JAPmap)
MLOC<<- locator(2)
rect(MLOC$x[1], MLOC$y[1],MLOC$x[2],MLOC$y[2])
OLOC<<- locator(1)
setPROJ(type=1, LAT0=OLOC$y, LON0=OLOC$x ,
        LATS=list(S=min(MLOC$y), N=max(MLOC$y)),
        LONS=list(E=max(MLOC$x), W=min(MLOC$x) ),
        DLAT=abs(MLOC$y[2]-MLOC$y[1]),
        DLON=abs(MLOC$x[2]-MLOC$x[1]) )
MLOC<<-list(x=MLOC$x, y=MLOC$y, lat=MLOC$y, lon=MLOC$x)
return(JAPmap)
}
############  
########################
######  source("/home/lees/Progs/R_stuff/bosai.R")

japmap<-function(add=FALSE, WIN=MLOC, STA=sta)
{
  if(missing(add)) { add=FALSE }
  if(missing(STA)) { STA=NULL }
  if(missing(WIN)) { WIN=MLOC }
  PROJmap(JAPmap, WIN=WIN,  ADD=add, ASP=TRUE, COL=TRUE)
  AXESmap( JAPmap, GRID=TRUE,  WIN=WIN)

  if(!is.null(STA))
    {
      dupflg = duplicated(STA$lat)&duplicated(STA$lon)
      spos = rep(4, length(STA$lat))
      spos[dupflg] = 3
      bxy = GLOB.XY(STA$lat,STA$lon)
      points(bxy$x, bxy$y, col=2, pch=6)
      text(bxy$x, bxy$y, STA$nm, pos=spos)
   
    }
  u = par("usr")

  KMscale(kmL="")
  
  box()
  
}
japmape<-function(add=FALSE, STA=FALSE)
{
  
  if(missing(add)) { add=FALSE }
  if(missing(STA)) { STA=FALSE }
PROJmap(JAPmap, WIN=MLOC,  ADD=FALSE, ASP=TRUE, COL=TRUE)

AXESmap( JAPmap, GRID=TRUE,  WIN=MLOC)
      exy = GLOB.XY(eqs$lat,eqs$lon)
  
points(exy$x, exy$y, pch=1, cex=0.5, col=cmp[eqs$col] )
  if(STA==TRUE)
    {

      bxy = GLOB.XY(sta$lat,sta$lon)
      points(bxy$x, bxy$y, col=2, pch=6)
      text(bxy$x, bxy$y, sta$nm, pos=3, col=4)
   
    }
  
box()

}

########################
######  source("/home/lees/Progs/R_stuff/bosai.R")

########################
xeq<-function(x, y, z, wd=10)
  {
    if(missing(wd)) { wd = 10 }
    dev.set(2)
    lin = locator(2, type='l', lwd=3)
    points(lin$x[1], lin$y[1], cex=3)
    ax = x-lin$x[1]
    ay = y-lin$y[1]
    r = sqrt((lin$x[1]-lin$x[2])^2+(lin$y[1]-lin$y[2])^2)
    si = (lin$x[2]-lin$x[1])/r
    co = (lin$y[2]-lin$y[1])/r
    px = si*ax+co*ay
    py = co*ax-si*ay
   
    flg = (px>=0)&(px<=r)&(py<=wd)& (py>= -wd)
    ## points(eqs$XY$x[flg], eqs$XY$y[flg], pch=1, cex=0.5, col=4)

    bx = c(0, r, r, 0)
    by = c(-wd, -wd, wd, wd)

    boxx = (si*bx+co*by)+lin$x[1]
    boxy = (co*bx-si*by)+lin$y[1]


    lines(c(boxx, boxx[1]), c(boxy, boxy[1]))

    dl = dev.list()
    lnum = dl[length(dl)]+1
    text(lin$x[1], lin$y[1],label=lnum, pos=2)

    x = px[flg]
    y = -1*z[flg]

    rx = range(x)
    ry = range(y)
    
    Xinch = 8
    Yinch = Xinch*(ry[2]-ry[1])/(rx[2]-rx[1])
    
    X11(width = Xinch, height = Yinch)


    
    plot(x, y, type='n', pch=21, col=4, asp=1, xlab="Dist, km", ylab="Depth, km")

  symbols(x,y, circles=rep(.1, length(x)), inches=.05, add = TRUE,
             fg = 1, bg =4)


    
    title(paste(sep=' ', "x-section", lnum))

    return(list(lin=lin))
    
  }
########################
######  source("/home/lees/Progs/R_stuff/bosai.R")


jcont<-function(x,y,z, d=0.7)
{
 if(missing(d)) { d = 0.7 }
 
JSUR = data.frame(cbind(x=x, y=y,  z=z))
 
JSUR.kr <- surf.gls(3, expcov, JSUR, d=d)
prsurf <- prmat(JSUR.kr,   min(JSUR$x), max(JSUR$x), min(JSUR$y), max(JSUR$y) , 100)
dlev = (max(JSUR$z)-min(JSUR$z))/25
contour(prsurf, levels=seq(min(JSUR$z), max(JSUR$z), dlev ), add=TRUE)
return(JSUR)
}

jimag<-function(x,y,z, d=0.7, col=terrain.colors(50))
{
if(missing(d)) { d = 0.7 }
if(missing(col)) { col=terrain.colors(50) }
  
JSUR = data.frame(cbind(x=x, y=y,  z=z))
JSUR.kr <- surf.gls(3, expcov, JSUR, d=d)
prsurf <- prmat(JSUR.kr,   min(JSUR$x), max(JSUR$x), min(JSUR$y), max(JSUR$y) , 100)
dlev = (max(JSUR$z)-min(JSUR$z))/25

image(prsurf, col=col , add=TRUE)



invisible(prsurf)
}
########################################
jmap<-function()
{

for(i in 1:length(themap$begs))
{
lines(themap$lon[themap$begs[i]:themap$vends[i]],themap$lat[themap$begs[i]:themap$vends[i]], col=1 )
}


}
########################################
jsta<-function()
{

points(themap$sta$lon, themap$sta$lat,pch=3,col=4)
image.SCALE( del92$p,  col = col , x=scale.loc$x  ,  labels="breaks" ,  nlab=10 )

}
########################################
SEESTA<-function(s)
{

k = names(splAZ)==s
 z1 =unlist( splAZ[k])
 z2 =unlist( pspl[k])

JUNK = STA.dist(z1, z2, s )

}


#################################################
DO.jap.res<-function(files, dir='/home/lees/Site/Fuji/UW/ATEST')
  {
    ## plot maps of residuals at stations on an event by event basis
    ## plot a large scale map and detail limited by the station array
    ##
    # files = c(20020205195723p,  20020410150216p,  20020410184005p,  20020411105235p)
    ##  need to get a list of pickfiles:
    #    f = system(paste(sep = ' ', 'ls' ,dir) ,intern=TRUE)
    #  DO.jap.res(files, dir='/home/lees/Site/Fuji/UW/ATEST')
    
  for(i in 1:length(files))
    {
      f1 = paste(sep='/', dir, files[i])
      system(paste(sep=' ', 'uw_resid_stat <',f1, ' > JUNK' ))
      
      map.jap1.res('residuals.P')
      locator()
      
## system( 'cat residuals.P') 
    }

  }

########################
######  source("/home/lees/Progs/R_stuff/bosai.R")

################################################
map.jap1.res<-function(file, cmp=rainbow(100) )
  {
    ## map.jap1.res('/home/beer/lees/DATA/BOSAI/INV3/residuals.P')
   ###  plot and contour the residuals from one event:
   ## in UNIX, dump out one UW file with residuals:
   ## uw_resid_stat P < 020205.195723.062.p
   ##  read in teh data into R
    if(missing(cmp)) { cmp=rainbow(100) }
    
   rs = scan(file=file, list(id=' ',sec=0,lat=0, lon=0,  sta=' ',res=0 ))
   ## find station locations:
   ps = match(rs$sta, sta$nm)
   ## project data:
   pxy = GLOB.XY(sta$lat[ps], sta$lon[ps] )
   exy =  GLOB.XY( rs$lat[1], rs$lon[1])
   
   blat = range(c(sta$lat[ps], rs$lat[1]))
   blon = range(c(sta$lon[ps], rs$lon[1]))

   bxy = GLOB.XY(blat,blon)

   BLOC = list(x=bxy$x, y=bxy$y, lat=blat, lon=blon)
   
   PROJmap(JAPmap, WIN=BLOC,  ADD=FALSE, ASP=TRUE, COL=TRUE, PLOT=FALSE)
  
   ##  J = jcont(pxy$x, pxy$y,rs$res, d=5)

   if(length(rs$res)<10)
     {
       
       nc = length(cmp)*(rs$res-min(rs$res))/(max(rs$res)-min(rs$res))
       
       points(pxy$x, pxy$y, col=cmp[nc], pch=21, cex=2 ) 
     }
   else
     {
       J = jimag(pxy$x, pxy$y,rs$res, d=5, col=cmp )
     }
   
   PROJmap(JAPmap, WIN=BLOC,  ADD=TRUE, ASP=TRUE, COL=TRUE, PLOT=TRUE)
   
   points(pxy$x, pxy$y)
   points(exy$x, exy$y, pch=8, cex=2, col=2)
   
   text(pxy$x, pxy$y, labels=format.default(rs$res, digits=4), pos=3)
   # text(pxy$x, pxy$y, labels=sta$nm[ps], pos=4)
   
   AXESmap( JAPmap, GRID=TRUE,  WIN=BLOC)
   
   box()

dev.set(dev.next())
       PROJmap(JAPmap,  ADD=FALSE, ASP=TRUE, COL=TRUE, PLOT=FALSE)
  
   ##  J = jcont(pxy$x, pxy$y,rs$res, d=5)

   if(length(rs$res)<10)
     {
       
       nc = length(cmp)*(rs$res-min(rs$res))/(max(rs$res)-min(rs$res))
       
       points(pxy$x, pxy$y, col=cmp[nc], pch=21, cex=2 ) 
     }
   else
     {
       J = jimag(pxy$x, pxy$y,rs$res, d=5, col=cmp )
     }
   
   PROJmap(JAPmap,  ADD=TRUE, ASP=TRUE, COL=TRUE, PLOT=TRUE)
   
   points(pxy$x, pxy$y)
   points(exy$x, exy$y, pch=8, cex=2, col=2)
   
   text(pxy$x, pxy$y, labels=format.default(rs$res, digits=4), pos=3)
   # text(pxy$x, pxy$y, labels=sta$nm[ps], pos=4)
   
   AXESmap( JAPmap, GRID=TRUE)
   
   box()




    
  }

###### 
#########################
plot.jap.res<-function(res, kind=1)
{
if(missing(kind)) { kind=1; }




if(kind==1)
{
vals = res$mns
}else
{
vals = res$mds

}


d =   round(RESCALE(vals, 1, 50, min(vals) , max(vals)))
points(sta$lon[res$ista],sta$lat[res$ista], pch=15, cex=1.5, col=col[d])
image.SCALE( vals,  col = col , x=scale.loc$x  ,  labels="breaks" ,  nlab=10 )



}
###################################
###################################
###################################
########################
######  source("/home/lees/Progs/R_stuff/bosai.R")


prep.ROSE<-function(infile)
  {
#####   preparation of the residule files: 
## cd /home/lees/Site/BOS
## uw_resid_stat P < lq4.1992.rloc > ho

##   warning:  this function sets global variables
inrs =  scan(file=infile, list(id=' ',sec=0,lat=0, lon=0,  sta=' ',res=0, wt=0 ))

## need here to weed out bad data

stam =  match( inrs$sta, sta$nm)

flg =   inrs$lon==0.0 | inrs$lat==0.0 | is.na(stam) | inrs$wt>4


rs <<-list(id=inrs$id[!flg],sec=inrs$sec[!flg],lat=inrs$lat[!flg], lon=inrs$lon[!flg],  sta=inrs$sta[!flg],res=inrs$res[!flg], wt=inrs$wt[!flg] )


res <<- split(rs$res, rs$sta)

nres<<- names(res)

rlat <<- split(rs$lat, rs$sta)
rlon <<- split(rs$lon, rs$sta)

rs$stam<<-  match( rs$sta, sta$nm)

rs$stlat <<- sta$lat[rs$stam]
rs$stlon <<- sta$lon[rs$stam]



##  plot(c(rs$stlon,rs$lon) , c(rs$stlat, rs$lat) , type='p', pch='.')
##  flg =   rs$lon==0.0 | rs$lat==0.0
##  plot(c(rs$stlon[flg],rs$lon[flg]) , c(rs$stlat[flg], rs$lat[flg]) , type='p', pch='.')

##  plot(c(rs$stlon[!flg],rs$lon[!flg]) , c(rs$stlat[!flg], rs$lat[!flg]) , type='p', pch='.')

##  segments(rs$stlon, rs$stlat, rs$lon, rs$lat)


rs$baz<<-  greatAz( rs$stlat , rs$stlon, rs$lat, rs$lon)


##  plot(c(rs$stlon[is.na(rs$baz)],rs$lon[is.na(rs$baz)]) , c(rs$stlat[is.na(rs$baz)], rs$lat[is.na(rs$baz)]) , type='p', pch='.')

##  segments(rs$stlon, rs$stlat, rs$lon, rs$lat)


plot(c(rs$stlon,rs$lon) , c(rs$stlat, rs$lat) , type='p', pch='.', xlab='Lon', ylab='Lat', main='input data for residual analysis')

rs$int <<- findInterval( rs$baz, seq(from=-180, to=180, by=10), all.inside = TRUE)


raz <<-  split(rs$baz, rs$sta)

rint<<-  split(rs$int, rs$sta)

}
######  source("/home/lees/Progs/R_stuff/bosai.R")
######  source("/home/lees/Progs/R_stuff/circ.R")

STA.ROSE<-function()
{
##  cycle through the stations stored in residualsP and plot map and rose diagrams
##   graphics.off(); X11(); X11()
##   
##  
##   STA.ROSE()

  for(i in 1:length(nres))
    {
      nres[i]
      r = res[[i]]
      ri = rint[[i]]
      rz = raz[[i]]
      dev.set(dev.next())
      par(mfrow=c(2,1))

    ##   Krose.jml(pi*(90-rz)/180,           bins=36, LABS= c("N", "S", "W", "E"))
       hist(r[abs(r)<10],  breaks=100, xlab="s", col=2)
      
      kros = Krose.jml(pi*(90-rz)/180, abs(r) , bins=36, LABS= c("N", "S", "W", "E"))
      title(main=paste(sep=' ', nres[i], length(r), i, 'of', length(nres)))


      dev.set(dev.next())

      elat = rlat[[i]]
      elon = rlon[[i]]
      ista = match(nres[i],	sta$nm)

      blat = range(c(elat, sta$lat[ista]))
      blon = range(c(elon,  sta$lon[ista] ))
      bxy = GLOB.XY(blat,blon)
      BLOC = list(x=bxy$x, y=bxy$y, lat=blat, lon=blon)

      PROJmap(JAPmap, WIN=BLOC, ADD=FALSE, ASP=TRUE, COL=TRUE, PLOT=TRUE)
      


      bxy = GLOB.XY(elat,elon)
      points(bxy$x, bxy$y, col=4, pch='.')
   #     points(bxy$x[r>=0.4], bxy$y[r>=0.4], col=2, pch='.')
   #     points(bxy$x[r<0.4], bxy$y[r<0.4], col=4, pch='.')

      

      bxy = GLOB.XY(sta$lat[ista],sta$lon[ista])
      points(bxy$x, bxy$y, col=2, pch=6)
      text(bxy$x, bxy$y, labels=nres[i], pos=3, col=4)

      readline()
    }
}
########################
######  source("/home/lees/Progs/R_stuff/bosai.R")
STA1.ROSE<-function(i)
{
##  cycle through the stations stored in residualsP and plot map and rose diagrams
##   graphics.off(); X11(); X11()
##   
##  
##   STA1.ROSE(i)


      nres[i]
      r = res[[i]]
      ri = rint[[i]]
      rz = raz[[i]]

      dev.set(dev.next())
      par(mfrow=c(1,1))
      elat = rlat[[i]]
      elon = rlon[[i]]
      ista = match(nres[i],	sta$nm)

      blat = range(c(elat, sta$lat[ista]))
      blon = range(c(elon,  sta$lon[ista] ))
      bxy = GLOB.XY(blat,blon)
      BLOC = list(x=bxy$x, y=bxy$y, lat=blat, lon=blon)

      PROJmap(JAPmap, WIN=BLOC, ADD=FALSE, ASP=TRUE, COL=TRUE, PLOT=TRUE)
      


      rxy = GLOB.XY(elat,elon)
      points(rxy$x, rxy$y, col=4, pch='.')
   #     points(bxy$x[r>=0.4], bxy$y[r>=0.4], col=2, pch='.')
   #     points(bxy$x[r<0.4], bxy$y[r<0.4], col=4, pch='.')

      

      bxy = GLOB.XY(sta$lat[ista],sta$lon[ista])
      points(bxy$x, bxy$y, col=2, pch=6)
      text(bxy$x, bxy$y, labels=nres[i], pos=3, col=4)

          dev.set(dev.next())
      par(mfrow=c(2,1))

    ##   Krose.jml(pi*(90-rz)/180,           bins=36, LABS= c("N", "S", "W", "E"))
     
      kros = Krose.jml(pi*(90-rz)/180, abs(r) , bins=36, LABS= c("N", "S", "W", "E"))
      title(main=paste(sep=' ', nres[i], length(r), i, 'of', length(nres)))

       hr = hist(r[abs(r)<10],  breaks=100, xlab="s", col=2)

      xsec  = locator()
      abline(v=xsec$x, col=2:(2+length(xsec$x)))

      efs = c(min(r), xsec$x, max(r))

      hcol = rep(2,length(hr$breaks))
      kj = length(efs)-1
      for( j in 1:kj)
        {
          flag <- hr$breaks>=efs[j]&hr$breaks<efs[j+1]
          hcol[flag] = col=2+(j-1)
        }
      kros = Krose.jml(pi*(90-rz)/180, abs(r) , bins=36, LABS= c("N", "S", "W", "E"))
      title(main=paste(sep=' ', nres[i], length(r), i, 'of', length(nres)))

      hist(r[abs(r)<10],  breaks=100, xlab="s", col=hcol)
      
      
      dev.set(dev.next())
    
      for( j in 1:kj)
        {
      flag <- r>=efs[j]&r<efs[j+1]
      points(rxy$x[flag], rxy$y[flag], col=2+(j-1), pch=16, cex=0.5)
    }
    
 
}
########################
######  source("/home/lees/Progs/R_stuff/bosai.R")
PRINT.sta<-function(stas)
  {
    cat( paste(sep='   ', stas$name,
               format.default(stas$lat, digits=8),
               format.default(stas$lon, digits=9),
               format.default(stas$z, digits=7) ), sep="\n")
  }
########################
######  source("/home/lees/Progs/R_stuff/bosai.R")
GET.stas<-function(fn)
  {
    stas = scan(file=fn, what=list(name='', lat=0, lon=0, z=0))
    return(stas)
  }
########################
######  source("/home/lees/Progs/R_stuff/bosai.R")



STA.ALL.ROSE<-function()
{
##  cycle through the stations stored in residualsP and plot map and rose diagrams
##   graphics.off(); X11(); X11()
##   
##  
##   STA.ROSE()

  for(i in 1:length(nres))
    {
      STA1.ROSE(i)
      readline()
    }
}





MAP.ROSE<-function()
{
##  cycle through the stations stored in residualsP and plot map and rose diagrams
##   graphics.off(); X11(); X11()
##   
##  
##  see above for preparation: STA.ROSE()


 
  for(i in 1:length(nres))
    {
      nres[i]
      r = res[[i]]
      ri = rint[[i]]
      rz = raz[[i]]
      dev.set(dev.next())
      par(mfrow=c(2,1))

      Krose.jml(pi*(90-rz)/180,           bins=36, LABS= c("N", "S", "W", "E"), plot=TRUE)
      kros = Krose.jml(pi*(90-rz)/180, abs(r) , bins=36, LABS= c("N", "S", "W", "E"), plot=TRUE)
      title(main=paste(sep=' ', nres[i], length(r), i, 'of', length(nres)))


      dev.set(dev.next())

      elat = rlat[[i]]
      elon = rlon[[i]]
      ista = match(nres[i],	sta$nm)

      blat = range(c(elat, sta$lat[ista]))
      blon = range(c(elon,  sta$lon[ista] ))
      bxy = GLOB.XY(blat,blon)
      BLOC = list(x=bxy$x, y=bxy$y, lat=blat, lon=blon)

      PROJmap(JAPmap, WIN=BLOC, ADD=FALSE, ASP=TRUE, COL=TRUE, PLOT=TRUE)
      


      bxy = GLOB.XY(elat,elon)
      points(bxy$x, bxy$y, col=4, pch='.')

      bxy = GLOB.XY(sta$lat[ista],sta$lon[ista])
      points(bxy$x, bxy$y, col=2, pch=6)
      text(bxy$x, bxy$y, labels=nres[i], pos=3, col=4)

      u = par('usr')
      ufac = (u[2]-u[1])*0.1

      
      prose(kros, ex=bxy$x, why=bxy$y, prop=ufac, perim=FALSE, add=TRUE, style=1)

      
      readline()
    }
}

#########################
######  source("/home/lees/Progs/R_stuff/bosai.R")



#########################
#########################
#########################
######  source("/home/lees/Progs/R_stuff/bosai.R")


#######

#######

#########################
#########################
######  source("/home/lees/Progs/R_stuff/bosai.R")


#########################
#########################
######  source("/home/lees/Progs/R_stuff/bosai.R")



#########################
#########################
######  source("/home/lees/Progs/R_stuff/bosai.R")
