
############################# source("grade_func.R")



do.grades<-function(ggrades, divs=NULL, cut=0)
{
  if(missing(divs)) { divs=NULL }
  if(missing(cut)) { cut=NULL }


  if(!is.null(cut))
    {
      agrades = ggrades[ggrades>cut]

    }
  else
    {

      agrades = ggrades

    }
  
  BIGN = length(ggrades)
  
  hist(agrades, breaks=BIGN/3, main="Exam Grades")
  m = mean(agrades)
  s = sqrt(var(agrades))
  abline(v=c( m-2*s,m-s, m,  m+s, m+2*s), col=2)
  mtext(text="mean", side=3, at=m, line=0)
  u = par("usr")
  text( c(20, (m-2*s+m-s)/2,(m-s+ m)/2, (m+m+s)/2, (m+s+m+2*s)/2 ), rep(u[4], 5), labels=c("E", "D", "C", "B", "A"), pos=1   )
  box()
  if(is.null(divs))
    {
      mtext(text="Type in the divisions from LOW to HIGH", side=3, at = min(ggrades), line=2)
      K = locator(type='p', col=4)
      abline(v=K$x, col=4)
      divs = c(min(ggrades), K$x, max(ggrades))
    }
  print(divs)
  divs = sort(divs)
  
  M = length(divs)
  N = M
  AP =  ggrades>=divs[N]-(divs[N]-divs[N-1])/3
  A =   ggrades>= (divs[N]-2*(divs[N]-divs[N-1])/3)& ggrades<divs[N]-(divs[N]-divs[N-1])/3
  AM =   ggrades>= (divs[N-1])& ggrades<divs[N]-2*(divs[N]-divs[N-1])/3

  N = M-1
  BP =  ggrades>=divs[N]-(divs[N]-divs[N-1])/3 & ggrades<divs[N]
  B =   ggrades>= (divs[N]-2*(divs[N]-divs[N-1])/3) & ggrades<divs[N]-(divs[N]-divs[N-1])/3
  BM =   ggrades>= (divs[N-1])& ggrades<divs[N]-2*(divs[N]-divs[N-1])/3

  N = M-2
  CP =  ggrades>=divs[N]-(divs[N]-divs[N-1])/3 & ggrades<divs[N]
  C =   ggrades>= (divs[N]-2*(divs[N]-divs[N-1])/3)& ggrades<divs[N]-(divs[N]-divs[N-1])/3
  CM =   ggrades>= (divs[N-1])& ggrades<divs[N]-2*(divs[N]-divs[N-1])/3

  N = M-3
  DP =  ggrades>=divs[N]-(divs[N]-divs[N-1])/3 & ggrades<divs[N]
  D =   ggrades>= (divs[N]-2*(divs[N]-divs[N-1])/3)& ggrades<divs[N]-(divs[N]-divs[N-1])/3
  DM =   ggrades>= (divs[N-1])& ggrades<divs[N]-2*(divs[N]-divs[N-1])/3

  N = M-4
  E = ggrades>=divs[N-1]&ggrades<divs[N]

  letts = rep(0, length(ggrades))
  scores  = rep(0, length(ggrades))

  SCRS = seq(from=100, by=(-4), length=13)
  LETS = c("A+", "A", "A-", "B+", "B", "B-", "C+", "C", "C-", "D+", "D", "D-", "E")

  scores[AP] = SCRS[1]
  scores[A] = SCRS[2]
  scores[AM] = SCRS[3]

  scores[BP] = SCRS[4]
  scores[B] = SCRS[5]
  scores[BM] = SCRS[6]

  scores[CP] = SCRS[7]
  scores[C] = SCRS[8]
  scores[CM] = SCRS[9]

  scores[DP] = SCRS[10]
  scores[D] = SCRS[11]
  scores[DM] = SCRS[12]

 scores[E] = SCRS[13]-SCRS[13]*(divs[2]-ggrades[E])/divs[2]
  
  letts[AP] = LETS[1]
  letts[A] = LETS[2]
  letts[AM] = LETS[3]

  letts[BP] = LETS[4]
  letts[B] = LETS[5]
  letts[BM] = LETS[6]

  letts[CP] = LETS[7]
  letts[C] = LETS[8]
  letts[CM] = LETS[9]

  letts[DP] = LETS[10]
  letts[D] = LETS[11]
  letts[DM] = LETS[12]

  letts[E] = LETS[13]

  for(i in 1:length(LETS))
    {
      print(paste(sep=' ', i, LETS[i], length(letts[letts==LETS[i]])))
    }


  for(i in 1:length(SCRS))
    {


      print(paste(sep=' ', i, SCRS[i], length(scores[scores==SCRS[i]])))
    }
  print(paste(sep=' ', "mean=",mean(scores)))


  return(list(grades=ggrades, lett=letts, scor=scores, divs=divs, LETS=LETS, SCRS=SCRS))
}



show.dist<-function(W)
  {

  for(i in 1:length(W$LETS))
    {
      print(paste(sep=' ', i, W$LETS[i], length(W$letts[W$letts==W$LETS[i]])))
    }

print("")
  
  for(i in 1:length(SCRS))
    {


      print(paste(sep=' ', i, W$SCRS[i], length(W$scores[W$scores==W$SCRS[i]])))
    }
  print("")
  
  print(paste(sep=' ', "mean=",mean(W$scores)))


  }



LETGRADE<-function(g)
  {

    lett = rep("I", length=length(g))
    
    SCRS = seq(from=100, by=(-4), length=13)
    LETS = c("A+", "A", "A-", "B+", "B", "B-", "C+", "C", "C-", "D+", "D", "D-", "E", "E")
    SCRS[1] = 100.1
    SCRS[length(SCRS)+1]  = 0

    for(i in 2:length(SCRS))
      {
        lett[g>=SCRS[i] & g<SCRS[i-1] ] = LETS[i-1]

      }
    

    return(lett)

  }
