
###   Mon Jul  7 13:53:54 EDT 2003
###   ls SEIS_INFO* > list.INFO
###    cd $DUMPING_GROUND
### A = scan(file="list.INFO", what="")
### source("/home/lees/Progs/R_stuff/kar.R")
### source("/home/lees/Progs/R_stuff/stromb.R")

## add in the compiled C-code
## dyn.load("/home/lees/Progs/Rc/LLNfilt.so")
## dyn.load("/home/lees/Progs/Rc/GetCornerFreq.so")
## dyn.load("/home/lees/Progs/Rc/MTAPSRC.so")

###  NEED these libraries to run this code
### library(modreg)

KAR.get<-function(A, DIR=".", j)
{
  ifile = A[j]
  
  gg = KAR.Gdat(ifile, DIR)
  
  
  return(gg)
  
}

KAR.it<-function(A, DIR=".", ZOOM=FALSE, PICK=1, Pause=0)
  {

    if(missing(DIR))
    {
      DIR="."
    }
    if(missing(ZOOM))
    {
      ZOOM=TRUE
    }
    if(missing(PICK))
    {
      PICK=1
    }
    if(missing(Pause)) {Pause = 0 ; }


    
    RET = as.list(A)
    BIGN = length(A)
    for(j in 1:BIGN)
      {
        dev.set(2)
        ifile = A[j]
        d = unlist(strsplit(ifile, "_"))
        dfile = paste(sep="_", d[1], "DATA", d[3])

        info = scan(file=paste(sep="/",DIR,ifile) , list(name="", yr=0, mo=0, dom=0,
                      hr=0, mn=0, sec=0, msec=0, dt=0, t1=0,
                      t2=0, off=0, n1=0, n2=0, n3=0, n=0))
        nn = length(info$name)
        ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)
        jd = jday(info$yr[1],info$mo[1],info$dom[1])
        wintim = jd + info$hr[1]/24+ info$mn[1]/(24*60)+(info$sec[1]+info$msec[1]+info$t1[1]-info$off[1])/(24*3600)
        
        dat = matrix(scan(file=paste(sep="/",DIR,dfile)), ncol=nn,  byrow=TRUE)
        p = dim(dat)
        ex = seq(0,p[1]-1)*info$dt[1]
        par(mfrow=c(nn,1))
        par(mai=c(0.1, .7, 0.1, 0.5) )

        for(i in 1:nn)
          {
            if(i==nn) {  par(mai=c(0.2, .7, 0.1, 0.5) ) }

            g = unlist(strsplit(info$name[i] , split='/' ))
            fnam = g[length(g)] 
            h = unlist(strsplit(fnam, split="\\." ) )
            cnam = paste(sep='.', h[length(h)-1], h[length(h)])
            ###  cnam= the component name
            plot(ex, dat[,i], type='l', axes=FALSE, xlab='', ylab='')
            box()
            axis(1, tck=0.03,lab=FALSE)
            axis(2)
            u = par("usr")
           ## text(u[2], u[3], labels=fnam, adj=1.0)
            text(u[2], u[4], labels=cnam, adj=1.0, cex=2.5, xpd=TRUE)

          }
        axis(1)

        
        u = par("usr")
        text(u[1], u[3]+(u[4]-u[3])*.05, labels=paste(sep = " ", ftime[i], "number", j, "of",BIGN) , pos=4)


        ## this part is for zooming


        if(ZOOM==TRUE)
          {
            el = locator(2)
          }
        else
          {
            el = list(x=0, y=0)

          }
        
        if(length(el$x)>1)
          {
            
            flag = ex>el$x[1] & ex<el$x[2]
            par(mai=c(0.1, .7, 0.1, 0.5) )
            
            for(i in 1:nn)
              {
                if(i==nn) {  par(mai=c(0.2, .7, 0.1, 0.5) ) }
                plot(ex[flag], dat[flag,i], type='l', axes=FALSE, xlab='', ylab='')
                box()
                axis(1, tck=0.03,lab=FALSE)
                axis(2)
                
              }
            axis(1)
            u = par("usr")
            text(u[1], u[3]+(u[4]-u[3])*.05, labels=ftime[i], pos=4)
          }
        ## this is the picking section

        if(PICK>0)
          {
            
            w1 = locator()
            # w2 = locator(2)
            #  RET[[j]] = list(name=ifile  ,ftime=ftime, w1=w1, w2=w2)
            RET[[j]] = list(name=ifile  ,ftime=ftime, wintim = wintim, w1=w1)


            
          }
        else
          {
            Sys.sleep(Pause)
            RET[[j]] = list(name=ifile  ,ftime=ftime, wintim = wintim)
          }
        
        
        

      }
    return(RET)
  }


######################################################
###  source("/home/lees/Progs/R_stuff/kar.R")


#####################################################################
######################################################
###  source("/home/lees/Progs/R_stuff/kar.R")


KAR.view<-function(A, DIR=".", ZOOM=FALSE, PICK=1, Pause=0, XSTA=NULL)
  {

    if(missing(DIR))
    {
      DIR="."
    }
    if(missing(ZOOM))
    {
      ZOOM=TRUE
    }
    if(missing(PICK))
    {
      PICK=1
    }
    if(missing(Pause)) {Pause = 0 ; }
    if(missing(XSTA)) { XSTA = NULL ; }


    
    RET = as.list(A)
    BIGN = length(A)
    for(j in 1:BIGN)
      {
        dev.set(2)
        ifile = A[j]
       
        GFIL = KAR.Gdat(ifile, DIR)
	dt = GFIL$dt
        ok = GFIL$ok
	ftime = GFIL$ftime[1]	
        

        PLOT.MATN(GFIL$JMAT[,ok], dt=GFIL$dt, notes=GFIL$KNOTES[ok], COL=GFIL$pcol[ok])
        
        u = par("usr")
        text(u[1], u[3]+(u[4]-u[3])*.05, labels=paste(sep = " ", GFIL$ftime[1], "number", j, "of",BIGN) , pos=4)


        ## this part is for zooming
        print(paste(sep=' ', "WORKING ON FILE:", paste(sep="/",DIR,ifile)))

        if(ZOOM==TRUE)
          {
            title(main="Determine ZOOM")
            el = vlocator(COL=2, NUM=TRUE)
            zl = length(el$x)
            ##  print(paste(sep=' ',"ZL ",zl, el[1], el[2]))
            if(zl>=2)
              {
                zel = c(el$x[zl-1], el$x[zl])
              }
            else
              {
                zel = el$x
              }
            
          }
        else
          {
            zel = 0
            
          }
        
         ## print(paste(sep=' ',"ZEL ",length(zel), zel[1], zel[2]))
                    
        if(length(zel)>1)
          {
            PLOT.MATN(GFIL$JMAT[,ok], dt=GFIL$dt, WIN=c(zel), notes=GFIL$KNOTES[ok], COL=GFIL$pcol[ok])
          }
        ## this is the picking section
        
        if(PICK>0)
          {
             title(main="Pick window with mouse", sub="MAKE PICKS with MOUSE", col=2)
           
             nst = length(GFIL$KNOTES[GFIL$ok])
             w = plocator(COL=4, NUM=TRUE,  YN=nst, style=2)
             ### protect against picks out of the box - use min and max
             ptag = nst-floor(w$y*nst)
             ptag[ptag<1]=1
             ptag[ptag>nst]= nst
             pnotes = GFIL$KNOTES[GFIL$ok[ptag]]
             if(length(pnotes)!=length(w$x))
               {
                 print("plocator: error in picking algorythm")
               }
             
            RET[[j]] = list(name=ifile, dir=DIR  ,ftime=GFIL$ftime, wintim=GFIL$wintim, w1=list(x=w$x, y=w$y), pnotes=pnotes)
          }
        else
          {
            Sys.sleep(Pause)
            RET[[j]] = list(name=ifile, dir=DIR  ,ftime=GFIL$ftime, wintim=GFIL$wintim)
          }
        
        
        

      }
    return(RET)
  }
######################################################
###  source("/home/lees/Progs/R_stuff/kar.R")

matchstas<-function(GFIL, STA, COMP)
  {
    iflg = !is.na(match(GFIL$STNS, STA))&!is.na(match(GFIL$COMPS, COMP))

    I = 1:GFIL$nn
    I = I[iflg]

    return(I)
  }

####### GFIL$KNOTES[matchstas(GFIL,c("krm1", "krm9"), 4)]
####### GFIL$KNOTES[matchstas(GFIL,c("krm1", "krm9"), c(1,4) )]
####### GFIL$KNOTES[matchstas(GFIL,c("krm1"), c(1,4, 7) )]
####### GFIL$KNOTES[matchstas(GFIL,c("krm6"), c(1,4, 7) )]
######################################################
###  source("/home/lees/Progs/R_stuff/kar.R")

checkpick<-function(fin, dir="./")
{
  if(missing(dir)) { dir=NULL }
  N=length(fin)
  n=1
  for(inp in fin)
    {
      if(is.null(dir)==TRUE)
        {
          KD = KAR.Gdat(inp$name, inp$dir)
        }
      else
        {
          KD = KAR.Gdat(inp$name, dir)
          
        }
      PLOT.MATN(KD$JMAT[,KD$ok], dt=KD$dt, notes=KD$KNOTES[KD$ok], COL=KD$pcol[KD$ok])
      title(main=paste(sep=' ',inp$name,n,'of', N ))
      if(is.vector(inp$w1$x)==TRUE)
        {
          pix = inp$w1
          npix = inp$pnotes
          if(is.null(npix)==FALSE)
            {
              Yrange = length(KD$KNOTES[KD$ok])
              mu = match(npix,KD$KNOTES[KD$ok])
              du = 1/( Yrange)
              y1 = (Yrange-mu)*du			
              y2 = y1+du
              segments(pix$x, y1, pix$x, y2)
            }
          else
            {
              abline(v=pix$x)

            }
        }
      readline("Hit Return")
      n=n+1
    }

}

######################################################
###  source("/home/lees/Progs/R_stuff/kar.R")

KAR.postview<-function(B, DIR=".", ZOOM=FALSE, PICK=1, Pause=0, XSTA=NULL, APLOT=FALSE, BPLOT=TRUE, COMP=4, s2nwin=2)
  {

###  example: K1 = KAR.postview(tin[1:3],  dirfls, ZOOM=FALSE, PICK=1, Pause=0.1, XSTA=dsta, BPLOT=FALSE, COMP=c(4,5,6), s2nwin=2)
###  example: K1 = KAR.postview(tin,  dirfls, ZOOM=FALSE, PICK=1, Pause=0.1, XSTA=dsta, BPLOT=FALSE, COMP=c(4,5,6), s2nwin=2)

   
    if(missing(DIR))
    {
      DIR="."
    }
    if(missing(ZOOM))
    {
      ZOOM=TRUE
    }
    if(missing(PICK))
    {
      PICK=1
    }
    if(missing(Pause)) {Pause = 0 ; }
    if(missing(XSTA)) { XSTA = NULL ; }

    if(missing(BPLOT))
    {
      BPLOT=FALSE
    }
    if(missing(APLOT))
    {
      APLOT=FALSE
    }

    
    if(missing(COMP))
      {
        COMP = 4
      }
    if(missing(s2nwin))
      {
        s2nwin=2;
      }
    devl = dev.list()
    
    Get.Screens(2)
    
    LCOMP = length(COMP)
    STA = XSTA
    LSTA = length(STA)
    
    RET = as.list(B)
    
    BIGN = length(B)

    hdr = c("wintim", "t1", "t2", "tstar0" , "fc", "omega0" , "gamma" , "alpha", "sig2noise")
    hdr1 = c("T0" , "FC", "OM" , "GM" , "AL", "SN")
    nparms = length(hdr1)
    cnames =  c("wintim", "t1", "t2")

	ncols = 3+nparms*LSTA*LCOMP
    
    for(ista in 1:(LSTA))
      {
        for(icomp in 1:(LCOMP))
          {
            for(n in 1:nparms)
              {
                ## knum = xyztoi( icomp, ista, 1,  LCOMP, LSTA, 1)
                ## kvec = 3+(knum-1)*5+1
                nam = paste(sep='.', STA[ista], COMP[icomp], hdr1[n])
                cnames = c(cnames, nam)
              }
            
          }
      }
    
    
    Svec = matrix(rep(0, BIGN*ncols), nrow=BIGN, ncol=ncols)
    colnames(Svec) <-  cnames
    
   Snam = rep(NA, BIGN)
  
     
    Ksave = 0;
    
      
    for(j in 1:BIGN)
      {
        dev.set(2)
	par(mfrow=c(1,1))
        ifile = B[[j]]$name

        GFIL = KAR.Gdat(ifile, DIR)
	dt = GFIL$dt
        ok = GFIL$ok
	ftime = GFIL$ftime[1]	

	dev.set(3)
        
        PLOT.MATN(GFIL$JMAT[,ok], dt=dt, notes=GFIL$KNOTES[ok], COL=GFIL$pcol[ok])
        
        u = par("usr")
        text(u[1], u[3]+(u[4]-u[3])*.05, labels=paste(sep = " ", ftime, "number", j, "of",BIGN) , pos=4)


        ## this part is for zooming

        tit = ifile
        title(tit)

        if(!is.null(B[[j]]$w1$x))
          {

            ##  select the last two elements of
            ##  the window vector

            wvec =unlist( B[[j]]$w1$x)
            lw = length(wvec)
              if(lw<2) { next; }
            winlim = c(wvec[lw-1], wvec[lw])

            abline(v=winlim)
            tdiff = winlim[2]-winlim[1]
            tit = paste(sep=' ',  tit, format(tdiff, digits=3))
            Ksave =Ksave+1;

            I = matchstas(GFIL,STA, COMP)
            if(length(I)<1)
              {
                next
              }
            
        windx = list(x=winlim)
        sense = .800
            dev.set(2)
             Svec[Ksave, 1:3 ] = c(GFIL$wintim, B[[j]]$w1$x[1], B[[j]]$w1$x[2])

            for(ii in 1:length(I))
              {
		kk = I[ii]
		print(paste(sep=' ', "working on ", GFIL$info$name[kk]))
		
                tamp = GFIL$dat[,kk]/sense
                staname = GFIL$STNS[kk]
                compname = GFIL$COMPS[kk]

                ista = match(staname, STA)
                icomp = match(compname, COMP)
                
                
                amp = tamp[!is.na(tamp)]
                amp = amp-mean(amp)
                Lamp = length(amp)
                
                SN = Get.S2N(amp, dt, windx$x[1], s2nwin)
                
              #   print(paste(sep=' ',ifile , j, kk, Lamp, STA, COMP, windx$x[1], windx$x[2]))            
                                        # flag1 = ex>windx$x[1] & ex<windx$x[2]
                                        # ampv = amp[flag1]
                                        # a = list(y=ampv, dt=dt)
                BF = brune.fit( amp, dt, nw=windx ,f1=0.01, f2=15, PLOTA=APLOT , PLOTB=BPLOT, tit= paste(sep=' ', staname, compname) )
                ## title(main=paste(sep=' ', staname, compname))
                
                knum = xyztoi( icomp, ista, 1,  LCOMP, LSTA, 1)
                kvec = 3+(knum-1)*nparms+1
                print(paste(sep=' ', kvec, knum, 'ista icomp', ista, icomp, 'Lsta Lcomp=', LSTA, LCOMP, staname,compname ))
                ##  print(kvec:(kvec+4))
                
                                        #  readline("Hit return to continue")            
                Svec[Ksave, kvec:(kvec+nparms-1) ] = c( BF$tstar0 , BF$fc, BF$omega0,BF$gamma, BF$alpha,  SN)
               
              }
             Snam[Ksave] = ifile
               
          }
        ## 
        
        if(Pause>0)
          {
            Sys.sleep(Pause)
          }
        else
          {
            readline("Hit Return")
          }

      }
    sk = 1:length(Snam)

    date.done = date()
    
    return(list(name=Snam, DIR=DIR, tims=Svec[sk,], hdr=hdr, STA=STA, COMP=COMP, COLN=cnames, date.done=date.done))
  }
#######################################################
###  source("/home/lees/Progs/R_stuff/kar.R")


Xpostview<-function(K1)
{
  ####  Xpostview(K1)

 
  DK =dim(K1$tims)
  N = DK[1]
  LSTA = length(K1$STA)
  LCOMP = length(K1$COMP)

  ##  syms = rep(1:LSTA, LCOMP)
  syms = rep( as.character(K1$COMP)  , LSTA)
   
  ##  clrs = c(1,1,1,2,2,2,3,3,3);
  clrs = rep( seq(from=1, to=LSTA, by=1) , each=LCOMP)
  
   


g1 = grep("GM", K1$COLN)
s1 = grep("SN", K1$COLN)
t1 = grep("T0", K1$COLN)
f1 = grep("FC", K1$COLN)
o1 = grep("OM", K1$COLN)

 eflag = !is.na(K1$name) 
  
  tees = K1$tims[eflag, 1]+ K1$tims[eflag, 2]/(24*3600)
  

  
  par(mfrow=c(3,2))

matplot(tees, K1$tims[eflag, g1], pch=syms, col=clrs, ylab="Gamma", xlab="Time, days")
  # readline("Hit Return\n")
matplot(tees, K1$tims[eflag, s1], pch=syms, col=clrs, ylab="Sig2Noise", xlab="Time, days")
 #     readline("Hit Return\n")
matplot(tees, K1$tims[eflag, o1], pch=syms, col=clrs, ylab="Omega0", xlab="Time, days")
  #    readline("Hit Return\n")
matplot(tees, K1$tims[eflag, t1], pch=syms, col=clrs, ylab="Tstar0", xlab="Time, days")
  #    readline("Hit Return\n")
matplot(tees, K1$tims[eflag, f1], pch=syms, col=clrs, ylab="Freq Corn", xlab="Time, days")


  return(K1$tims[eflag, ])

  #  K1$COLN[o1]
  
}
#######################################################
###  source("/home/lees/Progs/R_stuff/kar.R")

KAR.picker<-function(jump=25, begin=1, flist=f98.250, dir='.', ZOOM=TRUE, pref="TES00", sta="1025" )
  {
    if(missing(jump)) {jump=25}
   if(missing(begin)) {begin=1}    
    if(missing(ZOOM)) { ZOOM=TRUE }
    if(missing(pref)) { pref="TEM00" }
    if(missing(sta)) {sta=NULL }
    
      
    for(i in seq(from=begin,to=length(flist) , by=jump) ) 
      {
	nam <- paste(pref,formatC(i, format="d", wid=3, flag="0"), sep=".")
        
        
	j = min((i+jump-1), length(flist))

	TES00 = KAR.view(flist[i:j],  dir, ZOOM=ZOOM, PICK=1, Pause=0, XSTA=sta)

	assign(nam, TES00, env = .GlobalEnv)
	print("continue?")
	m = readline()	
	if(m=="n") 
          {
            break
          }
      }
  }

###  source("/home/lees/Progs/R_stuff/kar.R")
######################################################
###  source("/home/lees/Progs/R_stuff/kar.R")

KAR.calc<-function(B, DIR=".", rot=FALSE)
  {
    ###  use this after running KAR.view

        if(missing(DIR))
    {
      DIR="."
    }

    lat1=vent$lat; lon1=vent$lon;  lat2=karsta$lat[1] ;  lon2=karsta$lon[1] ;
    GBAZ = distaz(lat2, lon2, lat1, lon1)
    baz=GBAZ$baz

    rbaz = grotseis(baz, flip=FALSE)
        par(mfrow=c(5,1))
        
        Vp = 1.2
        Vair = 0.340
        DIST = sqrt((1.46 - 0.875)^2 +  1.528566^2 )
        
        PwaveARRT = DIST/Vair - DIST/Vp
        
       RET = as.list(B)
        BIGN = length(B)
    for(j in 1:length(B))
      {
          ifile = B[[j]]$name

        d = unlist(strsplit(ifile, "_"))
        dfile = paste(sep="_", d[1], "DATA", d[3])

        info = scan(file=paste(sep="/",DIR,ifile), quiet=TRUE, list(name="", yr=0, mo=0, dom=0,
                      hr=0, mn=0, sec=0, msec=0, dt=0, t1=0,
                      t2=0, off=0, n1=0, n2=0, n3=0, n=0))

        ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)     
        nn = length(info$name)
        
        dat = matrix(scan(file=paste(sep="/",DIR,dfile), quiet=TRUE), ncol=nn,  byrow=TRUE)
        p = dim(dat)
        ex = seq(0,p[1]-1)*info$dt[1]

          flag1 = ex>B[[j]]$w1$x[1] & ex<B[[j]]$w1$x[2]
          
          flag2 = ex>B[[j]]$w2$x[1] & ex<B[[j]]$w2$x[2]

            flag3 = ex>(B[[j]]$w1$x[1]-1) & ex<(B[[j]]$w2$x[2]+1)

        
          ARR = B[[j]]$w2$x[1] - PwaveARRT

          XLIM = c(B[[j]]$w1$x[1]-1 , B[[j]]$w2$x[2]+1)

          par(mai=c(0.1, .7, 0.1, 0.5) )

            amp = dat[,2:4]/sense
          
            a = apply(amp, 2, mean)

          
          amp[,1] = amp[,1] - a[1]
          amp[,2] = amp[,2] - a[2]
          amp[,3] = amp[,3] - a[3]

          rms =   amp[,1]^2+amp[,2]^2+amp[,3]^2
          
          ys = ksmooth(ex, rms, "normal", bandwidth=.2)
          
          trms = ex[rms==max(rms[flag1])]
          trms2 = ex[ys$y==max(ys$y[flag1])]

          

          plot(ex[flag3], rms[flag3], type='l', axes=FALSE, xlab='', ylab=ylab)
          lines(ex,ys$y, col=2)


          
             u = par("usr")
            box()
            axis(1, tck=0.03,lab=FALSE)
            axis(3, tck=0.03,lab=FALSE)
            axis(2)
          arrows(trms, u[4], trms,  u[4]-(u[4]-u[3])*.1, length=.1, col=2)
          points(trms2,   u[4]-(u[4]-u[3])*.1  ,  pch=6, col=3)
          
          
        for(i in 1:nn)
          {
             if(i==nn) {  par(mai=c(0.2, .7, 0.1, 0.5) ) }
            if(i==1)
              {
                sense = 0.46
                ylab = "Pa"
              }else{
                sense = .800
                ylab = "mm/s"                
              }
            amp = dat[,i]/sense
            amp = amp-mean(amp)

            
            plot(ex[flag3], amp[flag3], type='l', axes=FALSE, xlab='', ylab=ylab)
             u = par("usr")
            box()
            axis(1, tck=0.03,lab=FALSE)
            axis(3, tck=0.03,lab=FALSE)
            
            axis(2)
             arrows(ARR, u[4], ARR,  u[4]-(u[4]-u[3])*.05, length=.1, col=4)
             arrows(trms, u[4], trms,  u[4]-(u[4]-u[3])*.05, length=.1, col=2)
             

            if(i==1)
              {
                lines(ex[flag2], amp[flag2], col=4)
                m1 = max(amp[flag2])
                m2 = min(amp[flag2])
                m3 = sqrt(sum(amp[flag2]^2)/length(amp[flag2]))
                m4 = sqrt(sum(amp[flag1]^2)/length(amp[flag1]))
                # S2NMike = m3/m4
          
              }
            if(i==2)
              {
                lines(ex[flag1], amp[flag1], col=2)
                ema = extrema(ex[flag1] , amp[flag1], plot=FALSE)
                v1 = max(amp[flag1])
                v2 = min(amp[flag1])
                v3 = sqrt(sum(amp[flag1]^2)/length(amp[flag1]))
                vdi = ema$mdiff

              }

          }
          
        axis(1)
        u = par("usr")
       
        text(u[1], u[3]+(u[4]-u[3])*.05, labels=paste(sep = " ", ftime[i], "number", j, "of",BIGN) , pos=4)
          sense = .800
            a2 = dat[,2]/sense
            a2 = a2-mean(a2)
            a3 = dat[,3]/sense
            a3 = a3-mean(a3)
            a4 = dat[,4]/sense
            a4 = a4-mean(a4)


          PMOT = sqrt( a2[flag1]^2 +  a3[flag1]^2 + a4[flag1]^2)
          A1 = max(PMOT)
          A2 = min(PMOT)
          A3 = sum(PMOT/length(a2[flag1]))

          DTRMS =  B[[j]]$w2$x[1] - trms
          RET[[j]] = list(name=ifile,ftime=ftime, t1=info$t1, t2=info$t2, DTRMS=DTRMS, 
               w1=B[[j]]$w1, w2=B[[j]]$w2,
               M=c(m1,m2,m3, m4), V=c(v1, v2, v3, vdi), A=c(A1,A2,A3) )
          
         

          # p = locator(2)
          dev.set(3)
#
          
         # flag = ex<p$x[2] & ex>p$x[1]
          flag = flag2
          
          ascd = dat[flag, 2:4]


          
          x = ex[flag]
          if(rot==TRUE)
            {
              ascd= ascd  %*%  rbaz
              labs=c("Vertical", "Radial", "Transvers")
             #   PMOtrace(ascd, tim=x, labs=labs, PS=FALSE, ID=ifile )
              ptraceA(ascd, tim=x, labs=labs)
            }
          else
            {
              ptraceA(ascd, tim=x, labs=c("Vertical", "North", "East"))

            }


          
          
          # ptraceA(ascd, tim=x)
         
          #locator(2)
          dev.set(2)
          
  }
       
       return(RET)
  }
##############
UNPAK.calc<-function(LUV)
  {
    U = unlist(LUV)
    M1 = as.numeric(U[names(U) == "M1"])
    M2 = as.numeric(U[names(U) == "M2"])
    M3 = as.numeric(U[names(U) == "M3"])
    M4 = as.numeric(U[names(U) == "M4"])
    S2NM = M3/M4
    V1 = as.numeric(U[names(U) == "V1"])
    V2 = as.numeric(U[names(U) == "V2"])
    V3 = as.numeric(U[names(U) == "V3"])
    A1 = as.numeric(U[names(U) == "A1"])
    A2 = as.numeric(U[names(U) == "A2"])
    A3 = as.numeric(U[names(U) == "A3"])
    T1 = as.numeric(U[names(U) == "w1.x1"])
    T2 = as.numeric(U[names(U) == "w2.x1"])
    DTR = as.numeric(U[names(U) == "DTRMS"])
    VDI = as.numeric(U[names(U) == "V4"])

    Tdif = T2-T1
    D = cbind(M1,M2, M3,V1,V2,V3,A1, A2, A3,T1,T2,Tdif, DTR, VDI, S2NM)
    
    return(D)

  }
###  source("/home/lees/Progs/R_stuff/kar.R")

######################################################
KAR.Dchug<-function(A, B, CH=choose)
  {
    RET = list( length(A$N))
    BIGN = length(A$N)
    if(missing(CH))
      {
        CH = seq(1,BIGN)
      }
    for(j in CH)
      {
        ifile = B[A$N[j]]
        FIG3 = KAR.Getdat(ifile,A$DIR[j] )
        print(paste(sep=' ',ifile,A$DIR[j]))
    
        dt = FIG3$info$dt[1]
        
        par(mfrow=c(1,1))
        
        KAR.Nplot(FIG3, COMP=c(1))
        p1 = locator(2)

        KAR.Nplot(FIG3, COMP=c(1), WIN=p1$x) 
        p1 = locator(2)
        p2 = locator(2)
        
        par(mfrow=c(3,1))
        flag1 = FIG3$ex>p1$x[1] & FIG3$ex<p1$x[2]
        amp1  = FIG3$dat[flag1, 1]
        ex1 =  dt*seq(1,length(amp1))
        
        flag2 = FIG3$ex>p2$x[1] & FIG3$ex<p2$x[2]
        amp2  = FIG3$dat[flag2, 1]
        ex2 = dt*seq(1,length(amp2))

        
        plot(ex1, amp1, xlim=range(c(ex1,ex2)), type='l', main="Initial")
        plot(ex2,amp2, xlim=range(c(ex1,ex2)), type='l', main="Chugs")
        kp = locator()
        ip = locator(1)
        plot(ex2,amp2, xlim=range(c(ex1,ex2)), type='l', main="Chugs")
        for(k in 1:length(kp$x))
          {
            
            dex = ex1-ip$x+kp$x[k]
            z1 = min(amp2[ex2>=min(dex)&ex2<max(dex)  ])
            z2 = max(amp2[ex2>=min(dex)&ex2<max(dex)  ])
            kamp = z1+(z2-z1)*(amp1-min(amp1))/(max(amp1)-min(amp1))
            lines(dex,kamp, col=2)
            
          }
        locator()
        RET[[j]] = list(ifile=ifile, dir=A$DIR[j], p1=p1, p2=p2, kp=kp, ip=ip)
        }
    return(RET)
  }
######################################################
KAR.chug<-function(A, B, DIR=".")
  {

    if(missing(DIR))
      {
        DIR="."
      }
        
    RET = as.list(A$Kount)
    BIGN = A$Kount

    
    for(j in 1:BIGN)
      {
          ifile = B[[A$WIN[j, 1]]]$name
          print(paste(sep=' ',ifile, j ))

        d = unlist(strsplit(ifile, "_"))
        dfile = paste(sep="_", d[1], "DATA", d[3])

        info = scan(file=paste(sep="/",DIR,ifile), list(name="", yr=0, mo=0, dom=0,
                      hr=0, mn=0, sec=0, msec=0, dt=0, t1=0,
                      t2=0, off=0, n1=0, n2=0, n3=0, n=0))

        ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)     
        nn = length(info$name)
        
        dat = matrix(scan(file=paste(sep="/",DIR,dfile)), ncol=nn,  byrow=TRUE)
        p = dim(dat)
        ex = seq(0,p[1]-1)*info$dt[1]
          flag2 = ex>A$WIN[j, 2] & ex<A$WIN[j, 3]
          flag1 = flag2
          par(mfrow=c(nn,1))
          par(mai=c(0.1, .7, 0.1, 0.5) )
        for(i in 1:nn)
          {
             if(i==nn) {  par(mai=c(0.2, .7, 0.1, 0.5) ) }
            if(i==1)
              {
                sense = 0.46
                ylab = "Pa"
              }else{
                sense = .800
                ylab = "mm/s"                
              }
            amp = dat[,i]/sense
            amp = amp-mean(amp)

         dev.set(2)
            if(i==1)
              {
                
                m1 = max(amp[flag2])
                m2 = min(amp[flag2])
                m3 = sqrt(sum(amp[flag2]^2)/length(amp[flag2]))
                ema = extrema(ex[flag2] , amp[flag2], plot=FALSE)
                mdi = ema$mdiff
          
              }
            if(i==2)
              {
                
                v1 = max(amp[flag1])
                v2 = min(amp[flag1])
                v3 = sqrt(sum(amp[flag1]^2)/length(amp[flag1]))
                ema = extrema(ex[flag1] , amp[flag1], plot=FALSE)
                vdi = ema$mdiff
              }

            dev.set(3)
             
            plot(ex, amp, type='l', axes=FALSE, xlab='', ylab=ylab)
            box()
            axis(1, tck=0.03,lab=FALSE)
            axis(3, tck=0.03,lab=FALSE)
            
            axis(2)
            if(i==1)
              {
                lines(ex[flag2], amp[flag2], col=4)
              }
            if(i==2)
              {
                lines(ex[flag1], amp[flag1], col=2)
                
              }
          }
          
        axis(1)
        u = par("usr")
       
        text(u[1], u[3]+(u[4]-u[3])*.05, labels=paste(sep = " ", ftime[i], "number", j, "of",BIGN) , pos=4)
          sense = .800
            a2 = dat[,2]/sense
            a2 = a2-mean(a2)
            a3 = dat[,3]/sense
            a3 = a3-mean(a3)
            a4 = dat[,4]/sense
            a4 = a4-mean(a4)


          PMOT = sqrt( a2[flag1]^2 +  a3[flag1]^2 + a4[flag1]^2)
          A1 = max(PMOT)
          A2 = min(PMOT)
          A3 = sum(PMOT/length(a2[flag1]))
          
          RET[[j]] = list(name=ifile,ftime=ftime, t1=info$t1, t2=info$t2,
               w1=B[[j]]$w1, w2=B[[j]]$w2, M=c(m1,m2,m3, mdi), V=c(v1, v2, v3, vdi), A=c(A1,A2,A3) )
          
       locator(1)
          
  }
       
       return(RET)
  }
#########################################################

KAR.look<-function(B, DIR=".")
  {
 ###  use this after running KAR.view
    if(missing(DIR))
      {
        DIR="."
      }
        
      
        BIGN = length(B)
        
        OUT = matrix(nrow=BIGN, ncol=3)
        Kount = 0
        
    for(j in 1:length(B))
      {
          ifile = B[[j]]$name

        d = unlist(strsplit(ifile, "_"))
        dfile = paste(sep="_", d[1], "DATA", d[3])

        info = scan(file=paste(sep="/",DIR,ifile), list(name="", yr=0, mo=0, dom=0,
                      hr=0, mn=0, sec=0, msec=0, dt=0, t1=0,
                      t2=0, off=0, n1=0, n2=0, n3=0, n=0))

        ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)     
        nn = length(info$name)
        
        dat = matrix(scan(file=paste(sep="/",DIR,dfile)), ncol=nn,  byrow=TRUE)
        p = dim(dat)
        ex = seq(0,p[1]-1)*info$dt[1]
          flag2 = ex>B[[j]]$w2$x[1] & ex<B[[j]]$w2$x[2]
          flag1 = ex>B[[j]]$w1$x[1] & ex<B[[j]]$w1$x[2]
        par(mfrow=c(nn,1))
    
          par(mai=c(0.1, .7, 0.1, 0.5) )
        for(i in 1:nn)
          {
             if(i==nn) {  par(mai=c(0.2, .7, 0.1, 0.5) ) }
            if(i==1)
              {
                sense = 0.46
                ylab = "Pa"
              }else{
                sense = .800
                ylab = "mm/s"                
              }
            amp = dat[,i]/sense
            amp = amp-mean(amp)

            
            plot(ex, amp, type='l', axes=FALSE, xlab='', ylab=ylab)
            box()
            axis(1, tck=0.03,lab=FALSE)
            axis(3, tck=0.03,lab=FALSE)
            
            axis(2)
            if(i==1)
              {
                lines(ex[flag2], amp[flag2], col=4)

              }
            if(i==2)
              {
                lines(ex[flag1], amp[flag1], col=2)

              }

          }
          
          axis(1)
          u = par("usr")
          
          text(u[1], u[3]+(u[4]-u[3])*.05, labels=paste(sep = " ", ftime[i], "number", j, "of",BIGN) , pos=4)



       ploc = locator()
          if(length(ploc$x) == 2)
            {
              Kount = Kount +1
              OUT[Kount,] = c(j, ploc$x[1], ploc$x[2])
            
            }
          
  }
       
      return(list(WIN=OUT, Kount=Kount))
        
  }
################################################
KAR.Getdat<-function(ifile, DIR, ista=0, icomp=0)
{

    if(missing(DIR))
      {
        DIR="."
      }
     
   
    d = unlist(strsplit(ifile, "_"))
    
    dfile = paste(sep="_", d[1], "DATA", d[3])
    
    info = scan(file=paste(sep="/",DIR,ifile), list(name="", yr=0, mo=0, dom=0,
                  hr=0, mn=0, sec=0, msec=0, dt=0, t1=0,
                  t2=0, off=0, n1=0, n2=0, n3=0, n=0))

    info$name

    
    gem = unlist(strsplit(info$name[1], "\\."))
    kgem = length(gem)
    if(missing(ista)) { ista = kgem-1 }
    if(missing(icomp)) { icomp = kgem }
    

    
    ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)     
    nn = length(info$name)
    
    dat = matrix(scan(file=paste(sep="/",DIR,dfile)), ncol=nn,  byrow=TRUE)
    p = dim(dat)
    ex = seq(0,p[1]-1)*info$dt[1]


    ascd = as.list(1:nn) 
    notes = rep(NA, nn)
    stns = rep(NA, nn)
    comps = rep(NA, nn)
   info$jd = rep(NA, nn)
    
    for (j in 1:nn)
      {
        ascd[[j]] =  dat[,j]
        gem = unlist(strsplit(info$name[j], "\\."))
        stns[j]  = gem[ista]
        comps[j] = gem[icomp]
        
        notes[j] = paste(sep=".", stns[j], comps[j])
        info$jd[j] =  jday(info$yr[j], info$mo[j], info$dom[j])

        
        
      }
    
    return(list(ifile=ifile, JSTR=ascd, STNS=stns, COMPS=comps, dt=info$dt,   dir=DIR, info=info, dat=dat, ex=ex, KNOTES=notes))
    
  }
#################################################
##############source("/home/lees/Progs/R_stuff/kar.R")

KAR.LIM<-function(FIG, WIN=c(0,1))
{
  info = FIG$info
  dat = FIG$dat
  ex = FIG$ex

  if(missing(WIN))
    {
      WIN=c(min(ex), max(ex))
    }
  
  nn = length(info$name)
  
  flag2 = ex>WIN[1] & ex<WIN[2]

  dat = FIG$dat[flag2,]
  return(dat)
  
}



####################################################################
####################################################################
KAR.4plot<-function(FIG, WIN=c(0,1), LABS=LABS)
{

  if(missing(LABS)){
    LABS = c("Infrasonic", "Vertical", "North", "East")
  }
  info = FIG$info
  dat = FIG$dat
  ex = FIG$ex

    if(missing(WIN))
      {
        WIN=c(min(ex), max(ex))
      }
  
 nn = length(info$name)
       par(mfrow=c(nn,1))
    
          par(mai=c(0.1, .7, 0.1, 0.5) )

        ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)

       flag2 = ex>WIN[1] & ex<WIN[2]

       xtics = pretty(ex[flag2], n = 20)
  
        for(i in 1:nn)
          {
             if(i==nn) {  par(mai=c(0.3, .7, 0.1, 0.5) ) }
            if(i==1)
              {
                sense = 0.46
                ylab = "Pa"
              }else{
                sense = .800
                ylab = "mm/s"                
              }
            amp = dat[,i]/sense
            amp = amp-mean(amp)

            
            plot(ex[flag2], amp[flag2], type='l', axes=FALSE, xlab='Time, s', ylab=ylab)
             u = par("usr")
            # box()
            # axis(1, at=xtics,  tck=0.03,lab=FALSE)
             # axis(3, tck=0.03,lab=FALSE)
            ytics = pretty(amp[flag2], n = 5)
            axis(2, tck=-0.01 , at=ytics, labels=TRUE)
            # text(rep(u[1], length(ytics)), ytics, labels=ytics , pos=4)

             
             text(u[2], u[3]+(u[4]-u[3])*.35, labels=LABS[i] , pos=2, cex=1.5)


          }
          
          axis(side=1, tck=0.05, at=xtics, labels=FALSE)
          axis(side=1, tick=FALSE,  at=xtics, labels=xtics, line=-1)

  
      title(xlab='Time (s)', line=1.4, cex=1.2) 
          u = par("usr")
  
          
          text(u[1], u[3]+(u[4]-u[3])*.05, labels=paste(sep = " ", ftime[i]) , pos=4)


    
  }
####################################################################
###  source("/home/lees/Progs/R_stuff/kar.R")


KAR.Gdat<-function(ifile, DIR, stloc=1, cmploc=2, XSTA=null)
{
  ###  get a data file that has been dumped and saved by seissig
  ###  fill in a structure for use in plotting and analysis
  ###  ifile is the ascii dump file from seissig
  ###  DIR = directory where the ifile is located
  ###    stloc = position in string where the station name resides
  ###    cmploc = position in string where the component  name resides
    if(missing(DIR))
      {
        DIR="."
      }
    if(missing(stloc))
      {
        stloc=NULL
      }
    if(missing(cmploc))
      {
        cmploc=NULL
      }
    if(missing(XSTA))
      {
        XSTA=NULL
      }


    d = unlist(strsplit(ifile, "_"))
    dfile = paste(sep="_", d[1], "DATA", d[3])

    info = scan(file=paste(sep="/",DIR,ifile), quiet = TRUE, list(name="", yr=0, mo=0, dom=0,
                                                 hr=0, mn=0, sec=0, msec=0, dt=0, t1=0,
                                                 t2=0, off=0, n1=0, n2=0, n3=0, n=0))

    ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)
    nn = length(info$name)
        jd = jday(info$yr[1],info$mo[1],info$dom[1])
        ##  
        wintim = jd + info$hr[1]/24+ info$mn[1]/(24*60)+(info$sec[1]+info$msec[1]/1000+info$t1[1]-info$off[1])/(24*3600)
 
    dat = matrix(scan(file=paste(sep="/",DIR,dfile), quiet = TRUE), ncol=nn,  byrow=TRUE)
    p = dim(dat)
    ex = seq(0,p[1]-1)*info$dt[1]

    JMAT = matrix(ncol=nn, nrow=length(ex) )
    KNOTES = rep(" ", nn)
    STNS = rep(" ", nn)
    COMPS = rep(" ", nn)
    dt = info$dt[1]
     for(i in 1:nn)
          {
            g = unlist(strsplit(info$name[i] , split='/' ))
            fnam = g[length(g)] 
            h = unlist(strsplit(fnam, split="\\." ) )
            if(is.null(cmploc)==TRUE)
              {
                COMPS[i] = h[length(h)]
              }
            else
              {
                COMPS[i] = h[cmploc]
              }
            if(is.null(stloc)==TRUE)
              {
                STNS[i] = h[length(h)-1]
              }
            else
              {

                STNS[i] = h[stloc]
              }
            cnam = paste(sep='.', STNS[i], COMPS[i])
            
            ###  cnam= the component name
            JMAT[,i] =  dat[,i]
            KNOTES[i] = cnam
          }
        USTA = unique(STNS)
        pcol = rep(1, nn)
        for(m in 1:length(USTA))
          {
            pcol[!is.na(match( STNS, USTA[m]))] = 2+m
          }

        if(!is.null(XSTA))
          {
          
            pcol[!is.na(match( STNS, XSTA))] = 2
 
          }
        ok = order(KNOTES)
        
    return(list(ifile=ifile, dir=DIR, info=info, dat=dat, nn=nn, ex=ex, JMAT=JMAT, KNOTES=KNOTES,STNS=STNS, COMPS=COMPS,USTA=USTA, pcol=pcol, ok=ok, wintim=wintim, ftime=ftime, dt=dt  ))

  }
####################################################################
###  source("/home/lees/Progs/R_stuff/kar.R")
KAR.Pdat<-function(GFIL)
  {
    PLOT.MATN(GFIL$JMAT[,GFIL$ok], dt=GFIL$dt, notes=GFIL$KNOTES[GFIL$ok], COL=GFIL$pcol[GFIL$ok])
    
#######abline(v=c(B[[j]]$w2$x[1], B[[j]]$w1$x[1] ), col=2)
  }

####################################################################
###  source("/home/lees/Progs/R_stuff/kar.R")

####################################################################
#
KAR.door<-function(B, DIR=".")
  {

    if(missing(DIR))
      {
        DIR="."
      }
        
      
        BIGN = length(B)
        
        OUT = B
        Kount = 0
        
    for(j in 1:length(B))
      {
          ifile = B[[j]]$name
          FIG = KAR.Gdat(ifile, DIR)
          

         #  flag2 = ex>B[[j]]$w2$x[1] & ex<B[[j]]$w2$x[2]
          #         flag1 = ex>B[[j]]$w1$x[1] & ex<B[[j]]$w1$x[2]

          t1 = B[[j]]$w1$x[1]-1
          t2 = B[[j]]$w2$x[2]+1 
          KAR.Nplot(FIG, WIN=c(t1 ,t2) )

          abline(v=c(B[[j]]$w2$x[1], B[[j]]$w1$x[1] ), col=2)
          abline(v=B[[j]]$w2$x[1]-3.4, col=4)
          abline(v=B[[j]]$w2$x[1]-4.1, col=3)

          P = locator()
          if(length(P$x)==1)
            {
              newSeis = P$x
              OUT[[j]]$w1$x[1] = newSeis
            }
          if(length(P$x)==2)
            {
              newSeis = P$x[1]
              newAcc  = P$x[2]
              OUT[[j]]$w1$x[1] = newSeis
              OUT[[j]]$w2$x[1] = newAcc             
            }
          if(length(P$x)>5)
            {
              return(OUT)
            }

          
          
        }
    return(OUT)
  }

####################################################################
###  source("/home/lees/Progs/R_stuff/kar.R")

###
KAR.Nplot<-function(FIG, COMP=c(1:4), WIN=c(0,1), LABS=LABS, COL=1, ZERO=FALSE)
{
###
  if(missing(LABS)){
    LABS = c("Infrasonic", "Vertical", "North", "East")
  }
  if(missing(ZERO)){  ZERO=FALSE  }

  
  info = FIG$info
  dat = FIG$dat

  if(exists("FIG$ex"))
    {
      ex = FIG$ex
    }
  else
    {
      dt = info$dt[ COMP[1] ]
      d = dim(dat)
      ex = dt*seq(0,d[1]-1)
    }
  
    if(missing(WIN))
      {
        WIN=c(min(ex), max(ex))
      }


    if(missing(COMP))
      {
        COMP = seq(from=1, to=length(info$name))
      }
  
    if(missing(COL))
      {
       COL  = rep(1,  length(info$name))
      }
    if(length(COL)<length(info$name)  )
      {
       COL  = rep(COL[1],  length(info$name))
      }
  

  
 nn = length(COMP)
       par(mfrow=c(1,1))
    
### par(mai=c(0.1, .7, 0.1, 0.5) )

        ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)

       flag2 = ex>WIN[1] & ex<WIN[2]

       xtics = pretty(ex[flag2], n = 20)
  dy = 1/nn
  

  plot(range(ex[flag2]), c(0,1), type='n', axes=FALSE, xlab="", ylab="")
  
        for(i in 1:nn)
          {
            m = COMP[i]
###if(i==nn) {  par(mai=c(0.3, .7, 0.1, 0.5) ) }
            if(m==1)
              {
                sense = 0.46
                ylab = "Pa"
              }else{
                sense = .800
                ylab = "mm/s"                
              }

            
            amp = dat[flag2,m]/sense
            amp = amp-mean(amp)
            y3 = 1-(dy*i)
            if(ZERO==TRUE)
              {
                zer1 = RESCALE(0, y3, y3+dy, min(amp), max(amp) )
                abline(h=zer1, lty=2, col=4)
              }
            z = RESCALE(amp, y3, y3+dy, min(amp), max(amp) )
            abline(h=y3, lty=2, col=grey(0.8))
            lines(ex[flag2], z, col=COL[i])
             
            yy = pretty(amp, n = 5)
            flg = yy>min(amp) & yy<max(amp)
            yt = yy[flg]
            yts = RESCALE(yt, y3, y3+dy, min(amp), max(amp) )
            

            
           #  ytics = pretty(amp[flag2], n = 5)
           # if(i==1){
             axis(2, tck=0.01 , at=yts, labels=yt, las=2 , line=0.1 )
            mtext(side=2, at=y3+dy/2, text=ylab , line=3)
            
            
          # }
            # text(rep(u[1], length(ytics)), ytics, labels=ytics , pos=4)

             
              text(max(ex[flag2]), y3+dy*.1, labels=LABS[m] , pos=2, cex=1)


          }
          
          axis(side=1, tck=0.01, at=xtics, labels=FALSE)
          axis(side=1, tick=FALSE,  at=xtics, labels=xtics, line=-1)

  
  title(xlab='Time (s)', line=1.4, cex=1.2) 
  u = par("usr")
  
          
  text(u[1]+(u[2]-u[1])*.05 , u[3]+(u[4]-u[3])*.05, labels=paste(sep = " ", ftime[i]) , pos=4)

  box(col=grey(0.8))
    
  }




###################################################################################
###################################################################################
kar.SETAIN<-function(A1, J)
  {
    #   divide by sensitivity of the Guralps, .8 v/(mm/s)

   #  i = (j-1)*3+1
    dat = A1$dat[,J]/.8
    nms = A1$info$name[J]
    dt = A1$info$dt[J]
    comp = c("V", "N", "E")
    t = dt[1]*0:(length(dat[,1])-1)
    d = unlist(strsplit(nms[1], "\\."))
    sta = d[6]
    stai = match(sta,karsta$sta)
    stalat = karsta$lat[stai]
    stalon = karsta$lon[stai]
    staZ = karsta$el[stai]
    
    evlat = vent$lat
    evlon = vent$lon
    evZ =  vent$el
    
    az = greatAz( stalat, stalon , evlat,evlon)
    if(az<0) { az=az+180 }
    
    a1 = list(pfil=A1$ifile, dir=A1$dir, data=dat, t=t,   sta=sta, comp=comp,
    info=list(dt=dt, fn=nms, id=nms,   sec=0, psec=0),
    p=0, s=0, T1=0, T2=0, az=az,
    evla=evlat, evlo=evlon , evel=evZ,
    stla=stalat, stlo=stalon,stel=staZ, tbeg=0   )

  
  }
###################################################################################
############## source("/home/lees/Progs/R_stuff/kar.R")
###################################################################################
SETAIN<-function(A1, J, stas, vent)
  {
    ###  set up a data matrix which is later used by particle motion
    ###  programs
    ###  input is A1 = output of KAR.Gdat which reads in the
     ###    data from a dumped seissig file
    ###  J = vector of components from the dta matrix
    ###  stas is a list of station information
    ###       example:   stas = get.stas("/home/lees/Site/Sangay/Map/SANGAY.sta.LLZ")
    #   divide by sensitivity of the Guralps, .8 v/(mm/s)
   #  i = (j-1)*3+1

    ## divide by the sensitivity

    if(!is.null(A1$dat))
      {
        dat = A1$dat[,J]/.8
      }

   if(!is.null(A1$JSTR))
      {
        nj = length(J)
        n2 = length(A1$JSTR[[J[1]]])
        dat = matrix(ncol=nj, nrow=n2)
        for(i in 1:nj)
          {
            k = J[i]
            dat[,i] = A1$JSTR[[k]]

          }     
      }
 
    nms = A1$STNS[J]
    ##   old: nms = A1$info$name[J]
    dt = A1$dt[J]
    ncomp = c("V", "N", "E")
    t = dt[1]*0:(length(dat[,1])-1)
    
    ##   d = unlist(strsplit(nms[1], "\\."))
    
    sta = A1$STNS[J]
    comp = A1$COMP[J]
    
    stai = match(sta,stas$nm)
    stalat = stas$lat[stai]
    stalon = stas$lon[stai]

    staZ =   stas$z[stai]
    
    evlat = vent$lat
    evlon = vent$lon
    evZ   =   vent$z
    
    az = greatAz( stalat, stalon , evlat,evlon)
    az = az%%360
    
    a1 = list(pfil=A1$ifile, dir=A1$dir, data=dat, t=t,   sta=sta, comp=ncomp,
    info=list(dt=dt, fn=nms, id=nms,   sec=0, psec=0),
    p=0, s=0, T1=0, T2=0, az=az,
    evla=evlat, evlo=evlon , evel=evZ,
    stla=stalat, stlo=stalon,stel=staZ, tbeg=0   )

  
  }


###################################################################################
##############source("/home/lees/Progs/R_stuff/kar.R")

###################################################################################
PMO.LOOK<-function(ain1, p)
  {
    KNT = length(p$x)
    RET = as.list(rep("WINDOW", (KNT/2)))
    for(i in 1:(KNT/2))
      {
        j = 2*(i-1)+1
        dev.set(2)
        par(mfrow=c(3,1))
        tracepick(ain1$data, ain1$t)
        abline(v=c(p$x[j], p$x[j+1]), col=2)
        dev.set(3)
        a1 = ain1$data[ain1$t>p$x[j]& ain1$t<p$x[j+1], ]
        t1 = ain1$t[ain1$t>p$x[j]& ain1$t<p$x[j+1]]
        
        px = PMOtrace(a1, t1)
        locator(1)

        ain2 = ain1
        
        ain2$data = a1
        ain2$t = t1
         dev.set(4)
        
        KZ = KARAZI(ain2, 50, 5, 12.24048 )
        
        sel = locator(2)
        dev.set(5)
        par(mfrow=c(1,1))
        rose.jml(pi*(90-KZ$aaz[KZ$aex>sel$x[1] & KZ$aex<sel$x[2]])/180, bins=36, LABS= c("N", "S", "W", "E"))
        az = greatAz( ain1$stla, ain1$stlo , ain1$evla,ain1$evlo)
        vx = cos(deg2rad*(90-az))
        vy = sin(deg2rad*(90-az))

        vxo = cos(deg2rad*(90-az+180))
        vyo = sin(deg2rad*(90-az+180))
        
        points(vx,vy, col=2)
        text(vx,vy, labels="VENT")

        lines(c(vx, vxo), c(vy,vyo) , col=4)
        
        title(ain1$sta[1])
        
        RET[[i]]$WIN = c(p$x[j], p$x[j+1])
        RET[[i]]$sta = ain1$sta[1]
        RET[[i]]$AZ = KZ$aaz[KZ$aex>sel$x[1] & KZ$aex<sel$x[2]]
        RET[[i]]$RAT  = KZ$rateig[KZ$aex>sel$x[1] & KZ$aex<sel$x[2]]
         RET[[i]]$BAZ = az
        
        locator(1)
        

      }
    
    return(RET)
  }
####  source("/home/lees/Progs/R_stuff/kar.R")

###################################################################################
###################################################################################


KAR.rose<-function(PM, let=1)
  {

    if(missing(let)) { let=0 }
        # par(mfrow=c(1,1))
        rose.jml(pi*(90-PM$AZ)/180, bins=36, LABS= c("N", "S", "W", "E"))
        az = PM$BAZ
        vx = cos(deg2rad*(90-az))
        vy = sin(deg2rad*(90-az))

        vxo = cos(deg2rad*(90-az+180))
        vyo = sin(deg2rad*(90-az+180))
        
        points(vx,vy, col=2)
        text(vx,vy, labels="VENT")

        lines(c(vx, vxo), c(vy,vyo) , col=4)
        
        # title(PM$sta)
    u = par("usr")
    txt = paste(sep=" ", "station", PM$sta)
    
    text(u[1], u[3]+(u[4]-u[3])*.05 , labels=txt,pos=4, cex=1.2  )
    
    
    if(let>0)
      {
        letter.it(let,2)
      }

      }
###################################################################################
###################################################################################
###################################################################################
KARAZI<-function(ain, len, shift, prev )
{
#  particle motion estimator
#    len=window length   shift=10 samples  prev=pre-event offset(0.1)

       
        
	opar=par(no.readonly = TRUE)
	alen=length(ain$data[,1])
	dt=ain$info$dt[1]
	ex = ain$t

	dat = ain$data


	comp = ain$comp
	sta = ain$sta[1]


	ascd = ain$data
	fil = ain$info$fn[1]
	pfil  = "" 
	id = ain$info$fn[1]
	sec = ain$info$sec
 	az = ain$az
	
  	aex=rep(0,alen)
 	aaz=rep(0,alen)
  	ai=rep(0,alen)
  	rateig=rep(0,alen)

	winlen=len*dt
 	winn=len
  	winhalf=winn/2
	k = winn/2
   	wincen=ex[k]-ex[1]	
   	wina=(wincen/dt)-winhalf
    	winb=(wincen/dt)+winhalf
  
  	k=len/2
  	j=1
  

  # 	xtics=pretty(seq(from=min(ex), to=max(ex), N=10))
  	xtics=pretty(ex, n=10)


	mintic=min(xtics)
	maxtic=max(xtics)

  	# for each trace, find pre-event DC offset and remove that from the whole trace
	# do not remove the mean again below, that would be wrong

  	ax=1:length(ex)

	#   here we determine a limit on X

  # 	flagax = ax[ex<prev]
  # 	tem=dat[ flagax ,]
  	mns=apply(dat,2,mean)
  	dtem=sweep(dat, 2, mns)

  while(k<(alen-len/2))
    {
      wincen=ex[k]-ex[1]
      wina=round((wincen/dt)-winhalf+1)
      winb=round((wincen/dt)+winhalf+1)
      
      winb=min(winb,alen)
      #    print(c(wina, winb))

      tem=dtem[wina:winb,]
					# need to remove the mean value from each column (we did this above)
					#    NO:  tem=sweep(tem, 2, apply(tem,2,mean))
      
      covtem=t(tem) %*% (tem)
      eg=eigen(covtem, symmetric = TRUE )
					# Be=winn*diag(1,nrow=3) + matrix(c(-1,1,1,1,-1,1,1,1,-1),nrow=3)*covtem
					# Beg=eigen(Be)
      
					# Kappa<-log(Beg$values[1]/Beg$values[2])/log(Beg$values[2]/Beg$values[3])
      
      
      aex[j]=ex[k]
      ## rateig[j]=sqrt( eg$values[2]^2 + eg$values[3]^2 ) / eg$values[1]


      ##  Joydeep recommends using the following measure of rectilinearity
      ## jepsen and kennett, 1990, bssa, 80b, #6, 2032-2052.

      rateig[j]= 1 - ((eg$values[2]+eg$values[3])/(2*eg$values[1]))


      
					#  rateig[j]=Kappa

      #   careful here: be sure the azimuth below is calculated in the N-E-Down coordinate system
#   1=Z   2=N   3=E
#  this means that the real azimuth is 90-alpha  where alpha is the counter-clockwise
#  coordinate angle derived below

      alpha=RAD2DEG*atan(eg$vectors[2,1], eg$vectors[3,1])

       az<-90-alpha


      inci=RAD2DEG*atan(eg$vectors[1,1], sqrt(eg$vectors[2,1]^2+eg$vectors[3,1]^2))


### convert angles so that they are orientations as shiftnd not simply directions
###  this is because the direction is irrelevant and -10deg=170deg orientation

      if(az<0) az=az+180

      aaz[j]=az
      if(inci<0)inci=abs(inci)
      ai[j]=inci
      
      k=k+shift
      j=j+1
    }
  jall=j-1
  
#  dev.set(which=2)
#########   old: par(mfrow=c(6, 1) )
  par(mfrow=c(6, 1) )
  par(mai=c(0.1, .5, 0.1, 0.5) )
  for(i in 1:3)
    { 
      plot(ex,dat[,i], axes=FALSE, xlab="",ylab="", type="n")
      lines(ex,dat[,i],type="l")
      axis(1,tck=.03,at=xtics,lab=FALSE)
      axis(2, las=1)
      axis(3,tck=.03,at=xtics,lab=FALSE)
      box()
      locy=0.8*max(ascd[,i])

      if(comp[i]=="SHV"||comp[i]=="4"||comp[i]=="V"||comp[i]=="G1V" ) tcomp="Vertical"
      if(comp[i]=="N"||comp[i]=="G1N"||comp[i]=="SHN"|| comp[i]=="5") tcomp="North"
      if(comp[i]=="E" ||comp[i]=="G1E" ||comp[i]=="SHE" || comp[i]=="6") tcomp="East"
     
      text(ex[1], locy,paste(sta,tcomp,sep=" : ") ,cex=.8, adj=0)
      
     ###  plot.ps(ain)
     ###  plot.t1t2(ain)
      
      letter.it(i,2)
      
    }	
  i=3
  locy=0.8*max(ascd[,i])
					#  locy=0.95*min(dat[,i])
					# text(max(ex), locy, paste(ain$fil, ain$pfil,ain$id, ain$sec,sep=" : ") , cex=.8,  adj=1, col=3)
  
#######  NOW plot New Stuff  ############################
##  this switches to the other opened window

##    dev.set(which=3)
##  par(mfrow=c(3, 1) )
##   par(mai=c(0.0, .5, 0.1, 0.5) )
  par(mai=c(0.1, .5, 0.1, 0.5) )



#####    INC ANGLE
  
  plot(aex[0:jall],ai[0:jall],xlim=range(ex),ylim=c(0,90),type="n",  axes=FALSE, xlab="",ylab="IncAng, deg")
        lines(aex[0:jall],ai[0:jall],type="l")
					#   abline(h=c(0))
					#   axis(2, las=1)
 #  axis(2, at=c(-60, -30,0,30 , 60), tck=1, las=1, lty=2, lwd=0.5)
axis(2, at=seq(0,90, by=10), tck=1, las=1, lty=2, lwd=0.5)
  axis(3,at=xtics,tck=.03,lab=FALSE)
   plot.ps(ain)
   plot.t1t2(ain)
  
   letter.it(4,2)
  box()

  incpar<-par()

  figinc=par("fig")
  
####  RATIO
  

  plot(aex[0:jall],rateig[0:jall],xlim=range(ex),type='n',  axes=FALSE, xlab="",ylab="RatEig")
        lines(aex[0:jall],rateig[0:jall], type='l')
  locy=0.8*max(rateig[0:jall])
  
  axis(2, las=1)
  axis(1,at=xtics,tck=.03, las=1,   mgp=c(.1,.1,0))
  axis(3,at=xtics,tck=.03,lab=FALSE)
  mtext( paste(fil) , line=0.1)
  
 #   plot.ps(ain)
 #   plot.t1t2(ain)
  box()
   letter.it(5,2)
#####   Azimuth
   par(mai=c(0.2, .5, 0.15, 0.5) )

  plot(aex[1:jall],aaz[1:jall],xlim=range(ex),ylim=c(0,180),axes=FALSE, xlab="Time, s",ylab="Az, deg")
        points(aex[rateig>.9],aaz[rateig>.9], col=2)

 # axis(2, at=c(-150,-100, -50,0,50, 100, 150), tck=1, las=1, lty=2, lwd=0.5)
  axis(2, at=seq(0,180, by=20), tck=1, las=1, lty=2, lwd=0.5)
  axis(3,at=xtics,tck=.03,lab=FALSE)
   axis(1,at=xtics,tck=.03, las=1,   mgp=c(.1,.1,0))

  AZ<- ain$az[1]

  AZ = AZ%%360
					# abline(h=c(0))
  abline(h=c(AZ),lty=4, col=2)
    #   locy=0.8*max(aaz[0:jall])
  locy=165
  text(max(xtics), locy, paste("AZ=",format.default(AZ, digits=3)) ,adj=1, cex=1.2, col=2)
  box()
  

 #   plot.ps(ain)
 #   plot.t1t2(ain)

 #  plot.medbars(ain,aex[1:jall], aaz[1:jall]   )

   figaz=par("fig")
   usraz=par("usr")
  
     locy=0.9*min(aaz[0:jall])
 	#   locy=-165
  m=max(aex[0:jall])
  segments( m-winlen, locy, m , locy, lwd=3)
  
   letter.it(6,2)
  azpar<-par()
  # dev.prev()

  #  invisible(par(opar))
  #   par(opar)
  list(aex=aex[1:jall], rateig=rateig[1:jall], aaz=aaz[1:jall], ai=ai[1:jall], figaz=figaz, azpar=azpar, incpar=incpar )	
}
######################################################
######################################################
######################################################
####  source("kar.R"); save.image()

######################################################

brune.doom<-function(amp, dt=1, f1=0.01, f2=15,  PLOTB=FALSE ,  tit="")
{
  ##  fit a brune model to a windowed trace
  ##  brune.fit( amp, dt, f1=0.01, f2=15, PLOT=FALSE  )


  if(missing(dt)) { dt = 1 }
  if(missing(f1))
    {  f1 = 0.01 }
  if(missing(f2))
    { f2 = 14.0 }

  if(missing(PLOTB))
    { PLOTB=FALSE  }


  if(missing(tit))
    { tit = ""}

  ###  return this structure, WARN is a warning for failure
  xc = list(SUCCESS=TRUE, WARN = "OK",tstar0 = 0, gamma = 0,
    omega0 = 0,
    fc = 0,
    alpha= 0)
  
  ex = seq(0,length(amp)-1)*dt

  xv  = ex
  ampv = amp-mean(amp)
  a = list(y=ampv, dt=dt)

  if(length(a$y)<2)
    {
      return(list(WARN=FALSE, corn=0,ave=0,slope=0,interc=0,tstar0=0,omega0=0 ))
    }
  ##  ta = ts(a$y, start=0, deltat=dt)
  len2 = 2*next2(length(ampv))
  if(len2<1024)
    { len2 = 1024 }


  Spec =MTMdisp(a, f1=f1, f2=f2, len2=len2, PLOT=FALSE )
                                        #   Spec = spec(a, f1=f1, f2=f2, len2=len2, PLOT=FALSE )

  lspec = Spec$displ
  

  print(paste(sep=' ', "brune.TEST", length(Spec$f), length( lspec), dt, f1, f2))
  
  xc = get.corner(  Spec$f , lspec, dt, f1, f2, PLOT=FALSE)
  ## print(paste(sep=' ', "BF post", xc$omega0, xc$corn, xc$tstar0))

  fnyq = 1/(2*dt)

  if(xc$corn>fnyq|xc$corn<=0|xc$tstar0<0)
    {
      xc$SUCCESS = FALSE;
      xc$WARN = "xc$corn>fnyq|xc$corn<=0|xc$tstar0<0";

      if(PLOTB==TRUE)
        {
          
          par(mfrow=c(1,1))
          flag= Spec$f>=f1 & Spec$f<=f2
          
          print(paste(sep=' ', "Brune DOOM PLOTB==TRUE", length(Spec$f[flag]), length( lspec[flag]), dt, f1, f2))
          
          LY = log10(lspec[flag])
          LF = log10(Spec$f[flag])
          print(paste(sep=' ', "Brune DOOM", length(LF), length(LY) ))
          plot(LF, LY ,  lty=1 , type='l' , xlab="Log Freq", ylab="Log Amp Spec")
          
          ## jbrune = brune.func(Spec$f[flag], jmod$omega0, jmod$tstar0 , jmod$fc,  jmod$alpha, jmod$gamma )
          ##   lines(LF, log10(jbrune), col=3)
          title(main="xc$corn>fnyq|xc$corn<=0|xc$tstar0<0")
          
        }
      return(xc)

    }

  if(is.numeric(xc$omega0)==TRUE & is.numeric(xc$corn)==TRUE  & is.numeric(xc$tstar0)==TRUE )
    {
      
      jmod = brune.search(Spec$f, lspec, f1, f2,  xc$omega0, xc$corn, xc$tstar0, 2.0)
    }
  else
    {
      xc$SUCCESS = FALSE;
      xc$WARN = "Non-numeric";
      return(xc)
    }


  if(PLOTB==TRUE)
    {
      
      par(mfrow=c(1,1))
      flag= Spec$f>=f1 & Spec$f<=f2
      
      print(paste(sep=' ', "Brune DOOM PLOTB==TRUE", length(Spec$f[flag]), length( lspec[flag]), dt, f1, f2))

      LY = log10(lspec[flag])
      LF = log10(Spec$f[flag])
      print(paste(sep=' ', "Brune DOOM", length(LF), length(LY) ))
      plot(LF, LY ,  lty=1 , type='l' , xlab="Log Freq", ylab="Log Amp Spec")
      jbrune = brune.func(Spec$f[flag], jmod$omega0, jmod$tstar0 , jmod$fc,  jmod$alpha, jmod$gamma )
      lines(LF, log10(jbrune), col=3)


###### add.brune(list(y=Spec$f, dt=dt)  ,  xc$tstar0,   xc$corn,   xc$omega0, 4, f1=f1, f2=f2, plog=TRUE)
      abline(h=xc$ave, col=4)
      abline(xc$interc, xc$slope, col=2)
      
###  format.default(TIM$jday[1], digits=2, trim=FALSE)
      tit2 = paste(sep=' ',
        format.default(jmod$omega0, digits=4, trim=FALSE),
        format.default(jmod$tstar0, digits=4, trim=FALSE),
        format.default(jmod$fc,     digits=3, trim=FALSE),
        format.default(jmod$alpha,  digits=3, trim=FALSE),
        format.default(jmod$gamma,  digits=3, trim=FALSE))
      
      title(main=tit2)
     
     
      
      
    }
  
  xc$SUCCESS = TRUE;
  xc$WARN = "OK";
  xc$tstar0 = jmod$tstar0;
  xc$gamma = jmod$gamma;
  xc$omega0 = jmod$omega0;
  xc$fc = jmod$fc;
  xc$alpha= jmod$alpha
   
  return(xc)
  
}

####  source("kar.R"); save.image()

######################################################
######################################################
######################################################
######################################################

brune.fit<-function(amp, dt=1, f1=0.01, f2=15, nw=list(x=c(0,1)), PLOTA=FALSE, PLOTB=FALSE , PLOTP=FALSE, tit="", PICK=FALSE)
  {
    ##  fit a brune model to a windowed trace
    ##  brune.fit( amp, dt, f1=0.01, f2=15, PLOT=FALSE  )

    
   if(missing(dt)) { dt = 1 }
    if(missing(f1))
      {  f1 = 0.01 }
    if(missing(f2))
      { f2 = 14.0 }
    if(missing(PLOTA))
      { PLOTA=FALSE  }
    if(missing(PLOTB))
      { PLOTB=FALSE  }
    if(missing(PLOTP))
      { PLOTP=FALSE  }
 
     if(missing(tit))
      { tit = ""}
    
    ex = seq(0,length(amp)-1)*dt
    if(missing(nw))
      {
        nw = list(x=c(min(ex), max(ex)))
      }

    
        dev.set(2)

    if(PLOTA==TRUE)
      {
        ylab="amp"
        plot(ex, amp, type='l', axes=FALSE, xlab='', ylab=ylab)
        box()
        axis(1)
        axis(3, tck=0.03,lab=FALSE)
        readline("Hit Return")
      }
    
    

    if(missing(PICK))
      {
        PICK=FALSE

      }

   if(PICK==TRUE)
     {
       ylab="amp"
        plot(ex, amp, type='l', axes=FALSE, xlab='', ylab=ylab)
        box()
        axis(1)
        axis(3, tck=0.03,lab=FALSE)
        abline(v=nw$x, col=2)
        title(main=tit)
        nw = locator(type='p', col=2)    
      }

    
    flag1 = ex>=nw$x[1] & ex<=nw$x[2]

    if(PLOTA==TRUE)
      {
        ylab ="AMP"
        plot(ex[flag1], amp[flag1], type='l', axes=FALSE, xlab='', ylab=ylab)
        box()
        axis(1)
        axis(3, tck=0.03,lab=FALSE)
        title(main=tit)
         readline("Hit Return")
      }

    
        xv  = ex[flag1]
        ampv = amp[flag1]
        ampv = ampv-mean(ampv)
        a = list(y=ampv, dt=dt)

    if(length(a$y)<2)
      {
        return(list(WARN=FALSE, corn=0,ave=0,slope=0,interc=0,tstar0=0,omega0=0 ))
      }
   ##  ta = ts(a$y, start=0, deltat=dt)
    len2 = 2*next2(length(ampv))
    if(len2<1024)
      { len2 = 1024 }


       Spec =MTMdisp(a, f1=f1, f2=f2, len2=len2, PLOT=FALSE )
      #   Spec = spec(a, f1=f1, f2=f2, len2=len2, PLOT=FALSE )

    lspec = Spec$displ
      

    print(paste(sep=' ', "brune.fit", length(Spec$f), length( lspec), dt, f1, f2))
    
    xc = get.corner(  Spec$f , lspec, dt, f1, f2, PLOT=FALSE)
    ## print(paste(sep=' ', "BF post", xc$omega0, xc$corn, xc$tstar0))

   fnyq = 1/(2*dt)

   if(xc$corn>fnyq|xc$corn<=0|xc$tstar0<0)
     {
       return(list(WARN=FALSE, corn=0,ave=0,slope=0,interc=0,tstar0=0,omega0=0 ))

     }

   if(is.numeric(xc$omega0)==TRUE & is.numeric(xc$corn)==TRUE  & is.numeric(xc$tstar0)==TRUE )
     {
       
       jmod = brune.search(Spec$f, lspec, f1, f2,  xc$omega0, xc$corn, xc$tstar0, 2.0)
     }
   else
     {
       
      return(list(WARN=FALSE, corn=0,ave=0,slope=0,interc=0,tstar0=0,omega0=0 ))
     }


   if(PLOTB==TRUE)
     {
       par(mfrow=c(1,1))
       flag= Spec$f>=f1 & Spec$f<=f2
       
       print(paste(sep=' ', length(Spec$f[flag]), length( lspec[flag]), dt, f1, f2))
       plot(log10(Spec$f[flag]), log10(lspec[flag]) ,  lty=1 , type='l' , xlab="Log Freq", ylab="Log Amp Spec")
       jbrune = brune.func(Spec$f[flag], jmod$omega0, jmod$tstar0 , jmod$fc,  jmod$alpha, jmod$gamma )
       lines(log10(Spec$f[flag]), log10(jbrune), col=3)
                                        # add.brune(list(y=Spec$f, dt=dt)  ,  xc$tstar0,   xc$corn,   xc$omega0, 4, f1=f1, f2=f2, plog=TRUE)
       abline(h=xc$ave, col=4)
       abline(xc$interc, xc$slope, col=2)
        title(main=tit)
       readline("Hit Return")
       
      }
   if(PLOTP==TRUE)
     {
       par(mfrow=c(1,1))
       flag= Spec$f>=f1 & Spec$f<=f2
       
       print(paste(sep=' ', length(Spec$f[flag]), length( lspec[flag]), dt, f1, f2))
       plot(log10(Spec$f[flag]), log10(lspec[flag]) ,  lty=1 , type='l',  xlab="Log Freq", ylab="Log Amp Spec")
       jbrune = brune.func(Spec$f[flag], jmod$omega0, jmod$tstar0 , jmod$fc,  jmod$alpha, jmod$gamma )
       lines(log10(Spec$f[flag]), log10(jbrune), col=3)
                                        # add.brune(list(y=Spec$f, dt=dt)  ,  xc$tstar0,   xc$corn,   xc$omega0, 4, f1=f1, f2=f2, plog=TRUE)
       abline(h=xc$ave, col=4)
       abline(xc$interc, xc$slope, col=2)
        title(main=tit)

       u = par("usr")
      ### inset with seismogram
       dinx = (u[2]-u[1])
       diny = (u[4]-u[3])
       inx1 = u[1]+0.1*dinx
       inx2 = inx1+0.4*dinx
       iny1 = u[1]+0.2*diny
       iny2 = iny1+0.3*diny
       
       seisglyph(ampv, xv, inx1, inx2, iny1, iny2, lcol=2, border=3, rcol=gray(0.8))
       
       readline("Hit Return")
       
      }

   
           ############            add.brune(a,tstar,fc,Omega0, icol, f1=f1, f2=f2)

 ############ source("/home/lees/Progs/R_stuff/Specfit.R")
 ############ source("/home/lees/Progs/R_stuff/kar.R")

    
   xc$WARN = TRUE;
   xc$tstar0 = jmod$tstar0;
   xc$gamma = jmod$gamma;
   xc$omega0 = jmod$omega0;
   xc$fc = jmod$fc;
   xc$alpha= jmod$alpha
   
    return(xc)

  }
####
####  source("/home/lees/Progs/R_stuff/kar.R")

win.spec<-function(amp, dt, wins=list(x=c(0,1)) )
  {
    ## using a set of different windows on the seismogram,
    ##  calculate and plot the associated spectra and plot on the same log-log graph

    ##  usage:  win.spec(amp, dt)

    f1 = 0.01
    f2 = 10.0
    ex = seq(0,length(amp)-1)*dt
    
    if(missing(wins))
      {
        wins = list( x=range(ex) )

      }
   
    dev.set(2)
    
    plot(ex, amp, type='l', axes=FALSE, xlab='', ylab=ylab)
    box()
    axis(1)
    axis(3, tck=0.03,lab=FALSE)

    nw = locator(type='p', col=2)

    y1 = min(amp);
    y2 = max(amp);

    dy = (y2-y1)/(length(nw$x)-1)
    
   for(i in 2:(length(nw$x)))
      {
        y = y1+(i-2)*dy
        segments(nw$x[1],y,  nw$x[i],y,  col=i-1, lwd=2)
      }

    
    len = length(amp)
    len2 = 2*next2(len)

    JMAT = matrix(nrow=len2/2, ncol = (length(nw$x)-1))
    
    
    for(i in 2:(length(nw$x)))
      {
        flag1 = ex>nw$x[1] & ex<nw$x[i]
        xv  = ex[flag1]
        ampv = amp[flag1]
        ampv = ampv-mean(ampv)
        a = list(y=ampv, dt=info$dt[i])

        
        Spec = spec(a, f1=0.01, f2=10, len2, PLOT=FALSE )
        
       ##    Mspec =   mtapspec(a$y,dt, klen=len2)
        ##   plot(Mspec$freq[2:length(Mspec$freq)], Mspec$spec[2:length(Mspec$freq)], log='yx', type='l')
        
        JMAT[,(i-1)] = Spec$displ[,1]
       ##   JMAT[,(i-1)] = Mspec$spec[2:length(Mspec$freq)]

        
      }


    ##  f = Mspec$freq[2:length(Mspec$freq)]
    flag = Spec$f>=Spec$f1 & Spec$f <= Spec$f2;
    
    flag = Spec$f>=f1 & Spec$f <= f2;
    
    dev.set(dev.next())
    
    matplot(Spec$f[flag], JMAT[flag,], type='l', lty=1, log='y')

  }

####  source("/home/lees/Progs/R_stuff/kar.R")


######################################################
KAR.MOM<-function(BFILES, DIR=".", VEC=VEC,  f1=0.01, f2=15, STA=c("1025"), COMP=4, PICK=FALSE, Pause=0 )
  {
    ##   calculate the source paramters in R
    ##   input
    ##  BFILES = out put of KAR.it or some other
    ##    routine that gives:  list of INFO files in some directory in DIR
    ##   VEC = array of selected indecies of B  (so you do not have to analyze the whole thing?

  ##     KAR.MOM(f98.250 , dir98.250, VEC=c(25), f1=0.01, f2=15, STA=c("1025"), COMP=4, PICK=FALSE)

    if(missing(Pause)) {Pause = 0 ; }

    if(missing(f1))
      {  f1 = 0.01 }
    if(missing(f2))
      { f2 = 14.0 }
         
    if(missing(PICK))
      {
        PICK=FALSE
      }

    
    if(missing(DIR))
      {
        DIR="."
      }

    if(missing(VEC))
      {
        VEC=1:length(BFILES)
      }

    if(missing(STA))
      {
        STA=c("1025")
      }
    if(missing(COMP))
      {
        COMP=4
      }

    
    RET = as.list(VEC)
    BIGN = length(VEC)
    Kount = 0
    for(J in VEC)
      {
        Kount = Kount+1
        j = J
        ifile = BFILES[[j]]$name
        
        d = unlist(strsplit(ifile, "_"))
        dfile = paste(sep="_", d[1], "DATA", d[3])
        
        info = scan(file=paste(sep="/",DIR,ifile), list(name="", yr=0, mo=0, dom=0,
                      hr=0, mn=0, sec=0, msec=0, dt=0, t1=0,
                      t2=0, off=0, n1=0, n2=0, n3=0, n=0))
        ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)     
        nn = length(info$name)
        
        KNOTES = rep(" ", nn)
        STNS = rep(" ", nn)
        COMPS = rep(" ", nn)
        
        for(i in 1:nn)
          {
            g = unlist(strsplit(info$name[i] , split='/' ))
            fnam = g[length(g)] 
            h = unlist(strsplit(fnam, split="\\." ) )
            cnam = paste(sep='.', h[length(h)-1], h[length(h)])
            ##  cnam= the component name
            COMPS[i] = h[length(h)]
            STNS[i] = h[length(h)-1]
            KNOTES[i] = cnam
          }    
        
        dat = matrix(scan(file=paste(sep="/",DIR,dfile)), ncol=nn,  byrow=TRUE)
        p = dim(dat)

        iflg = !is.na(match(STNS, STA))&!is.na(match(COMPS, COMP))

        i = 1:nn
        i = i[iflg]
        
        ex = seq(0,p[1]-1)*info$dt[2]


        if(is.null(BFILES[[j]]$w1) == TRUE)
          {
            print(paste(sep=' ', "skipping trace ", j))
            RET[[Kount]] = list(name=ifile,ftime=ftime, t1=info$t1[i], t2=info$t2[i],
             w1=NULL, fc=NULL, omega=NULL, tstar=NULL, mypoints=NULL )
            
            next;

          }
        windx = BFILES[[j]]$w1
        flag1 = ex>windx$x[1] & ex<windx$x[2]

        par(mfrow=c(2,1))
        
        par(mai=c(0.5, .7, 0.1, 0.5) )
        
        sense = .800
        ylab = "mm/s"                
        
        amp = dat[,i]/sense
        amp = amp-mean(amp)
        
        plot(ex, amp, type='l', axes=FALSE, xlab='', ylab=ylab, col=1)
        box()
        axis(1)
        axis(3, tck=0.03,lab=FALSE)
        
        axis(2)
          
        lines(ex[flag1], amp[flag1], col=2)
        
        xv  = ex[flag1]
        ampv = amp[flag1]
        dt=info$dt[i]
        a = list(y=ampv, dt=dt)

        
        Spec = spec(a, f1=f1, f2=f2)

        BF = brune.fit( amp, dt, nw=windx ,f1=0.01, f2=15, PLOT=FALSE  )
        
        if(PICK==TRUE)
          {
            u = par("usr")
            u10 = par("usr")
            ut = u[3]+(u[4]-u[3])*.05
            u = 10^u10
            
            text(u[1], 10^ut, labels=paste(sep = " ", ftime[i], "number", j, "of",BIGN) , pos=4)
            
            mypoints = locator(3)
            fc = mypoints$x[2]
            Hc = mypoints$y[2]
            
            omega = mypoints$y[1]
                                        # tstar = (log(mypoints$y[3])-log(mypoints$y[2]))/(log(mypoints$x[3])-log(mypoints$x[2]))
                                        #  tstar = ((log(mypoints$y[3]))-(log(mypoints$y[2])))/((mypoints$x[3])-(mypoints$x[2]))
            
                                        # tstar = -1*log(sqrt(2)*Hc/omega )/(pi*fc)
            
                                        #  tstar1 = gettstar(Hc, fc,fc,omega)
            tstar = gettstar(mypoints$y[3], mypoints$x[3], fc , omega)
            
            lines(c(mypoints$x), c(mypoints$y), col=3)
            add.brune(a, tstar , fc, omega, 4, f1=f1, f2=f2)
      }



        add.brune(a, BF$tstar0 , BF$corn, BF$omega0, 2, f1=f1, f2=f2)

        tstar = BF$tstar0
        omega = BF$omega0
        fc = BF$corn
        
        #print(paste(sep=' ',y1,x1,x2,y2,x3))

 

        RET[[Kount]] = list(name=ifile,ftime=ftime, t1=info$t1[i], t2=info$t2[i],
             w1=BFILES[[j]]$w1, fc=fc, omega=omega, tstar=tstar, mypoints=mypoints )


        if(Pause>0) {  Sys.sleep(Pause) }
        
      }
    
    return(RET)
  }

## add.brune(a, km[[1]]$tstar, km[[1]]$fc, km[[1]]$omega, 6, f1=0.01, f2=10)

####  source("/home/lees/Progs/R_stuff/kar.R")

####  B = KAR.it(A)
####  B = KAR.it(A1)
####  LUV = KAR.calc(B)
####  KAR.look(B, dir)
####  KAR.look(B233, dir233)
####   KAR.4plot(FIG3, WIN=p$x)

######################################################
#  SEE.MOM(m, dir233)
#  SEE.MOM(MOM233, dir233)

SEE.MOM<-function(MOM, DIR=".", VEC=VEC)
  {
    if(missing(DIR))
      {
        DIR="."
      }

    if(missing(VEC))
      {
        VEC=1:length(MOM)
      }
    par(mfrow=c(2,1))
    RET = as.list(VEC)
    BIGN = length(VEC)
    Kount = 0
    for(J in VEC)
      {
        Kount = Kount +1 
        j = J
        
        print(paste(sep=' ',j, MOM[[j]]$name, MOM[[j]]$t1, MOM[[j]]$t2,  MOM[[j]]$fc,
              MOM[[j]]$omega, MOM[[j]]$tstar))
        
        ifile = MOM[[j]]$name
        d = unlist(strsplit(ifile, "_"))
        dfile = paste(sep="_", d[1], "DATA", d[3])
        
        info = scan(file=paste(sep="/",DIR,ifile), list(name="", yr=0, mo=0, dom=0,
                      hr=0, mn=0, sec=0, msec=0, dt=0, t1=0,
                      t2=0, off=0, n1=0, n2=0, n3=0, n=0))
        
        ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)     
        nn = length(info$name)
        
        dat = matrix(scan(file=paste(sep="/",DIR,dfile)), ncol=nn,  byrow=TRUE)
        p = dim(dat)
        i = 2
        
        ex = seq(0,p[1]-1)*info$dt[2]
        
        windx = MOM[[j]]$w1
        flag1 = ex>windx$x[1] & ex<windx$x[2]
        
        par(mai=c(0.5, .7, 0.1, 0.5) )
        
        sense = .800
        ylab = "mm/s"                
        
        amp = dat[,i]/sense
        amp = amp-mean(amp)
        
        plot(ex, amp, type='l', axes=FALSE, xlab='', ylab=ylab)
        box()
        axis(1)
        axis(3, tck=0.03,lab=FALSE)
        
        axis(2)
          
        lines(ex[flag1], amp[flag1], col=2)
        
        xv  = ex[flag1]
        ampv = amp[flag1]
        
        a = list(y=ampv, dt=info$dt[i])
        Spec = spec(a)
        
       
        
        # text(u[1], u[3]+(u[4]-u[3])*.05, labels=paste(sep = " ", ftime[i], "number", j, "of",BIGN) , pos=4)
        u10 = par("usr")
        ut = u[3]+(u[4]-u[3])*.05
        u = 10^u10
        
        text(u[1], 10^ut, labels=paste(sep = " ", j, ftime[i], "number", Kount, "of",BIGN) , pos=4)
        
         add.brune(a, MOM[[j]]$tstar , MOM[[j]]$fc, MOM[[j]]$omega, 4, f1=0.01, f2=10)

    
       locator(1)
        
      }
  }

### SEE.MOM(MOM233, dir233, VEC=bads)

###  source("/home/lees/Progs/R_stuff/kar.R")

KAR.shiftpick<-function(IN, dir)
  {
    
    ## cyckle through a set of picks and
    ## zoom and shift according tot he picks on the zoom
    for(j in 1:length(IN))
      {
                                        # readline()
        inp=IN[[j]]
        inp$dir=dir 
        KD = KAR.Gdat(inp$name, inp$dir)
        
        ## this is only true for 1999 data at krm9
        iflip = match("krm9.1", KD$KNOTES)
        KD$JMAT[,iflip] = -KD$JMAT[,iflip]
        
                                        #  PLOT.MATN(KD$JMAT[,KD$ok], dt=KD$dt, notes=KD$KNOTES[KD$ok], COL=KD$pcol[KD$ok])
                                        #  PLOT.MATN(KD$JMAT, dt=KD$dt, notes=KD$KNOTES, COL=KD$pcol)

        jj= match(  paste(sep='.', KD$USTA, 1), KD$KNOTES )
        
        PLOT.MATN(KD$JMAT[,jj], dt=KD$dt, notes=KD$KNOTES[jj], COL=KD$pcol[jj])
        u = par("usr")
        jd = jday(KD$info$yr[1], KD$info$mo[1], KD$info$dom[1])
        rd = recdate(jd, KD$info$hr[1], KD$info$mn[1], ( KD$info$sec[1]+KD$info$msec[1]/1000+KD$info$t1[1]-KD$info$off[1]) )
        ## IT = ISOdatetime(KD$info$yr[1], KD$info$mo[1], KD$info$dom[1], rd$hour, rd$min, rd$sec, tz = "")

        xt = paste(  paste(sep="/",KD$info$dom[1], KD$info$mo[1], KD$info$yr[1]-1900  ), paste(sep=":", rd$hour, rd$min, floor(rd$sec)) )
        po1 = paste(sep=".", KD$info$yr[1], KD$info$mo[1], KD$info$dom[1],  rd$hour, rd$min, floor(rd$sec))
        
        msec = floor((rd$sec-floor(rd$sec))*1000)
        xt2 = paste(  paste(sep="/",KD$info$yr[1], KD$info$mo[1],  KD$info$dom[1]  ), jd, paste(sep=":", rd$hour, rd$min, floor(rd$sec), msec) )
        
        
        title(main=paste(sep=' ', inp$dir, inp$name, j, 'of', length( K99P251.026)))
        
        ## 
        text(u[1], (0+u[3])/2, labels=xt2, adj=0)
        
        
        apix = plocator()
        if(length(apix$x)>=2)
          {
            w = apix$x[(length(apix$x)-1):length(apix$x)]
            
            PLOT.MATN(KD$JMAT[,jj], WIN=w, dt=KD$dt, notes=KD$KNOTES[jj], COL=KD$pcol[jj])
            
            
            pix = plocator(YN=length(jj), style=2)
            if(length(pix$x)<1) { next; }
            roy = 1+round((pix$x-min(pix$x))/KD$dt)
            
            k = length(jj)-floor((pix$y)*length(jj))
            
            print(paste(sep=' ', pix$x, k))
            KD$KNOTES[jj[k]]
            
            nmat = KD$JMAT[,jj[k]]
            
            NK = length(KD$JMAT[,1])
            
            for(m in 1:length(k))
              {
                if(roy[m]>1)
                  {
                    tem = c(KD$JMAT[roy[m]:NK,jj[k[m]]], rep(NA, (roy[m]-1) ) )
                  }
                else
                  {
                    tem= KD$JMAT[,jj[k[m]]]
                  }
                nmat[,m] = tem
              }
            
            PLOT.MATN(nmat, dt=KD$dt, WIN=w, notes=KD$KNOTES[jj[k]], COL=KD$pcol[jj[k]])
            title(main=paste(sep=' ', inp$dir, inp$name, j, 'of', length(K99P251.026)))
            u =par("usr")
            ## 
            text(u[1], (0+u[3])/2, labels=xt2, adj=0)
            locator()
            postscript(file=paste(sep="", po1, ".infra.ps"),onefile=TRUE,print.it=FALSE)
            PLOT.MATN(nmat, dt=KD$dt, WIN=w, notes=KD$KNOTES[jj[k]], COL=KD$pcol[jj[k]])
            title(main=paste(sep=' ', inp$dir, inp$name, j, 'of', length(K99P251.026)))
            u =par("usr")
            ## 
            text(u[1], (0+u[3])/2, labels=xt2, adj=0)
            dev.off()
            
            
          }

      }

  }
############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")

plot.karmap<-function()
{
  PROJmap(karmap, ADD=FALSE, ASP=TRUE, COL=FALSE)
  image(J, col=cmap , add=TRUE)
  PROJmap(karmap, ADD=TRUE, ASP=TRUE, COL=FALSE)
  AXESmap( karmap, GRID=TRUE,  WIN=MLOC)
  box()
  points(karsta$XY$x, karsta$XY$y, pch=6, col=karsta$COL)

  text(karsta$XY$x, karsta$XY$y, labels=karsta$name, pos=4, col=karsta$COL)

  KMscale( kmL='', len=2, units="km")

}
############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")

KAR.settit<-function(KD)
{

  jd = jday(KD$info$yr[1], KD$info$mo[1], KD$info$dom[1])
  rd = recdate(jd, KD$info$hr[1], KD$info$mn[1], ( KD$info$sec[1]+KD$info$msec[1]/1000+KD$info$t1[1]-KD$info$off[1]) )
  xt = paste(  paste(sep="/",KD$info$dom[1], KD$info$mo[1], KD$info$yr[1]-1900  ), paste(sep=":", rd$hour, rd$min, floor(rd$sec)) )
  po1 = paste(sep=".", KD$info$yr[1], KD$info$mo[1], KD$info$dom[1],  rd$hour, rd$min, floor(rd$sec), "ps")
  msec = floor((rd$sec-floor(rd$sec))*1000)
  xt2 = paste(  paste(sep="/",KD$info$yr[1], KD$info$mo[1],  KD$info$dom[1]  ), jd, paste(sep=":", rd$hour, rd$min, floor(rd$sec), msec) )
  main = paste(sep=' ', KD$dir, KD$ifile)
  
  return(list(main=main, xt=xt2, fn=po1))

}

############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")
GET.CHUGS<-function(NH, sel)
{
####  measure the times between chugs on an acoustic
####  microphone
###  user suplies initial picks, prog finds the maxima near the pick

  info = NH$info

  
  atime = paste(sep=":", info$yr[sel],info$mo[sel],info$dom[sel],info$hr[sel],info$mn[sel],info$sec[sel],info$msec[sel],info$t1[sel], info$off[sel])     
  
  jd = jday(info$yr[1],info$mo[1],info$dom[1])
  wintim = jd + info$hr[sel]/24+ info$mn[sel]/(24*60)+(info$sec[sel]+info$msec[sel]+info$t1[sel]-info$off[sel])/(24*3600)
  par(mfrow=c(1,1))

#### NH  = CUT.SEISN(NH, sel)
  a = ZOOM.SEISN(NH, sel)


  rd = recdate(info$jd[sel], info$hr[sel], info$mn[sel], info$sec[sel]+info$msec[sel]/1000+info$t1[sel]-info$off[sel]+a$x[1])
  sec = floor(rd$sec)
  msec = 1000*(rd$sec-sec)
  t1 =   (msec-floor(msec))/1000
  msec = floor(msec)

  ftime = paste(sep=":", info$yr[sel], rd$jday, rd$hour, rd$min, sec, msec)

  
  title(sub="NOW Click near peaks to determine chugs", cex.sub = 2, font.sub = 4, col.sub = "red")

  pks = plocator(COL=rgb(0.8, 0.8, 1), NUM = TRUE, YN = 1, style = 1)
  if(length(pks$x)<2)
    {
      print("NO PICKS")
      return(0)
    }
  amp =  NH$JSTR[[sel]]
  dt = NH$dt[sel]
  x = pks$x
  nx = round(pks$x/dt)
  As1 = rep(0, length(nx))
  As2 = rep(0, length(nx))	
  As3 = rep(0, length(nx))	
  wlen = 15

  for(i in 1:length(nx) )
    {
      tem = amp[(nx[i]-wlen):(nx[i]+wlen)]
      k = which.max(tem)
      m = nx[i]-wlen+k-1
      As1[i] = m
      As2[i] = m*dt
      As3[i] = amp[m]
    }

  fn=NH$info$fn[sel]
  ifile = unlist(strsplit(fn, "/"))
  ifile = ifile[length(ifile)]
  o = order(As2)
  d1 = As2[o]
  d2 = As3[o]
  das2 = diff(d1)
  
  chugs = list(fn=NH$info$fn[sel], ifile=ifile, ftime=ftime, atime=atime, wintim=wintim, WIN=a$x, dt=NH$dt[sel], pks=pks, tims=d1, amp=d2)
  
  PLOT.CHUGS(NH, sel, chugs)
  return(chugs)
}
############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")
###################
AUTO.CHUG<-function(NH, sel, xpix)
  {

    info = NH$info
    atime = paste(sep=":", info$yr[sel],info$mo[sel],info$dom[sel],info$hr[sel],info$mn[sel],info$sec[sel],info$msec[sel],info$t1[sel], info$off[sel])     
    jd = jday(info$yr[1],info$mo[1],info$dom[1])
    wintim = jd + info$hr[sel]/24+ info$mn[sel]/(24*60)+(info$sec[sel]+info$msec[sel]+info$t1[sel]-info$off[sel])/(24*3600)
    rd = recdate(info$jd[sel], info$hr[sel], info$mn[sel], info$sec[sel]+info$msec[sel]/1000+info$t1[sel]-info$off[sel]+xpix[1])
    sec = floor(rd$sec)
    msec = 1000*(rd$sec-sec)
    t1 =   (msec-floor(msec))/1000
    msec = floor(msec)
    
    ftime = paste(sep=":", info$yr[sel], rd$jday, rd$hour, rd$min, sec, msec)
    amp =  NH$JSTR[[sel]]
    dt = NH$dt[sel]
    x = xpix
    nx = round(xpix/dt)
    As1 = rep(0, length(nx))
    As2 = rep(0, length(nx))	
    As3 = rep(0, length(nx))	
    wlen = 15
    
    for(i in 1:length(nx) )
      {
        tem = amp[(nx[i]-wlen):(nx[i]+wlen)]
        k = which.max(tem)
        m = nx[i]-wlen+k-1
        As1[i] = m
        As2[i] = m*dt
        As3[i] = amp[m]
      }

    fn=NH$info$fn[sel]
    ifile = unlist(strsplit(fn, "/"))
    ifile = ifile[length(ifile)]
    o = order(As2)
    d1 = As2[o]
    d2 = As3[o]
    das2 = diff(d1)

    win =  c(d1[1]-2, d1[ length(d1)]+2)
    
    chugs = list(fn=NH$info$fn[sel], ifile=ifile, ftime=ftime, atime=atime, wintim=wintim, WIN=win, dt=NH$dt[sel], pks=xpix, tims=d1, amp=d2)
    return(chugs)
  }
##############################################
############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")
FILES.CHUGS<-function(chugfile , DBfile)
  {
    ### set up the windows and Database for the chugging events
     chuggen = readwpix(chugfile)
    
    chuggen$t1 = chuggen$jday+chuggen$hr/24+chuggen$min/(24*60)+chuggen$sec/(24*3600)
     chuggen$t2 = chuggen$t1 + chuggen$slen/(24*3600)
    
     ftimes = DBfile
    
     GENDB  = scan(file=ftimes, list(fn='', yr=0, jday=0,hr=0, min=0, sec=0, slen=0))
     GENDB$t1  = GENDB$jday+GENDB$hr/24+GENDB$min/(24*60)+GENDB$sec/(24*3600)
     GENDB$t2  = GENDB$t1 + GENDB$slen/(24*3600)

     return(list(chuggen=chuggen, GENDB=GENDB) )
  }
##############################################
############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")

PREP.CHUGS<-function(chuggen, GENDB, NSEL=1:length(chuggen$t1))
  {
###########  given a set of windows and a Database,
###########   get the picks and chugging picsk
    ## chug233 = readwpix("/home/lees/Site/Karymsky/CHUG_1997_233.wpix")    
    ## chug233$t1 = chug233$jday+chug233$hr/24+chug233$min/(24*60)+chug233$sec/(24*3600)
    ## chug233$t2 = chug233$t1 + chug233$slen/(24*3600)
    ## ftimes = "/home/beer/lees/KARYMSKY/Kar97PC/DB.kar97.times"
    ## k97DB  = scan(file=ftimes, list(fn='', yr=0, jday=0,hr=0, min=0, sec=0, slen=0))
    ## k97DB$t1  = k97DB$jday+k97DB$hr/24+k97DB$min/(24*60)+k97DB$sec/(24*3600)
    ## k97DB$t2  = k97DB$t1 + k97DB$slen/(24*3600)

    if(missing(NSEL))
      {
        NSEL = 1:length(chuggen$t1)
        chugpix = list(1:length(NSEL))
      }
    else
      {
        
        chugpix = list(1:length(NSEL))
        
      }

    ofile = local.file("CHUGPIX.TEMP")
  
    for(j in 1:length(NSEL))
      {
        i = NSEL[j]
        f1 = chuggen$t1[i]>GENDB$t1&chuggen$t1[i]<GENDB$t2
        f2 = chuggen$t2[i]>GENDB$t1&chuggen$t2[i]<GENDB$t2
        
        getem = unique(c(GENDB$fn[f1],  GENDB$fn[f2]))
        
        GG = GET.seis(getem, kind=1, PLOT=FALSE)
        ## fill a structre with data from segy format
        
        ## reorganize the data
        GH=prepGG3(GG)
        
        sel = 1:length(GH$JSTR)
        
        dot = which(duplicated(GH$KNOTES))
        
        if(length(dot)>=1)
          {
            GJ = GLUEseisSTR(GH)
            GH$JSTR = GJ$JSTR
            sel = sel[is.na(match(sel, GJ$dpl))]
            
          }
        
####  sel=c(1,2,3,4)
####  YN = PLOT.SEISN(GH, WIN=NULL, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
        
        
        win = 24*3600*c(chuggen$t1[i]-(GH$info$jd[1]+GH$info$hr[1]/24+GH$info$mn[1]/(24*60)+GH$info$sec[1]/(24*3600)),
          chuggen$t2[i]-(GH$info$jd[1]+GH$info$hr[1]/24+GH$info$mn[1]/(24*60)+GH$info$sec[1]/(24*3600)))
        
#### YN = PLOT.SEISN(GH, WIN=win, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
        a = PICK.CHUGZ(GH, sel , WIN=win)

        numtrace = sel[a$panels$nx[1]  ]
        chugs = NA
        if(length(a$xpix)>1)
          {
            
            chugs = AUTO.CHUG(GH, numtrace , a$xpix)
          }
        chugpix[[j]] = list(a=a, chugs=chugs)
        save(chugpix, file=ofile, ascii=TRUE)
####  locator()
      }
    
    return(chugpix)
    

  }
##############################################
############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")

PLOT.CHUGS<-function(NH, sel=1, chugs, CATS=NULL, shapes=shapes, REG=FALSE)
{
  if(missing(CATS)) { CATS=NULL }
  if(missing(shapes)) { shapes=NULL }
  if(missing(sel)) { sel=1 }
   if(missing(REG)) { REG=FALSE }
    


  As2=chugs$tims

  d1=chugs$tims
  d2=chugs$amp
  ifile=chugs$ifile
  ftime=chugs$ftime
  a = chugs$WIN
  pcols = rep(0,length(d1))

  if(!is.null(CATS))
    {
      
      for(i in 1:(length(CATS$x)-1))
        {
          t1 = CATS$x[i]
          t2 = CATS$x[i+1]
          flg = d1>t1&d1<=t2
          pcols[flg] = i
        }
      
  }
  
  
  

  upar = par(no.readonly = TRUE)

  nf <- layout(matrix(c(1,2),2,1,byrow=TRUE), heights=c(1,2), TRUE)
####  layout.show(nf)
  mai = upar$mai
  mai[1] = 0.5
  mai[3] = 0.1

  par(mai=mai )

  YN = PLOT.SEISN(NH, WIN=a, dt=NH$dt, sel=sel , notes=NH$KNOTES[sel], add=1)

####  YN = PLOT.SEISN(NH, WIN=a, dt=NH$dt, sel=sel , notes=NH$KNOTES[sel], pts=TRUE)

  abline(v=As2, col=rgb(0.8, 0.8, 1.0))
  YN = PLOT.SEISN(NH, WIN=a, dt=NH$dt, sel=sel , notes=NH$KNOTES[sel], add=3)

  if(!is.null(shapes))
    {
      ### shapes is a matrix with picking and shape information
      

    }

  if(!is.null(CATS))
    {
       points(As2, rep(1,length(As2))  ,pch=pcols , col=pcols)    
    }
  
  u1 = par("usr")
  text(u1[1],0, labels=ftime,adj=c(0,0) )

  das2 = diff(d1)
  ax = das2
  ay = d2[1:length(das2)]

  bb = boxplot(das2, plot=FALSE)

  flag =  das2<(bb$stats[5,1]+(bb$stats[5,1]-bb$stats[4,1]))
  

###  flag = (ax-mean(ax))<2*sqrt(var(das2))

  tx = ax[flag]
  why = ay[flag]
  
  labs = 1:length(das2)

  par(mai=upar$mai )
  plot(tx, why, xlab="Interval Time, s", ylab="Amplitude", type='n')

  u2 = par("usr")

  text(tx, why,labels=labs[flag], pos=3, col=rgb(1.0, 0.8, 0.8))

  if(!is.null(CATS))
    {
      
      points(tx, why ,pch=pcols , col=pcols)
    }
  else
    {
      points(tx, why ,pch=3 , col=4)

    }



  title(main=ifile)
  par(upar)

  invisible(list(x=d1, y=d2, itime=das2, amp=d2[1:length(das2)], tx=tx, why=why ))

  
}
###################
###  source("/home/lees/Progs/R_stuff/kar.R")

PLOT.CHUGZ<-function(ACHUG,  sel=1, CATS=NULL, shapes=shapes, REG=FALSE)
{
  if(missing(CATS)) { CATS=NULL }
  if(missing(shapes)) { shapes=NULL }
  if(missing(sel)) { sel=1 }
  if(missing(REG)) { REG=FALSE }
  
  chugs = ACHUG$chugs
  fnames = chugs$fn
  chugtmin = min(chugs$tims)
  chugtmax = max(chugs$tims)
  NH = GET.Kseis(fnames, kind=1, PLOT=FALSE, TWIN=c(chugtmin, chugtmax) )  

  
  As2=chugs$tims

  d1=chugs$tims
  d2=chugs$amp
  ifile=chugs$ifile
  ftime=chugs$ftime
  a = chugs$WIN
  pcols = rep(1,length(d1))

  if(!is.null(CATS))
    {
      
      for(i in 1:(length(CATS$x)-1))
        {
          t1 = CATS$x[i]
          t2 = CATS$x[i+1]
          flg = d1>t1&d1<=t2
          pcols[flg] = i
        }
      
    }

  upar = par(no.readonly = TRUE)

  nf <- layout(matrix(c(1,2),2,1,byrow=TRUE), heights=c(1,2), TRUE)
####  layout.show(nf)
  mai = upar$mai
  mai[1] = 0.5
  mai[3] = 0.1

  par(mai=mai )

  YN = PLOT.SEISN(NH, WIN=a, dt=NH$dt, sel=sel , notes=NH$KNOTES[sel], add=1)

####  YN = PLOT.SEISN(NH, WIN=a, dt=NH$dt, sel=sel , notes=NH$KNOTES[sel], pts=TRUE)

  abline(v=As2, col=rgb(0.8, 0.8, 1.0))
  YN = PLOT.SEISN(NH, WIN=a, dt=NH$dt, sel=sel , notes=NH$KNOTES[sel], add=3)

  if(!is.null(shapes))
    {
### shapes is a matrix with picking and shape information
      

    }

  if(!is.null(CATS))
    {
      points(As2, rep(1,length(As2))  ,pch=17 , col=pcols)    
    }
  
  u1 = par("usr")
  text(u1[1],0, labels=ftime,adj=c(0,0) )

  das2 = diff(d1)
  ax = das2
  ay = d2[1:length(das2)]

  bb = boxplot(das2, plot=FALSE)

  flag =  das2<(bb$stats[5,1]+(bb$stats[5,1]-bb$stats[4,1]))
  w1 = which(flag==FALSE)
  
  k1 = length(w1)+1
  ###  cols =  rep(1, length(das2))
  cols =  pcols[1:length(das2)]

  if(length(w1)>1)
    {
      vec = c(1, w1, length(das2))
      
####  this section is used to color code chugging sequences that are broken up
####   by large gaps in arrival times
      
      for(m in 1:(length(vec)-1))
        {
          cols[vec[m]:vec[m+1] ] =m
          
        }
    }


###  flag = (ax-mean(ax))<2*sqrt(var(das2))

  tx = ax[flag]
  why = ay[flag]
  
  labs = 1:length(das2)

  par(mai=upar$mai )

  u2 = par("usr")


  CHERR = ACHUG$CHERR

  if(is.null(CHERR))
    {

      e1 = rep(ACHUG$chugs$dt/3, length(das2))
      e2 = rep( diff(range(ACHUG$amp))/0.05 , length(das2))

    }
  else
    {
      
      e1 = CHERR[1:length(das2),1]+ACHUG$chugs$dt/3
      e2 = CHERR[1:length(das2),2]
    }
  
  w1 = 1/(e1)
  w1 = w1/sum(w1)
  
  w2 = 1/(e2)
  w2 = w2/sum(w2)

  WTS = w1 + w2 

  EX = das2[flag]
  WHY  = ay[flag]
  COLS = cols[flag]
  E1 = e1[flag]
  E2 = e2[flag]
  W = WTS[flag]

### check if WTS exist and are not NA
###  else do not

  if(length(which(is.na(W)))==length(W)  )
    {

      W = rep(1,length(W))
    }

  W[is.na(W) ] = min(W[!is.na(W)])

  
  if(length(which(is.na(W)))>1  )
    {
###  last resort
      W = rep(1,length(W))
    }
  
  UCOL = unique(COLS)

  
 ### print(UCOL)

 ### print(COLS)


  
### plot(das2[flag], ay[flag], type='n')
 ### print(flag)
 ### print(cols[flag])
 ### print(pcols)
  
 ### segments(das2[flag]-e1[flag],ay[flag],  das2[flag]+e1[flag], ay[flag] , col=cols[flag])
 ###  segments(das2[flag],ay[flag]-e2[flag],  das2[flag], ay[flag]+e2[flag] , col=cols[flag])

  plot(EX, WHY, xlab="Interval Time, s", ylab="Amplitude", type='n')

  text(EX, WHY,labels=labs[flag], pos=3, col=4)

  if(!is.null(CATS))
    {
      
      points(EX, WHY ,pch=1 , col=pcols)
    }
  else
    {
      points(EX, WHY ,pch=1 , col=4)

    }

   segments(EX-E1,WHY,  EX+E1, WHY , col=COLS)
   segments(EX,WHY-E2,  EX, WHY+E2 , col=COLS)

      GLMS = LINE.CHUGZ(EX, WHY, W, UCOL, COLS)


###   title(main=ifile)
  par(upar)

  invisible(list(x=d1, y=d2, itime=das2, amp=d2[1:length(das2)], tx=tx, why=why, EX=EX, E1=E1, WHY=WHY, E2=E2, W=W, UCOL=UCOL, COLS=COLS, GLMS=GLMS, WIN=chugs$WIN ))

  
}





############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")
########
########
SHAPE.CHUGS<-function(chugs, GH, sel=sel)
  {
########
########  go through a set of chugs and store information
########  ls(pat='san')
    
###   SHAPE.CHUGS(san.chug.006)

    
###   san.chug.005$Asig=SHAPE.CHUGS(san.chug.005)
      if(missing(sel)) {sel=c(1)}
    
    fnames = chugs$fn

    As2=chugs$tims
    d1=As2
    d2=chugs$amp
    ifile=chugs$ifile
    ftime=chugs$ftime
    a = chugs$WIN

    PLOT.CHUGS(GH, sel, chugs)

    
    
    print("To Continue: Right click in window")
    locator()
    one()
    a = range(chugs$tims)
    a[1] = a[1]-1.5
    a[2] = a[2]+1.5
    
    YN = PLOT.SEISN(GH, WIN=a, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel], add=1)

###   this code is for setting up a color scheme for the picks
    
###       print("To Continue: Right click in window")
    
###       jcats = plocator(COL=2, NUM=TRUE)
###       pcols = rep(0,length(d1))
###   if(length(jcats$x) >=2)
###    {
###      for(i in 1:(length(jcats$x)-1))
###        {
###           t1 = jcats$x[i]
###           t2 = jcats$x[i+1]
###           flg = d1>t1&d1<=t2
###          pcols[flg] = i
###        }
###      }

###       YN = PLOT.SEISN(GH, WIN=a, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel], add=1)

    
    abline(v=As2, col=rgb(0.8, 0.8, 1.0))
    print("PICK the WINDOW")
    b = plocator()

    if(length(b$x)<2)
      {
        b = list(x=a)
      }
    
    YN = PLOT.SEISN(GH, WIN=b, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel], add=2)
    abline(v=As2, col=rgb(0.8, 0.8, 1.0)) 
    YN = PLOT.SEISN(GH, WIN=b, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel], add=3)
    print("To Continue: Right click in window")
    locator()
    
    amp = GH$JSTR[[sel]]
    ex = GH$dt[sel]*seq(0, length(amp)-1)

    amp = amp[ex>=b$x[1]&ex<=b$x[2] ]
    ex = GH$dt[sel]*seq(0, length(amp)-1)
    dt = GH$dt[sel]
    amp = amp-mean(amp)
    plot(ex, amp, type='l')
    abline(h=0, lty=2, col=gray(0.8))

    abline(v=As2-b$x[1], col=rgb(0.8, 0.8, 1.0))

    wlen = 15

    abline(v=As2-b$x[1]-wlen*dt, col=rgb(1.0,0.8,0.8))
    abline(v=As2-b$x[1]+wlen*dt, col=rgb(0.8,1,0.8))
    print("To Continue: Right click in window")
    locator()
    
    AL  = As2-b$x[1]
    AL  = AL[AL>min(ex)&AL<max(ex)]
    dAL = diff(AL)

      win1 = c(dAL[1], dAL)
      win2 = c(dAL, dAL[length(dAL)])

      AWIN = apply( cbind( win1, win2), 1, min )

      


    plot(ex, amp, type='l')

    low = AL-AWIN*.75
    hi =  AL+AWIN*.75

    abline(v=AL, col=rgb(0.8, 0.8, 1.0))
    abline(v=low, col=rgb(1.0,0.8,0.8))
    abline(v=hi, col=rgb(0.8,1,0.8))
    print("To Continue: Right click in window")   
    locator()
    print("Starting analysis")   

    result = matrix(ncol=10, nrow=length(AL))

    for(i in 1:(length(AL)))
      {
        t1 = low[i]
        t2 = hi[i]
        q = amp[ex>=t1&ex<=t2]
        r = ex[ex>=t1&ex<=t2]

        ys = ksmooth(r, q, "normal", bandwidth=(4*dt) )

        ###   lines(ys$x, ys$y, type='b', col=2)
       
        result[i,] = chug.pulse(ys$x,ys$y, dt)
        title(main=paste(sep=' ', i,'of',length(AL)))
        locator()
        ####  result[i,] =c(Ex[1], Ex[2], Ey[1], Ey[2], Cx, Cy, ar2, s2, s3, sum0)   
      }

    colnames(result) = c("X1","X2", "Y1", "Y2", "C1", "C2", "area", "S2", "S3", "S0")
    
    return(result)
    
  }
############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")


############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")
chugshaper<-function(DeChug, SEL=1:length(DeChug))
{
  
  if(missing(SEL)) {   SEL=1:length(DeChug) }

  Get.Screens(2)
  ofile = local.file("SHAPE.CHUG")
  
  for(i in SEL)
    {
      print(paste(sep=' ', "chugshaper: working on ", i, " of ", length(SEL)))
      LACHUG = DeChug[[i]]
      
      if(length(LACHUG$chugs$tims)>0)
        {

          otime = as.numeric(unlist(strsplit(LACHUG$chugs$atime, ":")))
          offset = otime[length(otime)]
          LACHUG$chugs$tims = LACHUG$chugs$tims-offset
          
          if(is.na(LACHUG$chugs$fn)) { next; }

          
          GG = GET.seis(LACHUG$chugs$fn, kind=1, PLOT=FALSE)
          GH=prepGG3(GG)
          LACHUG$chugs$WIN = c(LACHUG$chugs$tims[1]-2, LACHUG$chugs$tims[length(LACHUG$chugs$tims)]+2)
          ## this is the time of the beginning of the trace
          t1 = GH$info$jd+ GH$info$hr/24+    GH$info$mn/(24*60) + (GH$info$sec + GH$info$msec/1000)/(24*3600)
          t2 =  t1+(GH$dt[1]*length(GH$JSTR[[1]]))/(24*3600)
      
          pickwin = GH$wintim + LACHUG$chugs$WIN/(24*3600)
          ## test to see if the chugging window fits on the trace window
          
          if(  !(pickwin[1]>t1&pickwin[1]<t2&pickwin[2]>t1&pickwin[2]<t2)  )
            {
              fn = LACHUG$chugs$fn
              f1 = pickwin[1]>GENDB$t1&pickwin[1]<GENDB$t2
              
              f2 = pickwin[2]>GENDB$t1&pickwin[2]<GENDB$t2
              
              fils = GENDB$fn[ f1|f2 ]
              nams = parseFN2STA(fn)
              gns = grep( paste(sep='.', nams$sta, nams$comp), fils)
              GG = GET.seis(fils[gns] , kind=1, PLOT=FALSE)
              GH=prepGG3(GG)
              GJ = GLUEseisSTR(GH)
              GH$JSTR = GJ$JSTR
              
            }

          
          dev.set(2)
          b = PLOT.CHUGS(GH, 1, LACHUG$chugs)
          locator()
          dev.set(3)
          shapechug  =  SHAPE.CHUGS(LACHUG$chugs, GH)


          das2 = b$itime
          amp = b$amp
 

          bb = boxplot(das2, plot=FALSE)

          kount = 1:length(das2)
          flag =  das2>bb$stats[1,1]&das2<bb$stats[5,1]
  

###  flag = (ax-mean(ax))<2*sqrt(var(das2))

        

          par(mfrow=c(2,2))
          plot(das2[flag], amp[flag], xlab="Interval Time", ylab="Amplitude")
          plot(das2[flag], shapechug[  kount[flag],7], xlab="Interval Time", ylab="area of triangle")  
          plot(das2[flag], shapechug[  kount[flag],8], xlab="Interval Time", ylab="DefInt[1]")  
          plot(das2[flag], shapechug[  kount[flag] ,10], xlab="Interval Time", ylab="RMS")  
          title(main="Chugging", outer=TRUE)
          locator()
          LACHUG$shapechug = shapechug

          DeChug[[i]]=LACHUG
          save(DeChug, file=ofile, ascii=TRUE)
        }
      else
        {
          print("No Chug Picks")
        }

    }
  invisible(DeChug)
}
############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")
SHOW.CHUGZ<-function(KCHUG, PLOT=FALSE)
  {
    if(missing(PLOT)) { PLOT = FALSE }
    Get.Screens(2)
    BIGN = length(KCHUG)
  for(i in 1:length(KCHUG))
    {
     ###  if(is.na(KCHUG[[i]]$chugs) == TRUE) { next }
      
      print(paste(sep=' ', "SHOW.CHUGZ", i, length(KCHUG[[i]]$chugs$tims), is.matrix(KCHUG[[i]]$shapechug)))
      if(is.matrix(KCHUG[[i]]$shapechug)==TRUE)
	{
	  shapechug = KCHUG[[i]]$shapechug

	  d1 = shapechug[,5]
	  das2 = diff(d1)
          amp =  shapechug[1:length(das2),6]
 
	  bb = boxplot(das2, plot=FALSE)

          kount = 1:length(das2)
 
	  ##	  flag = rep(TRUE, length(kount))

          ##

	  flag =  das2<(bb$stats[5,1]+(bb$stats[5,1]-bb$stats[4,1]))
          w1 = which(flag==FALSE)
          
          k1 = length(w1)+1
          cols =  rep(1, length(das2)) 
          vec = c(1, w1, length(das2))
          
          for(m in 1:(length(vec)-1))
            {
              cols[vec[m]:vec[m+1] ] =m

            }
          

          dev.set(2)
          one()
          REPLOT.CHUGS(KCHUG[[i]]$chugs)
          print(paste(sep=' ', "SHOW.CHUGZ: working on ",i, "of", BIGN))

          if( is.null(KCHUG[[i]]$CHERR) )
            {
              
              CHERR = chug.err(KCHUG, i, PLOT=PLOT)
              KCHUG[[i]]$CHERR = CHERR 
            }
          else
            {
              
              CHERR = KCHUG[[i]]$CHERR
            }

          e1 = CHERR[1:length(das2),1]+KCHUG[[i]]$chugs$dt/3
          e2 = CHERR[1:length(das2),2]
          w1 = 1/(e1)
          w1 = w1/sum(w1)
          
          w2 = 1/(e2)
          w2 = w2/sum(w2)

          WTS = w1 + w2 

            
          dev.set(3)
	  par(mfrow=c(2,2))

          EX = das2[flag]
          WHY  = amp[flag]
          COLS = cols[flag]
          W = WTS[flag]

          ### check if WTS exist and are not NA
          ###  else do not

          if(length(which(is.na(W)))==length(W)  )
            {

              W = rep(1,length(W))
            }

          W[is.na(W) ] = min(W[!is.na(W)])

          
          if(length(which(is.na(W)))>1  )
            {
              ###  last resort
              W = rep(1,length(W))
            }
          
          UCOL = unique(COLS)
          
          plot(das2[flag], amp[flag], xlab="Interval Time", ylab="Amplitude", col=cols[flag])
	  text(das2[flag], amp[flag], labels=kount[flag], pos=1, col=rgb(0.1, 0.5, 0.1) )

          segments(das2[flag]-e1[flag],amp[flag],  das2[flag]+e1[flag], amp[flag] , col=cols[flag])
          segments(das2[flag],amp[flag]-e2[flag],  das2[flag], amp[flag]+e2[flag] , col=cols[flag])

          GLMS = LINE.CHUGZ(EX, WHY, W, UCOL, COLS)
          KCHUG[[i]]$GLMS = GLMS
          plot(das2[flag], shapechug[  kount[flag],7], xlab="Interval Time", ylab="area of triangle", col=cols[flag])
          WHY = shapechug[  kount[flag],7]
          LINE.CHUGZ(EX, WHY , W, UCOL, COLS)
          plot(das2[flag], shapechug[  kount[flag],8], xlab="Interval Time", ylab="DefInt[1]", col=cols[flag])
          WHY =shapechug[  kount[flag],8]
          LINE.CHUGZ(EX, WHY , W, UCOL, COLS)
          plot(das2[flag], shapechug[  kount[flag] ,10], xlab="Interval Time", ylab="RMS", col=cols[flag])
          WHY =shapechug[  kount[flag] ,10]
          LINE.CHUGZ(EX, WHY , W, UCOL, COLS)
          title(main=paste(sep=' ', i, "Chugging Nchug=", length(das2)), outer=TRUE, line=-2)
       
          locator()

	}
  
    }

    return(KCHUG)
  }
############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")
LINE.CHUGZ<-function(EX, WHY, W, UCOL, COLS)
  {
    k = 0;
    GLMS = as.list(1:length(UCOL))
    tit1 = "R2="
    tit2 = "COR="
    for(m in UCOL)
      {
        x = EX[COLS==m]
        y = WHY[COLS==m]
        wts  = W[COLS==m]
        k = k+1
        if(length(x)>1)
          {
            #  here might try a robust regression rlm
            ###  need library(MASS)

            gm = rlm(y ~ x, weights=wts)
            abline(gm, col=m)
            agm = summary(gm)
           # tit1=paste(sep=' ',tit1, format(agm$adj.r.squared, digits=3))

            
            tit2=paste(sep=' ',tit2, format(cor(x,y), digits=3))
            
            GLMS[[k]] = gm
          }
        
        
      }
   # title(main=tit1)
    #  title(sub=tit2)

     u = par("usr")
   #   text(u[1], u[4]-.1*(u[4]-u[2]), labels=paste(sep=' ', tit1, tit2) , pos=4)
    mtext(paste(sep=' ', tit2) , line=1, side=3, at=u[1], adj=0)

    
    
   invisible( GLMS)
  }


############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")

GET.Kseis<-function(fnames, kind=1, PLOT=FALSE, TWIN=c(0,1))
  {
    GG = GET.seis(fnames, kind=1, PLOT=FALSE)
    t1 = GG[[1]]$DATTIM$t1
    t2 = GG[[1]]$DATTIM$t2
    glueit = FALSE
      if(TWIN[1]< t1 | TWIN[2] > t2)
        {
          ### got a problem here need to seek out some more data
         
          KNMS = unlist(strsplit(fnames, "\\/"))
          JK = length(KNMS)
          Ktem = KNMS[JK]
          KFIL = unlist(strsplit(Ktem, "\\."))
          tem = paste(sep='', KFIL[1],".",KFIL[2], ".*", ".", KFIL[length(KFIL)])
          wildcard = paste(c(KNMS[1:(JK-1)],tem), collapse="/")
          cmnd =  paste(sep=' ',"ls", wildcard)
          
          FLIST = system(cmnd, intern=TRUE)
          II = which(FLIST==fnames)

          if( TWIN[2] > t2)
            {
              fnames = c(FLIST[II], FLIST[II+1])
              GG = GET.seis(fnames, kind=1, PLOT=FALSE)

            }

          if( TWIN[1] < t1)
            {
              fnames = c(FLIST[II-1], FLIST[II])
              GG = GET.seis(fnames, kind=1, PLOT=FALSE)
              
            }

          
          glueit = TRUE
        }
     
    GH=prepGG3(GG)
    
    if(glueit==TRUE)
      {
        GJ = GLUEseisSTR(GH)
        GH$JSTR = GJ$JSTR
      }
    
    invisible(GH)

  }

############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")

REPLOT.CHUGS<-function(chugs, sel=sel)
  {
    
###   REPLOT.CHUGS(san.chug.006)
###   REPLOT.CHUGS(chugs)

     if(missing(sel)) {sel=c(1)}
   
    fnames = chugs$fn

     chugtmin = min(chugs$tims)
     chugtmax = max(chugs$tims)

     
    GH = GET.Kseis(fnames, kind=1, PLOT=FALSE, TWIN=c(chugtmin, chugtmax) )
  
     
     ###   this is here for the SANGAY data only
    ###  GG = fixstanames(GG, stas)
   

     ## see if the we need to glue two seismograms


   
     
    As2=chugs$tims
    d1=chugs$tims
    d2=chugs$amp
    ifile=chugs$ifile
    ftime=chugs$ftime
    a = chugs$WIN
    
    PLOT.CHUGS(GH, sel, chugs)
    
    invisible(GH)
  }

###  source("/home/lees/Progs/R_stuff/kar.R")
############################################################
RESHAPE.CHUGS<-function(chugs, sel=sel)
  {
########
########  go through a set of chugs and 
########  ls(pat='san')
    
###   RESHAPE.CHUGS(san.chug.006)
    
    
###   GH =RESHAPE.CHUGS(san.chug.005)
    
    if(missing(sel)) {sel=c(1)}
    fnames = chugs$fn
    GG = GET.seis(fnames, kind=1, PLOT=FALSE)
     ###   this is here for the SANGAY data only
    ###   GG = fixstanames(GG, stas)
    GH=prepGG3(GG)
    
    As2=chugs$tims
    d1=chugs$tims
    d2=chugs$amp
    ifile=chugs$ifile
    ftime=chugs$ftime
    a = chugs$WIN
    
###    PLOT.CHUGS(GH, sel, chugs)
    
    
    
###    print("To Continue: Right click in window")
###    locator()
    one()
    a = range(chugs$tims)
    a[1] = a[1]-1.5
    a[2] = a[2]+1.5
    
    YN = PLOT.SEISN(GH, WIN=a, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel], add=1)
    
    
    
    abline(v=As2, col=rgb(0.8, 0.8, 1.0))
    plocator()
    
###     print("Right Click in Window")
###     b = plocator()

    b = list(x=a)
    
    amp = GH$JSTR[[sel]]
    ex = GH$dt[sel]*seq(0, length(amp)-1)
    
    amp = amp[ex>=b$x[1]&ex<=b$x[2] ]
    ex = GH$dt[sel]*seq(0, length(amp)-1)
    dt = GH$dt[sel]
    amp = amp-mean(amp)
    
    AL  = As2-b$x[1]
    AL  = AL[AL>min(ex)&AL<max(ex)]
    dAL = diff(AL)
    
    myleft = chugs$Asig[,1]
    myright =chugs$Asig[,2]
    
    
    plot(ex, amp, type='l')
    
    low = AL-c(dAL[1], dAL)*.75
    hi =  AL+c(dAL, dAL[length(dAL)])*.75
    
    abline(v=AL, col=rgb(0.8, 0.8, 1.0))
    abline(v=low, col=rgb(1.0,0.8,0.8))
    abline(v=hi, col=rgb(0.8,1,0.8))
    print("To Continue: Right click in window")   
    locator()
    print("Starting analysis")   
    
    

    for(i in 1:(length(AL)))
      {
        t1 = low[i]
        t2 = hi[i]
        
        q = amp[ex>=t1&ex<=t2]
        r = ex[ex>=t1&ex<=t2]
        
        
        jp = hilow(q)
        
        
        
        mid = (low[i]+hi[i])/2
        dmid = (mid-r[jp$lo])
        
        
        omid = c(max(which(sign(dmid)==1)), min(which(sign(dmid)==-1)))
        mins= sort(jp$lo[c(omid[1], omid[2])])
        
        plot(r,q)
        title(main=paste(sep=' ', i,'of',length(AL))) 
        points(r[jp$hi],q[jp$hi], col=2)
        points(r[jp$lo],q[jp$lo], col=3)
        
        abline(v=r[mins], col=2)
        abline(v=c(myleft[i], myright[i]), col=4)
        
        
        locator()
        
      }
    
    invisible(GH)
    
  }


############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")

#############################
chug.pulse<-function(r,q, dt)
  {
    ###  plot a small pulse and calculate a characterization
    ### 
    ## chug.pulse(r,q,dt)
    
    jp = hilow(q)
    
    t1 = min(r)
    mid = mean(r)
    dmid = (mid-r[jp$lo])
    
    
    omid = c(max(which(sign(dmid)==1)), min(which(sign(dmid)==-1)))
    mins= sort(jp$lo[c(omid[1], omid[2])])
    
    plot(r,q, type='b')
    ##  title(main=paste(sep=' ', i,'of',length(AL))) 
    points(r[jp$hi],q[jp$hi], col=2)
    points(r[jp$lo],q[jp$lo], col=3)
    
    abline(v=r[mins], col=2)
    
    vp = plocator(COL=rgb(1.0,0.5,0.5))
    nvp = length(vp$x)
    if(nvp>1)
      {
        
        px = floor( 1+(vp$x[c(nvp-1, nvp)]-r[1])/dt)
        abline(v=r[px], col=4)
        px = sort(px)

        ### find lo point closest to left side
        gx = abs(px[1]-jp$lo)

        wpx1 = which.min(gx)
        min1 = jp$lo[wpx1]
        if(gx[wpx1] >5)
          {
            wpx1 =px[1]
            min1 =  wpx1
          }
        
         ### find lo point closest to right side
        gx = abs(px[2]-jp$lo)
        wpx2 = which.min(gx)
         min2 = jp$lo[wpx2]
        if(gx[wpx2] >5)
          {
            wpx2 =px[2]
            min2 = px[2]
          }
        
        omid =c(wpx1, wpx2)
        
        mins= sort(c(min1, min2))
        
      }
    
    abline(v=r[mins], col=3)
    
    s = q[r>=r[mins[1]]&r<=r[mins[2]]]
        
    sum0 = sqrt(sum(s*s)/length(s))
    
    imax = which.max(q[jp$hi])
    
   
    ### p1 = q[jp$hi[imax]]-q[jp$lo[c(omid[1], omid[2])]]
    
    ###  tees = t1+r[jp$lo[c(omid[1], omid[2])]]
    ###   t0 = mid+t1

    Ex = r[mins]
    Ey = q[mins]

    ###  find the max point that lies between the two low points

    jind = jp$hi[r[jp$hi]>Ex[1]&r[jp$hi]<Ex[2]]
    j2 = which.max(  q[jind])
    Cx = r[jind[j2]]
    Cy = q[ jind[j2]]

    
   ###   Cx = r[jp$hi[imax]]
    ###  Cy = q[jp$hi[imax]]

    lines(c(Ex[1],  Ex[2], Cx, Ex[1]), c(Ey[1],  Ey[2], Cy, Ey[1]))

    A1 = c(Ex[1]-Cx, Ey[1]-Cy, 0)
    A2 = c(Ex[2]-Cx, Ey[2]-Cy, 0)
    
    ar2 = 0.5*vlen(xprod(A1,A2))

    tr = r[r>=Ex[1]&r<=Ex[2] ]
    tq = q[r>=Ex[1]&r<=Ex[2] ]

 
     DefInt = integ1(tr, tq)

    ### print(paste(sep=' ',DefInt[1],DefInt[2] , s4, s3))
    #### Ex[1], Ex[2] = left minimum
     #### Ey[1], Ey[2] = right  minimum
     ####    Cx, Cy  = center (max?)
    ####    7:  ar2 = area of triangle
    ####    8:  DefInt[1]  = integral under curve
    ####    9:  DefInt[2]  = integral under curve ( bottom triangle removed)
    ####   10:  sum0   = RMS amplitude
    
    return(c(Ex[1], Ex[2], Ey[1], Ey[2], Cx, Cy, ar2, DefInt[1], DefInt[2], sum0))
  }

############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")
chug.err<-function(KCHUG, i , PLOT=TRUE)
{
  if(missing(PLOT)) { PLOT=FALSE }

  sel = 1

  fn = KCHUG[[i]]$chugs$fn
  
     chugtmin = min(KCHUG[[i]]$chugs$tims)
     chugtmax = max(KCHUG[[i]]$chugs$tims)

  
  NH = GET.Kseis(fn, kind=1, PLOT=FALSE, TWIN=c(chugtmin, chugtmax) )
  
  a = KCHUG[[i]]$chugs$WIN
  tim = NH$ex
  
  if(PLOT)
    {
      dev.set(3)
      YN = PLOT.SEISN(NH, WIN=a, dt=NH$dt, sel=sel , notes=NH$KNOTES[sel], add=1)
    }
  shapechug = KCHUG[[i]]$shapechug

  ERRchug = matrix(ncol=2, nrow=length(KCHUG[[i]]$chugs$tims))

  M = length(KCHUG[[i]]$chugs$tims)
  for(m in 1:length(KCHUG[[i]]$chugs$tims))
    {
      low = KCHUG[[i]]$chugs$tims[m]-( KCHUG[[i]]$shapechug[m,5]-KCHUG[[i]]$shapechug[m,1]    )
      hi = KCHUG[[i]]$chugs$tims[m]-( KCHUG[[i]]$shapechug[m,5]-KCHUG[[i]]$shapechug[m,2]    )
      ex = tim[tim>=low&tim<=hi]
      amp = NH$JSTR[[1]][tim>=low&tim<=hi ]

      if(length(amp)<2)
        {
          ERRchug[m,] = c(NA, NA)
          next;
        }

      if(PLOT)
        {
          print(paste(sep=' ', "chug.err", m, "of", M))
          dev.set(3)
          
          ik = 1
          y3 = 1-(YN$dy*ik)
          z = RESCALE(amp, y3, y3+YN$dy, YN$minS[ik], YN$maxS[ik] )
          
          lines(ex,z, col=2)
          dev.set(2)
          
          plot(ex,amp, main=paste(sep=' ', m))
          abline(v=KCHUG[[i]]$chugs$tims[m], col=2)
        }
      kmax = which.max(amp)
      
      E = EstChugErr(ex, amp, PLOT=PLOT)
      e1 = E[1]
      e2 = E[2]
      if(PLOT)
        {
          segments(ex[kmax]-e1,amp[kmax],  ex[kmax]+e1,amp[kmax], col=4)
          segments(ex[kmax], amp[kmax]-e2,  ex[kmax] ,amp[kmax]+e2)
        }
      ## print(paste(sep = ' ', e1, e2))

      ERRchug[m,] = E
      ## locator()
      
    }
  invisible(ERRchug)
}
###################
###  source("/home/lees/Progs/R_stuff/kar.R")


EstChugErr<-function(ex, amp, PLOT=FALSE, dt=0.008, j1=6, j2=2 )
  {

    
    if(missing(PLOT)) { PLOT=FALSE }
   if(missing(dt)) { dt=0.008  }
   if(missing(j1)) { j1=6  }
   if(missing(j2)) { j2=2  }


    
      kmax = which.max(amp)

    if(length(ex)<2|| length(amp)<2)
      {
        print("error in EstChugErr, no data input in ex or amp")
        return(c(NA, NA))
      }
      j = j1
      ys1 = ksmooth(ex, amp, "normal", bandwidth=j*dt)

    if(PLOT==TRUE)
      {
      lines(ys1$x, ys1$y, col=j, lty=2)
    }

      m1 = which.max(ys1$y)
      p1 = c(ys1$x[m1], ys1$y[m1])

      j = j2
      ys = ksmooth(ex, amp, "normal", bandwidth=j*dt)
      m2 = which.max(ys$y)
      p2 = c(ys$x[m2], ys$y[m2])

      e1 = abs(p1[1]-p2[1])
      e2 =  abs(p1[2]-p2[2])

    if(PLOT==TRUE)
      {
        lines(ys$x, ys$y, col=gray(.7), lty=2)
        points(ys1$x[m1], ys1$y[m1], pch=3)
        points(ys$x[m2], ys$y[m2], pch=3, col=4)
  
      }


      return(c(e1, e2))
  }
##############################################################

chug.cluster<-function(KCHUG, i , PLOT=TRUE)
{
  if(missing(PLOT)) { PLOT=FALSE }


  if(PLOT==TRUE)
    {
      Get.Screens(2)
    }

  sel = 1

  fn = KCHUG[[i]]$chugs$fn
  
     chugtmin = min(KCHUG[[i]]$chugs$tims)
     chugtmax = max(KCHUG[[i]]$chugs$tims)

  
  NH = GET.Kseis(fn, kind=1, PLOT=FALSE, TWIN=c(chugtmin, chugtmax) )
  
  a = KCHUG[[i]]$chugs$WIN
  tim = NH$ex
  
  if(PLOT)
    {
      dev.set(3)
      YN = PLOT.SEISN(NH, WIN=a, dt=NH$dt, sel=sel , notes=NH$KNOTES[sel], add=1)
    }
  shapechug = KCHUG[[i]]$shapechug

  CLUSTchug = matrix(ncol=length(KCHUG[[i]]$chugs$tims), nrow=length(KCHUG[[i]]$chugs$tims))

  M = length(KCHUG[[i]]$chugs$tims)
  for(m in 1:(M-1))
    {

      CLUSTchug[m,m] = 1
      low = KCHUG[[i]]$chugs$tims[m]-1.5*( KCHUG[[i]]$shapechug[m,5]-KCHUG[[i]]$shapechug[m,1]    )
      hi = KCHUG[[i]]$chugs$tims[m]-1.5*( KCHUG[[i]]$shapechug[m,5]-KCHUG[[i]]$shapechug[m,2]    )
      if(low<min(tim)) low = min(tim)
      if(hi>max(tim)) hi = max(tim)
      mastex = tim[tim>=low&tim<=hi]
      mastamp = NH$JSTR[[1]][tim>=low&tim<=hi ]
      
      if(length(mastamp)<2)
        {
          next;
        }


  for(slave in (m+1):M)
    {
      jlow = KCHUG[[i]]$chugs$tims[slave]-1.5*( KCHUG[[i]]$shapechug[m,5]-KCHUG[[i]]$shapechug[m,1]    )
      jhi = KCHUG[[i]]$chugs$tims[slave]-1.5*( KCHUG[[i]]$shapechug[m,5]-KCHUG[[i]]$shapechug[m,2]    )
      if(low<min(tim)) jlow = min(tim)
      if(hi>max(tim)) jhi = max(tim)
      slaveex = tim[tim>=jlow&tim<=jhi]
      slaveamp = NH$JSTR[[1]][tim>=jlow&tim<=jhi ]

         if(length(slaveamp)<2)
        {
          next;
        }

###  do cross correlation here, get score, save in matrix
      xc = xcor2(mastamp, slaveamp, 0.008, PLOT=FALSE, LAG=100)
      score = max(xc$acf)

      CLUSTchug[m,slave] = score
    }

      if(PLOT)
        {
          print(paste(sep=' ', "chug.cluster done", m, "master of", M))
          dev.set(3)
          
          ik = 1
          y3 = 1-(YN$dy*ik)
          z = RESCALE(mastamp, y3, y3+YN$dy, YN$minS[ik], YN$maxS[ik] )
          
          lines(mastex,z, col=2)
         
        }
    
    
      ## print(paste(sep = ' ', e1, e2))

     
      ## locator()
      
    }
  invisible(CLUSTchug)
}
##############################

see.chug.cluster<-function(KCHUG, i , GROUP=fannyx$clustering)
  {

    N = length(KCHUG[[i]]$chugs$tims)
    if(missing(GROUP)) { GROUP = rep(2,N) }

    sel = 1
    
    fn = KCHUG[[i]]$chugs$fn
    
    chugtmin = min(KCHUG[[i]]$chugs$tims)
    chugtmax = max(KCHUG[[i]]$chugs$tims)
    
    
    NH = GET.Kseis(fn, kind=1, PLOT=FALSE, TWIN=c(chugtmin, chugtmax) )
    
    a = KCHUG[[i]]$chugs$WIN
    tim = NH$ex
    

    upar = par(no.readonly = TRUE)
    
    nf <- layout(matrix(c(1,2),2,1,byrow=TRUE), heights=c(1,2), TRUE)
####  layout.show(nf)
    mai = upar$mai
    mai[1] = 0.5
    mai[3] = 0.1
    
    par(mai=mai )

    
    YN = PLOT.SEISN(NH, WIN=a, dt=NH$dt, sel=sel , notes=NH$KNOTES[sel], add=1)
    
    M = length(KCHUG[[i]]$chugs$tims)
    
    for(m in 1:M)
      {
        low = KCHUG[[i]]$chugs$tims[m]-( KCHUG[[i]]$shapechug[m,5]-KCHUG[[i]]$shapechug[m,1]    )
        hi = KCHUG[[i]]$chugs$tims[m]-( KCHUG[[i]]$shapechug[m,5]-KCHUG[[i]]$shapechug[m,2]    )
        ex = tim[tim>=low&tim<=hi]
        amp = NH$JSTR[[1]][tim>=low&tim<=hi ]
        ik = 1
        y3 = 1-(YN$dy*ik)
        z = RESCALE(amp, y3, y3+YN$dy, YN$minS[ik], YN$maxS[ik] )
        
        lines(ex,z, col=GROUP[m])
        
      }



  u1 = par("usr")
  ## text(u1[1],0, labels=ftime,adj=c(0,0) )
  d1=KCHUG[[i]]$chugs$tims
  d2=KCHUG[[i]]$chugs$amp
    
  das2 = diff(d1)
  ax = das2
  ay = d2[1:length(das2)]

  bb = boxplot(das2, plot=FALSE)

  flag =  das2<(bb$stats[5,1]+(bb$stats[5,1]-bb$stats[4,1]))
  

###  flag = (ax-mean(ax))<2*sqrt(var(das2))

  tx = ax[flag]
  why = ay[flag]
  
  labs = 1:length(das2)

  par(mai=upar$mai )
  plot(tx, why, xlab="Interval Time, s", ylab="Amplitude", type='n')

  u2 = par("usr")

  text(tx, why,labels=labs[flag], pos=3, col=rgb(1.0, 0.8, 0.8))


      points(tx, why ,pch=3 , col=GROUP)

 ### title(main=ifile)
  par(upar)







    
  }
##############################
############################################################
###  source("/home/lees/Progs/R_stuff/kar.R")

RECLUST.CHUGS<-function(chugs, sel=sel)
  {
    
###   REPLOT.CHUGS(san.chug.006)
###   REPLOT.CHUGS(chugs)

     if(missing(sel)) {sel=c(1)}
   
    fnames = chugs$fn

     chugtmin = min(chugs$tims)
     chugtmax = max(chugs$tims)

     
    GH = GET.Kseis(fnames, kind=1, PLOT=FALSE, TWIN=c(chugtmin, chugtmax) )
  
     
     ###   this is here for the SANGAY data only
    ###  GG = fixstanames(GG, stas)
   

     ## see if the we need to glue two seismograms


   
     
    As2=chugs$tims
    d1=chugs$tims
    d2=chugs$amp
    ifile=chugs$ifile
    ftime=chugs$ftime
    a = chugs$WIN
    
    PLOT.CHUGS(GH, sel, chugs)
    
    invisible(GH)
  }
#########################

get.the.chugs<-function(KCHUG, i)
{

  PLOT = FALSE
  if(is.matrix(KCHUG[[i]]$shapechug)==TRUE)
    {
      shapechug = KCHUG[[i]]$shapechug

      d1 = shapechug[,5]
      das2 = diff(d1)
      amp =  shapechug[1:length(das2),6]
      
      bb = boxplot(das2, plot=FALSE)

      kount = 1:length(das2)
      
      ##	  flag = rep(TRUE, length(kount))

      ##

      flag =  das2<(bb$stats[5,1]+(bb$stats[5,1]-bb$stats[4,1]))
      w1 = which(flag==FALSE)
      
      k1 = length(w1)+1
      cols =  rep(1, length(das2)) 
      vec = c(1, w1, length(das2))
      
      for(m in 1:(length(vec)-1))
        {
          cols[vec[m]:vec[m+1] ] =m

        }
      

      ##dev.set(2)
      ##one()
      ##REPLOT.CHUGS(KCHUG[[i]]$chugs)
      ## print(paste(sep=' ', "SHOW.CHUGZ: working on ",i, "of", BIGN))

      if( is.null(KCHUG[[i]]$CHERR) )
        {
          
          CHERR = chug.err(KCHUG, i, PLOT=PLOT)
          KCHUG[[i]]$CHERR = CHERR 
        }
      else
        {
          
          CHERR = KCHUG[[i]]$CHERR
        }

      e1 = CHERR[1:length(das2),1]+KCHUG[[i]]$chugs$dt/3
      e2 = CHERR[1:length(das2),2]
      w1 = 1/(e1)
      w1 = w1/sum(w1)
      
      w2 = 1/(e2)
      w2 = w2/sum(w2)

      WTS = w1 + w2 

      
      ## dev.set(3)
         ##  par(mfrow=c(2,2))

      EX = das2[flag]
      WHY  = amp[flag]
      COLS = cols[flag]
      W = WTS[flag]

### check if WTS exist and are not NA
###  else do not

      if(length(which(is.na(W)))==length(W)  )
        {

          W = rep(1,length(W))
        }

      W[is.na(W) ] = min(W[!is.na(W)])

      
      if(length(which(is.na(W)))>1  )
        {
###  last resort
          W = rep(1,length(W))
        }
      
      UCOL = unique(COLS)
      
      plot(EX, WHY, xlab="Interval Time", ylab="Amplitude", col=cols[flag])
      text(EX, WHY, labels=kount[flag], pos=1, col=rgb(0.1, 0.5, 0.1) )

      segments(EX-e1[flag],WHY,  EX+e1[flag], amp[flag] , col=cols[flag])
      segments(EX,WHY-e2[flag],  EX, WHY+e2[flag] , col=cols[flag])

      GLMS = LINE.CHUGZ(EX, WHY, W, UCOL, COLS)
      KCHUG[[i]]$GLMS = GLMS

    }

  invisible(list(EX=EX, WHY=WHY, W=W, K=kount[flag], COL=cols[flag], E1=e1[flag], E2=e2[flag]))

  

}
