###   source("/home/lees/Progs/R_stuff/krafla.R")


setupkrafmap<-function()
  {
krafsta = scan(file="krafla_passcal.llz", list(nam='', lat=0, lon=0, z=0))

krafwell = scan(file="krafla.well.LLZ", list(nam='', lat=0, lon=0, z=0))

load(file="/home/lees/Site/Iceland/krafla.road.ll.R")
roadLL$lon2 = roadLL$lon-360

Korg = which(krafwell$nam=="K-26")

setPROJ(type=1, LAT0=krafwell$lat[Korg], LON0=krafwell$lon[Korg], LATS=range(c(krafwell$lat, krafwell)), LONS=range(krafwell$lon), DLAT=NULL, DLON=NULL)
##############

krafsta.XY = GLOB.XY(krafsta$lat , krafsta$lon)
krafwell.XY = GLOB.XY(krafwell$lat , krafwell$lon)
roadLL$XY = GLOB.XY(roadLL$lat, roadLL$lon2)

}

krafmap<-function()
{
plot(c(krafwell.XY$x, krafsta.XY$x), c(krafwell.XY$y, krafsta.XY$y), type='n', xlab="X", ylab="Y", asp=TRUE)

points(krafwell.XY$x, krafwell.XY$y, pch = 9, col=4)
text(krafwell.XY$x, krafwell.XY$y, labels=krafwell$nam, col=4, pos=1)

points(krafsta.XY$x, krafsta.XY$y, pch = 6, col=2)
text(krafsta.XY$x, krafsta.XY$y, labels=krafsta$nam, pos=4, col=2)

lines(roadLL$XY$x, roadLL$XY$y, lwd=2, col=3)
}

getdem<-function(infile)
{
 
CARD.A = scan(file=infile, what="", sep="\n", nlines = 6)
 AS1  = wordsplit(CARD.A[3])
 nx = as.numeric(AS1[1])
 ny = as.numeric(AS1[2])
 AS1  = wordsplit(CARD.A[4])
 dx = as.numeric(AS1[1])
 dy = as.numeric(AS1[2])

 AS1  = wordsplit(CARD.A[5])
 ax = as.numeric(AS1[1])
 ay = as.numeric(AS1[2])

 AS1  = wordsplit(CARD.A[6])
 bx = as.numeric(AS1[1])
 by = as.numeric(AS1[2])

CARD.V = scan(file=infile, what=numeric(), skip = 6, nlines=(nx*ny)/5 )
CARD.Z = matrix(CARD.V, ncol=nx, nrow=ny)
Z = mirror.matrix(CARD.Z)
X = seq(from=ax, to=bx-dy, by=dx)
Y = seq(from=ay, to=by-dy, by=dy)
return(list(nx=nx, ny=ny, ax=ax, ay=ay, bx=bx, by=by, X=X, Y=Y, Z=Z ))
}

################
plotdem<-function(dem, add=FALSE)
{
if(missing(add)) { add= FALSE } 

image(x=dem$X, y=dem$Y, z=dem$Z, add=add)
contour(dem$X, dem$Y, dem$Z, nlevels =25, add=TRUE) 
}


PICK.KRAFLA<-function(GH, sel=1:length(GH$dt), WIN=NULL, PF=NULL, APIX=NULL, SHOWONLY=FALSE)
{
###  a = PICK.MARIO(GH,  sel, WIN=twin)
  
  if(missing(WIN)) { WIN = NULL }
  if(missing(sel)) { sel = 1:length(GH$dt)}
  if(missing(APIX)) { APIX = NULL}
  if(missing(PF)) { PF = NULL}

  
  if(missing(SHOWONLY)) { SHOWONLY=FALSE}

   NH = GH
  
###  if(!is.null(WIN))
###    {
###      NH = CHOP.SEISN(GH, sel , WIN=WIN)
###    }
###  else
###    {
###      NH = GH
###    }
###

  if(is.null(WIN)==TRUE)
    {
      WIN = c(0, NH$dt*length(NH$JSTR[[1]]))
    }
  
  labs = c("DONE", "zoom out", "zoom in", "restore", "PPix", "AccPIX", "XPIX", "NULL", "AUTOP","WLET", "SPEC", "SGRAM", "3COMP", "ROT" )
  colabs = rep(1,length(labs))
  colabs[c(5,6,7,9)] = c(2,3,4,6)
  pchlabs = rep(4,length(labs))
  pchlabs[c(5,6,7,9)] = c(15,16,17,18)


  
  NSEL = length(NH$dt[sel])

  if(is.null(APIX)==TRUE)
    {
      WPX = as.list(NA)
      NPX = 0
      
   
      
    }
  else
    {
      ## print("reading in pickfile")
##    APIX=SAVDAT[[ii]]
      WPX = APIX
      NPX = length(WPX)

      pdb = unlist(WPX)
      npdb = names(unlist(pdb))
      
   
    ##  print(paste(sep=' ', "read in pickfile",NPX))
     ## print(xpix)
    }
  

  
  STNS = NH$STNS[sel]
  COMPS = NH$COMPS[sel]
  UNIsta = unique(STNS)
  
   NUNI = length( UNIsta)

###  Upix = as.list(1:NUNI)
###  names(Upix) = UNIsta

 

 pcols = rep(rgb(0,0,1), NSEL)


  pcols[COMPS=="SHV" | COMPS=="1"] = rgb(0.4,0,0)
 
  
###   ords = 1:length(STNS)
###   ordc = match(COMPS, c("SHV", "SHN", "SHE"))

###  ordsel = order( ords+ordc/10)

###ordsel = 1:length(STNS)
  
  
###  sel = ordsel

  
   du = 1/NSEL


  isel = sel[1]
  
  T0 = list(jd=NH$info$jd[isel], hr=NH$info$hr[isel], mn=NH$info$mn[isel], sec=(NH$info$sec[isel]+NH$info$msec[isel]/1000+NH$info$t1[isel]-NH$info$off[isel]))

  YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel , notes=NH$KNOTES[sel], COL=pcols)
  if(!is.null(P)) {  plotPF(NH, P, YN, sel)  }

  

  if(SHOWONLY==TRUE) { return(0) }

  MAINdev = dev.cur()

  ###  Get.Screens(2)
  dev.set( MAINdev)
  
   if(NPX>0)
        {

          plot.WPX(T0, STNS, COMPS, WPX)
        ##   segments(xpix, ypixA, xpix, ypixB, col=colpix)
         ##  text(xpix, ypixB, labels=cpixa, col=colpix, pos=4)
        }
      
  
  u = par("usr")
  sloc = list(x=c(u[1],u[2]))
  ppick  = NA
  spick  = NA
  xpick = NA
#### ftime = Zdate(NH$info, sel[1],0)
#### mtext( ftime, side = 3, at = 0, line=0.5, adj=0)
  
####  title("LEFT 0 Click = done; 1 Click=replot;   2 Click=zoom")
  buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
  
####  NV = LabelBAR(labs)
 ###   zloc = plocator(COL=rgb(1,0.8, 0.8))
zloc = plocator(COL=rgb(1,0.8, 0.8), NUM=FALSE , YN=NSEL, style=1)
  
  Nclick = length(zloc$x)
  if(is.null(zloc$x)) { return(NULL) }
  K = whichbutt(zloc ,buttons)
  
  sloc = zloc
  
  while(Nclick>0)
    {
      
      if(K[Nclick] == 1)
        {
          break;
        }
      
      
      if(Nclick==1 & K[Nclick]==0)
        {
          WIN = NULL
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel , notes=NH$KNOTES[sel], COL=pcols)
            if(!is.null(P)) {  plotPF(NH, P, YN, sel)  }

          u = par("usr")
          
          sloc = list(x=c(u[1],u[2]))
          
          
        }

       ####################  START  BUTTON DEFINITIONS    ###########################

      
       ###################   RESTORE  ###########################      
      if(K[Nclick]==4)
        {
          WIN = NULL
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel , notes=NH$KNOTES[sel], COL=pcols)
            if(!is.null(P)) {  plotPF(NH, P, YN, sel)  }

          u = par("usr")
          L = length(sloc$x)
          if(L>1)
            {
              abline(v=sloc$x[c(L-1,L)], col=gray(0.8), lty=2)
            }
          sloc = list(x=c(u[1],u[2]))
          
        }

      ################  ZOOM IN BY WINDOW CLICKING   #################
      if(Nclick>1 & K[Nclick]==0)
        {
          
          WIN  = sort(zloc$x[c( Nclick-1, Nclick)])
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel , notes=NH$KNOTES[sel], COL=pcols)
            if(!is.null(P)) {  plotPF(NH, P, YN, sel)  }

         #### ftime = Zdate(NH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)
          sloc = zloc
        }

      ###################   ZOOM  OUT  ###########################      
      if(K[Nclick]==2)
        {
          u = par("usr")
          DX = (u[2]-u[1])*0.3
          zloc = list(x= c(u[1]-DX, u[2]+DX))
          WIN  = zloc$x
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel , notes=NH$KNOTES[sel], COL=pcols)
            if(!is.null(P)) {  plotPF(NH, P, YN, sel)  }

         #### ftime = Zdate(NH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)

          sloc = zloc
        }
      ###################   ZOOM IN   ###########################      
       if(K[Nclick]==3)
        {
          u = par("usr")
          DX = (u[2]-u[1])*0.3
          zloc = list(x= c(u[1]+DX, u[2]-DX))
          WIN  = zloc$x
         
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel , notes=NH$KNOTES[sel], COL=pcols)
            if(!is.null(P)) {  plotPF(NH, P, YN, sel)  }

         #### ftime = Zdate(NH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)

          sloc = zloc
        }

      ###################   P PICK   ###########################
      if(K[Nclick]==5 & Nclick>1)
        {  
         ppick = zloc$x[Nclick-1]
         ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
         ipick = sel[ypick]
         m = match(STNS[ypick],UNIsta)
       ###  Upix[[m]]$p  = ppick
         
       ###   PPIX(list(x=zloc$x[Nclick-1], y=zloc$y[Nclick-1]), YN=NSEL, col=3, lab="P")
         jj = floor((zloc$y[Nclick-1])/du)

         NPX = NPX+1

          asec = NH$info$sec[ipick]+NH$info$msec[ipick]/1000+NH$info$t1[ipick]-NH$info$off[ipick]+ppick
         WPX[[NPX]] = list( pick=c(NH$info$yr[ipick], NH$info$jd[ipick], NH$info$hr[ipick], NH$info$mn[ipick], asec), kind="P", sta= STNS[ypick], comp=COMPS[ypick], col=2)
         
    
         #### abline(v=ppick, col=3)
        }

      ###################   A  PICK   ###########################      
      if(K[Nclick]==6 & Nclick>1)
        {
          
### print(paste(sep=" " , "WIN=",sloc$x))
          ppick = zloc$x[Nclick-1]
 ###         abline(v=ppick, col=2)
       ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
         m = match(STNS[ypick],UNIsta)
          jj = floor((zloc$y[Nclick-1])/du)
       ###  Upix[[m]]$s  = ppick
         
       ###   PPIX(list(x=zloc$x[Nclick-1], y=zloc$y[Nclick-1]), YN=NSEL, col=3, lab="A")
          NPX = NPX+1
         
           asec = NH$info$sec[ipick]+NH$info$msec[ipick]/1000+NH$info$t1[ipick]-NH$info$off[ipick]+ppick
         WPX[[NPX]] = list( pick=c(NH$info$yr[ipick], NH$info$jd[ipick], NH$info$hr[ipick], NH$info$mn[ipick], asec), kind="A", sta= STNS[ypick], comp=COMPS[ypick], col=3)
        
        }

      ###################   X  PICK   ###########################      
      
      if(K[Nclick]==7 & Nclick>1)
        {
          
###   print(paste(sep=" " , "WIN=",sloc$x))
          ppick = zloc$x[1:(Nclick-1)]
   ###        abline(v=ppick, col=4)

          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          
         m = match(STNS[ypick],UNIsta)
       ###  Upix[[m]]$x  = ppick
         
       ###   PPIX(list(x=zloc$x[Nclick-1], y=zloc$y[Nclick-1]), YN=NSEL, col=3, lab="P")
          jj = floor((zloc$y[Nclick-1])/du)


          NPX = NPX+1
          ###   WPX[[NPX]] = list( yr=NH$info$yr[ipick], jd=NH$info$jd[ipick], hr=NH$info$hr[ipick], mn=NH$info$mn[ipick], sec=NH$info$sec[ipick],
          ##### msec=NH$info$msec[ipick], t1=NH$info$t1[ipick], off=NH$info$off[ipick], x=ppick, yA=jj*du, yB=jj*du+du, kind="X",
          ########  sta= STNS[ypick], comp=COMPS[ypick], col=4)
      asec = NH$info$sec[ipick]+NH$info$msec[ipick]/1000+NH$info$t1[ipick]-NH$info$off[ipick]+ppick
         WPX[[NPX]] = list( pick=c(NH$info$yr[ipick], NH$info$jd[ipick], NH$info$hr[ipick], NH$info$mn[ipick], asec), kind="X", sta= STNS[ypick], comp=COMPS[ypick], col=3)
          
       
        }

      ###################   REMOVE  PICKs   ###########################      
 
      
      if(K[Nclick]==8)
        {
          NPX = 0
          WPX = as.list(NA)
          
        
        }

      ###################   AUTO  PICKs   ###########################      
 
      if(K[Nclick]==9 & Nclick>=3)
        {
         
         ###  u = par("usr")
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          print(paste(sep=' ',ypick, NH$info$name[ ipick]))
          
         ###   amp = NH$JSTR[[j]][NH$ex>sloc$x[1]&NH$ex<sloc$x[2] ]
          
          print(paste(sep=' ',YN$DX[1], YN$DX[2], WIN[1], WIN[2]))
          famp = NH$JSTR[[ipick]]

           pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
          Xamp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]

       ###     dev.set(3)
          
       ###   plot.ts(Xamp)
        ###  locator()
        ###  dev.set(2)
          

          
         ### KPIX = autopick(Xamp, which.max(abs(Xamp)) )
         ###  ktarg = which.max(abs(Xamp))
          
         ### ktarg = floor((zloc$x[Nclick-1]-YN$DX[1])/NH$dt[ypick])
         ktarg = which.max(abs(Xamp))

          ###  print(paste(sep=' ',"DUMP",zloc$x[Nclick-1], ktarg,which.max(abs(Xamp))))
        
                 
        ###    KPIX = autopick(Xamp, ktarg )
          X11()

         
              fy = butfilt(Xamp, fl=.2, fh=200, 0.008, "HP", "BU" )
              RAT = ratcurve(fy, dt=0.002, fwlen =  175,  bwlen  = 175, PLOT=TRUE)
        
          
          dev.set( MAINdev)
          
          
          ### print(KPIX)
         ### dev.set(dev.next())
          
          ### plot.ts(Xamp)
          ### abline(v=KPIX$ind, col=2)
           ###  dev.set(dev.next())

          autpix = pwin[1]+RAT$ind*NH$dt[ipick]
          print(autpix)
          abline(v=autpix, col=2)
          
          
        }

      
      ###################   WLET ANALYSIS   ###########################      
 
      if(K[Nclick]==10 & Nclick>=3)
        {
         ###  u = par("usr")
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          print(paste(sep=' ',ypick, NH$info$name[ ipick]))

          famp = NH$JSTR[[ipick]]
          ###  need to flip the accoustic trace?

          pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
          temp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]
          Xamp =   temp
          smallex = NH$ex[ NH$ex > pwin[1] & NH$ex <pwin[2]]
          
          X11()
          ###  plot.ts(Xamp)

         
          wlet2.do(Xamp, NH$dt[ipick],  col=terrain.colors(100))
          dev.set( MAINdev)
  
          

          
        }
      
      ###################   FREQUENCY ANALYSIS   ###########################      
 
      if(K[Nclick]==11 & Nclick>=3)
        {
         ###  u = par("usr")
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          print(paste(sep=' ',ypick, NH$info$name[ ipick]))

          famp = NH$JSTR[[ipick]]
          ###  need to flip the accoustic trace?

         pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
          
          temp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]
          
          g  =  list(y=temp-mean(temp), dt=NH$dt[ipick])
          ### g$x = NH$ex[ NH$ex > zloc$x[Nclick-2] & NH$ex <zloc$x[Nclick-1]]
  
          X11()
           Spec = MTMplot(g, 0.1, 50, PLOT=TRUE)
          dev.set( MAINdev)
  
          ###  dev.off(dev.cur())
   
          ###     a = PICK.MARIO(GH,  sel, WIN=twin) 

          
        }
      
      ###################   SPECTROGRAM  ANALYSIS   ###########################      
 
      if(K[Nclick]==12 & Nclick>=3)
        {
         ###  u = par("usr")
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          print(paste(sep=' ',ypick, NH$info$name[ ipick]))


          famp = NH$JSTR[[ipick]]
          ###  need to flip the accoustic trace?

          pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
          
          Xamp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]
 
       
          ###  smallex = NH$ex[ NH$ex >  pwin[1] & NH$ex < pwin[2]]

         DEV = evolfft(Xamp,NH$dt[ipick] , Nfft=4096, Ns=250 , Nov=240,  fl=0, fh=15  )

        
          X11()
          plotevol(DEV, log=1, fl=0, fh=50, col=rainbow(50))
          
          dev.set(MAINdev)
          
        }

      ###################   3 COMPONENTS   ###########################      
 
      if(K[Nclick]==13 )
        {
         ###  u = par("usr")
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          print(paste(sep=' ',ypick, NH$info$name[ ipick]))
          
          if(Nclick>=3)
            {
              pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
            }
          else
            {
              pwin = WIN
            }
          
 
###   source("/home/lees/Progs/R_stuff/krafla.R")

          ima = which(!is.na(match(NH$STNS, NH$STNS[ipick])))
          print(paste(collapse=":", NH$STNS[ima], NH$COMPS[ima]))

          

          X11()

          PICK.KRAFLA(NH, WIN=pwin, sel=ima, PF=P)
          
          dev.set(MAINdev)
          
        }

     if(K[Nclick]==14 )
        {
         ###  particle motion plot
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          print(paste(sep=' ',ypick, NH$info$name[ ipick]))

         if(Nclick>=3)
            {
              pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
            }
          else
            {
              pwin = WIN
            }
          
###   source("/home/lees/Progs/R_stuff/krafla.R")

          ima = which(!is.na(match(NH$STNS, NH$STNS[ipick])))
          print(paste(collapse=":", NH$STNS[ima], NH$COMPS[ima]))


          if(length(ima)<3)
            {
              print("Not enough traces, must have 3 components")
            }
          else
            {
              rotangle = 0
              m = match(NH$STNS[ipick], krafsta$nam)
              ###   source("/home/lees/Progs/R_stuff/krafla.R")

              GBAZ = distaz(P$LOC$lat, P$LOC$lon, krafsta$lat[m],  krafsta$lon[m])
              rotangle = rotangle + GBAZ$baz

              cat(sep="\n", paste(sep=' ', m, krafsta$nam[m], GBAZ$baz, rotangle))


              
              X11()
              Kmot.SEISN(NH, sel=ima, WIN=pwin, ANG=rotangle, title=paste(sep=' ',NH$STNS[ipick], "rot=",formatC(rotangle, format="f", digits=2)) )
              dev.set(MAINdev)
            }
          
        }

      ####################  END BUTTON DEFINITIONS    ###########################      
            ###################   WRAP UP and PLOT AGAIN   ###########################      
      ####  plot the picks

     ####   fin = ftorn[ii]
       if(NPX>0)
        {

          plot.WPX(T0, STNS, COMPS, WPX)
          
         ##  segments(xpix, ypixA, xpix, ypixB, col=colpix)
         ##  text(xpix, ypixB, labels=cpixa, col=colpix, pos=4)
        }
      
      
        buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
 
###  NV = LabelBAR(labs)
      zloc = plocator(COL=rgb(1,0.8, 0.8), NUM=FALSE , YN=length(sel), style=1)
      Nclick = length(zloc$x)
      if(is.null(zloc$x)) { return(sloc) }
      K =  whichbutt(zloc ,buttons)
### K = ValBAR(NV, zloc)
###  print(paste(sep=" ", "K=",K))
      
    }

  ### PRET = list(TPIX=TPIX, xpix=xpix,ypixA=ypixA, ypixB=ypixB,cpixa= cpixa, cpixb=cpixb, cpixc=cpixc, colpix=colpix)
 ###  return(PRET)
  return(WPX)
}		
##################################################
#####  

###   source("/home/lees/Progs/R_stuff/krafla.R")

###  setenv XMA_VEL_FILE  /home/lees/Site/Krafla/PICKS/krafla1.vel
###  setenv  JPED_STA_FILE  /home/lees/Site/Krafla/PICKS/krafla.LLZ


###   source("/home/lees/Progs/R_stuff/particle_motion.R")


Kmot.SEISN<-function(GH, sel=1:3, WIN=NULL, ANG=0, title="")
  {
    ###  given a data structure from a UW file,
    ### plot a hodo gram
    ###  ANG = angle to rotate initially to get radial-transverse

    ###  sel must be a vector with the ( Vertical, North East ) components
      if(missing(sel)) { sel = 1:3}
      if(missing(WIN)) { WIN = NULL }
      if(missing(ANG)) { ANG = 0 }
      if(missing(title)) { title=""}
  
    ###   a = ZOOM.SEISN(GH, sel=sel, WIN=WIN)
    ###  need to get the location and the angle to
    ### rotate to radial-transverse
    
    flag = GH$ex>=WIN[1]&GH$ex<=WIN[2]

    dat = cbind(GH$JSTR[[sel[1]]],GH$JSTR[[sel[2]]], GH$JSTR[[sel[3]]])

    AA = srot(dat[flag , ], ANG)
    ex = GH$ex[flag]

    FMO = pmosel(AA, ex,  title=title, PS=FALSE)

  }


