###############
###############   source("/home/bourbon/DATA/Hengill/mattloop.R")

###############
###############   source("/home/lees/Progs/mattloop.R")



testmatt<-function(fname, A )
  {
    ############   test a pick file from detailed picks
    
    HH = unlist(strsplit(fname, split="/"))
    Hname = HH[length(HH)]
    
    
    nc = nchar(fname)
    aname = substr(fname, 1, nc-1)
    pname = paste(sep='', aname, "p")
    
    P = getpfile(pname)
    
    GU = GetUW(fname)
    
    GU$COMPS=substr(GU$COMPS, 3,3)
    
    sel=which(GU$COMP=="V")
    
    Adet = A$DETLINFO
    
    APX = as.list(1:length(Adet))
    
    k=1
    for(K in 1:length(Adet))	
      {
        
        astn = Adet[[K]]$stn
        acomp= Adet[[K]]$comp
        
        inda = which(GU$STNS==astn & GU$COMPS==acomp)
        
        
        
        for(i in 1:length(Adet[[K]]$points$x) )
          {
            APX[[k]] = list( pick=c(GU$info$yr[inda], GU$info$jd[inda], GU$info$hr[inda], GU$info$mn[inda],
                               GU$info$sec[inda]+GU$info$msec[inda]/1000+Adet[[K]]$points$x[i]  ),
                 kind=i, sta=astn , comp=acomp, col=rgb(.5, .8, .4))
            k = k+1
          }
        
      }
###  YN = PLOT.SEISN(GU, sel=sel, notes = GU$KNOTES[sel])
    
    
    JDAY = getjul(P$LOC$yr, P$LOC$mo , P$LOC$da)
    
    PPX = as.list(1:length(P$STAS$parr[P$STAS$comp=="V"]))
    
    j=1
    for(J in 1:length(P$STAS$parr))	
      {
        if(P$STAS$comp[J]=="V")
          {
            PPX[[j]] = list( pick=c(P$LOC$yr, JDAY, P$LOC$hr, P$LOC$mn, P$STAS$parr[J]), kind="P", sta=P$STAS$name[J] , comp=P$STAS$comp[J], col=rgb(1.0, .3, .4))
            j = j+1
          }
        
      }
    
    
    P$STAS$name[rev(order(P$STAS$parr))]
    
    P$STAS$comp[rev(order(P$STAS$parr))]
    
    order(P$STAS$parr[which(P$STAS$comp=="V")])
    
    
    
    Vsta = P$STAS$name[which(P$STAS$comp=="V")]
    Varr = P$STAS$parr[which(P$STAS$comp=="V")]
    
    osta = Vsta[(order(Varr))]
    msta = match(osta, GU$STNS)
    
    sel = msta 
    
    
    YP = PICK.GEN(GU, sel=sel, APIX=APX, PADDLAB=PADDLAB)
    return(YP)
  }

#########################################################
#########################################################

mattloop<-function(wfiles)
{

  screens(2)
  for(ii in 1:length(wfiles))
    {
      fname = wfiles[ii]
      HH = unlist(strsplit(fname, split="/"))
      Hname = HH[length(HH)]
    
      YP =  read1UW(fname)
      doubt = paste(sep='.', Hname, "HMATT")

      assign(doubt, YP, pos=1, immediate=TRUE)

      ##  PICK.KRAFLA(GU, sel=sel, PF=P)
      save(YP, file=doubt, ascii=TRUE)

      ## locator()
    }
}



#########################################################
#########################################################
###############   source("/home/lees/Progs/R_stuff/mattloop.R")


Xmatt<-function(YP, feq="fileW")
{
if(missing(feq)) { feq="fileW" }
  UN = unlist(YP)
  NUN = names(unlist(YP))

  gUN = grep("stn", NUN)

  jstn = paste(sep="_", UN[gUN], UN[gUN+1])



  ustn = unique( jstn  )


  
  Nall = length(ustn)

  
  N1 = length(YP$DETLINFO)
  NB = length(YP$BRUNINFO)
  

fnam = rep(feq, length=Nall)
  stn=rep(NA, length=Nall)
  
  comp=rep(NA, length=Nall)
  x1=rep(NA, length=Nall)
  y1=rep(NA, length=Nall)
  x2=rep(NA, length=Nall)
  y2=rep(NA, length=Nall)
  x3=rep(NA, length=Nall)
  y3=rep(NA, length =Nall)
  x4=rep(NA, length=Nall)
  y4=rep(NA, length=Nall)
  x5=rep(NA, length=Nall)
  y5=rep(NA, length=Nall)

  tstar0=rep(NA, length=Nall)
  omega0=rep(NA, length=Nall)
  gamma=rep(NA, length=Nall)
  fc=rep(NA, length=Nall)
  alpha=rep(NA, length=Nall)
  wlen = rep(NA, length=Nall)
  suc  = rep(NA, length=Nall)

if(!is.na(YP$DETLINFO[[1]]))
  {

  for(i in 1:N1)
    {
      Z = YP$DETLINFO[[i]]
      n = length(YP$DETLINFO[[i]]$points$x)


      ##  print(Z$stn, Z$comp, paste(YP$DETLINFO[[i]]$points$x) , paste(YP$DETLINFO[[i]]$points$y) )

      x = YP$DETLINFO[[i]]$points$x
      y = YP$DETLINFO[[i]]$points$y

      jstn = paste(sep="_", Z$stn, Z$comp)

      j = match(jstn, ustn)

      
      stn[j] = Z$stn
      comp[j]=Z$comp
      x1[j]=x[1]
      y1[j]=y[1]
      x2[j]=x[2]
      y2[j]=y[2]
      x3[j]=x[3]
      y3[j]=y[3]
      x4[j]=x[4]
      y4[j]=y[4]
      x5[j]=x[5]
      y5[j]=y[5]

    }
}


if(!is.na(YP$BRUNINFO[[1]]))
  {
  for(i in 1:NB)
    {
      if(is.na(YP$BRUNINFO[[i]]))
        {
          
          next
        }
      Z = YP$BRUNINFO[[i]]

      if(Z$BF$SUCCESS==FALSE) { next }
      ##  print(i)
      
       jstn = paste(sep="_", Z$stn, Z$comp)

      j = match(jstn, ustn)
      stn[j] = Z$stn
      comp[j]=Z$comp
      tstar0[j] = Z$BF$tstar0
      omega0[j] = Z$BF$omega0
      gamma[j] = Z$BF$gamma
      fc[j] = Z$BF$fc
      alpha[j] = Z$BF$alpha
      wlen[j] = abs(diff(Z$pwin))
      suc[j] = Z$BF$SUCCESS
      
    }
}


  
  return( data.frame(fnam=fnam, stn=stn, comp=comp,x1=x1,y1=y1,x2=x2,y2=y2,x3=x3,y3=y3,x4=x4,y4=y4,x5=x5,y5=y5,tstar0=tstar0, omega0=omega0,fc=fc,alpha=alpha,wlen=wlen    ))

}

###############   source("/home/lees/Progs/R_stuff/mattloop.R")



