cat("sourcing /home/lees/Progs/R_stuff/radiation.R\n")


## Aki and Richards page 115
# NOsource("radiation.notes")
# source("/home/lees/Progs/R_stuff/radiation.R")
# source("/home/lees/Progs/R_stuff/UWFILES.R")

# source("/home/lees/Progs/R_stuff/net.R")
# source("/home/lees/Progs/R_stuff/SUBS.R")
# source("/home/lees/Progs/R_stuff/sig.R")

# 
# del = dip of fault
# phiS = strike of fault
# lam = rake of fault
# ichi = angle of ray exiting sphere with the nadir (down Z)
# phi = strike of ray from North
# x = north, y=east, z= down

# coso.sta.SMALL = "/home/beer/lees/Coso/Scat_Data/coso.sta.SMALL"
# coso.velfile  = "/home/beer/lees/Coso/Scat_Data/wu_coso.vel"

GLOBAL.UP = TRUE


printmc1<-function(M)
  {
print(paste(sep=" ", "F=", round(M$az1) , round(M$d1) ,  "G=", round(M$az2) , round(M$d2) ,  "U=", round(M$uaz) , round(M$ud) ,  "V=", round(M$vaz) , round(M$vd) ,  "P=", round(M$paz) , round(M$pd)  ,  "T=", round(M$taz) , round(M$td) ))
  }

printmcrak<-function(RAK)
  {
print(paste(sep=" ", "F=", round(RAK$F$az) , round(RAK$F$dip) ,  "G=", round(RAK$G$az) , round(RAK$G$dip) ,  "U=", round(RAK$U$az) , round(RAK$U$dip) ,  "V=", round(RAK$V$az) , round(RAK$V$dip) ,  "P=", round(RAK$P$az) , round(RAK$P$dip)  ,  "T=", round(RAK$T$az) , round(RAK$T$dip) ))
  }



printmc0<-function(M)
  {
print(paste(sep=" ", "F=", M$az1 , M$d1 ,  "G=", M$az2 , M$d2 ,  "U=", M$uaz , M$ud ,  "V=", M$vaz , M$vd ,  "P=", M$paz , M$pd  ,  "T=", M$taz , M$td ))
  }
# source("/home/lees/Progs/R_stuff/radiation.R")

#################################################
seeoneM<-function(pf, stafile=coso.sta.SMALL, velfile=velfile, PLOT=TRUE, ALL=TRUE)
{
  if(missing(stafile)) { stafile = "coso.sta.LLZ" }
  if(missing(velfile)) { velfile = "coso.velfile" }
  if(missing(ALL)) {  ALL=TRUE  }
  if(missing(PLOT)) { PLOT=TRUE }

### ALL = TRUE plot all the stations on the sphere, FALSE=plot only stations with arrivals
  

   system("/bin/rm  MCARD",intern=TRUE)
   cmdM = paste(" ", "grep ^M", pf  , "> MCARD")
   system(cmdM )
   f = system("ls MCARD",intern=TRUE)

   print(paste(" ", pf,f))
  Apf = getpfile(pf)

  
   M = scan(file="MCARD", nmax=1, list(id="", F="", az1=0, d1=0, G="", az2=0, d2=0, U="", uaz=0, ud=0, V="", vaz=0, vd=0, P="", paz=0, pd =0, T="", taz=0, td=0))

#  cmd = paste(" ", "dump_incangle coso.sta.SMALL wu_coso.vel < ", pf,  " > testipol")
   cmd = paste(" ", "dump_incangle ",stafile, velfile,  " < ", pf,  " > testipol") 
  system(cmd)

PTS = scan("testipol", list(name="", lat=0, lon=0,elev=0, strike=0,  dip=0,  rake=0, gaz=0 , angP=0, prad=0, svrad=0, shrad=0, angS=0, prad2=0, svrad2=0, shrad2=0))

Msta = match(Apf$STAS$name[!is.na(Apf$STAS$ppol)],PTS$name)


  ## Msta = match(PTS$name, Apf$STAS$name)

  PTS$pol = rep(NA, length(PTS$name))
 PTS$pol[Msta] = Apf$STAS$ppol[!is.na(Apf$STAS$ppol)]

   if(is.numeric(M$az1))
    {
	print(paste(" ", pf, M$az1[1], M$d1[1], M$az2[1], M$d2[1]   ))
        RAK = MRake(M)
        RAK$name = pf

        if(ALL==TRUE)
          {
        RAK$PTS = list(name=PTS$name, lat=PTS$lat, lon=PTS$lon, elev=PTS$elev, gaz=PTS$gaz, angP=PTS$angP, angS=PTS$angS, pol=PTS$pol)
      }
        else
          {
            RAK$PTS = list(name=PTS$name[Msta], lat=PTS$lat[Msta], lon=PTS$lon[Msta], elev=PTS$elev[Msta], gaz=PTS$gaz[Msta], angP=PTS$angP[Msta], angS=PTS$angS[Msta], pol=PTS$pol[Msta])
          }
    
        ##   m4 = match(c( "CE4", "S4"), PTS$name)
        ##  K4 = !is.na(m4)
         ##  if(K4[1] || K4[2]  ){ alpha=RAK$PTS$angP[m4[K4]]; } else { alpha = 0;}
        
        RAK$UP= GLOBAL.UP
        RAK$evlat = Apf$LOC$lat
        RAK$evlon  = Apf$LOC$lon
        RAK$z  = Apf$LOC$z
        
        # if(alpha>90) 	{ RAK$UP = TRUE} else 	{ RAK$UP= FALSE}

      # print(paste(" ",RAK$pf," RAKE UP = ", RAK$UP, alpha))
      #  plotfoc(RAK)
        
        if(PLOT==TRUE)
          {
            RR = Simplerfoc(RAK)
          }
        invisible(RR)
      }

   else
     {
       print(paste(" ", pf, " Has no Mcard"))
       invisible(NULL)
     }
}

###  source("/home/lees/Progs/R_stuff/radiation.R")

#################################################
see1M<-function(pf, MAP=FALSE)
{
  if(missing(MAP)) { MAP=FALSE }

  cmdM = paste(sep=" ", "dumpangles", pf  , "> DUMPANGS.temp")
  system(cmdM )

  ID = scan(file="DUMPANGS.temp",  nmax=1, what=list(FLG="", id="", sec=0, lat=0 , lon=0, depth=0, mag=0))
  
  AM = scan(file="DUMPANGS.temp", skip=1, nmax=1, what=list(id="",Faz=0, Fpl=0, rake1=0, Gaz=0, Gpl=0, rake2=0,Uaz=0, Upl=0, Vaz=0, Vpl=0, Paz=0,Ppl=0, Taz=0 , Tpl=0))

  M =list(id="", F="", az1=0, d1=0, G="", az2=0, d2=0, U="", uaz=0, ud=0, V="", vaz=0, vd=0, P="", paz=0, pd =0, T="", taz=0, td=0)
  
  M$az1=AM$Faz;M$d1=AM$Fpl;
  M$az2=AM$Gaz;  M$d2=AM$Gpl ;
  M$uaz=AM$Uaz; M$ud=AM$Upl;
  M$vaz=AM$Vaz; M$vd=AM$Vpl;
  M$paz=AM$Paz; M$pd=AM$Ppl;
  M$taz=AM$Taz; M$td=AM$Tpl ;
  

  PPS = scan(file="DUMPANGS.temp", skip=2, what=list(FLG="", name="", az=0, offang=0, pol=""))
  
  if(is.numeric(M$az1))
    {
      print(paste(" ", pf, M$az1[1], M$d1[1], M$az2[1], M$d2[1]   ))
      RAK = MRake(M)
      RAK$name = pf
      RAK$evlat = ID$lat
      RAK$evlon = ID$lon
      RAK$evdep = ID$depth
      JJ = match(PPS$name, stas$name)
      LJ = length(JJ)

      RAK$PTS = list(name=PPS$name, lat=stas$lat[JJ], lon=stas$lon[JJ], elev=stas$z[JJ], gaz=PPS$az, angP=PPS$offang, pol=PPS$pol,   angS=PPS$angS)


      m4 = match(c( "CE4", "S4"), RAK$PTS$name)
      K4 = !is.na(m4)
      if(K4[1] || K4[2]  ){ alpha=RAK$PTS$angP[m4[K4]]; } else { alpha = 0;}
      RAK$UP= GLOBAL.UP
                                        # if(alpha>90){ RAK$UP = TRUE} 	else { RAK$UP = FALSE}

      

                                        # print(paste(" ",RAK$pf," RAKE UP = ", RAK$UP, alpha))
                                        #  plotfoc(RAK)

      if(MAP==TRUE)
        {
          dev.set(which=3)

          
          ####  COSOmap(cmp, EQS=eqs, STA=stas)
          DORAKMAP(RAK, mapfunc=mapfunc)
          
         ####  segments( rep( RAK$evlon , LJ ), rep( RAK$evlat , LJ ), RAK$PTS$lon, RAK$PTS$lat, col=2 )
          
        }
      dev.set(which=2)
      
      RAK = Simplerfoc(RAK)
      
      return(RAK)
    }

  else
    {
      print(paste(" ", pf, " Has no Mcard"))
    }
}
#################################################
Fmotion<-function(RAK)
  {
    t2=.15
    t1=-0.05
    for(i in 1:length(RAK$PTS$name))
      {
        pf = RAK$name
        lchar = nchar(RAK$name)
        rtf = substr(pf, 1, lchar-1)
        wf = paste(sep="", rtf, "W")

        cmd = paste(sep=" ","firstmotion",wf, RAK$name,RAK$PTS$name[i], "SHV", t1, t2, ">firstmot_out")
                                        # print(cmd)
        system(cmd)
        FIN = scan(file="firstmot_out", n=1, list(sps=0))
        FIN$data = scan(file="firstmot_out", skip=1, what=0)
        lx = length(FIN$data)
        if(lx>1)
          {
            siz = 2*0.12
            FX = SHFTNSCALE(1:lx, RAK$PTS$EQP$x[i]+siz,1,lx ,siz)
            siz = 2*0.08
            FY =  SHFTNSCALE(FIN$data,  RAK$PTS$EQP$y[i],min(FIN$data), max(FIN$data), siz)

            lines(FX, FY)
          }

      }    




  }
# source("/home/lees/Progs/R_stuff/radiation.R")
########
seeMech<-function(pf, stafile=coso.sta.SMALL, velfile=velfile, PLOT=TRUE, ...)
{
  if(missing(stafile)) { stafile = "coso.sta.LLZ" }
  if(missing(velfile)) { velfile = "coso.velfile" }
  if(missing(PLOT)) { PLOT=TRUE }
  
  
  RAK = seeoneM(pf, stafile=stafile, velfile=velfile, PLOT=PLOT, ...)
  
  invisible(RAK)
  
}


##########
seeALLcosoM<-function(Mpf)
{
###   provide a list of Pickfile names
 for(i in 1:length(Mpf))
 {
pfile = Mpf[i]
a1 = getUWwin(pfile)
  
dev.set(which=2)

# COSOmap(cmp)
COSOmap(cmp, EQS=eqs, STA=stas)

points(c(a1$evlo[1], a1$stlo[1]),c(a1$evla[1], a1$stla[1] ), pch=c(8,6) )
lines(c(a1$evlo[1], a1$stlo[1]),c(a1$evla[1], a1$stla[1] ), col=2 )


   dev.set(which=3)

   seeoneM(pfile)
  # G = PPLOT(Mpf[i])	
   locator(1)
  }
}
##########
seeALLM<-function(Mpf, eqs=eqs, stas=stas)
{
###   provide a list of Pickfile names
 for(i in 1:length(Mpf))
 {
pfile = Mpf[i]
a1 = getUWwin(pfile)
  
dev.set(which=2)

# COSOmap(cmp)
COSOmap(cmp, EQS=eqs, STA=stas)

points(c(a1$evlo[1], a1$stlo[1]),c(a1$evla[1], a1$stla[1] ), pch=c(8,6) )
lines(c(a1$evlo[1], a1$stlo[1]),c(a1$evla[1], a1$stla[1] ), col=2 )


   dev.set(which=3)

   seeoneM(pfile)
  # G = PPLOT(Mpf[i])	
   locator(1)
  }
}





############### seeALLM(Mpf)

PPLOT<-function(pf, stafile=coso.sta.SMALL, velfile=velfile)
 {
 if(missing(stafile)) { stafile = "coso.sta.LLZ" }
  if(missing(velfile)) { velfile = "coso.velfile" }


   
   system("/bin/rm  MCARD",intern=TRUE)
   cmdM = paste(" ", "grep ^M", pf  , "> MCARD")
   system(cmdM )
   f = system("ls MCARD",intern=TRUE)

   print(paste(" ", pf,f))
c2 = paste(sep="", "/home/lees/Progs/Perl/getUW_AM.prl ", pf," | head -2 > oneAM")
   print(c2)

  #  source(c2)
  #   source('geotouch  org.scat coso_station.online  null -F oneAM' )



   M = scan(file="MCARD", nmax=1, list(id="", F="", az1=0, d1=0, G="", az2=0, d2=0, U="", uaz=0, ud=0, V="", vaz=0, vd=0, P="", paz=0, pd =0, T="", taz=0, td=0))

#  cmd = paste(" ", "dump_incangle ",coso.sta.SMALL, coso.velfile,  " < ", pf,  " > testipol")
   cmd = paste(" ", "dump_incangle ",stafile,  velfile,  " < ", pf,  " > testipol") 
system(cmd)

PTS = scan("testipol", list(name="", lat=0, lon=0,elev=0, strike=0,  dip=0,  rake=0, gaz=0 , angP=0, prad=0, svrad=0, shrad=0, angS=0, prad2=0, svrad2=0, shrad2=0))


	print(paste(" ", pf, M$az1[1], M$d1[1], M$az2[1], M$d2[1]   ))
        RAK = MRake(M)
        RAK$name = pf
        RAK$PTS = list(name=PTS$name, lat=PTS$lat, lon=PTS$lon, elev=PTS$elev, gaz=PTS$gaz, angP=PTS$angP, angS=PTS$angS)

        m4 = match(c( "CE4", "S4"), PTS$name)
        K4 = !is.na(m4)
        if(K4[1] || K4[2]  ){ alpha=RAK$PTS$angP[m4[K4]]; } else { alpha = 0;}

	RAK$UP= GLOBAL.UP
        # if(alpha>90) { RAK$UP = TRUE} 	else 	{ RAK$UP= FALSE}



# print(paste(" ",RAK$pf," RAKE UP = ", RAK$UP, alpha))

radiateP(RAK )
focpoint(RAK$PTS$gaz, RAK$PTS$angP,  lab=RAK$PTS$name, UP=RAK$UP)

# print(paste(" ", "P=", RAK$P$az, RAK$P$dip, "T=", RAK$T$az, RAK$T$dip))

focpoint(RAK$P$az, RAK$P$dip,  lab="P", UP=RAK$UP)
focpoint(RAK$T$az, RAK$T$dip,  lab="T", UP=RAK$UP)

RAK$UP= GLOBAL.UP


# print(paste(" ",RAK$pf," RAKE UP = ", RAK$UP, alpha))

radiateP(RAK)
focpoint(RAK$PTS$gaz, RAK$PTS$angP,  lab=RAK$PTS$name, UP=RAK$UP)

# print(paste(" ", "P=", RAK$P$az, RAK$P$dip, "T=", RAK$T$az, RAK$T$dip))

focpoint(RAK$P$az, RAK$P$dip,  lab="P", UP=RAK$UP)
focpoint(RAK$T$az, RAK$T$dip,  lab="T", UP=RAK$UP)




return(list(RAK=RAK, M=M))

}
##############################
get.ref.file<-function()
  {


  }
#################################################
##############################
plotfoc<-function(RAK)
{
par(mfrow=c(3,1))

radiateP(RAK )

if(length(RAK$PTS)>0)
  {
    focpoint(RAK$PTS$gaz, RAK$PTS$angP,  lab=RAK$PTS$name, UP=RAK$UP)
  }
# print(paste(" ", "P=", RAK$P$az, RAK$P$dip, "T=", RAK$T$az, RAK$T$dip))
focpoint(RAK$P$az, RAK$P$dip,  lab="P", UP=RAK$UP)
focpoint(RAK$T$az, RAK$T$dip,  lab="T", UP=RAK$UP)

# dev.set(which = dev.next())
radiateSV(RAK )
if(length(RAK$PTS)>0)
  {
focpoint(RAK$PTS$gaz, RAK$PTS$angS,  lab=RAK$PTS$name, UP=RAK$UP)
}
# dev.set(which = dev.next())
radiateSH(RAK )
if(length(RAK$PTS)>0)
  {
focpoint(RAK$PTS$gaz, RAK$PTS$angS,  lab=RAK$PTS$name, UP=RAK$UP)
}
}

#################################################
##############################
Simplefoc<-function(RAK)
{

radiateP(RAK )

fpoint(RAK$PTS$gaz, RAK$PTS$angP,  lab=RAK$PTS$name, UP=RAK$UP)
print(paste(" ", "RAKE", RAK$rake1, RAK$dipaz1))
print(paste(" ", "P=", RAK$P$az, RAK$P$dip, "T=", RAK$T$az, RAK$T$dip))
focpoint(RAK$P$az, RAK$P$dip,  lab="P", UP=RAK$UP)
focpoint(RAK$T$az, RAK$T$dip,  lab="T", UP=RAK$UP)
}
#################################################
# source("/home/lees/Progs/R_stuff/radiation.R")

Simplerfoc<-function(RAK)
{
                                        # net(1)
  C = circle()
  plot(C$x,C$y, type='n', axes=FALSE, asp=1, xlab="", ylab="")
  lines(C$x,C$y, type='l')

                                        #circ.tics()

  COL = rep(gray(.7), length(RAK$PTS$gaz))
  PCH = rep(16, length(RAK$PTS$gaz))

  COL[RAK$PTS$pol=="U"]=4
  PCH[RAK$PTS$pol=="U"]=22
  COL[RAK$PTS$pol=="D"]=2
  PCH[RAK$PTS$pol=="D"]=16
  COL[RAK$PTS$pol=="X"]=3
  PCH[RAK$PTS$pol=="X"]=4
  COL[RAK$PTS$pol=="-"]=3
  PCH[RAK$PTS$pol=="-"]=4

  pax = focpoint(RAK$P$az, RAK$P$dip,  lab="P", UP=RAK$UP, PLOT=FALSE)
  
  PLS = polyfoc(RAK$az1, RAK$dip1, RAK$az2, RAK$dip2)
  POK = list(x=PLS$Px, y =PLS$Py)
  kin = inpoly(pax$x, pax$y,POK)

  if(kin==0)
    {
      polygon(PLS$Px, PLS$Py, col=gray(0.95) )
    }else
  {
    polygon(C$x,C$y, col=gray(0.95) )
    polygon(PLS$Px, PLS$Py, col=gray(1) )
  }

  QP = qpoint(RAK$PTS$gaz, RAK$PTS$angP,  col=COL , pch=PCH , lab=RAK$PTS$name, POS=4, UP=RAK$UP, PLOT=TRUE)
  #  qpoint(RAK$PTS$gaz, RAK$PTS$angP,  col=COL , pch=PCH , lab=RAK$PTS$pol, POS=2, UP=RAK$UP)
 

                                        # print(paste(" ", "P=", RAK$P$az, RAK$P$dip, "T=", RAK$T$az, RAK$T$dip))
  focpoint(RAK$P$az, RAK$P$dip,  lab="P", UP=RAK$UP)
  focpoint(RAK$T$az, RAK$T$dip,  lab="T", UP=RAK$UP)

  focpoint(RAK$V$az, RAK$V$dip,  lab="V", UP=RAK$UP)
  focpoint(RAK$U$az, RAK$U$dip,  lab="U", UP=RAK$UP)
  if(RAK$UP==TRUE)
    {
      subtit = paste("Upper Hemisphere")
    }else
  {subtit = paste("Lower Hemisphere")
 }
  # Plot.Planes(RAK)


  u = par("usr")
  
  dy = (u[4]-u[3]) * 0.038
  dx = (u[2]-u[1]) * 0.038
  points(u[1]+dx,u[3]+dy, pch=22, col=4)
  text(u[1]+dx,u[3]+dy,labels="UP Polarity", col=4, pos=4)
  
   points(u[1]+dx,u[3]+2*dy, pch=16, col=2)
  text(u[1]+dx,u[3]+2*dy,labels="Down Polarity", col=2, pos=4)
 
  
  
  title(main=RAK$name, sub=paste(subtit))
  RAK$PTS$EQP = QP
  return(RAK)
}
#################################################
SHFTNSCALE<-function(x,x1, minx, maxx, siz)
{
  nx = (x1-siz/2)+siz*(x-minx)/(maxx-minx)
  return(nx)
}

########
PLfoc<-function(x1, y1, siz,  GF, COL=gray(0.95)  )
  {
    minx = -1
    maxx = 1

    if(missing(COL)) { COL=gray(0.95); }
    fi = par("pin")
    u = par("usr")
    
    sizx = siz*((u[2]-u[1])/fi[1])
    sizy  =  siz*((u[4]-u[3])/fi[2])

    C = GF$C
    kin = GF$kin
    # plot(C$x,C$y, type='n', axes=FALSE, asp=1, xlab="", ylab="")
    
     lines(SHFTNSCALE(C$x,x1, minx, maxx, sizx),SHFTNSCALE(C$y,y1, minx, maxx, sizy), type='l')


  if(kin==0)
    {
       polygon(SHFTNSCALE(C$x,x1, minx, maxx, sizx),SHFTNSCALE(C$y,y1, minx, maxx, sizy), col=gray(1))
   
      polygon(SHFTNSCALE(GF$PLS$Px,x1, minx, maxx, sizx), SHFTNSCALE(GF$PLS$Py,y1, minx, maxx, sizy), col=COL)

    
    }else
  {
    polygon(SHFTNSCALE(C$x,x1, minx, maxx, sizx),SHFTNSCALE(C$y,y1, minx, maxx, sizy), col=COL )
   
     polygon(SHFTNSCALE(GF$PLS$Px,x1, minx, maxx, sizx), SHFTNSCALE(GF$PLS$Py,y1, minx, maxx, sizy), col=gray(1))

  
  }

    

   #  points(SHFTNSCALE(GF$qp$x,x1, minx, maxx, sizx), SHFTNSCALE(GF$qp$y,y1, minx, maxx, sizy), col=GF$COL , pch=GF$PCH )
   #  text(SHFTNSCALE(GF$qp$x,x1, minx, maxx, sizx), SHFTNSCALE(GF$qp$y,y1, minx, maxx, sizy), col=GF$COL , labels=GF$qlabs, pos=4)
    
    # points(GF$fP$x, GF$fP$y, col=1,  pch=1 )
  #   text( SHFTNSCALE(GF$fP$x,x1, minx, maxx, sizx), SHFTNSCALE(GF$fP$y,y1, minx, maxx, sizy), labels="P")
   #  text( SHFTNSCALE(GF$fT$x,x1, minx, maxx, sizx), SHFTNSCALE(GF$fT$y,y1, minx, maxx, sizy), labels="T")
   #   text( SHFTNSCALE(GF$fU$x,x1, minx, maxx, sizx), SHFTNSCALE(GF$fU$y,y1, minx, maxx, sizy), labels="U")
   #  text( SHFTNSCALE(GF$fV$x,x1, minx, maxx, sizx), SHFTNSCALE(GF$fV$y,y1, minx, maxx, sizy), labels="V")
   
   # lines(SHFTNSCALE(GF$PLS$LP1$x,x1, minx, maxx, sizx), SHFTNSCALE(GF$PLS$LP1$y,y1, minx, maxx, sizy), col=GF$PLS$col1)
   # lines(SHFTNSCALE(GF$PLS$LP2$x,x1, minx, maxx, sizx), SHFTNSCALE(GF$PLS$LP2$y,y1, minx, maxx, sizy), col=GF$PLS$col2)

    return(list(sx=sizx, sy=sizy))
  
    
  }
#################################################
#### source("/home/lees/Progs/R_stuff/radiation.R")

Calcfoc<-function(RAK, PLOT=FALSE)
{
                                        # net(1)
  if(missing(PLOT)) { PLOT=TRUE }
  
  C = circle()
  COL = rep(2, length(RAK$PTS$gaz))
  PCH = rep(16, length(RAK$PTS$gaz))

  COL[RAK$PTS$pol=="U"]=4
  PCH[RAK$PTS$pol=="U"]=22


  if(PLOT==TRUE)
    {
      
      plot(C$x,C$y, type='n', axes=FALSE, asp=1, xlab="", ylab="")
      lines(C$x,C$y, type='l')
      if(RAK$UP==TRUE)
        {
          subtit = paste("Upper Hemisphere")
        }
      else
        {
          subtit = paste("Lower Hemisphere")
        }
       title(main=RAK$name, sub=paste(subtit))
      
      
    }
  qp = qpoint(RAK$PTS$gaz, RAK$PTS$angP,  col = COL , pch=PCH , lab=RAK$PTS$name, UP=RAK$UP, PLOT=FALSE)                                        #circ.tics()
                                        # print(paste(" ", "P=", RAK$P$az, RAK$P$dip, "T=", RAK$T$az, RAK$T$dip))
  fP = focpoint(RAK$P$az, RAK$P$dip,  lab="P", UP=RAK$UP, PLOT=FALSE)
  fT = focpoint(RAK$T$az, RAK$T$dip,  lab="T", UP=RAK$UP, PLOT=FALSE)

  fV = focpoint(RAK$V$az, RAK$V$dip,  lab="V", UP=RAK$UP, PLOT=FALSE)
  fU = focpoint(RAK$U$az, RAK$U$dip,  lab="U", UP=RAK$UP, PLOT=FALSE)
                                        # PLS = Plot.Planes(RAK)
  pax = focpoint(RAK$P$az, RAK$P$dip,  lab="P", UP=RAK$UP, PLOT=FALSE)
  
  PLS = polyfoc(RAK$az1, RAK$dip1, RAK$az2, RAK$dip2, PLOT=FALSE)
  
  POK = list(x=PLS$Px, y =PLS$Py)
  kin = inpoly(pax$x, pax$y,POK)
  
 
  return(list(evlat=RAK$evlat,  evlon=RAK$evlon, C=C, COL=COL, PCH=PCH, qp=qp, qlabs=RAK$PTS$name, PLS=PLS, fP=fP, fT=fT, fU=fU, fV=fV, kin=kin))
}
#####################
radP<-function( del, phiS, lam, ichi, phi)
{

#  convert all angles to radians
deg2rad = pi/180

lam = deg2rad*lam
del = deg2rad*del
phiS = deg2rad*phiS
ichi = deg2rad*ichi
phi  = deg2rad*phi

phidif  = phi - phiS
Fp = cos(lam)*sin(del)*sin(ichi)*sin(ichi)*sin(2*phidif)-cos(lam)*cos(del)*sin(2*ichi)*cos(phidif)+ sin(lam)*sin(2*del)*(cos(ichi)*cos(ichi)-sin(ichi)*sin(ichi)*sin(phidif)*sin(phidif))+sin(lam)*cos(2*del)*sin(2*ichi)*sin(phidif)

return(Fp)

}

radSV<-function( del, phiS, lam, ichi, phi)
{

#  convert all angles to radians
deg2rad = pi/180

lam = deg2rad*lam
del = deg2rad*del
phiS = deg2rad*phiS
ichi = deg2rad*ichi
phi  = deg2rad*phi

phidif  = phi - phiS

A1 = sin(lam)*cos(2*del)*cos(2*ichi)*sin(phidif)
A2 = cos(lam)*cos(del)*cos(2*ichi)*cos(phidif)
A3 = 0.5*cos(lam)*sin(del)*sin(2*ichi)*sin(2*phidif)
A4 = 0.5*sin(lam)*sin(2*del)*sin(2*ichi)*(1+(sin(phidif)*sin(phidif)))


FSV = A1 -A2 +A3 -A4


#  FSV = (sin(lam)*cos(2*del)*cos(2*ichi)*sin(phidif)-cos(lam)*cos(del)*cos(2*ichi)*cos(phidif)+ 0.5*cos(lam)*sin(del)*sin(2*ichi)*sin(2*phidif)-0.5*sin(lam)*sin(2*del)*sin(2*ichi)*(1+(sin(phidif)*sin(phidif))))

return(FSV)

}

radSH<-function( del, phiS, lam, ichi, phi)
{

#  convert all angles to radians
deg2rad = pi/180

lam = deg2rad*lam
del = deg2rad*del
phiS = deg2rad*phiS
ichi = deg2rad*ichi
phi  = deg2rad*phi

phidif  = phi - phiS
FSH = cos(lam)*cos(del)*cos(ichi)*sin(phidif)+cos(lam)*sin(del)*sin(ichi)*cos(2*phidif)+ sin(lam)*cos(2*del)*cos(ichi)*cos(phidif)-0.5*sin(lam)*sin(2*del)*sin(ichi)*sin(2*phidif)

return(FSH)

}
################################
Plot.Planes<-function(RAK)
{
  #  planes are already in strike and dip format
LP1 = lowplane( RAK$az1, RAK$dip1, col=1, UP=RAK$UP)
LP2 = lowplane( RAK$az2, RAK$dip2, col=3, UP=RAK$UP)
return(list(LP1=LP1, col1=1, LP2=LP2, col2=3))
}
################################
Plot.UWPlanes<-function(M)
{
  # on Mcard az1 = down dip azimuth, dip = dip from horizontal
lowplane( M$az1+90, M$d1, col=4, UP=TRUE)
lowplane( M$az2+90, M$d2, col=4, UP=TRUE)
}
################################

##############################
radiateP<-function(RAK, SCALE=FALSE, col=col)
{
  if(missing(SCALE)) { SCALE=FALSE }
  if(missing(col)) { col=heat.colors(20) }

  updown = "Lower"
  if(RAK$UP==TRUE) { updown = " Upper" } else { updown = " Lower" }

  imageP(RAK$az1, RAK$dip1, RAK$rake1, SCALE=SCALE, UP=RAK$UP, col=col )

  net(0)
  Plot.Planes(RAK)
  title(main=paste(" ", "P-wave",RAK$name, updown) ,
        sub=paste(sep="", "dip=", RAK$dip1, " strike=",
          RAK$az1, " rake=", format.default(RAK$rake1, digits=3) ))
}
#######
radiateSV<-function(RAK, SCALE=FALSE, col=col)
{
  if(missing(SCALE)) { SCALE=FALSE }
   if(missing(col)) { col=heat.colors(20) }

  updown = "Lower"
  if(RAK$UP==TRUE) { updown = " Upper" } else { updown = " Lower" }

  imageSV(RAK$az1, RAK$dip1, RAK$rake1, SCALE=SCALE, UP=RAK$UP, col=col )
  net(0)

  # Plot.Planes(RAK)

  title(main=paste(" ", "SV-wave",RAK$name, updown),
        sub=paste(sep="", "dip=", RAK$dip1, " strike=",
          RAK$az1, " rake=", format.default(RAK$rake1, digits=3)))

}
#######
radiateSH<-function(RAK, SCALE=FALSE, col=col)
{
  if(missing(SCALE)) { SCALE=FALSE }
   if(missing(col)) { col=heat.colors(20) }

  updown = "Lower"

  if(RAK$UP==TRUE){updown = " Upper"} else {updown = " Lower"}

  imageSH(RAK$az1, RAK$dip1, RAK$rake1, SCALE=SCALE, UP=RAK$UP, col=col )
  net(0)
  # Plot.Planes(RAK)
  title(main=paste(" ", "SH-wave",RAK$name, updown),
        sub=paste(sep="", "dip=", RAK$dip1, " strike=",
          RAK$az1, " rake=", format.default(RAK$rake1, digits=3)))
}


##############################
imageP<-function(phiS, del , lam, SCALE=FALSE, UP=FALSE, col=NULL )
{
  #  Based on Aki and Richards convention figure 4.20 p. 114 2nd edition
  #  del = dip of plane from horizontal (face in direction of strike)
  #  phiS = strike of plane from north
  #  lam = rake of slip measured from strike horizontal
  #  x = north, y = east, z=down
  
if(missing(SCALE)) { SCALE=FALSE }
if(missing(col)) { col=heat.colors(20) }

if(missing(UP)) { UP=FALSE }

x = seq(-1, 1, 0.01)
y = x

X = matrix(rep(x, length(y)), nrow= length(x))
Y = t(X)

p = rad2deg*(pi/2 -atan2(Y, X))
p[p<0] = p[p<0] + 360

R = sqrt(X^2+Y^2)
R[R>1] = NaN

dip =rad2deg*2*asin(R/sqrt(2))

if(UP==TRUE) { dip = 180-dip }
G = radP( del, phiS, lam, dip, p)
image(x,y,G, col = col,asp=1, xlab='', ylab='', axes=FALSE )
if(SCALE==TRUE) { image.SCALE( G,  col = col , x=1.1,  labels="breaks" ,  nlab=10 ) }

}

imageSV<-function( phiS, del, lam, SCALE=FALSE, UP=FALSE, col=NULL )
{
if(missing(SCALE)) { SCALE=FALSE }
if(missing(UP)) { UP=FALSE }
if(missing(col)) { col=heat.colors(20) }

x = seq(-1, 1, 0.01)
y = x

X = matrix(rep(x, length(y)), nrow= length(x))
Y = t(X)

p = rad2deg*(pi/2 - atan2(Y, X))
p[p<0] = p[p<0] + 360

R = sqrt(X^2+Y^2)
R[R>1] = NaN
dip =rad2deg*2*asin(R/sqrt(2))

if(UP==TRUE) { dip = 180-dip }
G = radSV( del, phiS, lam, dip, p)
image(x,y,G, col = col, asp=1,  xlab='', ylab='', axes=FALSE )
if(SCALE==TRUE) { image.SCALE( G, col = col, x=1.1,  labels="breaks" , nlab=10) }

}

imageSH<-function( phiS, del, lam, SCALE=FALSE, UP=FALSE, col=NULL )
{
if(missing(SCALE)) { SCALE=FALSE }
if(missing(UP)) { UP=FALSE }
if(missing(col)) { col=heat.colors(20) }

x = seq(-1, 1, 0.01)
y = x

X = matrix(rep(x, length(y)), nrow= length(x))
Y = t(X)

p = rad2deg*(pi/2 -atan2(Y, X))
p[p<0] = p[p<0] + 360

R = sqrt(X^2+Y^2)
R[R>1] = NaN
dip =rad2deg*2*asin(R/sqrt(2))

if(UP==TRUE) { dip = 180-dip }
G = radSH( del, phiS, lam, dip, p)
image(x,y,G, col = col,asp=1,  xlab='', ylab='', axes=FALSE )
if(SCALE==TRUE) { image.SCALE( G, col = col, x=1.1, labels="breaks", nlab=10) }

}
############################################
##############################


############################################

mc2cart<-function(az, dip)
{
   DEG2RAD = pi/180;
    azrad = az * DEG2RAD;
    diprad = dip * DEG2RAD;
    z = sin (diprad);
    temp = cos(diprad);
    x = cos(azrad) * temp;
    y = sin(azrad) * temp;
    return(list(x=x, y=y, z=z))
}
GetRakeSense<-function(uaz, upl, vaz,  vpl , paz,  ppl,  taz, tpl)
{
    A1 = mc2cart(uaz, upl);
    A2 = mc2cart(vaz, vpl);
  x1=  A1$x;
  y1 = A1$y;
  z1 = A1$z;

  x2 = A2$x;
  y2 = A2$y;
  z2 = A2$z;

    x3 = x1+x2;
    y3 = y1+y2;
    z3 = z1+z2;
    A1 = mc2cart(paz, ppl);
    A2 = mc2cart(taz, tpl);
  x1=A1$x;
  y1 = A1$y;
  z1 = A1$z;

  x2 = A2$x;
  y2 = A2$y;
  z2 = A2$z;



    dprodp =  (x1*x3+y1*y3+z1*z3)/(sqrt(x1*x1+y1*y1+z1*z1)*sqrt(x3*x3+y3*y3+z3*z3));
    dprodt =  (x2*x3+y2*y3+z2*z3)/(sqrt(x2*x2+y2*y2+z2*z2)*sqrt(x3*x3+y3*y3+z3*z3));

    
      if(dprodt>dprodp)	{  ang2 = 1.0; }   else { ang2 = -1.0;}

      return(ang2);

}

##############################
#############
##### GetRake( 275, 70,  35, 35, 1)
#####GetRake(345.000000, 25.000000, 122.000000, 71.000000, 1)


MRake<-function(M)
{
ang2 = GetRakeSense(M$uaz, M$ud, M$vaz, M$vd, M$paz, M$pd, M$taz, M$td)

RAK = GetRake(M$az1-90, M$d1,   M$az2-90,  M$d2, ang2)

RAK$P = list(az=M$paz, dip=M$pd)
RAK$T = list(az=M$taz, dip=M$td)

RAK$U = list(az=M$uaz, dip=M$ud)
RAK$V = list(az=M$vaz, dip=M$vd)

RAK$F = list(az=M$az1, dip=M$d1)
RAK$G = list(az=M$az2, dip=M$d2)

RAK$M = M
return(RAK)

}
# source("/home/lees/Progs/R_stuff/net.R")
# source("/home/lees/Progs/R_stuff/radiation.R")
SetMech<- function(RAK)
{
mec = CONVERTSDR(RAK$az1, RAK$dip1, RAK$rake1)
RAK$M = mec$M

printmc0(RAK$M)
printmcrak(RAK)

return(RAK)
}

GetRake<- function( az1, dip1, az2, dip2,  dir)
{
# az1=345; dip1=25; az2=122; dip2=71 ;

#   float *dipaz1,float *rake1,float *dipaz2,float *rake2
# /* 
# c J.C. Pechmann, July 1986
#     converted to C and modified  J.M.Lees Sept. 1994
# c
# c Rakcal calculates dip azimuths (dipaz1,dipaz2) and rake angles (rake1,rake2)
# c for a focal mechanism from the strike azimuths (az1,az2) and dips (dip1,dip2)
# c of the planes.  The strike azimuths must be in degrees measured clockwise from
# c north, with the nodal plane dipping down to the right of the strike direction.
# c Dip angles must be in degrees measured downward from the horizontal. Set 
# c dir= +1.0 if the faulting has a reverse component to it and set dir= -1.0
# c if the faulting has a normal component to it.  For strike-slip faulting, set
# c dir= +1.0 if the plane with the smaller strike azimuth is right lateral.
# c All angles returned by this subroutine are in degrees.
# c
# c
# c   
#   Calculate dip azimuths in degrees
# */

#  double rdip1,raz2, rdip2, rdipd1,rdipd2;
#  double zslip1, hslip1, yslip1, xslip1, zslip2;
#   double hslip2, yslip2, xslip2, zstrk1, ystrk1;
#   double raz1, xstrk1, zstrk2, ystrk2, xstrk2;
#    double dot1, dot2;     

DEG2RAD = pi/180
# print(paste(sep=" ", "in GetRake: plane 1", az1, dip1, "plane 2: ", az2, dip2,  "dir=",dir))
      dipaz1= az1 + 90.0;
#dipaz1= az1 - 90.0;
      if (dipaz1 >= 360.0) { dipaz1= dipaz1- 360.0; }
      dipaz2 = az2 + 90.0;
#dipaz2 = az2 - 90.0;
      if (dipaz2 >= 360.0) { dipaz2= dipaz2- 360.0; }

# /*     Convert angles to radians*/
      raz1=   az1*DEG2RAD;
      rdip1=  dip1*DEG2RAD;
      raz2=   az2*DEG2RAD;
      rdip2=  dip2*DEG2RAD;
      rdipd1= dipaz1*DEG2RAD;
      rdipd2= dipaz2*DEG2RAD;
# /*     Determine Cartersian coordinates for slip vectors (upper hemisphere)*/
      zslip1= cos(rdip2);
      hslip1= sin(rdip2);
      yslip1= hslip1*cos(rdipd2);
      xslip1= hslip1*sin(rdipd2);
      zslip2= cos(rdip1);
      hslip2= sin(rdip1);
      yslip2= hslip2*cos(rdipd1);
      xslip2= hslip2*sin(rdipd1);
#   
# /*     Determine Cartesian coordinates for unit vectors in the strike direction
# c     of each plane*/
      zstrk1= 0.0;
      ystrk1= cos(raz1);
      xstrk1= sin(raz1);
      zstrk2= 0.0;
      ystrk2= cos(raz2);
      xstrk2= sin(raz2);

# /*     Determine rake angles by taking dot products between slip vectors and
# c     strike vectors and then taking the inverse cosine*/

      dot1= xslip1*xstrk1 + yslip1*ystrk1 + zslip1*zstrk1;
      dot2= xslip2*xstrk2 + yslip2*ystrk2 + zslip2*zstrk2;

        if(dot1>1.0) { dot1 = 1.0; }

        if(dot1<(-1.0)) { dot1=-1.0; }

        if(dot2>1.0)  { dot2 = 1.0;}
        if(dot2<(-1.0) ) { dot2=-1.0;}

      rake1= acos(dot1)/DEG2RAD;
      rake2= acos(dot2)/DEG2RAD;
# /*     Adjust rake angles to match the Aki and Richards (p.106) sign convention.
# c     According to this convention, the rake angle is the angle between the
# c     direction of movement of the hanging wall and the strike direction of the
# c     footwall.  The sign is determined by the direction of movement of the
# c     hanging wall relative to the footwall, where up is defined as being 
# c     positive.  Thus, if the faulting has a reverse component to it, the rake
# c     angle is between 0 and 180 degrees.  If the faulting has a normal compo-
# c     nent to it, the angle is between 0 and -180 degrees.  For strike-slip 
# c     faulting, the hanging wall is defined as the right-hand block as viewed by
# c     an observer looking along the strike.  Thus, a left-lateral strike slip 
# c     fault has a rake angle of 0 and a right-lateral strike-slip fault has a
# c     rake angle of 180.*/
      if (dir<0) rake1= rake1- 180.0;
      if (dir<0) rake2= rake2- 180.0;
      if (rake1==(-180.0)) rake1= 180.0;
      if (rake2==(-180.0)) rake2= 180.0;






return(list(az1=az1, dip1=dip1, az2=az2, dip2=dip2,  dir=dir, rake1=rake1, dipaz1=dipaz1, rake2=rake2, dipaz2=dipaz2))
}


####################################
plotfocPAPER<-function(RAK, SCALE=FALSE, col=rainbow(20) )
{
  if(missing(SCALE)) { SCALE=FALSE }

  
  pf = RAK$name
  cmd = paste(" ", "dump_incangle ",coso.sta.SMALL, coso.velfile,  " < ", pf,  " > testipol") 
  system(cmd)

  PTS = scan("testipol", list(name="", lat=0, lon=0,elev=0, strike=0,  dip=0,
    rake=0, gaz=0 , angP=0, prad=0, svrad=0, shrad=0, angS=0, prad2=0, svrad2=0, shrad2=0))

  par(mfrow=c(3,1))

  radiateP(RAK, SCALE=SCALE, col=col )

  qpoint(RAK$PTS$gaz, RAK$PTS$angP,  lab=RAK$PTS$name, UP=RAK$UP)
                                        # print(paste(" ", "P=", RAK$P$az, RAK$P$dip, "T=", RAK$T$az, RAK$T$dip))
  focpoint(RAK$P$az, RAK$P$dip,  lab="P", UP=RAK$UP)
  focpoint(RAK$T$az, RAK$T$dip,  lab="T", UP=RAK$UP)

  qpoint(PTS$gaz, PTS$angP,  lab=PTS$name, UP=RAK$UP)


                                        # dev.set(which = dev.next())
  radiateSV(RAK, SCALE=SCALE, col=col )
  qpoint(PTS$gaz, PTS$angS,  lab=PTS$name, UP=RAK$UP)

                                        # dev.set(which = dev.next())
  radiateSH(RAK, SCALE=SCALE, col=col )
  qpoint(PTS$gaz, PTS$angS,  lab=PTS$name, UP=RAK$UP)
  
#  phiS, del , lam
  
#  G = radP( del, phiS, lam, dip, p)
  
  phiS=RAK$az1
  del=RAK$dip1
  lam=RAK$rake1
  
  GP = radP( del, phiS, lam , PTS$angP, PTS$gaz)
  GSV = radSV( del, phiS, lam , PTS$angS, PTS$gaz)
  GSH = radSH( del, phiS, lam , PTS$angS, PTS$gaz)

  return(list(GP=GP, GSV=GSV, GSH=GSH))

}
####################################
radiationRATIO<-function(RAK )
{
 
  
  pf = RAK$name
  cmd = paste(" ", "dump_incangle ",coso.sta.SMALL, coso.velfile,  " < ", pf,  " > testipol") 
  system(cmd)

  PTS = scan("testipol", list(name="", lat=0, lon=0,elev=0, strike=0,  dip=0,
    rake=0, gaz=0 , angP=0, prad=0, svrad=0, shrad=0, angS=0, prad2=0, svrad2=0, shrad2=0))


  phiS=RAK$az1
  del=RAK$dip1
  lam=RAK$rake1
  
  GP = radP( del, phiS, lam , PTS$angP, PTS$gaz)
  GSV = radSV( del, phiS, lam , PTS$angS, PTS$gaz)
  GSH = radSH( del, phiS, lam , PTS$angS, PTS$gaz)

  return(list(GP=GP, GSV=GSV, GSH=GSH))

}


