
 cat("sourcing /home/lees/Progs/R_stuff/sig.R\n")
#####  to get this to work need to execute these commands for
#####   dynamics loading of software
##### cd /home/lees/Progs/Rc
##### R CMD SHLIB MTAPSRC.o
##### R CMD SHLIB LLNfilt.o
##### R CMD SHLIB GetCornerFreq.o
##### dyn.load("/home/lees/Progs/Rc/MTAPSRC.so")

## add in the compiled C-code
## dyn.load("/home/lees/Progs/Rc/LLNfilt.so")
## dyn.load("/home/lees/Progs/Rc/GetCornerFreq.so")
## dyn.load("/home/lees/Progs/Rc/MTAPSRC.so")


###  source("/home/lees/Progs/R_stuff/sig.R")
###
###  
lot<-function(x,y){
 	plot(x,y,type='l')
 }
jot<-function(x){
  
 	plot(seq(0,length=length(x$y), by=x$dt) ,x$y, type='l', xlab='time,s')
 }
### ########################################## 
###  source("/home/lees/Progs/R_stuff/sig.R")
zlot<-function(x, dt)
{
  t = dt*seq(1:length(x))
 	plot(t, x,type='l')
        L = locator(2)
        y = x[t>=L$x[1]&t<=L$x[2]]
  plot(t[t>=L$x[1]&t<=L$x[2]], y, type='l')
        return(y)
 }
### ########################################## 
###  source("/home/lees/Progs/R_stuff/sig.R")
tplot<-function(x,y,xlab=deparse(substitute(x)),ylab=deparse(substitute(y)),...)
{

if(missing(xlab))  xlab=deparse(substitute(x))
if(missing(ylab))   ylab=deparse(substitute(y))

  plot(x,y,xlab=xlab,ylab=ylab,...)
  text(x,y,labels=1:length(x), pos=1, col=rgb(1,0.7,0.7))

}
### ########################################## 
###  source("/home/lees/Progs/R_stuff/sig.R")

next2<-function(x)
{
	a <- ceiling(log(x, 2))
	y <- 2^a
	y
}
#################################################
which.outlier<-function(vec, m=1)
{
if(missing(m) ) m = 1
s = sqrt(var(vec))
ns = seq(from=1,to=length(vec))
v = ns[abs((vec-mean(vec)))>=(m*s)]

return(v)

}
#################################################
#################################################
###  source("/home/lees/Progs/R_stuff/sig.R")

#################################################
RESCALE<-function(x, nx1, nx2, minx, maxx)
{
  #    rescale a vector 
  nx = nx1+(nx2-nx1)*(x-minx)/(maxx-minx)
  return(nx)
}
#################################################
###  source("/home/lees/Progs/R_stuff/sig.R")

addlines<-function(ex, y, OLDY, lty=2, AX=TRUE, LAB="", col=1)
  {
 ####  add to a plot a line with same X-axis but different scaling of Y
    ##  OLDY is the original Y values, in the plot(x,y) call
    ## ex is the x axis, should be about same as the original X-axis
    ##  y = new y values to be plotted
    ## other inputs are self-explanatory
    if(missing(lty)) { lty=2 }
    if(missing(AX)) { AX=TRUE }
    if(missing(LAB)) { LAB="" }
    if(missing(col)) { col=1 }

    
    newdt   = RESCALE(y, min(OLDY), max(OLDY) ,  min(y), max(y) )
    lines(ex, newdt, type="l" , lty=lty, col=col )
    ### put the new scaled Y axis on the right hand side, color code
    if(AX==TRUE)
      {
        py = pretty(y)
        newpy   = RESCALE(py,  min(OLDY), max(OLDY) ,  min(y), max(y))
        axis(side=4,at=newpy,  mgp=c(1.5,.5,0), labels=py, col=col )
        mtext(side=4, line=1.5, LAB, col=col)
        

      }

  }


#################################################

stats<-function(d)
  {
    s1 = boxplot.stats(d, do.conf=FALSE, do.out=FALSE);
    m1 = mean(d)
    m2 = sqrt(var(d))
    
    return(list(mean=m1, std=m2, med=s1$stats[3], qdist=s1$stats[4]-s1$stats[2] ,
                bstats=s1$stats, mstats=c(m1,m2)))
    
    
  }
#################################################
###  source("/home/lees/Progs/R_stuff/sig.R")

tufteboxplot<-function(istr, OR=1:length(istr), ALAB=FALSE, OL=FALSE)
{
  ##  input:
  ##      istr = structure of values
  ##      OR = ordering of the structure ont eh plot
  ##      ALAB  = attribute for labeling the x-axis
  ##       OL = true/false to plot outliers
###  input is a structure with multiple data sets
######  e.g.: tufteboxplot(a$res)
######  e.g.: tufteboxplot(a$res[a$len>200])
######  e.g.: tufteboxplot(a$res[a$len>1000])
######  e.g.: 
######  e.g.:
######  e.g.: fl = a$len>1 & a$len<1000
######  e.g.: tufteboxplot(a$res[fl], OR=order(a$len[fl]), ALAB=a$len[fl])

  s1 = boxplot(istr, plot=FALSE)
  K = 1:length(s1$stats[3,])

  if(missing(OR)){ OR = K }
  if(missing(ALAB)){ ALAB=FALSE }
  if(missing(OL)){ OL=FALSE }

  #  plot(c(K, K, K, K, K) , c(s1$stats[1, OR], s1$stats[2, OR],s1$stats[3, OR], s1$stats[4, OR], s1$stats[5, OR]   ), type='n' , axes=FALSE, ann=FALSE)

  
  kran = range(K)
  kval = range(s1$stats[, OR])

  if(OL==TRUE)
    {
    kran = range(K)
    kval = range(s1$stats[, OR],s1$out )

    
  }
  ## plot(rbind(K, K, K, K, K) , s1$stats[, OR], type='n' , axes=FALSE, ann=FALSE)
  plot(kran , kval, type='n' , axes=FALSE, ann=FALSE)
  
  ylin = pretty(c(s1$stats[1, OR], s1$stats[2, OR],s1$stats[3, OR], s1$stats[4, OR], s1$stats[5, OR]   ))
  abline(h=ylin, lty=2, col=gray(0.85))

  points(K, s1$stats[3,OR], col=2, pch=3)
  segments(K, s1$stats[1,OR], K, s1$stats[2,OR], col=4)
  segments(K, s1$stats[4,OR], K, s1$stats[5,OR], col=4)
  axis(2)

  ## poser = rep(1,length(K))
  ##  poser[K%%2==0] = 0


   ## ADJ = cbind(poser, rep(0.5,length(K)))

  
  ypnt = s1$stats[1,OR]
  ypnt[K%%2==0] = s1$stats[5,OR[K%%2==0] ]
  ynms = s1$names[OR]
  
  text(K[K%%2==1], ypnt[K%%2==1], labels=ynms[K%%2==1], adj=c(1,0.5), xpd=TRUE, srt=90)

  text(K[K%%2==0], ypnt[K%%2==0], labels=ynms[K%%2==0], adj=c(0,0.5), xpd=TRUE, srt=90)


  if(OL==TRUE)
    {
      kp = s1$out
    }

  

if(length(ALAB)>1)
  {

    axis(1, at=K, labels=ALAB[OR])
  }

  ##  axis(1, at=K, labels=s1$names)
}
#################################################
####  source("/home/lees/Progs/R_stuff/sig.R")

Get.S2N<-function(g , dt, t1, twin )
{

  amp = g-mean(g)
  ex = seq(0,length(amp)-1)*dt
  w1 = ex>= (t1-twin) & ex<=t1
  w2 = ex >= (t1)& ex<=(t1+twin)
  a = amp[w1]
  rms1 = sqrt(sum(a^2))
  a = amp[w2]
  rms2 = sqrt(sum(a^2))
  
  if(rms1!=0)
    {
      return(rms2/rms1)
    }
  else
    {
      return(NA)
    }
  
}

####  source("/home/lees/Progs/R_stuff/sig.R")

#################################################
ampsp<-function(x, plot=FALSE){

  if(missing(plot)) { plot=FALSE }
  len = length(x)

  
  len2 = next2(len)

  
                                        # cat(len, len2)
  
  fs=fft(x)
  f=1:len2/len2
  f=f[1:(len2/2)]
  x = x - mean(x)
  amp = Mod(fft(x))[1:(len2/2)]
  if(plot==TRUE)
    {
      plot(f,log(amp),type='l')
    }
  z=list(fft=fs, f=f, amp=amp)
  invisible(z)
}
###  source("/home/lees/Progs/R_stuff/sig.R")
#################################################
Xspec<-function(x1, x2)
{
  len1 = length(x1)
  len2 = length(x2)

  lenM = max(c(len1 , len2))
  
  lenT = next2(lenM)
  
  why1 = c(x1,rep(0,lenT-len1))
  why2 = c(x2,rep(0,lenT-len2))
                                        
  fs1=fft(why1)
  fs2=fft(why2)
   
  return(z)
}
###  source("/home/lees/Progs/R_stuff/sig.R")


#################################################
GT<-function()
  {  #  get time differential on a time series plot
    
   p = locator(2)
    return(diff(p$x))

  }

#################################################
envelope<-function(x)
  {
    
    h = hilbert(x)
    return(abs(h))

  }
#################################################


hilbert<-function(x)
  {
### calculate the hilbert transform of a signal
    
###    nn = klen/2;
###    numfreqs2 = 1+klen/2;
###    no2 = klen/2;
###    numfreqs2 = 1+klen/2;

    n = length(x)
    
    ff = fft(x)
    h=rep(0, n)
    
    if(n>0 & 2*floor(n/2)==n)
      {
### even and nonempty
        h[c(1, n/2+1)] = 1;
        h[2:n/2] = 2;
      }
    else
      {
        if(n>0)
          {
            ##  odd and nonempty
            h[1] = 1;
            h[2:(n+1)/2] = 2;
          }
      }
    ht = fft(ff*h , inverse=TRUE)/length(ff);

    return(ht);

  }



#################################################
# read in an ascii dump file from xsegy    (this seems to be an ancient function
####ra<-function(fn){
####	a = scan(file=fn,n=5,what=list(name="",num=0,dt=0,t1=0,t2=0))
####	b = scan(file=fn,skip=1)
####	a = list(name=a$name,num=a$num,dt=a$dt,t1=a$t1,t2=a$t2,y=b)
####	a
####}




###  source("/home/lees/Progs/R_stuff/sig.R")

MTMdisp<-function(a, f1=f1, f2=f2, len2=1024, PLOT=FALSE)
  {

    ###  calculate and plot an MTM spectrum
#   a = list(y=ampv, dt=0.008)

  if(missing(PLOT)) { PLOT=TRUE }
  if(missing(f1)) { f1 = 0.01 }
  if(missing(f2)) { f2 = 10 }
  len = length(a$y)
  if(missing(len2))
    {
      len2 = 2*next2(len)
    }
  if(len2<len)
    {
      len2 = 2*next2(len)
    }
  Mspec =   mtapspec(a$y,a$dt, klen=len2,  MTP=list(kind=1,nwin=5, npi=3,inorm=0)  )

  f=Mspec$freq

  amp = Mspec$spec[1:length(f)]

  #  sam = lowess(f,amp, f=10/length(f));
  #  sam$y[sam$y<=0] = amp[sam$y<=0];
  
  #  ma = cbind(amp, sam$y);
  ma = amp;
  flag = f>=f1 & f <= f2;
  displ = ma/(2*pi*f);

  if(PLOT==TRUE)
    {
                                        # 	matplot(f[flag],displ[flag,],type='l',log='xy',axes=FALSE, xlab="Hz")
  
      plot(range(f[flag]),range(displ[flag]),type='n',log='xy',axes=FALSE, xlab="Hz", ylab="Disp Spec")
      lines(f[flag], displ[flag], col=1, lty=1)       
      axis(2, las=2)
      axis(1)
      box()
    }
  invisible( list(len2=len2, f=f, f1=f1, f2=f2, displ=displ, ampsp=amp, flag=flag ) )
  }

###########################################
MTMplot<-function(a, f1=f1, f2=f2, len2=1024, PLOT=FALSE, PADDLAB=NULL, GUI=TRUE)
  {

    ###  calculate and plot an MTM spectrum
#   a = list(y=ampv, dt=0.008)

  if(missing(PLOT)) { PLOT=TRUE }
  if(missing(GUI)) { GUI=TRUE }
  
  if(missing(f1)) { f1 = 0.01 }
  if(missing(f2)) { f2 = 10 }

  if(missing(PADDLAB)) { PADDLAB=NULL}
  
  
  len = length(a$y)
  if(missing(len2))
    {
      len2 = 2*next2(len)
    }
  if(len2<len)
    {
      len2 = 2*next2(len)
    }
  Mspec =   mtapspec(a$y,a$dt, klen=len2,  MTP=list(kind=1,nwin=5, npi=3,inorm=0)  )

  f=Mspec$freq
  
  amp = Mspec$spec[1:length(f)]

  #  sam = lowess(f,amp, f=10/length(f));
  #  sam$y[sam$y<=0] = amp[sam$y<=0];
  
  #  ma = cbind(amp, sam$y);
  ma = amp;
  flag = f>=f1 & f <= f2;
  displ = ma ;

  if(PLOT==TRUE)
    {
      stdlab = c("DONE", "X-LOG", "Y-LOG", "VALS")
      labs = c(stdlab, PADDLAB)
      NLABS = length(labs)
      NOLAB = NLABS +1000
      colabs = (1:length(labs))
      pchlabs = rep(0,length(labs))
   
      plot(range(f[flag]),range(displ[flag]),type='n',log='',axes=FALSE, xlab="Hz", ylab="Spec")
      lines(f[flag], displ[flag], col=1, lty=1)       
      axis(2, las=2)
      axis(1)
      box()

      if(GUI==FALSE) { return( list(len2=len2, f=f, f1=f1, f2=f2, displ=displ, ampsp=amp, flag=flag ) ) }
      
      u = par("usr")
      sloc = list(x=c(u[1],u[2]))
      
      
      buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
      zloc = zlocator(COL=rgb(1,0.8, 0.8), ID=TRUE, NUM=FALSE , YN=1, style=0)
      Nclick = length(zloc$x)
      if(is.null(zloc$x)) { return(NULL) }
      K = whichbutt(zloc ,buttons)

      sloc = zloc
      plogx=''
      plogy=''
      
      
      
      while(Nclick>0)
        {
          
          if(K[Nclick]==1)
            {
              break;
            }
          
          
     if(Nclick==1 & K[Nclick]==0)
       {
         plxy = NULL
       }
          
          
          
          if(K[Nclick]==2)
        {
          if( (plogx=='x')==TRUE ) { plogx = '' }
          else { plogx = "x" }
        }
          if(K[Nclick]==3)
            {
              if( (plogy=='y')==TRUE) { plogy = '' }
          else { plogy = "y" }
              
              
            }
          if(K[Nclick]==4)
            {
          alabs = format.default(zloc$x[1:(Nclick-1)], digits=3)
          print(paste( paste( sep=' ',"Frequencies:", paste(alabs, collapse=" "))))
          ## abline(v=zloc$x[1:(Nclick-1)])
          ## mtext(labs, at=zloc$x[1:(Nclick-1)], side=3, line=0)
        
        }

      plxy = paste(sep='', plogx , plogy)

      plot(range(f[flag]),range(displ[flag]),type='n',log=plxy,axes=FALSE, xlab="Hz", ylab="Spec")
      lines(f[flag], displ[flag], col=1, lty=1)       
      axis(2, las=2)
      axis(1)
      box()
        buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
 
      zloc = zlocator(COL=rgb(1,0.8, 0.8), NUM=FALSE , ID=TRUE ,YN=1, style=0)
      Nclick = length(zloc$x)
      if(is.null(zloc$x)) { return(sloc) }
      K =  whichbutt(zloc ,buttons) 
      
    }


   
    }
  invisible( list(len2=len2, f=f, f1=f1, f2=f2, displ=displ, ampsp=amp, flag=flag ) )
  }

###  source("/home/lees/Progs/R_stuff/sig.R")
####


#################################################
spec<-function(a, f1=f1, f2=f2, len2=1024, PLOT=FALSE)
{
#   a = list(y=ampv, dt=0.008)

  if(missing(PLOT)) { PLOT=TRUE }
  if(missing(f1)) { f1 = 0.01 }
  if(missing(f2)) { f2 = 10 }
  len = length(a$y)
  if( missing(len2)| len2<len )
    {
      
      len2 = 2*next2(len)
    }
  
  f=1:len2/len2
  f=f[1:(len2/2)]/a$dt
  why = a$y - mean(a$y)
  why = spec.taper(why, p=0.05)    # taper with 5% cosine

  
  why = c(why,rep(0,len2-len))     # zero pad

  amp = Mod(fft(why))[1:(len2/2)]

  #  sam = lowess(f,amp, f=10/length(f));
  #  sam$y[sam$y<=0] = amp[sam$y<=0];
  
  #  ma = cbind(amp, sam$y);
  ma = cbind(amp);

  
  flag = f>=f1 & f <= f2;

  
  displ = cbind(ma/(2*pi*f));

  if(PLOT==TRUE)
    {
                                        # 	matplot(f[flag],displ[flag,],type='l',log='xy',axes=FALSE, xlab="Hz")
  
      plot(range(f[flag]),range(displ[flag,]),type='n',log='xy',axes=FALSE, xlab="Hz", ylab="Disp Spec")
      lines(f[flag], displ[flag,1], col=1, lty=1)
     #  lines(f[flag], displ[flag,2], col=2, lty=2)
                                        #   points(f[flag], displ[flag,2], col=3, pch=2)
      
      
      axis(2, las=2)
      axis(1)
      box()
    }
  invisible( list(len2=len2, f=f, f1=f1, f2=f2, displ=displ, ampsp=amp, flag=flag ) )
	


}
#################################################
specl<-function(a, f1=f1, f2=f2)
{
#   a = list(y=ampv, dt=0.008)

  if(missing(f1)) { f1 = 0.01 }
  if(missing(f2)) { f2 = 10 }
	len = length(a$y)
	len2 = 2*next2(len)
	
	f=1:len2/len2
	f=f[1:(len2/2)]/a$dt
	why = a$y - mean(a$y)
	why = spec.taper(why, p=0.05)    # taper with 5% cosine
	why = c(why,rep(0,len2-len))     # zero pad

	amp = Mod(fft(why))[1:(len2/2)]

        sam = lowess(f,amp, f=10/length(f))
  sam$y[sam$y<=0] = amp[sam$y<=0]
  
	ma = cbind(amp, sam$y)
	flag = f>=f1 & f <= f2

	        
	displ = cbind(ma/(2*pi*f))

  
# 	matplot(f[flag],displ[flag,],type='l',log='xy',axes=FALSE, xlab="Hz")
  plot(range(f[flag]),range(log(displ[flag,])),type='n',log='x', axes=FALSE, xlab="Hz")
  lines(f[flag], log(displ[flag,1]), col=1, lty=1)
  lines(f[flag], log(displ[flag,2]), col=2, lty=2)
    
	axis(2, las=2)
	axis(1)
	box()
  
	invisible( list(len2=len2, f=f, f1=f1, f2=f2, displ=displ, ampsp=amp, flag=flag ) )
	


}

#################################################
#################################################
add.brune0<-function(a,tstar,fc,Omega0, icol, f1=f1, f2=f2, plog=FALSE)
{
  ##  a = list(
  if(missing(f1)) { f1 = 0.01 }
  if(missing(f2)) { f2 = 10 }
  if(missing(plog)) { plog=FALSE }

  
  len = length(a$y)
  len2 = next2(len)
  f=1:len2/len2
  f=f[1:(len2/2)]/a$dt
  flag = f>=f1 & f <= f2
  ff = f[flag]
 # amp = Mod(fft(a$y))[1:(len2/2)]
  #sam = lowess(f,amp, f=0.05)/(2*pi*f)
 # sam = sam[flag]
                                        # brune model
	
  gamma = 2
  bruney = (Omega0*exp(-pi*f*tstar)) / (1+(f/fc)^(2*gamma) ) ^ 0.5
  bruf = bruney[flag]

  if(plog==TRUE)
    {
      lines(log10(ff),log10(bruf),col=icol)
    }
  else
    {
      lines(ff,bruf,col=icol)
    }
                                        # score = sqrt(sum(((sam)-(bruf) )^2) )
 # text(ff[length(ff)],bruf[length(ff)],score,adj=0)
 # return(score)
}
####
###  source("/home/lees/Progs/R_stuff/sig.R")
####


add.brune<-function(a,tstar,fc,Omega0, gamma=2, icol=2, f1=f1, f2=f2, plog=FALSE)
{
  ##  a = list(y=amp, dt=0.008)
    if(missing(gamma)) { gamma = 2 }
  if(missing(f1)) { f1 = 0.01 }
  if(missing(f2)) { f2 = 15 }
  if(missing(icol)) { icol = 2 }
  
  if(missing(plog)) { plog=FALSE }

  
  len = length(a$y)
  len2 = next2(len)
  f=1:len2/len2
  f=f[1:(len2/2)]/a$dt
  flag = f>=f1 & f <= f2
  ff = f[flag]
 # amp = Mod(fft(a$y))[1:(len2/2)]
  #sam = lowess(f,amp, f=0.05)/(2*pi*f)
 # sam = sam[flag]
                                        # brune model
    
  bruney = (Omega0*exp(-pi*f*tstar)) / (1+(f/fc)^(2*gamma) ) ^ 0.5
  bruf = bruney[flag]

  if(plog==TRUE)
    {
      lines(log10(ff),log10(bruf),col=icol)
    }
  else
    {
      lines(ff,bruf,col=icol)
    }
                                        # score = sqrt(sum(((sam)-(bruf) )^2) )
 # text(ff[length(ff)],bruf[length(ff)],score,adj=0)
 # return(score)
}
#################################################
####
###  source("/home/lees/Progs/R_stuff/sig.R")
####
tsplot<-function(a)
{

  if(is.ts(a))
    {
      plot(a)

    }
  else
    {

      ex = seq(from=0, by=a$dt, length=length(a$y))
      plot(ex,a$y, xlab="Time", type='l')
    }
}





#################################################
#################################################
brune<-function(f,tstar,fc,Omega0)
{	
  gamma = 2
  bruney = (Omega0*exp(-pi*f*tstar)) / (1+(f/fc)^(2*gamma) ) ^ 0.5
  return(bruney)
}
#################################################
gettstar<-function(H, f,fc,Omega0)
{	
  gamma = 2
  den = sqrt((1+(f/fc)^(gamma*2)))
  tstar = (-1)*log(den*H/Omega0)/(pi*f)
  return(tstar)
}
#################################################
#################################################
#################################################
####  source("/home/lees/Progs/R_stuff/sig.R")

hilow<-function(y)
{
 #####  find the peaks and valleys of the signals return the indecies of the locations 

  ind = seq(1,length(y))
  w = y

  aa = peaks(w, span=3)
 
  ab = peaks((-1)*w, span=3)
  
  ka = rep(FALSE, length(aa)+2)
  ka[2:(length(aa)+1)] = aa
  pks = ind[ka]
 ###  print(pks)
  
  kb = rep(FALSE, length(ab)+2)
  kb[2:(length(ab)+1)] = ab 
  vals = ind[kb]
###   print(vals)

  return(list(hi=pks, lo=vals))

}

#################################################
#################################################
#################################################
####  source("/home/lees/Progs/R_stuff/sig.R")

#########  find the 
extrema<-function(x, y, smooth=TRUE , plot=FALSE)
{
 #####  find the peaks and valleys of the signals return the indecies of the locations 
  if(missing(plot)) { plot=FALSE }
  if(missing(smooth)) { smooth=FALSE }

  ind = seq(1,length(y))
  w = y
  if(smooth==TRUE)
    {
      ys = ksmooth(x, y, "normal", bandwidth=.1)
      w = ys$y
    }
  else
    {
      w = y
    }
  aa = peaks(w, span=3)
 
  ab = peaks((-1)*w, span=3)
  
  ka = rep(FALSE, length(aa)+2)
  ka[2:(length(aa)+1)] = aa
  pks = ind[ka]
 ### print(pks)
  
  kb = rep(FALSE, length(ab)+2)
  kb[2:(length(ab)+1)] = ab 
  vals = ind[kb]
 ###  print(vals)
 
  d = c( x[pks], x[vals] )
  
  vd = c(y[pks], y[vals])
  
  id = order(d)
  
  mdiff = diff(vd[id])
  wind = which.max(diff(vd[id]))
  kw = id[wind]
  kw2 = id[wind+1]
  
  
  if(plot==TRUE)
    {
      plot(x,y, type='l')
      lines(ys, col=2)
      points(x[ka], y[ka], col=4)
      points(x[kb], y[kb ], col=3)
      points(d[kw],vd[kw]  , pch = 6, col=4)
       points(d[kw2],vd[kw2]  , pch = 6, col=4)
     
      points(x[which.max(y)] , y[which.max(y)], pch=8,  col=4)
      points(x[which.min(y)] , y[which.min(y)], pch=8,  col=4)


    }
  return(list(hi=pks, lo=vals, mdiff=mdiff[wind], kw=kw, wind=wind) )
  
}
#################################################
fixna<-function(y)
  {
    w = which(is.na(y))
    if(length(w)==0)
      {
        return(y)
      }
    if(length(w)==1)
      {
        y[w] = mean(c(y[w-1], y[w+1]))
      } else  {
        dd = diff(w)
        wd = which(dd>1)
        nw = length(wd)
        for(j in 1:length(w))
          {
            y[w] = mean(c(y[w-1], y[w+1]))
            
          }
      }
    return(y)
}

#################################################
####
###  source("/home/lees/Progs/R_stuff/sig.R"); save.image()
####
#### trapezoidal rule for integration
trapz<-function(y, dt)
  {
    # integrate a signal to get displacement plot
    #  using trapezoidal rule
    #  remove mean
     z = y - mean(y)
     n = length(z)
     
     h = cumsum(  dt * 0.5*(z[1:(n-1)]+z[2:n]))
     
     h = c(0,h)
     return(h) 

  }
#####
integ1<-function (x,y,dm=-Inf,hm=+Inf)
{
  ####  integrate under the curve of a time series
  ####  return 2 numbers, one with the bottom triangle included
  ###  one without
  if(dm==-Inf)dm<-min(x)
  if(hm==+Inf)hm<-max(x)
  vyber<-x<=hm&x>=dm
  l<-length(x[vyber])
  v<-diff(x[vyber])
  z<-y[vyber][1:l-1]+y[vyber][2:l]
  o<-z*v/2
  osum<-sum(o)
  o1<-(y[x==min(x[vyber])]+y[x==max(x[vyber])])*(max(x[vyber])-min(x[vyber]))/2
  cista<-osum-o1
  return(c(osum,cista))
}


defintegral<-function(y, dt)
  {
    z = y
     n = length(z) 
     h = cumsum(  dt * 0.5*(z[1:(n-1)]+z[2:n]))
     
     h = c(0,h)
     return(h) 


  }

#################################################
####
###  source("/home/lees/Progs/R_stuff/sig.R")

applytaper<-function(f, p=0.05)
  {

    if(missing(p)) { p = 0.05 }
    n = length(f)
    
    l=round((n-2)*p);

    s = seq(1,n)

    vwin=rep(1,n)

    bend = seq(1,round(l) )
    
    vwin[s<=round(l)] = 0.5*(1.0-cos(bend*pi/(l+1)));

    bend = seq(n-l-2, n )
    
    vwin[s>= n-l-2] = 0.5*(1.0-cos(bend*pi/(l+1)));

    newf = vwin*f
    return(newf)
}
#################################################
####
###  source("/home/lees/Progs/R_stuff/sig.R")
#################################################
####
###  source("/home/lees/Progs/R_stuff/sig.R")

detrend<-function(x)
  {
    ##  remove linear trend from a time series
   
    n = length(x)
    
    t = seq(1,n)

    r = lm(x ~ t)
    b = r$coefficients[1]
    m = r$coefficients[2]
    
    newf = x - (m*t+b)
    
    return(newf)
}
#################################################
#################################################
#################################################
#####  to get this to work need to execute these commands for
#####   dynamics loading of software
##### cd /home/lees/Progs/Rc
##### R CMD SHLIB MTAPSRC.o
##### dyn.load("/home/lees/Progs/Rc/MTAPSRC.so")

## add in the compiled C-code
## dyn.load("/home/lees/Progs/Rc/LLNfilt.so")
## dyn.load("/home/lees/Progs/Rc/GetCornerFreq.so")
## dyn.load("/home/lees/Progs/Rc/MTAPSRC.so")


################
#####

###  source("/home/lees/Progs/R_stuff/sig.R")

#####
#####
#####

mtapspec<-function(a, dt, klen=length(a), MTP=NULL)
{
#####  multi-taper spectrum analysis
  ####     Mspec =   mtapspec(a$y,a$dt, klen=4096, MTP=list(kind=2,nwin=5, npi=3,inorm=0)  )   
#####

  if(missing(MTP))
    {
      kind=2;  
      nwin=5;  
      npi=3; 
      inorm=0;
    }
  else
    {
      kind=MTP$kind;  
      nwin=MTP$nwin;  
      npi=MTP$npi; 
      inorm=MTP$inorm ;
    }



  
  if(missing(klen))
    {
      klen=next2(length(a))
    }
  numfreqs = 1+klen/2;
  numfreqtap = numfreqs*nwin;
  nyquist = 0.5/dt;
   df = 2*nyquist/klen;
  freq = df*seq(0,numfreqs-1)
  
  spec1 = rep(0, length=klen )
  dof = rep(0, length=klen )
  Fvalues = rep(0, length=klen )
  ReSpec= rep(0, length= numfreqtap)
  ImSpec= rep(0, length=numfreqtap )

  barf = .C("CALL_Mspec",
    as.double(a),
    as.integer(length(a)),
    as.integer(kind),
    as.integer(nwin) ,
    as.double(npi) ,
    as.integer(inorm) ,
    as.double(dt) ,
    as.double(spec1) ,
    as.double(dof) ,
    as.double(Fvalues) ,
    as.integer(klen) ,
    as.double(ReSpec) ,
    as.double(ImSpec) )

  Ispec=  matrix(unlist(barf[13]), byrow=FALSE, nrow=numfreqs,  ncol=nwin)

  
  Rspec=   matrix(unlist(barf[12]), byrow=FALSE, nrow=numfreqs,  ncol=nwin)
  invisible(list(dat=a, dt=dt, spec=unlist(barf[8]), dof=unlist(barf[9]),Fv=unlist(barf[10]),Rspec=Rspec, Ispec=Ispec, freq=freq, df=df, numfreqs=numfreqs, klen=klen,   mtm=list(kind=kind, nwin=nwin, npi=npi, inorm=inorm)))


}
#####

seemspec<-function(Mspec, maxfreq=10)
{

  if(missing(maxfreq)) {  maxfreq=10 }
  KK = 1:length(Mspec$freq)
  ppoints  =  c(50.0, 90.0, 95.0, 99.0)
  qpoints = qf(ppoints/100, 2, 14)

  q1 = qpoints[2]
  flagq = Mspec$Fv>q1
  flagf = Mspec$freq<maxfreq

  par(mfrow=c(3,1))

  xp = Mspec$freq[KK[flagf]];
  whyp = Mspec$spec[KK[flagf]]

  plot(Mspec$freq[KK[flagf]], Mspec$dof[KK[flagf]], type='l')

  plot(xp, whyp, log='y', type='l')
  points(xp[flagq], whyp[flagq], col=2)



  plot(Mspec$freq[KK[flagf]], Mspec$Fv[KK[flagf]], type='l')

  abline(h=qf(ppoints/100, 2, 14), lty=2, col=3)
  axis(4, at=qf(ppoints/100, 2, 14), labels=ppoints)

}


#####
plot.mtm<-function(ma, PLOT=1, LOG='x')
  {
    if(missing(PLOT)) {  PLOT=1  }
    if(missing(LOG)) { LOG = 'x' }

    if(PLOT==2)
      {
    par(mfrow=c(2,1))
    t = ma$dt*seq(0, to=(length(ma$dat)-1) )
    plot(t, ma$dat, type='l')
  }

    plot(ma$freq[2:length(ma$freq)], ma$spec[2:length(ma$freq)], log=LOG, type='l')


  }

#####
plspec<-function(ma, PLOT=1, LOG='x')
  {
    if(missing(PLOT)) {  PLOT=1  }
    if(missing(LOG)) { LOG = 'x' }

    if(PLOT==2)
      {
    par(mfrow=c(2,1))
    t = ma$dt*seq(0, to=(length(ma$dat)-1) )
    plot(t, ma$dat, type='l')
  }

    plot(ma$freq[2:length(ma$freq)], ma$spec[2:length(ma$freq)], log=LOG, type='l')


  }





#####
###  source("/home/lees/Progs/R_stuff/sig.R")

#####
#####  evolfft(a,dt, Nfft=4096, Ns=250 , Nov=240,  fl=0, fh=10  )
#####  evolfft(a,dt, Nfft=4096, Ns=250 , Nov=240,  fl=0, fh=25  )
#####  evolfft(a,dt, Nfft=4096, Ns=250 , Nov=240,  fl=0, fh=10  )

evolfft<-function(a, dt=0, Nfft=0,  Ns=0, Nov=0, fl=0, fh=10 )
  {
    ###  Nfft=1024;Ns=250;Nov=240;fl=0; fh=10
    if(missing(dt)) { dt=1;}
    if(missing(Nfft)) { Nfft=1024;}
    if(missing(Ns)) { Ns=250;}
    if(missing(Nov)) { Nov=240;}
    if(missing(fl)) { fl=0;}
    if(missing(fh)) { fh=1/(2*dt);}

    NT = length(a);
    nyquistf = 1/(2*dt);
    if(Nov<1)
      {
        Nov = floor(Ns - 0.1*Ns);
      }
      kcol = floor( (NT-Nov)/(Ns-Nov));
   
    min1 = Nfft%%2;
    if(min1 == 0)
      {
        ## /* even */
        krow = (Nfft/2);
      } else {
        ##  /*  odd */
        krow = (Nfft+1)/2;
      }
    
    skiplen = Ns - Nov;
    
    df = 1.0/(Nfft*dt);
    numfreqs=krow;


     print(paste(sep=' ', "evolfft kcol=", kcol, "krow=", krow, "Ns", Ns, "Nov", Nov))
    if(kcol<1)
      {
        print(paste(sep=' ', "error in evolfft kcol=", kcol, "krow=", krow))
      }
          
    DMAT = matrix(rep(0,krow*kcol), ncol=kcol, nrow=krow)

    m = 1:(kcol)
    ibeg=((m-1)*skiplen)+1;
     iend = ibeg+Ns-1;
    
    for( i in m)
      { 
        ## print(paste(sep=" ", m, ibeg, iend, NT))
        tem = a[ibeg[i]:iend[i]]
        tem = tem-mean(tem, na.rm=TRUE)
        tem = spec.taper(tem, p=0.05)
        tem =  c(tem,rep(0,krow-Ns)) 
        DMAT[,i] = tem
      }
    
    DFFT = mvfft(DMAT)

   DSPEC = Mod(DFFT)
     # col=heat.colors(50)


    
    x = (ibeg+Ns/2)*dt
    
    freqs = df*c(0:((numfreqs/2)-1),(-numfreqs/2):(-1)  )

    y = (1:(numfreqs/2))*2*df

  
   
    RET = list(sig=a, dt=dt, numfreqs=numfreqs, wpars=list(Nfft= Nfft,  Ns=Ns, Nov=Nov, fl=fl, fh=fh), DSPEC=DSPEC, freqs=y, tims=x)

    ## plotevol(RET)
    
    invisible(RET)

  }
###  source("/home/lees/Progs/R_stuff/sig.R")
###  source("sig.R"); save.image()


#####
#####  evolfft(a,dt, Nfft=4096, Ns=250 , Nov=240,  fl=0, fh=10  )
#####  evolfft(a,dt, Nfft=4096, Ns=250 , Nov=240,  fl=0, fh=25  )
#####  DEV = evolfft(a,dt, Nfft=4096, Ns=250 , Nov=240,  fl=0, fh=10  )

### plotevol(DEV, log=1, fl=0, fh=15, col=rainbow(50))
### plotevol(DEV, log=1, fl=0, fh=15, col=heat.colors(50))
### plotevol(DEV, log=1, fl=0, fh=15, col=terrain.colors(50))
### plotevol(DEV, log=1, fl=0, fh=15, col=topo.colors(50))

### plotevol(DEV, log=1, fl=0, fh=15, col=rainbow(50))

###  source("/home/lees/Progs/R_stuff/sig.R")

##  to plot a spectrogram use: plotevol 

plotevol<-function(DEVOL, log=0,  fl=0, fh=10 , col=col, ylog=FALSE, ygrid=FALSE, AXE=c(1,2,3,4) )
  {
    if(missing(log)) { log = 0 }
    if(missing(fl)) { fl=DEVOL$wpars$fl}
    if(missing(fh)) { fh=DEVOL$wpars$fh}
    
    if(missing(col)) { col=rainbow(50) }
    if(missing(ylog)) { ylog=FALSE }
    if(missing(ygrid)) { ygrid=FALSE }
    if(missing(AXE)) { AXE=c(1,2,3,4) }
    
    perc = 0.85
    a = DEVOL$sig
    dt = DEVOL$dt
    DSPEC = DEVOL$DSPEC
    numfreqs = DEVOL$numfreqs
    y = DEVOL$freqs
    x = DEVOL$tims
    
    
    yflag = (y>=fl&y<=fh)
    
    
    tim = dt*seq(0, length=length(a))
    
    
    ##   image(x,why,t(DSPEC[1:(numfreqs/2),]), add=TRUE, col = col,xlab='time', ylab='freq', axes=FALSE)
    
    ##   image(x,why,log10(t(DSPEC[1:(numfreqs/2),])), add=TRUE, col = col,xlab='time', ylab='freq', axes=FALSE)
    
    IMAT = t(DSPEC[1:(numfreqs/2),])
    
    if(ylog==TRUE)
      {
        why   = RESCALE( log10(y[yflag]), 0 , perc , min(log10(y[yflag])), max(log10(y[yflag])) )
      }
    else
      {
        why   = RESCALE( (y[yflag]), 0 , perc , min(y[yflag], na.rm=TRUE), max(y[yflag], na.rm=TRUE) )

      }
    
    if(log<=0){ ImPlot = IMAT[ , yflag]; units="Amp" } 
    if(log==1){ ImPlot =     log10(IMAT[ , yflag]) ; units="Log Amp"}
    if(log==2){ ImPlot = sqrt(IMAT[ , yflag] ) ; units="SQRT Amp"}
    if(log==3){ ImPlot = 20*log10( IMAT[ , yflag]/ max( IMAT[ , yflag]) ) ; units="DB"}
    if(log>3){ ImPlot = IMAT[ , yflag]; units="Amp" }  

    ##   par(mfrow=c(1,1))
    par(xaxs='i', yaxs='i')

    plot(range(tim), c(0,1), axes=FALSE, type='n', xlab='', ylab='')
    
    image(x,why,ImPlot , add=TRUE, col = col, xlab='time', ylab='freq', axes=FALSE)
    
    trace = RESCALE( a, perc , 1.0  , min(a, na.rm=TRUE), max(a, na.rm=TRUE) )

    
    lines(tim, trace)

    ##  sy = RESCALE( a, perc , 1.0  , min(a), max(a) )
    Tdiff = max(tim, na.rm=TRUE)-min(tim, na.rm=TRUE)
    
    segments(max(tim)-Tdiff*.04-DEVOL$wpars$Ns*dt, perc+0.01, max(tim)-Tdiff*.04, perc+0.01, lwd=2)
    
                                        # axis(1)
                                        #  axis(3)
    
    xtix = pretty(x, n=10)
    xtix = xtix[xtix>=min(x)&xtix<max(x)]

    ### print(paste(sep=" ",min(x),  max(x), paste(xtix)))

  #   xtix = c(floor(min(x)),xtix,  floor(max(x)))
    axis(3,tck=.01,at=xtix,lab=FALSE)
    if(!is.na(match(3, AXE)))
      {

    mtext( side=3,    at=xtix, text=xtix, line=.5)
  }

    axis(1,tck=.01,at=xtix,lab=FALSE)
    mtext( side=1,    at=xtix, text=xtix, line=.25)

   
                                        #  title(xlab="Time, s")
    mtext(side=1, at=max(x), text="Time, s" , line=1.5, adj=1)

    if(ylog==TRUE)
      {
        axspec = pretty(log10(y[yflag]), n=10)
        axspec = axspec[axspec<=max(log10(y[yflag])) ]

        
        raxspec= RESCALE( axspec, 0 , perc , min(log10(y[yflag]), na.rm=TRUE), max(log10(y[yflag]), na.rm=TRUE) )

        axspec = 10^(axspec[axspec<=max(log10(y[yflag])) ])
        axspec[ axspec<1] = 1/axspec[ axspec<1]
        
      }
    else
      {
        axspec = pretty(y[yflag], n=10)
        axspec = axspec[axspec<=max(y[yflag], na.rm=TRUE) ]
        raxspec= RESCALE( axspec, 0 , perc , min(y[yflag], na.rm=TRUE), max(y[yflag], na.rm=TRUE) )
      }
    
    axis(2, at=raxspec, labels=format.default(axspec, digits=3), pos=min(x, na.rm=TRUE))

    if(ygrid==TRUE)
      {
      
        ##  abline(h=raxspec)
        segments(rep(min(x, na.rm=TRUE), length(raxspec)), raxspec,  rep(max(x, na.rm=TRUE), length(raxspec)) , raxspec, lty=2, col=rgb(0.2, 0.2, 0.2))

      }

    if(ylog==TRUE)
      {
        mtext(side=2, at=perc/2, text="Hz or s" , line=0)
      }
    else
      {
        mtext(side=2, at=perc/2, text="Hz" , line=2)
      }
    
    axtrace = range(a, na.rm=TRUE)
    raxtrace= RESCALE( axtrace, perc , 1.0 , min(a, na.rm=TRUE), max(a, na.rm=TRUE) )
    axis(4, at=raxtrace, labels=format.default(axtrace, digits=3), pos=max(tim, na.rm=TRUE))
    
    HOZscale( ImPlot, col, units=units, s1=0.4, s2=0.95)

    invisible(list(y=y[yflag], why=why, yBounds=c(0,perc), x=x, yat=raxspec))

  }
###  source("/home/lees/Progs/R_stuff/sig.R")

####   source("/home/lees/Progs/R_stuff/iscale.R")
#####
###KEV = evolfft(KAR$dat[,4], 0.008, Nfft=4096, Ns=250 , Nov=240,  fl=0, fh=10)
###  plotevol(KEV, log=1, fl=0, fh=15, col=rainbow(50))

###  a = DA$dat[,1]
###  dt = DA$info$dt[1]
###DEV = evolfft(DA$dat[,1],  DA$info$dt[1], Nfft=4096, Ns=250 , Nov=240,  fl=0, fh=10)
###DEV = evolfft(DA$dat[,1],  DA$info$dt[1], Nfft=4096, Ns=250 , Nov=240,  fl=0, fh=10)

###  plotevol(DEV, log=1, fl=0, fh=15, col=rainbow(50))
###  plotevol(DEV, log=1, fl=0, fh=15, col=gray( (0:50)/50 ))
###  plotevol(DEV, log=1, fl=0, fh=15, col=gray( (50:0)/50 ))
###  plotevol(DEV, log=1, fl=0, fh=15, col=gray( c(rep(1,24), (25:0)/25) ))
###  plotevol(KEV, log=1, fl=0, fh=15, col=gray( c(rep(1,24), (25:0)/25) ))
###  plotevol(KEV, log=1, fl=0, fh=15, col=rainbow(50))

plotevolM<-function(DEVOL, log=0,  fl=0, fh=10 , col=col, ylog=FALSE, ygrid=FALSE)
  {
    if(missing(log)) { log = 0 }
    if(missing(fl)) { fl=DEVOL$wpars$fl}
    if(missing(fh)) { fh=DEVOL$wpars$fh}
    
    if(missing(col)) { col=rainbow(50) }
     if(missing(ylog)) { ylog=FALSE }
     if(missing(ygrid)) { ygrid=FALSE }
   
    
    a = DEVOL$sig
    dt = DEVOL$dt
    DSPEC = DEVOL$DSPEC
    numfreqs = DEVOL$numfreqs
    y = DEVOL$freqs
    x = DEVOL$tims
   
    
    yflag = (y>=fl&y<=fh)
    
    
    tim = dt*seq(0, length=length(a))
   
    
  ##   image(x,why,t(DSPEC[1:(numfreqs/2),]), add=TRUE, col = col,xlab='time', ylab='freq', axes=FALSE)

   ##   image(x,why,log10(t(DSPEC[1:(numfreqs/2),])), add=TRUE, col = col,xlab='time', ylab='freq', axes=FALSE)

    IMAT = t(DSPEC[1:(numfreqs/2),])

      
    
    if(ylog==TRUE)
      {
        why   = RESCALE( log10(y[yflag]), 0 , 0.75 , min(log10(y[yflag])), max(log10(y[yflag])) )
      }
    else
      {
        why   = RESCALE( (y[yflag]), 0 , 0.75 , min(y[yflag]), max(y[yflag]) )

      }
 
    if(log<=0){ ImPlot = IMAT[ , yflag]; units="Amp" } 
    if(log==1){ ImPlot =     log10(IMAT[ , yflag]) ; units="Log Amp"}
    if(log==2){ ImPlot = sqrt(IMAT[ , yflag] ) ; units="SQRT Amp"}
    if(log==3){ ImPlot = 20*log10( IMAT[ , yflag]/ max( IMAT[ , yflag]) ) ; units="DB"}
       if(log>3){ ImPlot = IMAT[ , yflag]; units="Amp" }  

   ##   par(mfrow=c(1,1))

    plot(range(tim), c(0,1), axes=FALSE, type='n', xlab='', ylab='')
  
 image(x,why,ImPlot , add=TRUE, col = col, xlab='time', ylab='freq', axes=FALSE)

    
    
    trace = RESCALE( a, 0.75 , 1.0  , min(a), max(a) )

    
   lines(tim, trace)

    ##  sy = RESCALE( a, 0.75 , 1.0  , min(a), max(a) )
    Tdiff = max(tim)-min(tim)
    
    segments(max(tim)-Tdiff*.04-DEVOL$wpars$Ns*dt, 0.76, max(tim)-Tdiff*.04, 0.76, lwd=2)
    
                                        # axis(1)
                                        #  axis(3)
    
    xtix = pretty(x, n=5)
    xtix = xtix[xtix>=min(x)&xtix<=max(x)]

    xtix = c(floor(min(x)),xtix,  floor(max(x)))
    
    axis(3,tck=.01,at=xtix,lab=FALSE)
    mtext( side=3,    at=xtix, text=xtix, line=.5)


    axis(1,tck=.01,at=xtix,lab=FALSE)
    mtext( side=1,    at=xtix, text=xtix, line=.25)

   
                                        #  title(xlab="Time, s")
    mtext(side=1, at=max(x), text="Time, s" , line=1.5, adj=1)

    if(ylog==TRUE)
      {
        axspec = pretty(log10(y[yflag]), n=5)
        axspec = axspec[axspec<=max(log10(y[yflag])) ]

        
        raxspec= RESCALE( axspec, 0 , 0.75 , min(log10(y[yflag])), max(log10(y[yflag])) )

        axspec = 10^(axspec[axspec<=max(log10(y[yflag])) ])
        axspec[ axspec<1] = 1/axspec[ axspec<1]
        
      }
    else
      {
        axspec = pretty(y[yflag], n=5)
        axspec = axspec[axspec<=max(y[yflag]) ]
        axspec = c(axspec, fh)
        raxspec= RESCALE( axspec, 0 , 0.75 , min(y[yflag]), max(y[yflag]) )
      }
    
    axis(2, at=raxspec, labels=format.default(axspec, digits=3), pos=min(x))

    if(ygrid==TRUE)
      {
      
        ##  abline(h=raxspec)
        segments(rep(min(x), length(raxspec)), raxspec,  rep(max(x), length(raxspec)) , raxspec)

      }

    if(ylog==TRUE)
      {
        mtext(side=2, at=0.75/2, text="Hz or s" , line=0)
      }
    else
      {
        mtext(side=2, at=0.75/2, text="Hz" , line=0)
      }
    
    axtrace = range(a)
    raxtrace= RESCALE( axtrace, 0.75 , 1.0 , min(a), max(a) )
    axis(4, at=raxtrace, labels=format.default(axtrace, digits=3), pos=max(tim))


    
    HOZscale( ImPlot, col, units=units)

    invisible(list(y=y[yflag], why=why, yBounds=c(0,0.75), x=x, yat=raxspec))

  }

###################################################################
pevol<-function(cha)
  {
    v = locator()

    nv = RESCALE(v$y, cha$y[1], cha$y[length(cha$y)], cha$yBounds[1], cha$yBounds[2])

    invisible(list(x=v$x, y=nv, v=v))
    
  }

###  source("/home/lees/Progs/R_stuff/sig.R")

genrick<-function(freq,dt,nw)
{
#
# RICKER WAVELET GENERATOR
# Written by Leonard Lisapaly (leonardl@fisika.ui.ac.id)
  ##  converted to R  j. lees Wed Sep  1 09:39:21 2004
#
# INPUTS
# freq = wavelet dominant frequency [Hz]
# dt   = sampling interval [sec]
# nw   = length of wavelet [odd number]
#
# USAGE
# If you want to obtain a 35 samples Ricker wavelet 
# with dominant frequency of 25 Hz and sampling interval
# of 0.002 sec, you should type :
#      w = genrick(25,0.002,35)

a  = freq*sqrt(pi)/2;
nc = (nw+1)/2;
tc = (nc-1)*dt;
t  = seq(from=0, length=nw-1 )*dt;
b  = pi*freq*(t-tc);
w  = a*(1-2*b^2)*exp(-b^2);
return(w)

}
###  source("/home/lees/Progs/R_stuff/sig.R")
