###  source("/home/lees/Progs/R_stuff/sung.chug.R")
###
repname<-function(new, n1, n2)
  {
    
###  sub(n1, n2, new)
###  sub("/home/beer", "/data/love/beer", n1)


  }

SANG.CHUGZ<-function(ACHUG,  sel=1, CATS=NULL, shapes=shapes, REG=FALSE, BASE=NULL)
{
  if(missing(CATS)) { CATS=NULL }
  if(missing(shapes)) { shapes=NULL }
  if(missing(sel)) { sel=1 }
  if(missing(REG)) { REG=FALSE }
  ###   base is a base directory where the data is stored
  if(missing(BASE)) { BASE=NULL }
  
  chugs = ACHUG$chugs

  
  fnames = chugs$fn
  if( !is.null(BASE))
    {
      nfnames = sub(BASE$from, BASE$new, fnames)
      fnames = nfnames
    }

  
  chugtmin = min(chugs$tims)
  chugtmax = max(chugs$tims)
  
  NH = GET.Kseis(fnames, kind=1, PLOT=FALSE, TWIN=c(chugtmin, chugtmax) )  

### AI =   c("40T", "3T",  "LD",  "EL",  "MC")
###  codes =    1     2     101    102    103

  aW = chugs$WIN
  temp = NH$JSTR[[sel]]
  meanval = mean(temp[ NH$ex>=aW[1]&NH$ex<=aW[2]  ])
  ### print(paste("mean val = ", meanval))
  NH$JSTR[[sel]] = NH$JSTR[[sel]]-meanval
  inst  = setTUNGsense(102)
 
  if(!is.na(inst$sense))
    {
      NH$JSTR[[sel]] = NH$JSTR[[sel]]/inst$sense
      units = inst$units
    }
  else
    {
      units = "V"
    }
  
  As2=chugs$tims

  d1=chugs$tims
  d2=(chugs$amp-meanval)/inst$sense
  ifile=chugs$ifile
  ftime=chugs$ftime

  
  
  
  pcols = rep(1,length(d1))

  if(!is.null(CATS))
    {
      
      for(i in 1:(length(CATS$x)-1))
        {
          t1 = CATS$x[i]
          t2 = CATS$x[i+1]
          flg = d1>t1&d1<=t2
          pcols[flg] = i
        }
      
    }

  upar = par(no.readonly = TRUE)

  nf <- layout(matrix(c(1,2),2,1,byrow=TRUE), heights=c(1,2), TRUE)
####  layout.show(nf)
####   mai = c(0.8882490, 0.7140825, 0.7140825, 0.3657496)
  mai = upar$mai
  mai[1] = 0.5
  mai[3] = 0.1

  par(mai=mai )
  
  print(paste(sep=' ', "aw",aW))
  
  YN = PLOT.SEISN(NH, WIN=aW, dt=NH$dt, sel=sel , notes=NH$KNOTES[sel], add=2)

####  YN = PLOT.SEISN(NH, WIN=aW, dt=NH$dt, sel=sel , notes=NH$KNOTES[sel], pts=TRUE)

  abline(v=As2, col=rgb(0.8, 0.8, 1.0))
  YN = PLOT.SEISN(NH, WIN=aW, dt=NH$dt, sel=sel , notes=NH$KNOTES[sel], add=3)

 ###   zd = RESCALE(d2, 0, YN$dy, YN$minS,  YN$maxS )
  
 ###  points(d1,zd)


 #### y = (NH$JSTR[[1]])
####  ex = NH$dt*(0:(length(y)-1))
####  plot(ex[ex>a[1]&ex<a[2]],y[ex>a[1]&ex<a[2]], type='l')

####    points(d1,d2)
  
  title(ylab=units)

  if(!is.null(shapes))
    {
### shapes is a matrix with picking and shape information
      

    }

  if(!is.null(CATS))
    {
      points(As2, rep(1,length(As2))  ,pch=17 , col=pcols)    
    }
  
  u1 = par("usr")
  text(u1[1],0, labels=ftime,adj=c(0,0) )

  das2 = diff(d1)
  ax = das2
  ay = d2[1:length(das2)]

  bb = boxplot(das2, plot=FALSE)

  flag =  das2<(bb$stats[5,1]+(bb$stats[5,1]-bb$stats[4,1]))
  w1 = which(flag==FALSE)
  
  k1 = length(w1)+1
###  cols =  rep(1, length(das2))
  cols =  pcols[1:length(das2)]

  if(length(w1)>1)
    {
      vec = c(1, w1, length(das2))
      
####  this section is used to color code chugging sequences that are broken up
####   by large gaps in arrival times
      
      for(m in 1:(length(vec)-1))
        {
          cols[vec[m]:vec[m+1] ] =m
          
        }
    }


###  flag = (ax-mean(ax))<2*sqrt(var(das2))

  tx = ax[flag]
  why = ay[flag]
  
  labs = 1:length(das2)

  par(mai=upar$mai )

  u2 = par("usr")


  CHERR = ACHUG$CHERR

  if(is.null(CHERR))
    {

      e1 = rep(ACHUG$chugs$dt/3, length(das2))
      e2 = rep( diff(range(d2))/0.05 , length(das2))

    }
  else
    {
      
      e1 = CHERR[1:length(das2),1]+ACHUG$chugs$dt/3
      e2 = CHERR[1:length(das2),2]/inst$sense
    }
  
  w1 = 1/(e1)
  w1 = w1/sum(w1)
  
  w2 = 1/(e2)
  w2 = w2/sum(w2)

  WTS = w1 + w2 

  EX = das2[flag]
  WHY  = ay[flag]
  COLS = cols[flag]
  E1 = e1[flag]
  E2 = e2[flag]
  W = WTS[flag]

### check if WTS exist and are not NA
###  else do not

  if(length(which(is.na(W)))==length(W)  )
    {

      W = rep(1,length(W))
    }

  W[is.na(W) ] = min(W[!is.na(W)])

  
  if(length(which(is.na(W)))>1  )
    {
###  last resort
      W = rep(1,length(W))
    }
  
  UCOL = unique(COLS)

  
### print(UCOL)

### print(COLS)


  
### plot(das2[flag], ay[flag], type='n')
### print(flag)
### print(cols[flag])
### print(pcols)
  
### segments(das2[flag]-e1[flag],ay[flag],  das2[flag]+e1[flag], ay[flag] , col=cols[flag])
###  segments(das2[flag],ay[flag]-e2[flag],  das2[flag], ay[flag]+e2[flag] , col=cols[flag])

  plot(EX, WHY, xlab="Interval Time, s", ylab=units, type='n')

  text(EX, WHY,labels=labs[flag], pos=3, col=4)

  if(!is.null(CATS))
    {
      
      points(EX, WHY ,pch=1 , col=pcols)
    }
  else
    {
      points(EX, WHY ,pch=1 , col=4)

    }

  segments(EX-E1,WHY,  EX+E1, WHY , col=COLS)
  segments(EX,WHY-E2,  EX, WHY+E2 , col=COLS)

  GLMS = LINE.CHUGZ(EX, WHY, W, UCOL, COLS)


###   title(main=ifile)
  par(upar)

  invisible(list(x=d1, y=d2, itime=das2, amp=d2[1:length(das2)], tx=tx, why=why, EX=EX, E1=E1, WHY=WHY, E2=E2, W=W, UCOL=UCOL, COLS=COLS, GLMS=GLMS, WIN=chugs$WIN, fnames=fnames, TWIN=c(chugtmin, chugtmax), sel=sel, WIN=aW ))

  
}


##################################################

SEEALL.CHUGZ<-function(ACHUG, I=1, PLOT=c(0, 1, 2))
{
  ###   PLOT is a vector of options, if PLOT includes
  ###    0  plot initial time series
  ####   1  plot only the individual chugs
  ####   2  plot chugs and summary
  ####   3  plot summary only

  
  if(missing(I)) { I = 1:length(ACHUG$chugs$tims) }
  if(missing(PLOT)) { PLOT=c(0, 1, 2) }



  
  ###  ACHUG = SCHUGZ[[ii]]
  sel = 1
  
  chugs = ACHUG$chugs
  fnames = chugs$fn
  chugtmin = min(chugs$tims)
  chugtmax = max(chugs$tims)

  
  NH = GET.Kseis(fnames, kind=1, PLOT=FALSE, TWIN=c(chugtmin, chugtmax) )  

### AI =   c("40T", "3T",  "LD",  "EL",  "MC")
###  codes =    1     2     101    102    103

  ### plot(NH$ex, temp)
  ### plot(NH$ex[ NH$ex>=a[1] & NH$ex<=a[2]  ], temp[ NH$ex>=a[1] & NH$ex<=a[2]  ])

  

  aW = chugs$WIN
  temp = NH$JSTR[[sel]]
  meanval = mean(temp[ NH$ex>=aW[1] & NH$ex<=aW[2]  ])
### print(paste("mean val = ", meanval))

  
  NH$JSTR[[sel]] = NH$JSTR[[sel]]-meanval


  
  inst  = setTUNGsense(102)
  
  NH$JSTR[[sel]] = NH$JSTR[[sel]]/inst$sense
  units = inst$units
  
  As2=chugs$tims

  d1=chugs$tims
  d2=(chugs$amp-meanval)/inst$sense
  ifile=chugs$ifile
  ftime=chugs$ftime
  das2 = diff(d1)
  dx = mean(das2)

  
  g = NH$JSTR[[1]]
  x = NH$ex

  if(length(PLOT[PLOT==0])>0)
    {
      plot(x[x>=aW[1]&x<=aW[2]],g[x>=aW[1]&x<=aW[2]], type='l')
    }

####   chex = x[x>=aW[1]&x<=aW[2]]   
####   champ = g[x>=aW[1]&x<=aW[2]]
  
########
  rat = rep(NA, length(I))
  j = 0
  for(i in I)
    {
      j =j+1
      bW = c(d1[i]-dx/2, d1[i]+dx/2)
      thex = x[x>=bW[1]&x<=bW[2]]
      they = g[x>=bW[1]&x<=bW[2]]

      owhy = temp[x>=bW[1]&x<=bW[2]]


      if(PLOT<=1) plot(thex, they, type='l', xlab="s", ylab="Pa")

      E = EstChugErr(thex, they, PLOT=TRUE, dt=NH$dt, j1=10, j2=2)

      k = which.max(g[x>=bW[1]&x<=bW[2]])

        if(length(PLOT[PLOT==1])>0)   abline(v=thex[k], col=3)

      ## points(d1[i], d2[i], col=2)
      ## points(chugs$pks[i], d2[i], col=4)


###  source("/home/lees/Progs/R_stuff/sung.chug.R")

      trishape = ACHUG$shapechug[i,]

      x1 = thex[k]-(trishape[5]-trishape[1])
      x2 = thex[k]+(trishape[2]-trishape[5])

      k1 = findInterval(x1, thex)
      k2 = findInterval(x2, thex)

      if(length(PLOT[PLOT==1])>0)   abline(v=c(x1, x2), col=rgb(.7,1, .7))

###y1 = (trishape[3]-meanval)/inst$sense
###y2 = (trishape[4]-meanval)/inst$sense

      y1 = they[k1]
      y2 = they[k2]

      zip1 = owhy[k1]
      zip2 = owhy[k2]


       if(length(PLOT[PLOT==1])>0)
          {
            lines(c(x1, thex[k], x2, x1), c(y1,d2[i], y2, y1), col=rgb(.5, .1, .1)) 
            
            points(thex[k]  , d2[i], col=3)
            label.it(paste(sep='/', i, length(d1)), 1)
          }



      
     

      rat[j] =     ((x2-thex[k])*(d2[i]-y1))  / ((thex[k]-x1)*(d2[i]-y2) ) 


      

      kaka = (trishape[2]-trishape[5])*(trishape[6]-trishape[4])/((trishape[5]-trishape[1])* (trishape[6]-trishape[3]) )

      print(paste(sep = ' ' , kaka, rat[j],zip1,trishape[3], zip2, trishape[4]   ))
      
      ## title(sub=paste(sep='/', i, length(d1)))
      ## Sys.sleep(.8)

    }


     if(length(PLOT[PLOT==2])>0)
       {
         plot(I, rat)
         abline(h=1)
       }
return(rat)
}

###
colplot<-function(Aex, Ay,  cols = terrain.colors(100))
{
if(missing(cols)) {cols = terrain.colors(100)}
KR = round(length(Aex)/(length(cols)-1))

KX = floor(seq(from=1, length=length(Aex))/(KR))+1

plot(Aex, Ay, type='n', bg=0)
segments(Aex[1:(length(Aex)-1)], Ay[1:(length(Aex)-1)], Aex[2:length(Aex)], Ay[2:length(Aex)],type='l', col=cols[KX])
}





###  source("/home/lees/Progs/R_stuff/sung.chug.R")

phasetraj<-function(x, tau, cols, ...)
{
        ind = 1:(length(x)-tau)
        plot(x[ind], x[ind+tau], asp=TRUE , type='n')

    oz = 1:length(x[ind])
         hj = length(cols)-1
    colind = floor(hj* (oz-min(oz))/(max(oz)-min(oz)))+1
    
      a1 = x[ind]
      a2 = x[ind+tau]
        k = length(a1)
        
        #  lines(x[ind], x[ind+tau], type='l', col=cols[colind[oz]])
segments(a1[1:(k-1)], a2[1:(k-1)], a1[2:k], a2[2:k],  col=cols[colind[oz]], ... )

}
###  source("/home/lees/Progs/R_stuff/sung.chug.R")


Btraj<-function(ex,why, tau=14)
  {
    if(missing(tau)) { tau = 14 }
    pal =  terrain.colors(100)
    KR = round(length(ex)/(length(pal)-1))

    KX = floor(seq(from=1, length=length(ex))/(KR))+1

    par(bg=rgb(0,0,0), fg=rgb(1,1,1),col.axis=rgb(1,1,1),col.lab=rgb(1,1,1),col.main=rgb(1,0,0) ,col.sub=rgb(1,1,1)   )

    nf <- layout(matrix(c(1,2),2,1,byrow=TRUE), widths =c(8,8), heights=c(2,6), respect=TRUE)

    par(mai=c(0.5, 0.5, .2, 0.2))

    plot(ex,why, type='n')
    segments(ex[1:(length(ex)-1)], why[1:(length(ex)-1)], ex[2:length(ex)], why[2:length(ex)],type='l', col=pal[KX], lwd=1.8)

    segments(ex[1], max(why), ex[tau], max(why), col=rgb(1,1,1))

    
    phasetraj(why,14, terrain.colors(100), lwd=1.8)




  }


animate.phase<-function(x, y, tau)
  {

   ##   Get.Screens(2)

    pal = terrain.colors(100)
    KR = round(length(x)/(length(pal)-1))

    KX = floor(seq(from=1, length=length(x))/(KR))+1

   ##   par(bg=rgb(0,0,0), fg=rgb(1,1,1),col.axis=rgb(1,1,1),col.lab=rgb(1,1,1),col.main=rgb(1,0,0) ,col.sub=rgb(1,1,1)   )

   ##   dev.set(2)
 ##  RESCALE<-function(x, nx1, nx2, minx, maxx)


    rx = range(x)

    dx = diff(rx)

    
    ny = RESCALE(y, min(x)+0.8*dx, max(x), min(y), max(y))
    
 ##    plot(x,y,type='n')

    plot(range(x), range(x), asp=TRUE, type='n', axes=FALSE, ann=FALSE)

    axis(3)

    ind = 1:(length(y)-tau)
   ##   dev.set(3)
   ##   plot(y[ind], y[ind+tau], type='n')

    oz = 1:length(y[ind])
    hj = length(pal)-1
    colind = floor(hj* (oz-min(oz))/(max(oz)-min(oz)))+1
    
    a1 = y[ind]
    a2 = y[ind+tau]

na1 =  RESCALE(a1, min(x),   min(x)+0.8*dx, min(a1), max(a1))
na2 =  RESCALE(a2, min(x),  min(x)+0.8*dx, min(a2), max(a2))


yax1 = pretty(a1)
yax2 = pretty(a2)


sy = RESCALE(yax1, min(x),   min(x)+0.8*dx, min(a1), max(a1))
sx = RESCALE(yax2, min(x),   min(x)+0.8*dx, min(a1), max(a1))

    axis(side=1, at=sx, labels=yax2)
    axis(side=2, at=sy, labels=yax1)

    
    
    
    k = length(a1)
 par(bg=rgb(0,0,0), fg=rgb(1,1,1),col.axis=rgb(1,1,1),col.lab=rgb(1,1,1),col.main=rgb(1,0,0) ,col.sub=rgb(1,1,1)   )
    for(i in 1:(k-1))
      {
        ##  dev.set(2)
        segments(x[i], ny[i], x[i+1], ny[i+1], col=pal[colind[i]])
       ##   dev.set(3)

        segments(na1[i], na2[i], na1[i+1], na2[i+1], col=pal[colind[i]] )

        ##  Sys.sleep(0.05)
      }
    box()
  }


######################################################################
phase.portrait<-function(x, dtau=1:24, cols=rainbow(100), title="", asp=TRUE)
  {

### 
    ## make a phase protrait suite for examining phase space
    ##  USAGE: phase.portrait(champ, dtau=1:36)

    if(missing(dtau)) { dtau=1:24 }
    
    if(missing(cols)) { cols=rep(rgb(0,0,0), 100)  }
    if(missing(asp)) { asp = FALSE }
    

    k = length(dtau)

    if(k>12) { ppage = 12; par(mfrow=c(3,4)) }
    if(k>6&k<=12) { ppage = 12; par(mfrow=c(3,4)) }
    if(k>1 & k<=6) { ppage = 6; par(mfrow=c(3,2)) }
    if(k==1) { ppage = 1; par(mfrow=c(1,1)) }

    j = 0
    for(tau in dtau)
      {
        ind = 1:(length(x)-tau)
        plot(x[ind], x[ind+tau], type='n', asp=asp)
        j = j+1

        oz = 1:length(x[ind])

        hj = length(cols)-1
        
        colind = floor(hj* (oz-min(oz))/(max(oz)-min(oz)))+1
        
        a1 = x[ind]
        a2 = x[ind+tau]
        k = length(a1)
        
                                        #  lines(x[ind], x[ind+tau], type='l', col=cols[colind[oz]])
        segments(a1[1:(k-1)], a2[1:(k-1)], a1[2:k], a2[2:k],  col=cols[colind[oz]] )

        

        
        if(missing(title)) {  title(main=tau) }
        else
         {   title(main=title) }
        
                                        # locator()
        if(fmod(j, ppage)==0 & ppage>1) locator()
      }

  }




#############################################
###  source("/home/lees/Progs/R_stuff/sung.chug.R")
###


search.portrait<-function(SCHUGZ,  cols = terrain.colors(100))
  {

    if(missing(cols)) {  cols = terrain.colors(100)  }
  
    Get.Screens(2)

    for(ii in 1:length(SCHUGZ))
      {

        ACHUG = SCHUGZ[[ii]]
        chugs = ACHUG$chugs
        fnames = chugs$fn
        chugtmin = min(chugs$tims)
        chugtmax = max(chugs$tims)
        NH = GET.Kseis(fnames, kind=1, PLOT=FALSE, TWIN=c(chugtmin, chugtmax) )  
        aW = chugs$WIN
        temp = NH$JSTR[[sel]]
        meanval = mean(temp[ NH$ex>=aW[1]&NH$ex<=aW[2]  ])
### print(paste("mean val = ", meanval))
        NH$JSTR[[sel]] = NH$JSTR[[sel]]-meanval
        inst  = setTUNGsense(102)
        NH$JSTR[[sel]] = NH$JSTR[[sel]]/inst$sense
        units = inst$units
	x = NH$ex
	g = NH$JSTR[[sel]]
        chex = x[x>=aW[1]&x<=aW[2]]   
        champ = g[x>=aW[1]&x<=aW[2]]

        ##  write(champ, file="champ", ncolumns=1)

        
        dev.set(2)
        plot(chex, champ, type='n')
      
      

        KR = round(length(chex)/(length(cols)-1))

        KX = floor(seq(from=1, length=length(chex))/(KR))+1

        lines(chex, champ)
        segments(chex[1:(length(chex)-1)], champ[1:(length(chex)-1)], chex[2:length(chex)], champ[2:length(chex)],type='l', col=cols[KX])

        dev.set(3)
        phase.portrait(champ, dtau=1:24, cols=cols )
        locator()

      }
  }


###  source("/home/lees/Progs/R_stuff/sung.chug.R")
#############################################
###  break up a signal into parts, analyze each with varying methods

SIG.ANAL<-function(ex, why, DT=0.008, WINS=cW, DO=1, col=terrain.colors(100))
  {


 

    ## break a signal down and then analyze each part with desired stuff

    if(missing(DO)) { DO = 1 }
    if(missing(WINS)) { WINS = c(0,1) }
    if(missing(DT)) { DT = ex[2]-ex[1] }
   if(missing(col)) { col=terrain.colors(100)}
    
    ##  cW = WINS

    if(DO==1)
      {
        plot(ex, why, type='l')
        cloc  = plocator(COL=4)
        cW = cloc$x
        return(list(WINS=cW))
      }



    if(DO==2)
      {
        nwin = (length(WINS)-1)
###  par(mfrow=c(nwin,1))

        len2 =  2*next2(round(max(diff(WINS)*(1/DT))))
        J = (len2/2)+1
        JMAT = matrix(ncol=nwin, nrow=J)
        for(i in 1:nwin)
          {
            t1 = WINS[i]
            t2 = WINS[i+1]

            Aex = ex[ex>=t1&ex<=t2]   
            Ay =  why[ex>=t1&ex<=t2]

            ## plot(Aex, Ay, type='l')

            Ay = Ay-mean(Ay)
            Mspec =   mtapspec(Ay,DT, klen=len2,  MTP=list(kind=1,nwin=5, npi=3,inorm=0)  )
            f=Mspec$freq
            amp = Mspec$spec[1:length(f)]
            JMAT[,i] = amp
          }

        flag = f>=0.01 & f <= 10;
        PLOT.MATN(JMAT[flag,], dt=f[2]-f[1] )
        invisible(JMAT)
      }

    if(DO==3)
      {
        nwin = (length(WINS)-1)
        opar = par(no.readonly = TRUE)
        par(mfrow=c(nwin,1))
        par(mai=c(.2, .5 , .1, .5))

        for(i in 1:nwin)
          {
            t1 = WINS[i]
            t2 = WINS[i+1]
            Aex = ex[ex>=t1&ex<=t2]   
            Ay =  why[ex>=t1&ex<=t2]
            wlet.do(Ay, DT, noctave=7, zscale=3, col=col)

          }
   
        invisible( par(opar))

      }

    if(DO==4)
      {
        nwin = (length(WINS)-1)
        opar = par(no.readonly = TRUE)
        par(mfrow=c(nwin,1))

        for(i in 1:nwin)
          {
            t1 = WINS[i]
            t2 = WINS[i+1]
            Aex = ex[ex>=t1&ex<=t2]   
            Ay =  why[ex>=t1&ex<=t2]
            DEV = evolfft(Ay,  DT, Nfft=4096, Ns=250 , Nov=240,  fl=0, fh=10)
            plotevol(DEV, log=1, fl=0, fh=10, col=col)


          }
   
        invisible( par(opar))

      }


  }




###  source("/home/lees/Progs/R_stuff/sung.chug.R")
#############################################
