######################################################
###  source("/home/lees/Progs/R_stuff/tung.R")
#########
#########
#########
setTUNGsense<-function(K)
  {
    ###  instruments
    ### AI = c("40T", "3T",  "LD",  "MC",  "EL")
    ###  1 2 101 102 103

    ###  MC = 80 mV/PA  = 0.008 V/PA
    codes = c(1,    2,   101,   102,   103)
    AI = c("40T", "3T",  "LD",    "EL", "MC")
    II = c(0.8/1000, 1.5/1000, 0.04841724,  .1,  0.08 )
    unit = c("mu m/s", "mu m/s","PA", "PA","PA")

    i = match(K, codes)
   return(list(code=codes[i], inst=AI[i], sense=II[i], units=unit[i]))
    
  }

setUname<-function(TIM, style=0)
{
  ###   create a name for a variable using a time to the second
  isec = 	floor(TIM$sec[1])


  if(missing(style)) { style=1 }

  if(style==0)
    {
      ENAME = paste(sep="_", 	format.default(TIM$yr[1], digits=4), 
	format.default(TIM$jday[1], digits=2, trim=FALSE), 
	format.default(TIM$hour[1], digits=2, trim=FALSE), 
	format.default(TIM$min[1], digits=2, trim=FALSE), 
	format.default(isec, digits=2, trim=FALSE)
	)
    }
  else
    {

      ENAME = paste(sep="_", 	formatC(TIM$yr[1], format="d", wid=4), 
	formatC(TIM$jday[1], format="d", wid=2), 
	formatC(TIM$hour[1], format="d", wid=2,  flag="0"), 
	formatC(TIM$min[1], format="d", wid=2,flag="0"), 
	formatC(isec, format="d", wid=2, flag="0")
	)

    }


  return(ENAME)	
}
######################################################
getmario<-function(DB=DB, timeA=timeA, timeB=timeB, i)
{
##  getmario(DB, timeA = timeA, timeB=timeB, 7)
##  getmario(DB, timeA = timeA[7:10], timeB=timeB[7:10])
  
  if(missing(DB) ) { DB=DB }
  if(missing(timeA) ) { timeA=timeA }
  if(missing(timeB) ) { timeB=timeB }

print(i)
flag = (timeA[i] > DB.T1 & timeA[i]<DB.T2) | (timeB[i]> DB.T1 & timeB[i]<DB.T2)
print(DB$name[flag])
if(length(DB$name[flag])<1) next;
fnames = DB$name[flag]
Fisthere = file.exists(fnames) 
gnames = fnames[Fisthere]
if(length(gnames)<1) next;
###   system(paste(sep=' ', "seissig -se ", length(gnames),paste(gnames, collapse=' ')))
GG = GET.seis(gnames, kind=1, PLOT=FALSE)
GH=prepGG3(GG)
sel = 1:length(GH$JSTR)
## sel = c(1,4,5,6)
tbegjd = GH$info$jd+GH$info$hr/24+ GH$info$mn/(24*60)+(GH$info$sec+GH$info$msec/1000+GH$info$t1)/(24*3600)
Atim1 = (timeA[i]-tbegjd)*24*3600 
Atim2 = (timeB[i]-tbegjd)*24*3600 

twin = c(max(Atim1)-5, max(Atim2))

return(GH)

  }

seemario<-function(DB=DB, timeA=timeA, timeB=timeB)
{
##  seemario(DB, timeA = timeA[1:3], timeB=timeB[1:3])
##  seemario(DB, timeA = timeA[7:10], timeB=timeB[7:10])

  
  if(missing(DB) ) { DB=DB }
  if(missing(timeA) ) { timeA=timeA }
  if(missing(timeB) ) { timeB=timeB }

  
for(i in 1:length(timeA))
{
print(i)
flag = (timeA[i] > DB.T1 & timeA[i]<DB.T2) | (timeB[i]> DB.T1 & timeB[i]<DB.T2)
print(DB$name[flag])
if(length(DB$name[flag])<1) next;
fnames = DB$name[flag]
Fisthere = file.exists(fnames) 
gnames = fnames[Fisthere]
if(length(gnames)<1) next;
###   system(paste(sep=' ', "seissig -se ", length(gnames),paste(gnames, collapse=' ')))
GG = GET.seis(gnames, kind=1, PLOT=FALSE)
GH=prepGG3(GG)

sel = 1:length(GH$JSTR)
## sel = c(1,4,5,6)
tbegjd = GH$info$jd+GH$info$hr/24+ GH$info$mn/(24*60)+(GH$info$sec+GH$info$msec/1000+GH$info$t1)/(24*3600)
Atim1 = (timeA[i]-tbegjd)*24*3600 
Atim2 = (timeB[i]-tbegjd)*24*3600 

twin = c(max(Atim1)-5, max(Atim2))


YN = PLOT.SEISN(GH, WIN=twin, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
title(main=paste(sep='/', i,length(timeA)))
abline(v=max(Atim1), col=rgb(1,0.8, 0.8))

 locator()
}

}

##################################################
GLUEseisDUMP<-function(dat, KNOTES)
      {
	###  find duplicated stations in a matrix and
        ###   fill in the traces that are continuations
	### return the new matrix and the vector duplicates
	dot = which(duplicated(KNOTES))

       	### print(paste(sep=' ', "in GLUEseisDUMP", length(dot)))
	G = dat 
	for(i in 1:length(dot))
	  {
	    w = which(!is.na(match(KNOTES, KNOTES[dot[i]])))
	    
	    a =  dat[,w[1]]
            b =  dat[,w[2]]
	    a[!is.na(b)] = b[!is.na(b)]

            
	   G[,w[1]]=  a 
	    
	  }
	invisible(G)
	
      }


###   source("/home/lees/Progs/R_stuff/tung.R")
Get.DumpDat<-function(ifile, DIR, stloc=1, cmploc=2, XSTA=NULL, GLUE=TRUE, DATA=TRUE)
{
  ###  get a data file that has been dumped and saved by seissig
  ###  fill in a structure for use in plotting and analysis
  ###  ifile is the ascii dump file from seissig
  ###  DIR = directory where the ifile is located
  ###    stloc = position in string where the station name resides
  ###    cmploc = position in string where the component  name resides
    if(missing(DIR))
      {
        DIR="."
      }
    if(missing(stloc))
      {
        stloc=NULL
      }
    if(missing(cmploc))
      {
        cmploc=NULL
      }
    if(missing(XSTA))
      {
        XSTA=NULL
      }
    if(missing(GLUE))
      {
        GLUE = TRUE
      }
    if(missing(DATA))
      {
        DATA=TRUE
      }

    

    d = unlist(strsplit(ifile, "_"))
    dfile = paste(sep="_", d[1], "DATA", d[3])

    info = scan(file=paste(sep="/",DIR,ifile), quiet = TRUE, list(name="", yr=0, mo=0, dom=0,
                                                 hr=0, mn=0, sec=0, msec=0, dt=0, t1=0,
                                                 t2=0, off=0, n1=0, n2=0, n3=0, n=0))

    nn = length(info$name)

    if(DATA==TRUE)
      {
        dat = matrix(scan(file=paste(sep="/",DIR,dfile)), ncol=nn,  byrow=TRUE)
      }
    else
      {
        dat = NULL

      }
    

    KNOTES = rep(" ", nn)
    STNS = rep(" ", nn)
    COMPS = rep(" ", nn)
    
     for(i in 1:nn)
          {
            g = unlist(strsplit(info$name[i] , split='/' ))
            fnam = g[length(g)]
            h = unlist(strsplit(fnam, split="\\." ) )
            if(is.null(cmploc)==TRUE)
              {
                COMPS[i] = h[length(h)]
              }
            else
              {
                COMPS[i] = h[cmploc]
              }
            if(is.null(stloc)==TRUE)
              {
                STNS[i] = h[length(h)-1]
              }
            else
              {

                STNS[i] = h[stloc]
              }
            cnam = paste(sep='.', STNS[i], COMPS[i])

            ###  cnam= the component name
 
            KNOTES[i] = cnam
          }
    
    dot = which(duplicated(KNOTES))
   ###   print(KNOTES)
   ###   print(dot)
    if(DATA==TRUE)
      {
        if(length(dot)>=1)
          {
            dat =  GLUEseisDUMP(dat, KNOTES)
            
          }
      }
    savei = which(!duplicated(KNOTES))

    KNOTES = KNOTES[savei]
    STNS = STNS[savei]
    COMPS = COMPS[savei]

    if(DATA==TRUE)
      {
        dat = dat[,savei]
      }
    
    info = list(name=info$name[savei], yr=info$yr[savei], mo=info$mo[savei], dom=info$dom[savei],
      hr=info$hr[savei], mn=info$mn[savei], sec=info$sec[savei], msec=info$msec[savei], dt=info$dt[savei], t1=info$t1[savei],
      t2=info$t2[savei], off=info$off[savei], n1=info$n1[savei], n2=info$n2[savei], n3=info$n3[savei], n=info$n[savei])

    nn = length(info$name)

    info$jd =  jday(info$yr, info$mo, info$dom)

    ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)
    nn = length(info$name)
        jd = jday(info$yr[1],info$mo[1],info$dom[1])
        ##
        wintim = jd + info$hr[1]/24+ info$mn[1]/(24*60)+(info$sec[1]+info$msec[1]/1000+info$t1[1]-info$off[1])/(24*3600)

    dt = info$dt

    if(DATA==TRUE)
      {
        p = dim(dat)
        ex = seq(0,p[1]-1)*info$dt[1]
        JMAT = matrix(ncol=nn, nrow=length(ex) )
        ascd = as.list(1:nn)
        
        for(i in 1:nn)
          {
            
            JMAT[,i] =  dat[,i]
            ascd[[i]] = dat[,i]
          }
        
      }
    else
      {
        ex = NULL
        JMAT = NULL
        ascd = NULL
        
      }

        USTA = unique(STNS)
        pcol = rep(1, nn)
        for(m in 1:length(USTA))
          {
            pcol[!is.na(match( STNS, USTA[m]))] = 2+m
          }

        if(!is.null(XSTA))
          {

            pcol[!is.na(match( STNS, XSTA))] = 2

          }
        ok = order(KNOTES)

    return(list(JSTR=ascd, STNS=STNS, dir=DIR, ifile=ifile, COMPS= COMPS, dt=info$dt, KNOTES=KNOTES, info=info, dat=dat, nn=nn, ex=ex, pcol=pcol, ok=ok, wintim=wintim, ftime=ftime, USTA=USTA, JMAT=JMAT  ))

  }
##################################################
add.pick<-function(ppick, ypick, ipick, m)
  {


  }

plot.WPX<-function(t0, STNS, COMPS, WPX)
  {
    ##     WPX[[NPX]] =  list( pick=c(NH$info$yr[ipick], NH$info$jd[ipick], NH$info$hr[ipick], NH$info$mn[ipick], asec), kind="SHAPE", sta= STNS[ypick], comp=COMPS[ypick], PULS=PULS)

    ### match(JH$COMPS, "V")
    ###  match(JH$STN, "MAS")&match(JH$COMPS, "V")

    du = 1/length(STNS)

    
    for(i in 1:length(WPX))
      {
        if( WPX[[i]]$kind== "SHAPE")  { next; }
        
        imatch = which(match(STNS, WPX[[i]]$sta)& match(COMPS,WPX[[i]]$comp))
        
       ###  print(paste(sep=' ', imatch, WPX[[i]]$sta, WPX[[i]]$comp))

              
        ypixA = (length(STNS)-imatch)*du
        ypixB =  ypixA+du
        x1 = secdif(   t0$jd, t0$hr, t0$mn, t0$sec, WPX[[i]]$pick[2],  WPX[[i]]$pick[3],  WPX[[i]]$pick[4], WPX[[i]]$pick[5])
        
        segments(x1, ypixA, x1, ypixB, col=WPX[[i]]$col)
        text(x1, ypixB, labels=WPX[[i]]$kind, col=WPX[[i]]$col, pos=4)

        if(WPX[[i]]$kind=="A")
          {
            if(WPX[[i]]$sta=="MAS") { ptim = 3516/340 }
            if(WPX[[i]]$sta=="JUI") { ptim = 4168/340 }
            if(WPX[[i]]$sta=="RUN") { ptim = 5889/340 }
            
            x2 = secdif(   t0$jd, t0$hr, t0$mn, t0$sec, WPX[[i]]$pick[2],  WPX[[i]]$pick[3],  WPX[[i]]$pick[4], WPX[[i]]$pick[5]-ptim)

            segments(x2, ypixA, x2, ypixB, col=rgb(1.0, 0.8,0.8), lty=2)
            
          }

        
      }
    
  }





###   source("/home/lees/Progs/R_stuff/tung.R")
#############################
######################################################################
######################################################################
######################################################################
#################   individual pulse analysis
tung.pulse<-function(r,q, dt)
  {
    ###  plot a small pulse and calculate a characterization
    ### 
    ## chug.pulse(r,q,dt)
    
    jp = hilow(q)
    
    t1 = min(r)
    mid = mean(r)
    dmid = (mid-r[jp$lo])
    
    
    omid = c(max(which(sign(dmid)==1)), min(which(sign(dmid)==-1)))
    mins= sort(jp$lo[c(omid[1], omid[2])])
    
    plot(r,q, type='b')
    title("CLICK TWICE IN WINDOW")
    ##  title(main=paste(sep=' ', i,'of',length(AL))) 
    points(r[jp$hi],q[jp$hi], col=2)
    points(r[jp$lo],q[jp$lo], col=3)
    
    abline(v=r[mins], col=2)
    
    vp = plocator(COL=rgb(1.0,0.5,0.5))
    
    nvp = length(vp$x)

    rvp = sort(vp$x)
    
    if(nvp>1)
      {
        ###   source("/home/lees/Progs/R_stuff/tung.R");
     left =     which.min(abs(r-rvp[nvp-1]) )
     right =    which.min(abs(r-rvp[nvp]) )
    
      }
    mins = c(left, right)
    
    abline(v=r[c(left, right)], col=3)
    
    s = q[r>=r[left]&r<=r[right]]
        
    sum0 = sqrt(sum(s*s)/length(s))
    
    imax = left-1+which.max(q[r>=r[left]&r<=r[right]]^2)

    
    abline(v=r[imax])
   
    ### p1 = q[jp$hi[imax]]-q[jp$lo[c(omid[1], omid[2])]]
    
    ###  tees = t1+r[jp$lo[c(omid[1], omid[2])]]
    ###   t0 = mid+t1

    Ex = r[mins]
    Ey = q[mins]

    ###  find the max point that lies between the two low points


    Cx = r[imax]
    Cy = q[imax]

    
   ###   Cx = r[jp$hi[imax]]
    ###  Cy = q[jp$hi[imax]]

    lines(c(Ex[1],  Ex[2], Cx, Ex[1]), c(Ey[1],  Ey[2], Cy, Ey[1]))

    A1 = c(Ex[1]-Cx, Ey[1]-Cy, 0)
    A2 = c(Ex[2]-Cx, Ey[2]-Cy, 0)
    
    ar2 = 0.5*vlen(xprod(A1,A2))

    tr = r[r>=Ex[1]&r<=Ex[2] ]
    tq = q[r>=Ex[1]&r<=Ex[2] ]

 
     DefInt = integ1(tr, tq)

    ### print(paste(sep=' ',DefInt[1],DefInt[2] , s4, s3))
    #### Ex[1], Ex[2] = left minimum
     #### Ey[1], Ey[2] = right  minimum
     ####    Cx, Cy  = center (max?)
    ####    7:  ar2 = area of triangle
    ####    8:  DefInt[1]  = integral under curve
    ####    9:  DefInt[2]  = integral under curve ( bottom triangle removed)
    ####   10:  sum0   = RMS amplitude
    
    return(c(Ex[1], Ex[2], Ey[1], Ey[2], Cx, Cy, ar2, DefInt[1], DefInt[2], sum0))
  }
######################################################################
######################################################################
######################################################################


 ###   source("/home/lees/Progs/R_stuff/tung.R");   a = PICK.MARIO(GH,  sel, WIN=twin) 


PICK.MARIO<-function(GH, sel=1:length(GH$dt), WIN=NULL, APIX=NULL, SHOWONLY=FALSE, CHOP=FALSE)
{
###  a = PICK.MARIO(GH,  sel, WIN=twin)
  
  if(missing(WIN)) { WIN = NULL }
  if(missing(sel)) { sel = 1:length(GH$dt)}
  if(missing(APIX)) { APIX = NULL}
  if(missing(SHOWONLY)) { SHOWONLY=FALSE}
  if(missing(CHOP)) { CHOP=TRUE }
  

  if(CHOP==TRUE)
    {
      if(!is.null(WIN))
        {
          NH = CHOP.SEISN(GH, sel , WIN=WIN)
        }
      else
        {
          
          NH = GH
        }
      
      WIN = c(0, NH$dt*length(NH$JSTR[[1]]))
      
    }
  else{
    
    NH = GH
  }




  
  labs = c("DONE", "zoom out", "zoom in", "restore", "PPix", "AccPIX", "XPIX", "CPIX", "NULL", "AUTOP","SIG", "SPEC", "SGRAM" )
  colabs = rep(1,length(labs))
  colabs[c(5,6,7,9)] = c(2,3,4,6)
  pchlabs = rep(4,length(labs))
  pchlabs[c(5,6,7,9)] = c(15,16,17,18)


  
  NSEL = length(NH$dt[sel])

  if(is.null(APIX)==TRUE)
    {
      WPX = as.list(NA)
      NPX = 0
      
   
      
    }
  else
    {
      ## print("reading in pickfile")
##    APIX=SAVDAT[[ii]]
      WPX = APIX
      NPX = length(WPX)

      pdb = unlist(WPX)
      npdb = names(unlist(pdb))
      
   
    ##  print(paste(sep=' ', "read in pickfile",NPX))
     ## print(xpix)
    }
  

  
  STNS = NH$STNS[sel]
  COMPS = NH$COMPS[sel]
  UNIsta = unique(STNS)
  
   NUNI = length( UNIsta)

###  Upix = as.list(1:NUNI)
###  names(Upix) = UNIsta

  ###  TUNGURAHUA Stations c("MAS", "JUI" ,"RUN",   "OVT")
  ###  TUNGURAHUA components "V" "I"


 pcols = rep(rgb(0,0,0), NSEL)

  pcols[COMPS=="I" | COMPS=="1"] = rgb(0,.4,0)
  pcols[COMPS=="V" | COMPS=="4"] = rgb(0.4,0,0)
  pcols[COMPS=="J" | COMPS=="K"] = rgb(0,0,0.4)
  
  
   ords = match(STNS,c("MAS", "JUI" ,"RUN",   "OVT"))
   ordc = match(COMPS, c("I", "J", "K", "V", "N",  "E"))

  ordsel = order( ords+ordc/10)
  
  sel = ordsel
   du = 1/NSEL

  STNS = STNS[sel]
  COMPS = COMPS[sel]

  isel = sel[1]
  
  T0 = list(jd=NH$info$jd[isel], hr=NH$info$hr[isel], mn=NH$info$mn[isel], sec=(NH$info$sec[isel]+NH$info$msec[isel]/1000+NH$info$t1[isel]-NH$info$off[isel]))

  YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel , notes=NH$KNOTES[sel], COL=pcols[sel])

  TE = !is.na(WPX[[1]])

       
     if(NPX>0 & TE[1])
        {
         
          plot.WPX(T0, STNS, COMPS, WPX)
        ##   segments(xpix, ypixA, xpix, ypixB, col=colpix)
         ##  text(xpix, ypixB, labels=cpixa, col=colpix, pos=4)
        }
      

  if(SHOWONLY==TRUE) { return(0) }

  MAINdev = dev.cur()

  ###  Get.Screens(2)
  dev.set( MAINdev)
  
###   if(NPX>0)
 ###       {

  ###        plot.WPX(T0, STNS, COMPS, WPX)
        ##   segments(xpix, ypixA, xpix, ypixB, col=colpix)
         ##  text(xpix, ypixB, labels=cpixa, col=colpix, pos=4)
   ###     }
      
  
  u = par("usr")
  sloc = list(x=c(u[1],u[2]))
  ppick  = NA
  spick  = NA
  xpick = NA
#### ftime = Zdate(NH$info, sel[1],0)
#### mtext( ftime, side = 3, at = 0, line=0.5, adj=0)
  
####  title("LEFT 0 Click = done; 1 Click=replot;   2 Click=zoom")
  buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
  
####  NV = LabelBAR(labs)
 ###   zloc = plocator(COL=rgb(1,0.8, 0.8))
zloc = plocator(COL=rgb(1,0.8, 0.8), NUM=FALSE , YN=NSEL, style=1)
  
  Nclick = length(zloc$x)
  if(is.null(zloc$x)) { return(NULL) }
  K = whichbutt(zloc ,buttons)
  
  sloc = zloc
  
  while(Nclick>0)
    {
      
      if(K[Nclick] == 1)
        {
          break;
        }
      
      
      if(Nclick==1 & K[Nclick]==0)
        {
          WIN = NULL
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel , notes=NH$KNOTES[sel], COL=pcols[sel])
          
          u = par("usr")
          
          sloc = list(x=c(u[1],u[2]))
          
          
        }

       ####################  START  BUTTON DEFINITIONS    ###########################

      
       ###################   RESTORE  ###########################      
      if(K[Nclick]==4)
        {
          WIN = NULL
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel , notes=NH$KNOTES[sel], COL=pcols[sel])
          u = par("usr")
          L = length(sloc$x)
          if(L>1)
            {
              abline(v=sloc$x[c(L-1,L)], col=gray(0.8), lty=2)
            }
          sloc = list(x=c(u[1],u[2]))
          
        }

      ################  ZOOM IN BY WINDOW CLICKING   #################
      if(Nclick>1 & K[Nclick]==0)
        {
          
          WIN  = sort(zloc$x[c( Nclick-1, Nclick)])
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel , notes=NH$KNOTES[sel], COL=pcols[sel])
         #### ftime = Zdate(NH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)
          sloc = zloc
        }

      ###################   ZOOM  OUT  ###########################      
      if(K[Nclick]==2)
        {
          u = par("usr")
          DX = (u[2]-u[1])*0.3
          zloc = list(x= c(u[1]-DX, u[2]+DX))
          WIN  = zloc$x
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel , notes=NH$KNOTES[sel], COL=pcols[sel])
         #### ftime = Zdate(NH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)

          sloc = zloc
        }
      ###################   ZOOM IN   ###########################      
       if(K[Nclick]==3)
        {
          u = par("usr")
          DX = (u[2]-u[1])*0.3
          zloc = list(x= c(u[1]+DX, u[2]-DX))
          WIN  = zloc$x
         
          YN = PLOT.SEISN(NH, WIN=WIN, dt=NH$dt[sel], sel=sel , notes=NH$KNOTES[sel], COL=pcols[sel])
         #### ftime = Zdate(NH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)

          sloc = zloc
        }

      ###################   P PICK   ###########################
      if(K[Nclick]==5 & Nclick>1)
        {  
         ppick = zloc$x[Nclick-1]
         ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
         ipick = sel[ypick]
         m = match(STNS[ypick],UNIsta)
       ###  Upix[[m]]$p  = ppick
         
       ###   PPIX(list(x=zloc$x[Nclick-1], y=zloc$y[Nclick-1]), YN=NSEL, col=3, lab="P")
         jj = floor((zloc$y[Nclick-1])/du)

         NPX = NPX+1

          asec = NH$info$sec[ipick]+NH$info$msec[ipick]/1000+NH$info$t1[ipick]-NH$info$off[ipick]+ppick
         WPX[[NPX]] = list( pick=c(NH$info$yr[ipick], NH$info$jd[ipick], NH$info$hr[ipick], NH$info$mn[ipick], asec), kind="P", sta= STNS[ypick], comp=COMPS[ypick], col=2)
         
    
         #### abline(v=ppick, col=3)
        }

      ###################   A  PICK   ###########################      
      if(K[Nclick]==6 & Nclick>1)
        {
          
### print(paste(sep=" " , "WIN=",sloc$x))
          ppick = zloc$x[Nclick-1]
 ###         abline(v=ppick, col=2)
       ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
         m = match(STNS[ypick],UNIsta)
          jj = floor((zloc$y[Nclick-1])/du)
       ###  Upix[[m]]$s  = ppick
         
       ###   PPIX(list(x=zloc$x[Nclick-1], y=zloc$y[Nclick-1]), YN=NSEL, col=3, lab="A")
          NPX = NPX+1
         
           asec = NH$info$sec[ipick]+NH$info$msec[ipick]/1000+NH$info$t1[ipick]-NH$info$off[ipick]+ppick
         WPX[[NPX]] = list( pick=c(NH$info$yr[ipick], NH$info$jd[ipick], NH$info$hr[ipick], NH$info$mn[ipick], asec), kind="A", sta= STNS[ypick], comp=COMPS[ypick], col=3)
        
        }

      ###################   X  PICK   ###########################      
      
      if(K[Nclick]==7 & Nclick>1)
        {
          
###   print(paste(sep=" " , "WIN=",sloc$x))
          ppick = zloc$x[1:(Nclick-1)]
   ###        abline(v=ppick, col=4)

          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          
         m = match(STNS[ypick],UNIsta)
       ###  Upix[[m]]$x  = ppick
         
       ###   PPIX(list(x=zloc$x[Nclick-1], y=zloc$y[Nclick-1]), YN=NSEL, col=3, lab="P")
          jj = floor((zloc$y[Nclick-1])/du)


          NPX = NPX+1
          ###   WPX[[NPX]] = list( yr=NH$info$yr[ipick], jd=NH$info$jd[ipick], hr=NH$info$hr[ipick], mn=NH$info$mn[ipick], sec=NH$info$sec[ipick],
          ##### msec=NH$info$msec[ipick], t1=NH$info$t1[ipick], off=NH$info$off[ipick], x=ppick, yA=jj*du, yB=jj*du+du, kind="X",
          ########  sta= STNS[ypick], comp=COMPS[ypick], col=4)
      asec = NH$info$sec[ipick]+NH$info$msec[ipick]/1000+NH$info$t1[ipick]-NH$info$off[ipick]+ppick
         WPX[[NPX]] = list( pick=c(NH$info$yr[ipick], NH$info$jd[ipick], NH$info$hr[ipick], NH$info$mn[ipick], asec), kind="X", sta= STNS[ypick], comp=COMPS[ypick], col=3)
          
       
        }
      ###################   C  PICK   ###########################      
      
      if(K[Nclick]==8 & Nclick>1)
        {
          
###   print(paste(sep=" " , "WIN=",sloc$x))
          ppick = zloc$x[1:(Nclick-1)]
   ###        abline(v=ppick, col=4)

          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          
         m = match(STNS[ypick],UNIsta)
       ###  Upix[[m]]$x  = ppick
         
       ###   PPIX(list(x=zloc$x[Nclick-1], y=zloc$y[Nclick-1]), YN=NSEL, col=3, lab="P")
          jj = floor((zloc$y[Nclick-1])/du)


          NPX = NPX+1
          ###   WPX[[NPX]] = list( yr=NH$info$yr[ipick], jd=NH$info$jd[ipick], hr=NH$info$hr[ipick], mn=NH$info$mn[ipick], sec=NH$info$sec[ipick],
          ##### msec=NH$info$msec[ipick], t1=NH$info$t1[ipick], off=NH$info$off[ipick], x=ppick, yA=jj*du, yB=jj*du+du, kind="X",
          ########  sta= STNS[ypick], comp=COMPS[ypick], col=4)
      asec = NH$info$sec[ipick]+NH$info$msec[ipick]/1000+NH$info$t1[ipick]-NH$info$off[ipick]+ppick
         WPX[[NPX]] = list( pick=c(NH$info$yr[ipick], NH$info$jd[ipick], NH$info$hr[ipick], NH$info$mn[ipick], asec), kind="C", sta= STNS[ypick], comp=COMPS[ypick], col=3)
          
       
        }

      ###################   REMOVE  PICKs   ###########################      
 
      
      if(K[Nclick]==9)
        {
          NPX = 0
          WPX = as.list(NA)
          
        
        }

      ###################   AUTO  PICKs   ###########################      
 
      if(K[Nclick]==10 & Nclick>=3)
        {
         
         ###  u = par("usr")
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          print(paste(sep=' ',ypick, NH$info$name[ ipick]))
          
         ###   amp = NH$JSTR[[j]][NH$ex>sloc$x[1]&NH$ex<sloc$x[2] ]
          
          print(paste(sep=' ',YN$DX[1], YN$DX[2], WIN[1], WIN[2]))
          famp = NH$JSTR[[ipick]]

           pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
          Xamp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]

       ###     dev.set(3)
          
       ###   plot.ts(Xamp)
        ###  locator()
        ###  dev.set(2)
          

          
         ### KPIX = autopick(Xamp, which.max(abs(Xamp)) )
         ###  ktarg = which.max(abs(Xamp))
          
         ### ktarg = floor((zloc$x[Nclick-1]-YN$DX[1])/NH$dt[ypick])
         ktarg = which.max(abs(Xamp))

          ###  print(paste(sep=' ',"DUMP",zloc$x[Nclick-1], ktarg,which.max(abs(Xamp))))
          ###   source("/home/lees/Progs/R_stuff/tung.R");   a = PICK.MARIO(GH,  sel, WIN=twin) 

                 
        ###    KPIX = autopick(Xamp, ktarg )
          X11()

          if(COMPS[ipick] == "I")
            {
              fy = butfilt(Xamp, fl=.5, fh=20, 0.008, "HP", "BU" )
              RAT = ratcurve(fy, dt=0.008, fwlen =  75,  bwlen  = 125, PLOT=TRUE)
            }
          else
            {
              fy = butfilt(Xamp, fl=.2, fh=20, 0.008, "HP", "BU" )
              RAT = ratcurve(fy, dt=0.008, fwlen =  175,  bwlen  = 175, PLOT=TRUE)
            }

          
          dev.set( MAINdev)
          
          
          ### print(KPIX)
         ### dev.set(dev.next())
          
          ### plot.ts(Xamp)
          ### abline(v=KPIX$ind, col=2)
           ###  dev.set(dev.next())

          autpix = pwin[1]+RAT$ind*NH$dt[ipick]
          print(autpix)
          abline(v=autpix, col=2)
          
          
        }

      
      ###################   PULSE ANALYSIS   ###########################      
 
      if(K[Nclick]==11 & Nclick>=3)
        {
         ###  u = par("usr")
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          print(paste(sep=' ',ypick, NH$info$name[ ipick]))

          famp = NH$JSTR[[ipick]]
          ###  need to flip the accoustic trace?

          pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
          temp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]
          Xamp =  -1*temp
          smallex = NH$ex[ NH$ex > pwin[1] & NH$ex <pwin[2]]
          
          X11()
          ###  plot.ts(Xamp)

          PULS = tung.pulse( smallex , Xamp , NH$dt[ipick])
          NPX = NPX+1
               asec = NH$info$sec[ipick]+NH$info$msec[ipick]/1000+NH$info$t1[ipick]-NH$info$off[ipick]+pwin[1]
           WPX[[NPX]] =  list( pick=c(NH$info$yr[ipick], NH$info$jd[ipick], NH$info$hr[ipick], NH$info$mn[ipick], asec), kind="SHAPE", sta= STNS[ypick], comp=COMPS[ypick], PULS=PULS)


             
          dev.set( MAINdev)
  
          

          
        }
      
      ###################   FREQUENCY ANALYSIS   ###########################      
 
      if(K[Nclick]==12 & Nclick>=3)
        {
         ###  u = par("usr")
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          print(paste(sep=' ',ypick, NH$info$name[ ipick]))

          famp = NH$JSTR[[ipick]]
          ###  need to flip the accoustic trace?

         pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
          
          temp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]
          
          g  =  list(y=temp-mean(temp), dt=NH$dt[ipick])
          ### g$x = NH$ex[ NH$ex > zloc$x[Nclick-2] & NH$ex <zloc$x[Nclick-1]]
  
          X11()
           Spec = MTMplot(g, 0.1, 20, PLOT=TRUE)
          dev.set( MAINdev)
  
          ###  dev.off(dev.cur())
    ###   source("/home/lees/Progs/R_stuff/tung.R");
          ###     a = PICK.MARIO(GH,  sel, WIN=twin) 

          
        }
      
      ###################   SPECTROGRAM  ANALYSIS   ###########################      
 
      if(K[Nclick]==13 & Nclick>=3)
        {
         ###  u = par("usr")
          ypick = length(sel)-floor(length(sel)*zloc$y[Nclick-1])
          ipick = sel[ypick]
          print(paste(sep=' ',ypick, NH$info$name[ ipick]))


          famp = NH$JSTR[[ipick]]
          ###  need to flip the accoustic trace?

          pwin = sort( c(zloc$x[Nclick-2], zloc$x[Nclick-1]))
          
          Xamp =  famp[ NH$ex > pwin[1] & NH$ex <pwin[2]]
 
       
          ###  smallex = NH$ex[ NH$ex >  pwin[1] & NH$ex < pwin[2]]

         DEV = evolfft(Xamp,NH$dt[ipick] , Nfft=4096, Ns=250 , Nov=240,  fl=0, fh=15  )

        
          X11()
          plotevol(DEV, log=1, fl=0, fh=15, col=rainbow(50))
          
          dev.set(MAINdev)
          
        }
      ####################  END BUTTON DEFINITIONS    ###########################      


            ###################   WRAP UP and PLOT AGAIN   ###########################      

      
      ###   source("/home/lees/Progs/R_stuff/tung.R");   a = PICK.MARIO(GH,  sel, WIN=twin) 

       ###  a = PICK.MARIO(GH,  sel, WIN=twin)
      ####  plot the picks

     ####   fin = ftorn[ii]
     ###    JH = Get.DumpDat( fin, "/home/beer/lees/DUMP/MARIO2", stloc=6, cmploc=7, XSTA=NULL)
      ####  a = PICK.MARIO(JH,sel=1:length(JH$dt), WIN=NULL)



      
      if(NPX>0)
        {

          plot.WPX(T0, STNS, COMPS, WPX)
          
         ##  segments(xpix, ypixA, xpix, ypixB, col=colpix)
         ##  text(xpix, ypixB, labels=cpixa, col=colpix, pos=4)
        }
      
      
        buttons = rowBUTTONS(labs, col=colabs, pch=pchlabs)
 
###  NV = LabelBAR(labs)
      zloc = plocator(COL=rgb(1,0.8, 0.8), NUM=FALSE , YN=length(sel), style=1)
      Nclick = length(zloc$x)
      if(is.null(zloc$x)) { return(sloc) }
      K =  whichbutt(zloc ,buttons)
### K = ValBAR(NV, zloc)
###  print(paste(sep=" ", "K=",K))
      
    }

  ### PRET = list(TPIX=TPIX, xpix=xpix,ypixA=ypixA, ypixB=ypixB,cpixa= cpixa, cpixb=cpixb, cpixc=cpixc, colpix=colpix)
 ###  return(PRET)
  return(WPX)
}		
##################################################
#####  rm( getmario, seemario, Get.DumpDat, add.pick, tung.pulse, PICK.MARIO)
get1pick<-function(a, STA)
{

  k = length(a)

  if(k<2) return(NULL)
  ua = unlist(a)
  psta = ua[names(ua) == "sta"]
  pcomp = ua[names(ua) == "comp"]
  ppick = ua[names(ua)=="kind"]
  yr = as.numeric(ua[names(ua)=="pick1"])
  jd = 	as.numeric(ua[names(ua)=="pick2"])
  hr = as.numeric(ua[names(ua)=="pick3"])
  mn = as.numeric(ua[names(ua)=="pick4"])
  sec = as.numeric(ua[names(ua)=="pick5"])

  P1 = paste(sep=' ', psta,pcomp,  ppick, yr, jd,hr, mn,  sec)
  t = recdate(jd,hr, mn,  sec)

  P2 = paste(sep=' ', psta,pcomp,  ppick, yr, t$jday,t$hour, t$min,  t$sec)
  return(P2)
}


###   source("/home/lees/Progs/R_stuff/tung.R")
