###  
##   source("/home/lees/Progs/R_stuff/xmcolor.R")
##

source("/home/lees/Progs/R_stuff/General.R")

setXMCOL<-function()
{
  XMCOL<<-c("black",
            "white",
            "red",
            "light blue",
            "mediumpurple",
            "azure",
            "darkorange",
            "green",
            "plum",
            "LemonChiffon1",
            "SeaGreen1",
            "DeepSkyBlue1",
            "turquoise1",
            "DeepPink",
            "gold",
            "lightcyan",
            "OldLace",
            "DarkSlateGray",
            "DarkSeaGreen",
            "GreenYellow",
            "orange",
            "RoyalBlue",
            "SkyBlue1",
            "cyan1",
            "DarkSlateGray4",
            "dimgray",
            "beige",
            "aquamarine1",
            "LemonChiffon",
            "AntiqueWhite",
            "MintCream",
            "lavender",
            "PeachPuff1",
            "cornsilk2",
            "LightSkyBlue1",
            "MediumAquamarine",
            "PaleGreen",
            "LightSeaGreen",
            "PaleGreen3",
            "SkyBlue",
            "green",
            "LightCyan2",
            "yellow1",
            "IndianRed",
            "salmon",
            "bisque3",
            "yellow2",
            "khaki",
            "moccasin",
            "pink",
            "SteelBlue2",
            "MistyRose2",
            "tan4",
            "SeaGreen1",
            "DeepPink",
            "magenta3",
            "LightPink",
            "thistle1",
            "LightSalmon",
            "sienna4")

}
###  
##   source("/home/lees/Progs/R_stuff/xmcolor.R")

SHOWPAL<-function(XMCOL, NAME=FALSE, ncol=5)
  {
    if(missing(NAME)) { NAME=FALSE }
   if(missing(ncol)) { ncol=5 }

    
##  SHOWPAL(XMCOL)
    N  = length(XMCOL)

    par(mfrow=c(1,1))
    
    plot(c(0,1), c(0,1), type='n', axes=FALSE, xlab='', ylab='')

    nrow = round(N/ncol)

    dx = 1/ncol
    dy =  1/nrow
    
    for(i in 1:N)
      {
        B =  itoxyz(i, ncol, nrow, 1)
        x = (B$ix-1)*dx
        y = (B$iy-1)*dy
        rect(x , y , x+dx, y+dy, lty=1, col=XMCOL[i] )
        if(NAME==TRUE)
          {
            lab = paste(sep=':', i,XMCOL[i])
            text(x+dx/2 , y+dy/2, lab, adj=0.5, col=1)
          }
      }
    title("Color Palette")
    return(list(N=N, ncol=ncol, nrow=nrow, dx=dx, dy=dy))
  }


###############################
###  
##   source("/home/lees/Progs/R_stuff/xmcolor.R")


###  
##   source("/home/lees/Progs/R_stuff/xmcolor.R")

###  read in the X11 system colors and make a palette map
pickcolors<-function(COLLIST=colors())
  {
    if(missing(COLLIST)) { COLLIST=colors() }
    A = SHOWPAL(COLLIST, NAME=FALSE, ncol=15)
    z = locator(type='p')
    ii = 1+floor(z$x/A$dx)
    jj = 1+floor(z$y/A$dy)
    B =  ii+(jj-1)*(A$ncol)
    return(COLLIST[B])
  }

syscolors<-function()
  {
    SHOWPAL(colors(), NAME=FALSE, ncol=15)

  }
