#include <math.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define FILENAME_LEN  100

typedef struct
  {
  char name[9];
  int num, style, col, idum;
  float latmin, latmax, lonmin, lonmax;
  int index1;
  char code;
  } MAPSTROKE;


typedef struct
  {
  double   x, y, z;
  } fxyz;


typedef struct
  {
  int color;
  fxyz *km;
  fxyz *latlon;
  char file_name[FILENAME_LEN];
  int numpoints;
  int stroke_count;
  MAPSTROKE *stroke;
  char map_code[50];
  } Map_File;


int Get_Map2(char *mapfile, Map_File *m);


int  main(int argc, char **argv)
{
   int i;
   Map_File MM;
   char fname1[100], fname2[100];
   FILE *fout1, *fout2;


   strcpy(fname1, argv[1]);
   strcpy(fname2, argv[1]);

   strcat(fname1, ".strks");
   strcat(fname2, ".pnts");

if((fout1 = fopen(fname1, "w")) == NULL)
   {
      fprintf(stderr, "Can't open %s : Try Again!\n", fname1);
      return(0);
   }

if((fout2 = fopen(fname2, "w")) == NULL)
   {
      fprintf(stderr, "Can't open %s : Try Again!\n", fname2);
      return(0);
   }


   Get_Map2(argv[1], &MM);


   for(i=0; i<MM.stroke_count; i++)
   {
      fprintf(fout1, "%s %d %d %d %d\n", MM.stroke[i].name, MM.stroke[i].num, MM.stroke[i].index1, MM.stroke[i].col, MM.stroke[i].style);

   }

   for(i=0; i<MM.numpoints; i++)
   {
      fprintf(fout2, "%lf %lf\n", MM.latlon[i].x, MM.latlon[i].y);

   }



   return(1);
}


void   CALL_LEESMAP1(char **fn, int *nstroke, int *npoints);

int  mainB(int argc, char **argv)
{
   int i;
   int nstroke, npoints;
  int  ks;
   char **fn;

   ks = strlen(argv[1]);

   fn = (char **)malloc(1 * sizeof(char));

   fn[0] = (char *)malloc(ks * sizeof(char));


   strcpy(fn[0], argv[1]);

   fprintf(stderr, "%s\n", fn[0]);


   CALL_LEESMAP1(fn,  &nstroke, &npoints);

   fprintf(stderr, "%d %d\n", nstroke, npoints);
   return(1);
}
