#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>


#define XmapNewArray(T, N) \
        (T *)calloc((size_t)(N), sizeof(T))


#define FILENAME_LEN      100
#define LINE_LENGTH       300

typedef struct
  {
  char name[9];
  int num, style, col, idum;
  float latmin, latmax, lonmin, lonmax;
  int index1;
  char code;
  } MAPSTROKE;

typedef struct
  {
  double  x, y, z;
  } fxyz;


typedef struct
  {
  int color;
  fxyz *km;
  fxyz *latlon;
  char file_name[FILENAME_LEN];
  int numpoints;
  int stroke_count;
  MAPSTROKE *stroke;
  char map_code[50];
  } Map_File;

/***************************/

/* line holds the long string */
#define SEPCHARS " \n"


void break_line(char *line, int *fake_argc, char **fake_argv)
  {
  int i = 0;

  fake_argv[i++] = strtok(line, SEPCHARS);
  while((fake_argv[i++] = strtok(NULL, SEPCHARS)) != NULL);
  *fake_argc = i - 1;
  }

int getline(FILE *input, char s[], int lim)
  {
  int c = 0, i;
  /* fprintf(stderr, "in getline\n"); */

  for(i = 0; (i < lim - 1) && ((c = fgetc(input)) != EOF) && (c != '\n'); i++)
     s[i] = c;

  if(c == '\n') s[i++] = c;

  s[i] = '\0';

  return(i);
  }



int Get_Map2(char *mapfile, Map_File *m)
{
   int i = 0,ii, j, k, kount, n, nump, sty, co, fake_argc, nstroke, npoint,
      lowy, num, indx[4];
  
   int kin, sin, left;

   
   int *wraps, nwrap, kn;
  
   float ftem;
  
   FILE *mf;
   float rlatmin, rlatmax, rlonmin, rlonmax, phi, lam, xmax, xmin, ymax, ymin,
      bx1, by1, bx2, by2, mx1, my1, mx2, my2, p1x, p1y, pys[4], pxs[4];
   char gmtchar, alph[12], code, line[LINE_LENGTH], *fake_argv[100];
   /* max 100 parameters for now */

/***   open map file, ignore all lines starting with the lb sign #   ****/ 

   fprintf(stderr, "Get_Map2  working on: %s\n", mapfile);
   
   if((mf = fopen(mapfile, "r")) == NULL)
   {
      fprintf(stderr, "Can't open Map-file %s : Try Again!\n", mapfile);
      return(0);
   }
   else j = 0;

fprintf(stderr, "in Get_Map2 1\n");

   while((ii = getline(mf, line, LINE_LENGTH)) > 0)
   {
      /* fprintf(stderr, "%s", line); */
      if(!strncmp(line, "#", 1)) continue;
      break_line(line, &fake_argc, fake_argv);
      break;
   }

   fprintf(stderr, "Get_Map2 1.1\n");

/*  if first line is two args, then it tells the program how many strokes 
    and how many points to read  */
   if(fake_argc == 2)
   {
      /* sscanf(line, "%d %d", &nstroke, &npoint); */

      nstroke = atoi(fake_argv[0]);
      npoint = atoi(fake_argv[1]);
      fprintf(stderr, "ASCII mapfile nstroke=%d npoint=%d :\n If you convert"
	      " to BIN it will run faster...\n", nstroke, npoint);
   }
   else
   {
      fprintf(stderr, "Get_Map2 1.2\n");
      fclose(mf);
      nstroke = npoint = 0;
      mf = fopen(mapfile, "r");
fprintf(stderr, "Get_Map2 2\n");

      while((ii = getline(mf, line, LINE_LENGTH)) > 0)
      {
	 if(!strncmp(line, "#", 1)) continue;

	 sscanf(line, "%s %s %d %d %d %c %f %f %f %f", &gmtchar, alph, &nump,
		&sty, &co, &code, &rlatmin, &rlatmax, &rlonmin, &rlonmax);

	 for(j = 0; j < nump; j++)
	 {
	    if(!strncmp(line, "#", 1))
	    {
	       j--;
	       continue;
	    }
	    k = getline(mf, line, LINE_LENGTH);
	 }
	 nstroke++;
	 npoint += nump;
      } /* end loop  */

      fclose(mf);
      /* we now know how many points and strokes are in the file */
 
      mf = fopen(mapfile, "r");
   }

   fprintf(stderr, "GETMAP2 MAPFILE: nstroke=%d  npoint=%d\n" , nstroke, npoint);

   

   /* assign memory for the mapfile  */
   m->stroke = XmapNewArray(MAPSTROKE, nstroke);
   m->latlon = XmapNewArray(fxyz, npoint);
      
   j = k = 0;



   /*   read in the mapfile  */
   while((ii = getline(mf, line, LINE_LENGTH)) > 0)
   {
      if(!strncmp(line, "#", 1)) continue;
      sscanf(line, "%s %s %d %d %d %c %f %f %f %f", &gmtchar, alph, &nump,
	     &sty, &co, &code, &rlatmin, &rlatmax, &rlonmin, &rlonmax);

     
      kin=1;
      if(kin==1)
      {
	 /*  fprintf(stderr," IN\n");*/
       
	 /*  there is some overlap of the regions, so include it in database  */

	 m->stroke[k].num = nump;
	 m->stroke[k].style = sty;
	 m->stroke[k].col = co;
	 m->stroke[k].code = code;
	 strcpy(m->stroke[k].name, alph);
	 m->stroke[k].latmin = rlatmin;
	 m->stroke[k].latmax = rlatmax;
	 m->stroke[k].lonmin = rlonmin;
	 m->stroke[k].lonmax = rlonmax;
	 m->stroke[k].index1 = j;
		 

	 /* fprintf(stderr, "%d %d %d %s %d %d\n", k, nump, sty, alph, j, i); */

	 k++;

	 /* print_stroke_info(m, kount, k); */



	 for(i = j; i < j + nump; i++)
	 {
	    ii = getline(mf, line, LINE_LENGTH);
	    if(!strncmp(line, "#", 1))
	    {
	       i--;
	       continue;
	    }
	    sscanf(line, "%f %f", &phi, &lam);
	    /* fprintf(stderr, "%f %f %d\n", phi, lam, i); */
	    m->latlon[i].x = phi;
	    m->latlon[i].y = lam;
	    
	 }
		 j += nump;
      }
      else
      {
	 /*  loop through points and ignore them  */
       
	 for(n = 0; n < nump; n++)
	 {
	    ii = getline(mf, line, LINE_LENGTH);
	    if(!strncmp(line, "#", 1))
	    {
	       n--;
	       continue;
	    }
	  
	    sscanf(line, "%f %f", &phi, &lam);
	 }
      }
   }
  
   m->numpoints = i;
   m->stroke_count = k;
  
   fprintf(stderr, "GETMAP2 stroke count: %d\n", m->stroke_count);
   fprintf(stderr, "GETMAP2 numpoints: %d %d\n", m->numpoints, i); 

   fprintf(stderr, "\n");
   fclose(mf);
   return(1);
}

/** FUNC DEF */ void   CALL_LEESCHAR(char **fn)
{
   Map_File MM;

   fprintf(stderr, "<%s>\n", fn[0]);
 
}



/** FUNC DEF */ void   CALL_LEESMAP1(char **fn, int *nstroke, int *npoints)
{
   Map_File MM;
   char input[100];


   fprintf(stderr, "<%s>\n", fn[0]);
   fprintf(stderr, "going to CALL_LEESMAP1 1\n");

   strcpy(input, fn[0]);

   fprintf(stderr, "going to CALL_LEESMAP1 2 %s\n", input);

   Get_Map2(input, &MM);

   *nstroke = MM.stroke_count;
   *npoints = MM.numpoints;


  free(MM.stroke);
  free(MM.latlon);

   
}




/** FUNC DEF */ void   CALL_LEESMAP2(char *fn, int *num, int *index,  int *col, int *style, double *lat , double *lon)
{
   int i, j, k;
   Map_File MM;
   
   Get_Map2(fn , &MM);
   k = 0;
   for(i=0; i<MM.stroke_count; i++)
   {
      num[i] = MM.stroke[i].num;
      index[i] = MM.stroke[i].index1;
      col[i] = MM.stroke[i].col;
      style[i] =  MM.stroke[i].style;
   }

   for(j=0; j<MM.numpoints; j++)
   {
      lat[j] = MM.latlon[j].x;
      lon[j] = MM.latlon[j].y;
   }


   free(MM.stroke);
   free(MM.latlon);
   

}



